/*
 * Decompiled with CFR 0.152.
 */
package com.sun.entdiag.ui;

import com.sun.entdiag.ui.NavData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class NavTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected static Font defaultFont;
    protected static ImageIcon rootIcon;
    protected static ImageIcon groupIcon;
    protected static ImageIcon leafIcon;
    protected static ImageIcon passIcon;
    protected static ImageIcon failIcon;
    protected static final Color SelectedBackgroundColor;
    protected static final Color VisitedBackgroundColor;
    protected boolean selected;
    protected boolean visited;

    static {
        SelectedBackgroundColor = Color.blue.darker().darker();
        VisitedBackgroundColor = Color.blue.darker().darker();
    }

    public NavTreeCellRenderer(Vector vector) {
        try {
            defaultFont = new Font("SansSerif", 0, 12);
        }
        catch (Exception exception) {}
        try {
            rootIcon = new ImageIcon((Image)vector.elementAt(0));
            groupIcon = new ImageIcon((Image)vector.elementAt(1));
            leafIcon = new ImageIcon((Image)vector.elementAt(2));
            passIcon = new ImageIcon((Image)vector.elementAt(3));
            failIcon = new ImageIcon((Image)vector.elementAt(4));
        }
        catch (Exception exception) {
            System.out.println("Couldn't load node images: " + exception);
        }
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
        NavData navData = (NavData)((DefaultMutableTreeNode)object).getUserObject();
        int n2 = navData.getState();
        boolean bl5 = navData.getRoot();
        this.setText(string);
        this.setToolTipText(string);
        if (bl5) {
            this.setIcon(rootIcon);
        } else if (!bl3) {
            this.setIcon(groupIcon);
        } else {
            switch (n2) {
                case 0: {
                    this.setIcon(leafIcon);
                    break;
                }
                case 1: {
                    this.setIcon(passIcon);
                    break;
                }
                case 2: {
                    this.setIcon(failIcon);
                    break;
                }
            }
        }
        if (bl) {
            this.setForeground(Color.white);
        } else {
            this.setForeground(navData.getColor());
        }
        if (navData.getFont() == null) {
            this.setFont(defaultFont);
        } else {
            this.setFont(navData.getFont());
        }
        this.selected = bl;
        this.visited = navData.getVisit();
        return this;
    }

    public void paint(Graphics graphics) {
        Icon icon = this.getIcon();
        Color color = this.visited ? VisitedBackgroundColor : (this.selected ? SelectedBackgroundColor : (this.getParent() != null ? this.getParent().getBackground() : this.getBackground()));
        graphics.setColor(color);
        if (icon != null && this.getText() != null) {
            int n = icon.getIconWidth() + this.getIconTextGap();
            graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
        } else {
            graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        super.paint(graphics);
    }
}

