/*
 * Decompiled with CFR 0.152.
 */
package com.sun.entdiag.ui;

import com.sun.entdiag.ui.MsgTranslator;
import com.sun.entdiag.ui.NavData;
import com.sun.entdiag.ui.NavTreeCellRenderer;
import com.sun.entdiag.ui.NavTreeModel;
import com.sun.entdiag.ui.VisitEvent;
import com.sun.entdiag.ui.VisitListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class NavTree {
    public JPanel panel;
    public DefaultTreeModel treeModel;
    public JTree tree;
    protected TreeExpansionListener treeExpand;
    protected DefaultMutableTreeNode root = null;
    private Vector allPaths = new Vector();
    private Vector allNames = new Vector();
    private Vector selectedPaths = new Vector();
    private Vector visiblePaths = new Vector();
    private Vector failedPaths = new Vector();
    private Vector listeners = new Vector();
    private TreePath previousVisit = null;
    private JScrollPane sp = new JScrollPane();
    private boolean locked = false;
    private JPanel titlePane;
    private JPanel buttonPane;
    private JButton oneButton;
    private JButton allButton;
    private JButton noneButton;
    private MsgTranslator rb = null;
    private boolean debug = false;
    private static Vector nodeIcons = new Vector(5);

    public NavTree(String string, Vector vector, Vector vector2, MsgTranslator msgTranslator) {
        Accessible accessible;
        Serializable serializable;
        this.panel = new JPanel(true);
        this.rb = msgTranslator;
        File file = new File("/tmp/eddebug");
        if (file.exists()) {
            this.debug = true;
        }
        this.sp.setPreferredSize(new Dimension(300, 300));
        this.buttonPane = new JPanel(true);
        this.buttonPane.setLayout(new FlowLayout(0, 0, 0));
        int n = 0;
        while (n < vector2.size()) {
            nodeIcons.addElement((Image)vector2.elementAt(n));
            ++n;
        }
        try {
            serializable = new ImageIcon((Image)vector.elementAt(0));
            this.oneButton = new JButton((Icon)((Object)serializable));
            accessible = new ImageIcon((Image)vector.elementAt(1));
            this.allButton = new JButton((Icon)((Object)accessible));
            ImageIcon imageIcon = new ImageIcon((Image)vector.elementAt(2));
            this.noneButton = new JButton(imageIcon);
        }
        catch (Exception exception) {
            System.out.println("Couldn't load tree images: " + exception);
        }
        this.oneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath treePath;
                int n = NavTree.this.allPaths.size() - 1;
                while (n >= 0) {
                    treePath = (TreePath)NavTree.this.allPaths.elementAt(n);
                    NavTree.this.tree.collapsePath(treePath);
                    --n;
                }
                treePath = (TreePath)NavTree.this.allPaths.elementAt(0);
                NavTree.this.tree.expandPath(treePath);
            }
        });
        this.allButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                while (n < NavTree.this.allPaths.size()) {
                    TreePath treePath = (TreePath)NavTree.this.allPaths.elementAt(n);
                    NavTree.this.tree.expandPath(treePath);
                    ++n;
                }
            }
        });
        this.noneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath treePath = (TreePath)NavTree.this.allPaths.elementAt(0);
                NavTree.this.tree.collapsePath(treePath);
            }
        });
        this.setTree(string);
        serializable = new Dimension(28, 27);
        this.oneButton.setPreferredSize((Dimension)serializable);
        this.oneButton.setToolTipText(this.rb.getString("OneLevel"));
        this.allButton.setPreferredSize((Dimension)serializable);
        this.allButton.setToolTipText(this.rb.getString("AllLevel"));
        this.noneButton.setPreferredSize((Dimension)serializable);
        this.noneButton.setToolTipText(this.rb.getString("NoLevel"));
        this.buttonPane.add(this.noneButton);
        this.buttonPane.add(this.oneButton);
        this.buttonPane.add(this.allButton);
        ToolTipManager.sharedInstance().registerComponent(this.buttonPane);
        this.titlePane = new JPanel(true);
        this.titlePane.setLayout(new BorderLayout());
        accessible = new JLabel(this.rb.getString("Treelabel"));
        this.titlePane.add("West", this.buttonPane);
        this.titlePane.add("South", (Component)((Object)accessible));
        this.panel.setLayout(new BorderLayout());
        this.panel.add("North", this.titlePane);
        this.panel.add("Center", this.sp);
    }

    public void addVisitListener(VisitListener visitListener) {
        this.listeners.addElement(visitListener);
    }

    public DefaultMutableTreeNode createNewNode(String string, int n) {
        Color color;
        switch (n) {
            case 0: {
                color = Color.black;
                break;
            }
            case 1: {
                color = Color.green.darker();
                break;
            }
            case 2: {
                color = Color.red;
                break;
            }
            default: {
                color = Color.black;
            }
        }
        NavData navData = new NavData(null, color, string, n, false);
        return new DefaultMutableTreeNode(navData);
    }

    public DefaultMutableTreeNode createRootNode(String string) {
        return new DefaultMutableTreeNode(new NavData(null, Color.black, string, 0, false, true));
    }

    private void doubleClick(TreePath treePath, int n) {
        Color color = Color.black;
        boolean bl = false;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        this.previousVisit = treePath;
        this.notifyVisitEvent(defaultMutableTreeNode.toString(), n);
    }

    private int downList(DefaultMutableTreeNode defaultMutableTreeNode, String string, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            String string2;
            int n4;
            String string3;
            int n5;
            String string4;
            if (string.charAt(n3) == '{') {
                string4 = string.substring(n2, n3);
                n5 = string4.indexOf(":");
                if (n5 < 0) {
                    string3 = string4;
                    n4 = 0;
                } else {
                    string3 = string4.substring(0, n5);
                    string2 = string4.substring(n5 + 1);
                    n4 = string2.equals("1") ? 1 : (string2.equals("2") ? 2 : 0);
                }
                DefaultMutableTreeNode defaultMutableTreeNode2 = this.createNewNode(string3, n4);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                n3 = this.downList(defaultMutableTreeNode2, string.substring(n3 + 1, string.length()), n3);
                n2 = n3 + 1;
                if (n3 >= string.length()) {
                    break;
                }
            } else {
                if (string.charAt(n3) == '}' || string.charAt(n3) == '=' && string.charAt(n3 + 1) == '}') {
                    string4 = string.substring(n2, n3);
                    n5 = string4.indexOf(":");
                    if (n5 < 0) {
                        string3 = string4;
                        n4 = 0;
                    } else {
                        string3 = string4.substring(0, n5);
                        string2 = string4.substring(n5 + 1);
                        n4 = string2.equals("1") ? 1 : (string2.equals("2") ? 2 : 0);
                    }
                    if (string3.compareTo("") == 0) break;
                    defaultMutableTreeNode.add(this.createNewNode(string3, n4));
                    ++n3;
                    break;
                }
                if (string.charAt(n3) == '=') {
                    string4 = string.substring(n2, n3);
                    n5 = string4.indexOf(":");
                    if (n5 < 0) {
                        string3 = string4;
                        n4 = 0;
                    } else {
                        string3 = string4.substring(0, n5);
                        string2 = string4.substring(n5 + 1);
                        n4 = string2.equals("1") ? 1 : (string2.equals("2") ? 2 : 0);
                    }
                    defaultMutableTreeNode.add(this.createNewNode(string3, n4));
                    n2 = n3 + 1;
                }
            }
            ++n3;
        }
        return n + n3 + 1;
    }

    public Vector getAllNames() {
        return this.allNames;
    }

    private void getAllTreePaths(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector) {
        vector.addElement(new TreePath(defaultMutableTreeNode.getPath()));
        int n = 0;
        while (n < defaultMutableTreeNode.getChildCount()) {
            this.getAllTreePaths((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n), vector);
            ++n;
        }
    }

    private Vector getChildPaths(DefaultMutableTreeNode defaultMutableTreeNode) {
        Vector<TreePath> vector = new Vector<TreePath>();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            vector.addElement(new TreePath(defaultMutableTreeNode2.getPath()));
        }
        return vector;
    }

    public Vector getLeaves() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.allPaths.size()) {
            TreePath treePath = (TreePath)this.allPaths.elementAt(n);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode.isLeaf()) {
                vector.addElement(defaultMutableTreeNode.toString());
            }
            ++n;
        }
        return vector;
    }

    private void getParentPaths(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector) {
        vector.addElement(new TreePath(defaultMutableTreeNode.getPath()));
        if (defaultMutableTreeNode.isRoot()) {
            return;
        }
        this.getParentPaths((DefaultMutableTreeNode)defaultMutableTreeNode.getParent(), vector);
    }

    public String getSelectedNode() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            return defaultMutableTreeNode.toString();
        }
        return null;
    }

    public Vector getTestList() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.selectedPaths.size()) {
            TreePath treePath = (TreePath)this.selectedPaths.elementAt(n);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode.isLeaf()) {
                vector.addElement(defaultMutableTreeNode.toString());
            }
            ++n;
        }
        return vector;
    }

    public Vector getTreeList() {
        Vector vector = new Vector(this.selectedPaths.size());
        this.stringVector(this.selectedPaths, vector);
        return vector;
    }

    public String getVisitedNode() {
        if (this.previousVisit != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.previousVisit.getLastPathComponent();
            return defaultMutableTreeNode.toString();
        }
        return null;
    }

    public void lockTree() {
        block2: {
            try {
                this.locked = true;
                this.oneButton.setEnabled(false);
                this.oneButton.repaint();
                this.allButton.setEnabled(false);
                this.allButton.repaint();
                this.noneButton.setEnabled(false);
                this.noneButton.repaint();
                this.tree.setEnabled(false);
                this.tree.repaint();
            }
            catch (Exception exception) {
                if (!this.debug) break block2;
                System.out.println("lockTree: " + exception);
            }
        }
    }

    protected void notifyVisitEvent(String string, int n) {
        Vector vector;
        VisitEvent visitEvent = new VisitEvent(this, string, n);
        NavTree navTree = this;
        synchronized (navTree) {
            vector = (Vector)this.listeners.clone();
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            VisitListener visitListener = (VisitListener)vector.elementAt(n2);
            visitListener.visitNode(visitEvent);
            ++n2;
        }
    }

    private void orderInsert(Vector vector, Vector vector2) {
        int n = 0;
        while (n < vector.size()) {
            this.vectorInsert((TreePath)vector.elementAt(n), vector2);
            ++n;
        }
    }

    private int pathValue(TreePath treePath) {
        return this.allPaths.indexOf(treePath);
    }

    private void populateTree(String string) {
        int n;
        if (this.debug) {
            System.out.println(string);
        }
        int n2 = string.indexOf("{");
        String string2 = string.substring(0, n2);
        if (this.debug) {
            System.out.println("root " + string2);
        }
        this.root = this.createRootNode(string2);
        int n3 = n = n2 + 2;
        while (n3 < string.length()) {
            String string3;
            int n4;
            String string4;
            int n5;
            String string5;
            if (string.charAt(n3) == '{') {
                string5 = string.substring(n, n3);
                n5 = string5.indexOf(":");
                if (n5 < 0) {
                    string4 = string5;
                    n4 = 0;
                } else {
                    string4 = string5.substring(0, n5);
                    string3 = string5.substring(n5 + 1);
                    n4 = string3.equals("1") ? 1 : (string3.equals("2") ? 2 : 0);
                }
                DefaultMutableTreeNode defaultMutableTreeNode = this.createNewNode(string4, n4);
                this.root.add(defaultMutableTreeNode);
                n3 = this.downList(defaultMutableTreeNode, string.substring(n3 + 1, string.length()), n3);
                if (n3 >= string.length()) break;
                n = n3 + 1;
            } else if (string.charAt(n3) == '}' || string.charAt(n3) == '=' && string.charAt(n3 + 1) == '}') {
                string5 = string.substring(n, n3);
                n5 = string5.indexOf(":");
                if (n5 < 0) {
                    string4 = string5;
                    n4 = 0;
                } else {
                    string4 = string5.substring(0, n5);
                    string3 = string5.substring(n5 + 1);
                    n4 = string3.equals("1") ? 1 : (string3.equals("2") ? 2 : 0);
                }
                if (string4.compareTo("") == 0) break;
                this.root.add(this.createNewNode(string4, n4));
                n = n3 + 1;
            } else if (string.charAt(n3) == '=') {
                string5 = string.substring(n, n3);
                n5 = string5.indexOf(":");
                if (n5 < 0) {
                    string4 = string5;
                    n4 = 0;
                } else {
                    string4 = string5.substring(0, n5);
                    string3 = string5.substring(n5 + 1);
                    n4 = string3.equals("1") ? 1 : (string3.equals("2") ? 2 : 0);
                }
                this.root.add(this.createNewNode(string4, n4));
                n = n3 + 1;
            }
            ++n3;
        }
    }

    private void printVector(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            TreePath treePath = (TreePath)vector.elementAt(n);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            System.out.println("vector " + defaultMutableTreeNode.toString());
            ++n;
        }
    }

    public void removeVisitListener(VisitListener visitListener) {
        this.listeners.removeElement(visitListener);
    }

    public void resetTree() {
        int n = 0;
        while (n < this.allPaths.size()) {
            TreePath treePath = (TreePath)this.allPaths.elementAt(n);
            NavData navData = new NavData(null, Color.black, null, 0, false);
            this.treeModel.valueForPathChanged(treePath, navData);
            ++n;
        }
    }

    private void restorePrevious() {
        if (this.previousVisit != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.previousVisit.getLastPathComponent();
            NavData navData = (NavData)defaultMutableTreeNode.getUserObject();
            Color color = navData.getState() == 0 ? Color.black : navData.getColor();
            NavData navData2 = new NavData(null, color, null, navData.getState(), false);
            this.treeModel.valueForPathChanged(this.previousVisit, navData2);
        }
    }

    public void setTree(String string) {
        if (this.root != null) {
            this.sp.getViewport().remove(this.tree);
            this.root.removeAllChildren();
            this.root = null;
            this.allPaths.removeAllElements();
            this.allNames.removeAllElements();
            this.selectedPaths.removeAllElements();
            this.visiblePaths.removeAllElements();
        }
        this.populateTree(string);
        this.getAllTreePaths(this.root, this.allPaths);
        if (this.debug) {
            this.printVector(this.allPaths);
        }
        this.stringVector(this.allPaths, this.allNames);
        this.treeModel = new NavTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setCellRenderer(new NavTreeCellRenderer(nodeIcons));
        this.tree.setRowHeight(-1);
        this.tree.getSelectionModel().setSelectionMode(4);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (NavTree.this.locked) {
                    return;
                }
                int n = NavTree.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = NavTree.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    int n2 = mouseEvent.getClickCount();
                    if (NavTree.this.selectedPaths.contains(treePath) && n2 == 1) {
                        NavTree.this.treeDeselect(treePath);
                        NavTree.this.showAllVisible();
                        return;
                    }
                    if (mouseEvent.isShiftDown()) {
                        if (NavTree.this.debug) {
                            System.out.println("shift");
                        }
                    } else if (mouseEvent.isControlDown()) {
                        if (NavTree.this.debug) {
                            System.out.println("control");
                        }
                    } else {
                        NavTree.this.selectedPaths.removeAllElements();
                        NavTree.this.visiblePaths.removeAllElements();
                    }
                    if (n2 == 2) {
                        NavTree.this.doubleClick(treePath, 0);
                        NavTree.this.singleClick(treePath);
                    } else if (n2 == 1) {
                        NavTree.this.singleClick(treePath);
                    }
                    NavTree.this.printVector(NavTree.this.selectedPaths);
                } else {
                    NavTree.this.showAllVisible();
                }
            }
        };
        this.tree.addMouseListener(mouseAdapter);
        this.treeExpand = new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                TreePath treePath = treeExpansionEvent.getPath();
                NavTree.this.treeCollapse(treePath);
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreePath treePath = treeExpansionEvent.getPath();
                NavTree.this.treeExpansion(treePath);
                NavTree.this.showVisible();
            }
        };
        this.tree.addTreeExpansionListener(this.treeExpand);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.sp.getViewport().add(this.tree);
    }

    public void showAll() {
        int n = 0;
        while (n < this.allPaths.size()) {
            TreePath treePath = (TreePath)this.allPaths.elementAt(n);
            this.tree.expandPath(treePath);
            ++n;
        }
    }

    private void showAllVisible() {
        this.visiblePaths.removeAllElements();
        int n = 0;
        while (n < this.selectedPaths.size()) {
            TreePath treePath = (TreePath)this.selectedPaths.elementAt(n);
            if (this.tree.isVisible(treePath)) {
                this.visiblePaths.addElement(treePath);
            }
            ++n;
        }
        this.showVisible();
    }

    public void showSelected() {
        Object[] objectArray = new TreePath[this.selectedPaths.size()];
        this.selectedPaths.copyInto(objectArray);
        this.tree.clearSelection();
        this.tree.setSelectionPaths((TreePath[])objectArray);
    }

    private void showVisible() {
        Object[] objectArray = new TreePath[this.visiblePaths.size()];
        this.visiblePaths.copyInto(objectArray);
        this.tree.clearSelection();
        this.tree.setSelectionPaths((TreePath[])objectArray);
    }

    private void singleClick(TreePath treePath) {
        this.treeSelect(treePath);
        this.showVisible();
    }

    private void stringVector(Vector vector, Vector vector2) {
        int n = 0;
        while (n < vector.size()) {
            TreePath treePath = (TreePath)vector.elementAt(n);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            vector2.addElement(defaultMutableTreeNode.toString());
            ++n;
        }
    }

    private void treeCollapse(TreePath treePath) {
        if (!this.selectedPaths.contains(treePath)) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (this.debug) {
            System.out.println("collapse " + defaultMutableTreeNode.toString());
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (this.debug) {
                System.out.println("collapse child " + defaultMutableTreeNode2.toString());
            }
            TreePath treePath2 = new TreePath(defaultMutableTreeNode2.getPath());
            this.visiblePaths.removeElement(treePath2);
        }
    }

    private void treeDeselect(TreePath treePath) {
        if (treePath != null) {
            Cloneable cloneable;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                cloneable = (DefaultMutableTreeNode)enumeration.nextElement();
                if (this.debug) {
                    System.out.println("deselect " + ((DefaultMutableTreeNode)cloneable).toString());
                }
                TreePath treePath2 = new TreePath(((DefaultMutableTreeNode)cloneable).getPath());
                this.selectedPaths.removeElement(treePath2);
                this.visiblePaths.removeElement(treePath2);
            }
            if (defaultMutableTreeNode.isRoot()) {
                return;
            }
            cloneable = new Vector();
            this.getParentPaths(defaultMutableTreeNode, (Vector)cloneable);
            int n = 1;
            while (n < ((Vector)cloneable).size()) {
                TreePath treePath3 = (TreePath)((Vector)cloneable).elementAt(n);
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath3.getLastPathComponent();
                Vector vector = this.getChildPaths(defaultMutableTreeNode2);
                boolean bl = true;
                int n2 = 0;
                while (n2 < vector.size()) {
                    TreePath treePath4 = (TreePath)vector.elementAt(n2);
                    if (this.selectedPaths.contains(treePath4)) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
                if (!bl) break;
                this.selectedPaths.removeElement(treePath3);
                this.visiblePaths.removeElement(treePath3);
                ++n;
            }
        }
    }

    private void treeExpansion(TreePath treePath) {
        if (!this.selectedPaths.contains(treePath)) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (this.debug) {
            System.out.println("expand " + defaultMutableTreeNode.toString());
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            TreePath treePath2;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (this.debug) {
                System.out.println("expand child " + defaultMutableTreeNode2.toString());
            }
            if (!this.selectedPaths.contains(treePath2 = new TreePath(defaultMutableTreeNode2.getPath())) || !this.tree.isVisible(treePath2)) continue;
            this.visiblePaths.addElement(treePath2);
        }
    }

    private void treeSelect(TreePath treePath) {
        if (treePath != null) {
            Vector vector = new Vector();
            Vector<TreePath> vector2 = new Vector<TreePath>();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode.isLeaf()) {
                vector2.addElement(treePath);
            } else {
                this.getAllTreePaths(defaultMutableTreeNode, vector2);
            }
            this.orderInsert(vector2, this.selectedPaths);
            if (!this.visiblePaths.isEmpty()) {
                this.visiblePaths.removeAllElements();
            }
            int n = 0;
            while (n < this.selectedPaths.size()) {
                TreePath treePath2 = (TreePath)this.selectedPaths.elementAt(n);
                if (this.tree.isVisible(treePath2)) {
                    this.visiblePaths.addElement(treePath2);
                }
                ++n;
            }
        }
    }

    public void unlockTree() {
        block2: {
            try {
                this.locked = false;
                this.oneButton.setEnabled(true);
                this.oneButton.repaint();
                this.allButton.setEnabled(true);
                this.allButton.repaint();
                this.noneButton.setEnabled(true);
                this.noneButton.repaint();
                this.tree.setEnabled(true);
                this.tree.repaint();
            }
            catch (Exception exception) {
                if (!this.debug) break block2;
                System.out.println("lockTree: " + exception);
            }
        }
    }

    public void updateTree(String string, int n) {
        Color color;
        int n2 = 0;
        if (string == null) {
            return;
        }
        if (string.length() < 1) {
            return;
        }
        n2 = this.allNames.indexOf(string);
        if (n2 < 0) {
            return;
        }
        TreePath treePath = (TreePath)this.allPaths.elementAt(n2);
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        switch (n) {
            case 0: {
                color = Color.black;
                break;
            }
            case 1: {
                color = Color.green.darker();
                if (!this.failedPaths.contains(treePath)) break;
                this.failedPaths.removeElement(treePath);
                break;
            }
            case 2: {
                color = Color.red;
                this.failedPaths.addElement(treePath);
                break;
            }
            default: {
                color = Color.black;
            }
        }
        NavData navData = new NavData(null, color, null, n, false);
        this.treeModel.valueForPathChanged(treePath, navData);
        Vector vector = new Vector();
        this.getParentPaths(defaultMutableTreeNode, vector);
        if (this.debug) {
            System.out.println("failed:" + n);
            this.printVector(this.failedPaths);
        }
        int n3 = 1;
        while (n3 < vector.size()) {
            TreePath treePath2 = (TreePath)vector.elementAt(n3);
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath2.getLastPathComponent();
            Vector vector2 = this.getChildPaths(defaultMutableTreeNode2);
            boolean bl = true;
            if (n == 1) {
                int n4 = 0;
                while (n4 < vector2.size()) {
                    TreePath treePath3 = (TreePath)vector2.elementAt(n4);
                    if (this.failedPaths.contains(treePath3)) {
                        bl = false;
                        break;
                    }
                    ++n4;
                }
            } else if (n == 2) {
                this.failedPaths.addElement(treePath2);
            }
            if (!bl) break;
            if (n == 1 && this.failedPaths.contains(treePath2)) {
                this.failedPaths.removeElement(treePath2);
            }
            this.treeModel.valueForPathChanged(treePath2, navData);
            ++n3;
        }
    }

    private void vectorInsert(TreePath treePath, Vector vector) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (vector.isEmpty()) {
            vector.addElement(treePath);
        } else {
            if (vector.contains(treePath)) {
                return;
            }
            int n = 0;
            while (n < vector.size()) {
                if (this.pathValue(treePath) < this.pathValue((TreePath)vector.elementAt(n))) {
                    vector.insertElementAt(treePath, n);
                    return;
                }
                ++n;
            }
            vector.addElement(treePath);
        }
    }

    public void visitTree(String string) {
        Color color = Color.black;
        boolean bl = false;
        int n = 0;
        if (string == null) {
            return;
        }
        if (string.length() < 1) {
            return;
        }
        n = this.allNames.indexOf(string);
        if (n < 0) {
            return;
        }
        TreePath treePath = (TreePath)this.allPaths.elementAt(n);
        if (treePath == null) {
            return;
        }
        this.doubleClick(treePath, 1);
    }
}

