/*
 * Decompiled with CFR 0.152.
 */
package com.sun.entdiag.ui;

import com.sun.symon.base.utility.UcInternationalizer;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class MsgTranslator {
    private boolean inSunMC = false;
    private ResourceBundle rb = null;
    private boolean debug = true;

    public MsgTranslator(boolean bl) throws MissingResourceException {
        this.inSunMC = bl;
        try {
            this.rb = ResourceBundle.getBundle("com.sun.entdiag.ui.msg.EDResource");
        }
        catch (MissingResourceException missingResourceException) {
            Locale locale = new Locale("", "");
            Locale.setDefault(locale);
            if (this.debug) {
                System.out.println("Reset LANG");
            }
            this.rb = ResourceBundle.getBundle("com.sun.entdiag.ui.msg.EDResource");
        }
    }

    private String bundleKey(String string, String string2) {
        ResourceBundle resourceBundle = null;
        String string3 = null;
        if (string == null || string2 == null) {
            return " ";
        }
        try {
            resourceBundle = ResourceBundle.getBundle("com.sun.entdiag.ui.msg." + string);
        }
        catch (MissingResourceException missingResourceException) {
            if (this.debug) {
                System.out.println("bundleKey-1- ex:" + missingResourceException);
            }
            return " ";
        }
        try {
            string3 = resourceBundle.getString(string2);
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("bundleKey-2- ex:" + exception);
            }
            return " ";
        }
        if (string3 == null) {
            return " ";
        }
        return string3;
    }

    public String getString(String string) {
        String string2;
        try {
            string2 = this.rb.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    public Object[] messageArgs(String string) {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        int n = string.indexOf("||");
        if (n > 0) {
            objectArray = string.substring(n + 2);
            StringTokenizer stringTokenizer = new StringTokenizer((String)objectArray, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = new String(stringTokenizer.nextToken());
                if (this.debug) {
                    System.out.println("token " + string2);
                }
                vector.addElement(string2);
            }
        }
        objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String processMsg(String string) {
        int n;
        String string2 = null;
        int n2 = string.indexOf("==") + 2;
        int n3 = string.indexOf("=", n2);
        if (n2 < 0 || n3 < 0) {
            return new String("UNKNOWN");
        }
        int n4 = string.indexOf("VERBOSE", n2) - 1;
        if (n4 < 0 && (n4 = string.indexOf("WARNING", n2) - 1) < 0 && (n4 = string.indexOf("ERROR", n2) - 1) < 0 && (n4 = string.indexOf("INFO", n2) - 1) < 0) {
            return new String("UNKNOWN");
        }
        String string3 = string.substring(n3, n4).trim();
        int n5 = string3.indexOf(".", (n = string3.indexOf(".", n2 = string3.indexOf("Diagnostic.") + 11)) + 1);
        if (n5 < 1) {
            n5 = 100000;
        } else {
            string2 = string3.substring(n + 1, n5);
            if (this.debug) {
                System.out.println("subTest=" + string2);
            }
        }
        int n6 = string3.indexOf(" ", n3);
        String string4 = string3.substring(n2, n);
        String string5 = null;
        string5 = n5 < n6 ? string3.substring(n5 + 1, n6) : string3.substring(n + 1, n6);
        if (this.debug) {
            System.out.println("test " + string4 + ", key " + string5);
        }
        Object[] objectArray = this.messageArgs(string);
        String string6 = new String(" ");
        string6 = string5.equals("0") ? string.substring(n4 + 11, string.length() - 1) : (string2 != null && string2.trim().equalsIgnoreCase("libtest") ? this.translate("libtest", string5, objectArray) : this.translate(string4, string5, objectArray));
        return string6;
    }

    public String translate(String string, String string2, Object[] objectArray) {
        if (this.debug) {
            System.out.println("file " + string + ", key " + string2);
        }
        String string3 = " ";
        if (this.inSunMC) {
            string3 = UcInternationalizer.translateKey((String)("com.sun.entdiag.ui.msg." + string + ":" + string2));
            if (this.debug) {
                System.out.println("Uc msg text " + string3);
            }
        }
        if (!this.inSunMC || string3.startsWith("com.sun.entdiag")) {
            string3 = this.bundleKey(string, string2);
            if (this.debug) {
                System.out.println("bundle msg text " + string3);
            }
        }
        if (string3.equals(" ")) {
            return " ";
        }
        if (objectArray.length > 0) {
            String string4 = MessageFormat.format(string3, objectArray);
            if (this.debug) {
                System.out.println("msg final " + string4);
            }
            return string4;
        }
        return string3;
    }
}

