/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.remitters.cache;

import com.sun.symon.base.beans.BcTreeNode;
import com.sun.symon.base.server.common.ScRequestDispatchException;
import com.sun.symon.base.server.common.ScRequestJoiner;
import com.sun.symon.base.server.common.ScRequestSink;
import com.sun.symon.base.server.events.SvRequestEvent;
import com.sun.symon.base.server.remitters.SmRemitter;
import com.sun.symon.base.utility.UcDDL;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SmCacheRemitter
extends SmRemitter {
    private static final String JOB_PREFIX = "J";
    private static final String KEY_PREFIX = "K";
    private Hashtable Cache = new Hashtable();

    public SmCacheRemitter() {
        super(null);
    }

    protected void cacheEmpty() {
    }

    public boolean canHandle(SvRequestEvent svRequestEvent) {
        if (svRequestEvent.getCommand() == 6) {
            return svRequestEvent.getPeriod() != null;
        }
        return svRequestEvent.getCommand() == 1 && svRequestEvent.getData() == null && svRequestEvent.getPeriod() != null;
    }

    public synchronized void dumpCache(BcTreeNode bcTreeNode, String[] stringArray) {
        PrintWriter printWriter = bcTreeNode.getOut();
        printWriter.println("Cache jobs:");
        int n = 0;
        Enumeration enumeration = this.Cache.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(JOB_PREFIX)) continue;
            Job job = (Job)this.Cache.get(string);
            printWriter.println("  Job #" + ++n + ":");
            job.dump(printWriter);
        }
    }

    public void emit(Matcher matcher) {
        Object object;
        UcDDL.logDebugMessage((String)"Cache: emit()");
        Hashtable hashtable = new Hashtable();
        int n = KEY_PREFIX.length();
        SmCacheRemitter smCacheRemitter = this;
        synchronized (smCacheRemitter) {
            object = this.Cache.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                if (!string.startsWith(KEY_PREFIX) || !matcher.doEmit(string.substring(n))) continue;
                Vector vector = (Vector)this.Cache.get(string);
                int n2 = vector.size();
                int n3 = 0;
                while (n3 < n2) {
                    if (!hashtable.contains(vector.elementAt(n3))) {
                        hashtable.put(vector.elementAt(n3), vector.elementAt(n3));
                    }
                    ++n3;
                }
            }
        }
        int n4 = hashtable.size();
        if (n4 == 0) {
            UcDDL.logDebugMessage((String)"Cache: nothing emitted");
        } else {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                object = (Job)enumeration.nextElement();
                ((ScRequestJoiner)object).emit();
            }
        }
    }

    protected void jobAdded() {
    }

    protected ScRequestSink newSink(SvRequestEvent svRequestEvent) throws ScRequestDispatchException {
        boolean bl;
        Job job;
        String[] stringArray = svRequestEvent.getURL();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(JOB_PREFIX);
        stringBuffer.append(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append("\u0000");
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        stringBuffer.append("\u0000\u0000");
        stringBuffer.append(svRequestEvent.getPeriod());
        String string = stringBuffer.toString();
        SmCacheRemitter smCacheRemitter = this;
        synchronized (smCacheRemitter) {
            job = (Job)this.Cache.get(string);
            if (job == null) {
                job = new Job(string);
                this.Cache.put(string, job);
                this.jobAdded();
                bl = true;
            } else {
                bl = false;
            }
        }
        UcDDL.logInfoMessage((String)("Cache: " + (bl ? "new entry" : "got hit") + " for '" + svRequestEvent.getURL()[0] + "', '" + svRequestEvent.getPeriod() + "'"));
        return (ScRequestSink)job.createSink(svRequestEvent);
    }

    public static interface Matcher {
        public boolean doEmit(String var1);
    }

    private class Job
    extends ScRequestJoiner {
        private String FullKey;
        private String[][] Keys;

        Job(String string) {
            super(SmCacheRemitter.this.getRequestDispatcher());
            this.FullKey = string;
            this.Keys = null;
        }

        private void addKey(String string) {
            string = SmCacheRemitter.KEY_PREFIX + string;
            Vector<Job> vector = (Vector<Job>)SmCacheRemitter.this.Cache.get(string);
            if (vector == null) {
                vector = new Vector<Job>();
                SmCacheRemitter.this.Cache.put(string, vector);
            }
            vector.addElement(this);
        }

        protected void allDeleted() {
            SmCacheRemitter.this.Cache.remove(this.FullKey);
            if (this.Keys != null) {
                int n = 0;
                while (n < this.Keys.length) {
                    int n2 = 0;
                    while (n2 < this.Keys[n].length) {
                        this.removeKey(this.Keys[n][n2]);
                        ++n2;
                    }
                    ++n;
                }
            }
            super.allDeleted();
        }

        void dump(PrintWriter printWriter) {
            printWriter.println("    # originating requests=" + this.getNumSinks());
            String string = this.FullKey.substring(1);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0000");
            int n = stringTokenizer.countTokens() - 1;
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (n2 == n) {
                    printWriter.println("    period=" + string2);
                    continue;
                }
                printWriter.println("    url[" + n2 + "]=" + string2);
                ++n2;
            }
            if (this.Keys == null) {
                printWriter.println("    keys=null");
            } else {
                int n3 = 0;
                while (n3 < this.Keys.length) {
                    int n4 = 0;
                    while (n4 < this.Keys[n3].length) {
                        printWriter.println("    keys[" + n3 + "][" + n4 + "]='" + this.Keys[n3][n4] + "'");
                        ++n4;
                    }
                    ++n3;
                }
            }
        }

        protected void ready() {
            this.Keys = this.getCacheKeys();
            if (this.Keys != null) {
                int n = 0;
                while (n < this.Keys.length) {
                    int n2 = 0;
                    while (n2 < this.Keys[n].length) {
                        this.addKey(this.Keys[n][n2]);
                        ++n2;
                    }
                    ++n;
                }
            }
        }

        private void removeKey(String string) {
            string = SmCacheRemitter.KEY_PREFIX + string;
            Vector vector = (Vector)SmCacheRemitter.this.Cache.get(string);
            vector.removeElement(this);
            if (vector.size() == 0) {
                SmCacheRemitter.this.Cache.remove(string);
            }
        }

        protected void sinkDelete(ScRequestSink scRequestSink) {
            SmCacheRemitter smCacheRemitter = SmCacheRemitter.this;
            synchronized (smCacheRemitter) {
                super.sinkDelete(scRequestSink);
                if (SmCacheRemitter.this.Cache.size() == 0) {
                    SmCacheRemitter.this.cacheEmpty();
                }
            }
        }
    }
}

