/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.request;

import com.sun.symon.apps.generic.help.SMHelpBrowser;
import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.group.SMObjectGroup;
import com.sun.symon.base.client.group.SMObjectGroupInfo;
import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDBChangeListener;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMStaleDataException;
import com.sun.symon.base.client.task.SMTask;
import com.sun.symon.base.client.task.SMTaskInfo;
import com.sun.symon.base.client.task.SMTaskRequestData;
import com.sun.symon.base.client.task.SMTaskRequestInfo;
import com.sun.symon.base.console.awx.AwxObject;
import com.sun.symon.base.console.grouping.CgUtil;
import com.sun.symon.base.console.grouping.request.CgRequestManagerDialog;
import com.sun.symon.base.console.grouping.request.ChangeNotifier;
import com.sun.symon.base.console.grouping.request.TitledLayout;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.console.views.table.CvBaseTable;
import com.sun.symon.base.console.views.table.CvBaseTableModel;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcConfirmDialog;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcThreadWorker;
import com.sun.symon.base.utility.UcToolTipCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CgRequestUpdateDialog
extends JDialog
implements ActionListener {
    static String[] frequency = new String[]{CgUtil.getI18nMsg((String)"oneTime"), CgUtil.getI18nMsg((String)"minutes"), CgUtil.getI18nMsg((String)"hourly"), CgUtil.getI18nMsg((String)"daily"), CgUtil.getI18nMsg((String)"weekly"), CgUtil.getI18nMsg((String)"monthly")};
    static String[] dayOfWeek = new String[]{CgUtil.getI18nMsg((String)"sunday"), CgUtil.getI18nMsg((String)"monday"), CgUtil.getI18nMsg((String)"tuesday"), CgUtil.getI18nMsg((String)"wednesday"), CgUtil.getI18nMsg((String)"thursday"), CgUtil.getI18nMsg((String)"friday"), CgUtil.getI18nMsg((String)"saturday")};
    private JButton taskMgrBtn;
    private JButton ogMgrBtn;
    private JButton cancelBtn;
    private JButton saveBtn;
    private JButton helpBtn;
    private CvBaseTable taskTbl;
    private CvBaseTable ogTbl;
    private CvBaseTable mcpTaskTbl;
    private JTabbedPane tabPane;
    private JTabbedPane taskTabPane;
    private JCheckBox scheduleBox;
    private JComboBox frequencyCmB;
    private JComboBox dayOfWeekCmB;
    private JTextField timeFld;
    private JTextField dayOfMonthFld;
    private JComboBox forCmB;
    private JLabel unitLbl;
    private JLabel statusLbl;
    private boolean isAddDlg = true;
    private CgRequestManagerDialog rqstMgrDlg;
    private SMTaskInfo[] tasks;
    private SMTaskInfo[] mcpTasks;
    private SMTaskRequestData request;
    private SMObjectGroupInfo[] objectGroups;
    private SMTask taskHandle;
    private SMObjectGroup ogHandle;
    private TaskTableModel taskTblModel;
    private TaskTableModel mcpTaskTblModel;
    private OGTableModel ogTblModel;
    private boolean runNow = false;
    static /* synthetic */ Class class$java$lang$String;

    public CgRequestUpdateDialog(CgRequestManagerDialog cgRequestManagerDialog) throws SMAPIException {
        this(cgRequestManagerDialog, null);
    }

    public CgRequestUpdateDialog(CgRequestManagerDialog cgRequestManagerDialog, SMTaskRequestInfo sMTaskRequestInfo) throws SMAPIException {
        super((JFrame)cgRequestManagerDialog.getOwner());
        String string;
        this.rqstMgrDlg = cgRequestManagerDialog;
        SMRawDataRequest sMRawDataRequest = SMConsoleContext.getInstance().getAPIHandle();
        this.taskHandle = new SMTask(sMRawDataRequest);
        this.ogHandle = new SMObjectGroup(sMRawDataRequest);
        UcCommon.isServiceLicenseAvailable((String)"task", (Component)cgRequestManagerDialog);
        this.createGUI();
        this.installListeners();
        String string2 = null;
        if (sMTaskRequestInfo != null) {
            string2 = CgUtil.getI18nMsg((String)("modifyRqst(" + sMTaskRequestInfo.getName() + ")"));
            this.isAddDlg = false;
            try {
                this.request = this.rqstMgrDlg.rqstHandle.load(sMTaskRequestInfo);
            }
            catch (SMAPIException sMAPIException) {
                UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
            }
        } else {
            this.request = new SMTaskRequestData();
            string = CgUtil.getI18nMsg((String)"untitle");
            string2 = CgUtil.getI18nMsg((String)("addRqst(" + string + ")"));
            try {
                this.request.setName(string);
            }
            catch (SMAPIException sMAPIException) {}
            this.isAddDlg = true;
        }
        this.setTitle(string2);
        this.fillData();
        string = new UcToolTipCellRenderer();
        TableColumnModel tableColumnModel = this.taskTbl.getColumnModel();
        tableColumnModel.getColumn(0).setCellRenderer((TableCellRenderer)((Object)string));
        tableColumnModel.getColumn(1).setCellRenderer((TableCellRenderer)((Object)string));
        tableColumnModel = this.ogTbl.getColumnModel();
        tableColumnModel.getColumn(0).setCellRenderer((TableCellRenderer)((Object)string));
        tableColumnModel.getColumn(1).setCellRenderer((TableCellRenderer)((Object)string));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CgRequestUpdateDialog.this.close();
            }
        });
    }

    static /* synthetic */ boolean access$2(CgRequestUpdateDialog cgRequestUpdateDialog) {
        return cgRequestUpdateDialog.isAddDlg;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.taskMgrBtn) {
            this.setCursor(new Cursor(3));
            CmConsoleSession cmConsoleSession = CmConsoleSession.getInstance();
            String[] stringArray = new String[]{".console.console-1", ".templates.tools.taskManager"};
            cmConsoleSession.launchUniqueFrame(stringArray);
            this.setCursor(new Cursor(0));
        } else if (object == this.ogMgrBtn) {
            String[] stringArray = new String[]{".console.console-1", "com.sun.symon.base.console.grouping.objectgroup.CgOGManagerDialog"};
            CmConsoleSession.getInstance().launchApp(stringArray);
        } else if (object == this.cancelBtn) {
            this.close();
        } else if (object == this.helpBtn) {
            CmConsoleSession.getInstance().launchHelp("grouping-request-editor-help");
        } else if (object == this.saveBtn) {
            this.save(true);
        }
    }

    void afterSaveSuc() {
        this.statusLbl.setText(CgUtil.getI18nMsg((String)"saveSuc"));
        this.setTitle(CgUtil.getI18nMsg((String)("modifyRqst(" + this.request.getName() + ")")));
        this.saveBtn.setEnabled(true);
        this.isAddDlg = false;
    }

    boolean beforeSave(boolean bl) {
        Object object;
        if (!this.getRequestData()) {
            return false;
        }
        if (!this.request.isScheduled()) {
            object = new String[]{CgUtil.getI18nMsg((String)"yes"), CgUtil.getI18nMsg((String)"no"), CgUtil.getI18nMsg((String)"cancel")};
            UcConfirmDialog ucConfirmDialog = new UcConfirmDialog((Dialog)this, CgUtil.getI18nMsg((String)"noRqstScheduled"), CgUtil.getI18nMsg((String)"startDlg.info1"), CgUtil.getI18nMsg((String)"startDlg.info2"), object);
            ucConfirmDialog.pack();
            ucConfirmDialog.setLocationRelativeTo(this);
            ucConfirmDialog.setVisible(true);
            int n = ucConfirmDialog.getClicked();
            if (n == 2) {
                return false;
            }
            if (n == 0) {
                this.request.setStartDate(null);
                this.runNow = true;
            }
        }
        this.statusLbl.setText(" ");
        if (bl) {
            object = CgUtil.showSave((Component)this, (String)CgUtil.getI18nMsg((String)"rqstEditor.saveRqst"), (String)CgUtil.getI18nMsg((String)"rqstEditor.rqstNameLbl"), (int)32, (int)256, (String)this.request.getName(), (String)this.request.getDescription());
            if (object != null) {
                try {
                    this.request.setName((String)object.elementAt(0));
                    this.request.setDescription((String)object.elementAt(1));
                }
                catch (SMAPIException sMAPIException) {}
            } else {
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    void close() {
        ((Component)this).setVisible(false);
        try {
            this.taskHandle.close();
            this.ogHandle.close();
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
        }
        this.dispose();
    }

    JPanel createControlPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 0, 10, 10));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 5, 0));
        jPanel.add((Component)jPanel2, "East");
        this.saveBtn = new JButton(CgUtil.getI18nMsg((String)"standard.save"));
        jPanel2.add(this.saveBtn);
        this.cancelBtn = new JButton(CgUtil.getI18nMsg((String)"cancel"));
        jPanel2.add(this.cancelBtn);
        this.helpBtn = new JButton(CgUtil.getI18nMsg((String)"help"));
        jPanel2.add(this.helpBtn);
        return jPanel;
    }

    void createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab(CgUtil.getI18nMsg((String)"rqstUdt.taskOGtab"), this.createTaskOGPanel());
        SMRawDataRequest sMRawDataRequest = SMConsoleContext.getInstance().getAPIHandle();
        SMResourceAccess sMResourceAccess = new SMResourceAccess(sMRawDataRequest);
        ImageIcon imageIcon = new ImageIcon(sMResourceAccess.getImage("stdimages/scheduled.gif"));
        this.tabPane.addTab(CgUtil.getI18nMsg((String)"schTab"), imageIcon, this.createSchedulePanel());
        this.tabPane.setBorder(new EmptyBorder(5, 0, 0, 0));
        jPanel.add(this.tabPane);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.createControlPanel(), "North");
        this.statusLbl = new JLabel(" ");
        this.statusLbl.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.statusLbl.setForeground(Color.black);
        jPanel2.add((Component)this.statusLbl, "South");
        jPanel.add((Component)jPanel2, "South");
        this.setContentPane(jPanel);
    }

    JPanel createSchedulePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel(new TitledLayout());
        jPanel.add((Component)jPanel2, "North");
        this.scheduleBox = new JCheckBox(CgUtil.getI18nMsg((String)"setSchedule"));
        jPanel2.add((Component)this.scheduleBox, "North");
        Dimension dimension = this.scheduleBox.getPreferredSize();
        jPanel2.setBorder(new CompoundBorder(new EmptyBorder(dimension.height / 2, 2, 2, 2), LineBorder.createGrayLineBorder()));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new EmptyBorder(0, 25, 5, 5));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel3.setLayout(gridBagLayout);
        jPanel2.add(jPanel3);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        JLabel jLabel = new JLabel(CgUtil.getI18nMsg((String)"time"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel3.add(jLabel);
        gridBagConstraints.gridy = 1;
        jLabel = new JLabel(CgUtil.getI18nMsg((String)"frequency"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel3.add(jLabel);
        gridBagConstraints.gridy = 2;
        jLabel = new JLabel(CgUtil.getI18nMsg((String)"for"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel3.add(jLabel);
        gridBagConstraints.gridy = 3;
        jLabel = new JLabel(CgUtil.getI18nMsg((String)"dayOfWeek"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel3.add(jLabel);
        gridBagConstraints.gridy = 4;
        jLabel = new JLabel(CgUtil.getI18nMsg((String)"dayOfMonth"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel3.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.timeFld = new JTextField(5);
        this.timeFld.setEnabled(false);
        this.timeFld.setText("00:00");
        gridBagLayout.setConstraints(this.timeFld, gridBagConstraints);
        jPanel3.add(this.timeFld);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.frequencyCmB = new JComboBox<String>(frequency);
        this.frequencyCmB.setEnabled(false);
        gridBagLayout.setConstraints(this.frequencyCmB, gridBagConstraints);
        jPanel3.add(this.frequencyCmB);
        gridBagConstraints.gridy = 2;
        this.forCmB = new JComboBox();
        this.forCmB.setEditable(true);
        this.forCmB.setEnabled(false);
        int n = 1;
        while (n <= 14) {
            this.forCmB.addItem(String.valueOf(n));
            ++n;
        }
        this.forCmB.setSelectedIndex(0);
        gridBagLayout.setConstraints(this.forCmB, gridBagConstraints);
        jPanel3.add(this.forCmB);
        gridBagConstraints.gridy = 3;
        this.dayOfWeekCmB = new JComboBox<String>(dayOfWeek);
        this.dayOfWeekCmB.setEnabled(false);
        gridBagLayout.setConstraints(this.dayOfWeekCmB, gridBagConstraints);
        jPanel3.add(this.dayOfWeekCmB);
        gridBagConstraints.gridy = 4;
        this.dayOfMonthFld = new JTextField(10);
        this.dayOfMonthFld.setEnabled(false);
        this.dayOfMonthFld.setText("1");
        gridBagLayout.setConstraints(this.dayOfMonthFld, gridBagConstraints);
        jPanel3.add(this.dayOfMonthFld);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 2;
        this.unitLbl = new JLabel("     ");
        gridBagLayout.setConstraints(this.unitLbl, gridBagConstraints);
        jPanel3.add(this.unitLbl);
        return jPanel;
    }

    JPanel createTaskOGPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        this.ogMgrBtn = new JButton(CgUtil.getI18nMsg((String)"ogmgr"));
        Dimension dimension = this.ogMgrBtn.getPreferredSize();
        Dimension dimension2 = this.ogMgrBtn.getMinimumSize();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new TitledBorder(LineBorder.createGrayLineBorder(), CgUtil.getI18nMsg((String)"task")));
        jPanel3.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new TitledBorder(LineBorder.createGrayLineBorder(), CgUtil.getI18nMsg((String)"objectgroup")));
        JPanel jPanel4 = new JPanel();
        jPanel3.add(jPanel4);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(jPanel3);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setBorder(new EmptyBorder(3, 10, 10, 10));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.taskTabPane = new JTabbedPane();
        gridBagLayout.setConstraints(this.taskTabPane, gridBagConstraints);
        jPanel2.add((Component)this.taskTabPane, gridBagConstraints);
        this.taskTbl = new CvBaseTable();
        this.taskTbl.setSelectionMode(0);
        this.taskTbl.setCellSelectionEnabled(false);
        this.taskTbl.setBackground(jPanel2.getBackground());
        this.taskTbl.setPreferredScrollableViewportSize(new Dimension(200, 120));
        JScrollPane jScrollPane = new JScrollPane((Component)this.taskTbl);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel5.add(jScrollPane);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        String string = CgUtil.getI18nMsg((String)"otherTask");
        this.taskTabPane.add(string, jPanel5);
        this.mcpTaskTbl = new CvBaseTable();
        this.mcpTaskTbl.setSelectionMode(0);
        this.mcpTaskTbl.setCellSelectionEnabled(false);
        this.mcpTaskTbl.setBackground(jPanel2.getBackground());
        this.mcpTaskTbl.setPreferredScrollableViewportSize(new Dimension(200, 120));
        jScrollPane = new JScrollPane((Component)this.mcpTaskTbl);
        jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel5.add(jScrollPane);
        String string2 = CgUtil.getI18nMsg((String)"mcpTask");
        this.taskTabPane.add(string2, jPanel5);
        JLabel jLabel = new JLabel(String.valueOf(string) + string2 + "WWW");
        Dimension dimension3 = this.taskTabPane.getPreferredSize();
        dimension3.width = jLabel.getPreferredSize().width;
        this.taskTabPane.setPreferredSize(dimension3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(32, 10, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        this.taskMgrBtn = new JButton(CgUtil.getI18nMsg((String)"taskmgr"));
        gridBagLayout.setConstraints(this.taskMgrBtn, gridBagConstraints);
        jPanel2.add((Component)this.taskMgrBtn, gridBagConstraints);
        this.taskMgrBtn.setPreferredSize(dimension);
        this.taskMgrBtn.setMinimumSize(dimension2);
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        jPanel4.setLayout(gridBagLayout);
        jPanel4.setBorder(new EmptyBorder(3, 10, 10, 10));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.ogTbl = new CvBaseTable();
        this.ogTbl.setCellSelectionEnabled(false);
        this.ogTbl.setBackground(jPanel4.getBackground());
        this.ogTbl.setSelectionMode(0);
        this.ogTbl.setPreferredScrollableViewportSize(new Dimension(200, 100));
        jScrollPane = new JScrollPane((Component)this.ogTbl);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel4.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        gridBagLayout.setConstraints(this.ogMgrBtn, gridBagConstraints);
        jPanel4.add((Component)this.ogMgrBtn, gridBagConstraints);
        return jPanel;
    }

    private void fillData() {
        this.taskTblModel = new TaskTableModel(false);
        this.ogTblModel = new OGTableModel();
        this.mcpTaskTblModel = new TaskTableModel(true);
        this.mcpTaskTbl.setModel((TableModel)((Object)this.mcpTaskTblModel));
        this.taskTbl.setModel((TableModel)((Object)this.taskTblModel));
        this.ogTbl.setModel((TableModel)((Object)this.ogTblModel));
        Runnable runnable = new Runnable(){

            public void run() {
                Object object;
                CgRequestUpdateDialog.this.taskChanged(null);
                CgRequestUpdateDialog.this.ogChanged(null);
                try {
                    object = new ChangeNotifier(0, CgRequestUpdateDialog.this);
                    CgRequestUpdateDialog.this.taskHandle.addDBChangeListener((SMDBChangeListener)object);
                    object = new ChangeNotifier(1, CgRequestUpdateDialog.this);
                    CgRequestUpdateDialog.this.ogHandle.addDBChangeListener((SMDBChangeListener)object);
                }
                catch (SMAPIException sMAPIException) {
                    UcDialog.showError((Component)CgRequestUpdateDialog.this, (Object)sMAPIException.getMessage());
                }
                object = new Runnable(CgRequestUpdateDialog.this){
                    private final /* synthetic */ CgRequestUpdateDialog this$0;
                    {
                        this.this$0 = cgRequestUpdateDialog;
                    }

                    public void run() {
                        if (!CgRequestUpdateDialog.access$2(this.this$0)) {
                            this.this$0.setRequestData();
                        }
                    }
                };
                SwingUtilities.invokeLater((Runnable)object);
            }
        };
        new Thread(runnable).start();
    }

    SMObjectGroupInfo[] getAllObjectGroups() {
        SMObjectGroupInfo[] sMObjectGroupInfoArray = null;
        try {
            sMObjectGroupInfoArray = this.ogHandle.getAll();
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
        }
        return sMObjectGroupInfoArray;
    }

    SMTaskInfo[] getAllTasks(Vector vector, Vector vector2) {
        SMTaskInfo[] sMTaskInfoArray = null;
        try {
            sMTaskInfoArray = this.taskHandle.getAll();
            int n = 0;
            while (n < sMTaskInfoArray.length) {
                if (sMTaskInfoArray[n].getTaskType() == 3) {
                    vector.addElement(sMTaskInfoArray[n]);
                } else {
                    vector2.addElement(sMTaskInfoArray[n]);
                }
                ++n;
            }
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
        }
        return sMTaskInfoArray;
    }

    boolean getRequestData() {
        int n;
        boolean bl = this.scheduleBox.isSelected();
        try {
            if (this.taskTabPane.getSelectedIndex() == 0) {
                n = this.taskTbl.getSelectedRow();
                if (n == -1) {
                    UcDialog.showError((Component)this, (Object)CgUtil.getI18nMsg((String)"noTask"));
                    this.tabPane.setSelectedIndex(0);
                    return false;
                }
                n = this.taskTblModel.getRealRow(n);
                this.request.setTaskName(this.tasks[n].getName());
            } else {
                n = this.mcpTaskTbl.getSelectedRow();
                if (n == -1) {
                    UcDialog.showError((Component)this, (Object)CgUtil.getI18nMsg((String)"noTask"));
                    this.tabPane.setSelectedIndex(0);
                    return false;
                }
                n = this.mcpTaskTblModel.getRealRow(n);
                this.request.setTaskName(this.mcpTasks[n].getName());
            }
            n = this.ogTbl.getSelectedRow();
            if (n == -1) {
                UcDialog.showError((Component)this, (Object)CgUtil.getI18nMsg((String)"noOG"));
                this.tabPane.setSelectedIndex(0);
                return false;
            }
            n = this.ogTblModel.getRealRow(n);
            this.request.setObjectGroupName(this.objectGroups[n].getName());
            this.request.setScheduled(bl);
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
            return false;
        }
        if (bl) {
            Object object;
            int n2;
            Object object2;
            n = 0;
            int n3 = 0;
            int n4 = 0;
            if (this.timeFld.isEnabled()) {
                object2 = this.timeFld.getText();
                n2 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer((String)object2, ":");
                object = new String[2];
                int n5 = 0;
                while (n5 < 2) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        n2 = 1;
                        break;
                    }
                    object[n5] = stringTokenizer.nextToken();
                    ++n5;
                }
                if (n2 == 0) {
                    try {
                        n = new Integer(object[0]);
                        n3 = new Integer(object[1]);
                        if (n4 > 31 || n4 < 0) {
                            n2 = 1;
                        }
                        if (n > 23 || n < 0) {
                            n2 = 1;
                        }
                        if (n3 > 59 || n3 < 0) {
                            n2 = 1;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        n2 = 1;
                    }
                }
                if (n2 != 0) {
                    UcDialog.showError((Component)this, (Object)CgUtil.getI18nMsg((String)"scheduleErr"));
                    this.tabPane.setSelectedIndex(1);
                    this.timeFld.selectAll();
                    this.timeFld.requestFocus();
                    return false;
                }
            }
            if (this.dayOfMonthFld.isEnabled()) {
                boolean bl2 = false;
                try {
                    n4 = new Integer(this.dayOfMonthFld.getText());
                    if (n4 < 1 || n4 > 28) {
                        bl2 = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bl2 = true;
                }
                if (bl2) {
                    UcDialog.showError((Component)this, (Object)CgUtil.getI18nMsg((String)"scheduleErr"));
                    this.tabPane.setSelectedIndex(1);
                    this.dayOfMonthFld.selectAll();
                    this.dayOfMonthFld.requestFocus();
                    return false;
                }
            }
            object2 = Calendar.getInstance();
            n2 = this.frequencyCmB.getSelectedIndex();
            int n6 = 0;
            if (n2 == 1) {
                n6 = 1;
            } else if (n2 == 2) {
                n6 = 2;
            } else if (n2 == 3) {
                n6 = 3;
            } else if (n2 == 4) {
                n6 = 4;
                ((Calendar)object2).set(7, this.dayOfWeekCmB.getSelectedIndex() + 1);
            } else if (n2 == 5) {
                n6 = 5;
                ((Calendar)object2).set(5, n4);
            }
            if (n2 != 0) {
                object = (String)this.forCmB.getEditor().getItem();
                long l = 0L;
                try {
                    l = new Long((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    UcDialog.showError((Component)this, (Object)CgUtil.getI18nMsg((String)"scheduleErr"));
                    this.tabPane.setSelectedIndex(1);
                    return false;
                }
                this.request.setPeriod(l);
            }
            ((Calendar)object2).set(11, n);
            ((Calendar)object2).set(12, n3);
            ((Calendar)object2).set(13, 0);
            if (n6 == 0 && ((Calendar)object2).before(object = Calendar.getInstance())) {
                ((Calendar)object2).add(5, 1);
            }
            this.request.setStartDate(((Calendar)object2).getTime());
            this.request.setPeriodUnits(n6);
        } else {
            this.request.setStartDate(null);
            this.request.setPeriodUnits(0);
            this.request.setPeriod(1L);
        }
        return true;
    }

    public String getRequestName() {
        String string = "";
        if (!this.isAddDlg) {
            string = this.request.getName();
        }
        return string;
    }

    private SMTaskInfo[] getTaskArray(Vector vector) {
        int n = vector.size();
        SMTaskInfo[] sMTaskInfoArray = new SMTaskInfo[n];
        int n2 = 0;
        while (n2 < n) {
            sMTaskInfoArray[n2] = (SMTaskInfo)vector.elementAt(n2);
            ++n2;
        }
        return sMTaskInfoArray;
    }

    void handleFrequency() {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = " ";
        int n = this.frequencyCmB.getSelectedIndex();
        if (n == 0) {
            bl = false;
            string = " ";
        } else if (n == 1) {
            string = CgUtil.getI18nMsg((String)"minuteUnit");
        } else if (n == 2) {
            string = CgUtil.getI18nMsg((String)"hourUnit");
        } else if (n == 3) {
            string = CgUtil.getI18nMsg((String)"dayUnit");
        } else if (n == 4) {
            bl2 = true;
            string = CgUtil.getI18nMsg((String)"weekUnit");
        } else if (n == 5) {
            bl3 = true;
            string = CgUtil.getI18nMsg((String)"monthUnit");
        }
        this.forCmB.setEnabled(bl);
        this.dayOfWeekCmB.setEnabled(bl2);
        this.dayOfMonthFld.setEnabled(bl3);
        this.unitLbl.setText(string);
    }

    void help() {
        CmConsoleSession cmConsoleSession = CmConsoleSession.getInstance();
        SMHelpBrowser sMHelpBrowser = (SMHelpBrowser)((AwxObject)cmConsoleSession.locate("~helpmanager", true)).getBean();
        sMHelpBrowser.init("");
    }

    private void installListeners() {
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CgRequestUpdateDialog.this.setSaveBtnStatus();
            }
        };
        this.scheduleBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = CgRequestUpdateDialog.this.scheduleBox.isSelected();
                CgRequestUpdateDialog.this.frequencyCmB.setEnabled(bl);
                CgRequestUpdateDialog.this.forCmB.setEnabled(bl);
                CgRequestUpdateDialog.this.timeFld.setEnabled(bl);
                CgRequestUpdateDialog.this.dayOfWeekCmB.setEnabled(bl);
                CgRequestUpdateDialog.this.dayOfMonthFld.setEnabled(bl);
                if (bl) {
                    CgRequestUpdateDialog.this.handleFrequency();
                }
            }
        });
        this.frequencyCmB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CgRequestUpdateDialog.this.handleFrequency();
            }
        });
        ListSelectionModel listSelectionModel = this.taskTbl.getSelectionModel();
        listSelectionModel.addListSelectionListener(listSelectionListener);
        listSelectionModel = this.ogTbl.getSelectionModel();
        listSelectionModel.addListSelectionListener(listSelectionListener);
        listSelectionModel = this.mcpTaskTbl.getSelectionModel();
        listSelectionModel.addListSelectionListener(listSelectionListener);
        this.taskTabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CgRequestUpdateDialog.this.setSaveBtnStatus();
            }
        });
        this.saveBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        this.taskMgrBtn.addActionListener(this);
        this.ogMgrBtn.addActionListener(this);
        this.helpBtn.addActionListener(this);
    }

    public boolean isAddDialog() {
        return this.isAddDlg;
    }

    public void ogChanged(SMDBChangeEvent sMDBChangeEvent) {
        this.statusLbl.setText(CgUtil.getI18nMsg((String)"loadOG"));
        final SMObjectGroupInfo[] sMObjectGroupInfoArray = this.getAllObjectGroups();
        Runnable runnable = new Runnable(){

            public void run() {
                int n = ogTbl.getSelectedRow();
                objectGroups = sMObjectGroupInfoArray;
                ((AbstractTableModel)((Object)ogTblModel)).fireTableDataChanged();
                ogTbl.clearSelection();
                int n2 = ogTbl.getRowCount();
                if (n != -1 && n2 != 0 && n2 > n) {
                    ogTbl.setRowSelectionInterval(n, n);
                }
                ogTbl.invalidate();
                statusLbl.setText(" ");
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    void refreshTable(CvBaseTable cvBaseTable) {
        int n = cvBaseTable.getSelectedRow();
        CvBaseTableModel cvBaseTableModel = (CvBaseTableModel)cvBaseTable.getModel();
        cvBaseTableModel.fireTableDataChanged();
        cvBaseTable.clearSelection();
        int n2 = cvBaseTable.getRowCount();
        if (n != -1 && n2 != 0 && n2 > n) {
            cvBaseTable.setRowSelectionInterval(n, n);
        }
        cvBaseTable.invalidate();
    }

    void save(boolean bl) {
        final String string = this.request.getName();
        final String string2 = this.request.getDescription();
        if (this.beforeSave(bl)) {
            if (string.equals(this.request.getName())) {
                bl = false;
            }
            final boolean bl2 = bl;
            UcThreadWorker ucThreadWorker = new UcThreadWorker(){
                boolean saveSuc = false;

                public void doWork() {
                    if (this.saveRequest(bl2)) {
                        this.saveSuc = true;
                        if (runNow) {
                            try {
                                ((CgRequestUpdateDialog)this).rqstMgrDlg.rqstHandle.resume(request.getObjectID());
                            }
                            catch (SMAPIException sMAPIException) {
                                UcDialog.showError((Component)this, (Object)(String.valueOf(CgUtil.getI18nMsg((String)"failResume")) + "\n" + sMAPIException.getMessage()));
                                this.saveSuc = false;
                                return;
                            }
                        }
                        this.close();
                    }
                }

                public void workDone() {
                    if (this.saveSuc) {
                        this.afterSaveSuc();
                    } else {
                        this.saveUnsuccess(string, string2);
                    }
                }
            };
            ucThreadWorker.start();
        }
    }

    boolean saveRequest(boolean bl) {
        String string = this.request.getName();
        try {
            if (bl) {
                this.request = this.rqstMgrDlg.rqstHandle.saveAs(this.request, string);
            } else {
                this.rqstMgrDlg.rqstHandle.save(this.request);
            }
        }
        catch (SMStaleDataException sMStaleDataException) {
            int n = JOptionPane.showConfirmDialog(this, CgUtil.getI18nMsg((String)"continueSave"), CgUtil.getI18nMsg((String)"ogUdt.confirmDlg"), 0);
            if (n == 0) {
                try {
                    SMTaskRequestData sMTaskRequestData = this.rqstMgrDlg.rqstHandle.load(string);
                    this.request.setTimestamp(sMTaskRequestData.getTimestamp());
                    return this.saveRequest(bl);
                }
                catch (SMAPIException sMAPIException) {
                    CgUtil.handleAPIException((SMAPIException)sMAPIException, (Component)this);
                    return false;
                }
            }
            return false;
        }
        catch (SMDuplicateException sMDuplicateException) {
            int n = JOptionPane.showConfirmDialog(this, CgUtil.getI18nMsg((String)("confirmOverwrite(" + string + ")")), CgUtil.getI18nMsg((String)"ogUdt.confirmDlg"), 0);
            if (n == 0) {
                try {
                    SMTaskRequestData sMTaskRequestData = this.rqstMgrDlg.rqstHandle.load(string);
                    this.rqstMgrDlg.rqstHandle.delete((SMTaskRequestInfo)sMTaskRequestData);
                    return this.saveRequest(bl);
                }
                catch (SMAPIException sMAPIException) {
                    CgUtil.handleAPIException((SMAPIException)sMAPIException, (Component)this);
                    return false;
                }
            }
            return false;
        }
        catch (SMAPIException sMAPIException) {
            CgUtil.handleAPIException((SMAPIException)sMAPIException, (Component)this);
            return false;
        }
        return true;
    }

    void saveUnsuccess(String string, String string2) {
        try {
            this.request.setName(string);
            this.request.setDescription(string2);
        }
        catch (SMAPIException sMAPIException) {}
    }

    void setRequestData() {
        int n;
        String string = this.request.getTaskName();
        String string2 = this.request.getObjectGroupName();
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.tasks.length) {
            if (this.tasks[n2].getName().equals(string)) {
                this.taskTbl.setRowSelectionInterval(n2, n2);
                break;
            }
            ++n2;
        }
        if (!bl) {
            n = 0;
            while (n < this.mcpTasks.length) {
                if (this.mcpTasks[n].getName().equals(string)) {
                    this.mcpTaskTbl.setRowSelectionInterval(n, n);
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        this.taskTabPane.setSelectedIndex(bl ? 1 : 0);
        n = 0;
        while (n < this.objectGroups.length) {
            if (this.objectGroups[n].getName().equals(string2)) {
                this.ogTbl.setRowSelectionInterval(n, n);
                break;
            }
            ++n;
        }
        if (this.request.isScheduled()) {
            this.scheduleBox.setSelected(true);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.request.getStartDate());
            int n3 = calendar.get(11);
            int n4 = calendar.get(12);
            String string3 = n3 < 10 ? "0" + n3 : String.valueOf(n3);
            String string4 = n4 < 10 ? "0" + n4 : String.valueOf(n4);
            String string5 = String.valueOf(string3) + ":" + string4;
            this.timeFld.setText(String.valueOf(calendar.get(11)) + ":" + calendar.get(12));
            int n5 = this.request.getPeriodUnits();
            int n6 = 0;
            if (n5 == 1) {
                n6 = 1;
            } else if (n5 == 2) {
                n6 = 2;
            } else if (n5 == 3) {
                n6 = 3;
            } else if (n5 == 4) {
                n6 = 4;
                int n7 = calendar.get(7);
                this.dayOfWeekCmB.setSelectedIndex(n7 - 1);
            } else if (n5 == 5) {
                n6 = 5;
                this.dayOfMonthFld.setText(String.valueOf(calendar.get(5)));
            } else {
                n6 = 0;
            }
            this.forCmB.getEditor().setItem(n6 == 0 ? "1" : String.valueOf(this.request.getPeriod()));
            this.timeFld.setText(string5);
            this.frequencyCmB.setSelectedIndex(n6);
        }
    }

    private void setSaveBtnStatus() {
        boolean bl = true;
        int n = this.taskTabPane.getSelectedIndex();
        ListSelectionModel listSelectionModel = this.taskTbl.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.mcpTaskTbl.getSelectionModel();
        if (this.ogTbl.getSelectionModel().isSelectionEmpty() || n == 0 && listSelectionModel.isSelectionEmpty() || n == 1 && listSelectionModel2.isSelectionEmpty()) {
            bl = false;
        }
    }

    public void taskChanged(SMDBChangeEvent sMDBChangeEvent) {
        this.statusLbl.setText(CgUtil.getI18nMsg((String)"loadTask"));
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.getAllTasks(vector, vector2);
        final SMTaskInfo[] sMTaskInfoArray = this.getTaskArray(vector);
        final SMTaskInfo[] sMTaskInfoArray2 = this.getTaskArray(vector2);
        Runnable runnable = new Runnable(){

            public void run() {
                tasks = sMTaskInfoArray;
                mcpTasks = sMTaskInfoArray2;
                this.refreshTable(taskTbl);
                this.refreshTable(mcpTaskTbl);
                statusLbl.setText(" ");
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    class TaskTableModel
    extends CvBaseTableModel {
        boolean isMCPModel = false;
        String[] columnNames = new String[]{CgUtil.getI18nMsg((String)"name"), CgUtil.getI18nMsg((String)"description")};

        TaskTableModel(boolean bl) {
            this.isMCPModel = bl;
        }

        public Class getColumnClass(int n) {
            return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = CgRequestUpdateDialog.class$("java.lang.String"));
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRealRow(int n) {
            return this.indexes[n];
        }

        public Object getRealValueAt(int n, int n2) {
            String string = null;
            SMTaskInfo sMTaskInfo = null;
            sMTaskInfo = !this.isMCPModel ? CgRequestUpdateDialog.this.tasks[n] : CgRequestUpdateDialog.this.mcpTasks[n];
            if (sMTaskInfo != null) {
                string = n2 == 0 ? sMTaskInfo.getName() : sMTaskInfo.getDescription();
            }
            return string;
        }

        public int getRowCount() {
            int n = 0;
            if (!this.isMCPModel) {
                if (CgRequestUpdateDialog.this.tasks != null) {
                    n = CgRequestUpdateDialog.this.tasks.length;
                }
            } else if (CgRequestUpdateDialog.this.mcpTasks != null) {
                n = CgRequestUpdateDialog.this.mcpTasks.length;
            }
            return n;
        }
    }

    class OGTableModel
    extends CvBaseTableModel {
        String[] columnNames = new String[]{CgUtil.getI18nMsg((String)"name"), CgUtil.getI18nMsg((String)"description")};

        OGTableModel() {
        }

        public Class getColumnClass(int n) {
            return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = CgRequestUpdateDialog.class$("java.lang.String"));
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRealRow(int n) {
            return this.indexes[n];
        }

        public Object getRealValueAt(int n, int n2) {
            String string = null;
            SMObjectGroupInfo sMObjectGroupInfo = CgRequestUpdateDialog.this.objectGroups[n];
            if (sMObjectGroupInfo != null) {
                string = n2 == 0 ? sMObjectGroupInfo.getName() : sMObjectGroupInfo.getDescription();
            }
            return string;
        }

        public int getRowCount() {
            int n = 0;
            if (CgRequestUpdateDialog.this.objectGroups != null) {
                n = CgRequestUpdateDialog.this.objectGroups.length;
            }
            return n;
        }
    }
}

