/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.jts;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import oracle.aurora.jndi.orb_dep.Orb;
import oracle.aurora.jts.CurrentImpl;
import oracle.aurora.jts.util.TS;
import oracle.aurora.jts.util.TransactionService;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import org.omg.CORBA.Environment;
import org.omg.CORBA.ORB;
import org.omg.CosTSPortability.TSIdentification;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.InvalidControl;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHolder;
import org.omg.CosTransactions.TransactionFactory;

public abstract class AuroraTransactionService
extends TransactionService {
    public static final int SERVICE_ID = 0;
    protected TransactionFactory txnFactory;
    private static Connection conn = null;
    protected Hashtable current;

    protected AuroraTransactionService() {
        TS.setTS(this);
        TS.setORB((ORB)Orb.init());
    }

    protected AuroraTransactionService(TransactionFactory fact) {
        this();
        this.txnFactory = fact;
    }

    protected Hashtable current() {
        if (this.current == null) {
            this.current = new Hashtable();
        }
        return this.current;
    }

    public abstract void endTxn(PropagationContext var1, boolean var2);

    public synchronized Current getCurrent() {
        Current c = (Current)this.current().get(Thread.currentThread());
        if (c == null) {
            c = new CurrentImpl();
            this.current().put(Thread.currentThread(), c);
        }
        return c;
    }

    synchronized CurrentImpl getCurrentOrNull() {
        return (CurrentImpl)this.current().get(Thread.currentThread());
    }

    private Connection getDefaultConnection() {
        if (conn != null) {
            return conn;
        }
        try {
            conn = new OracleDriver().defaultConnection();
            return conn;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract TransactionFactory getTxnFactory();

    public void identifyCommManager(TSIdentification ident) {
    }

    public abstract void joinTxn(PropagationContext var1);

    protected Control newTransaction(int timeout) {
        return this.getTxnFactory().create(timeout);
    }

    protected void propagate(PropagationContext ctx) {
        if (((CurrentImpl)this.getCurrent()).noTxn()) {
            ((CurrentImpl)this.getCurrent()).pushContext(null, ctx);
        }
    }

    public void received_reply(int id, PropagationContext ctx, Environment env) {
        CurrentImpl c = this.getCurrentOrNull();
        if (c == null) {
            return;
        }
        c.set_context(ctx);
    }

    public void received_request(int id, PropagationContext ctx) {
        CurrentImpl c = (CurrentImpl)this.getCurrent();
        if (c == null) {
            return;
        }
        c.pushContext(null, ctx);
        try {
            this.resumeTxn(ctx);
        }
        catch (InvalidControl invalidControl) {
            return;
        }
        ((OracleConnection)this.getDefaultConnection()).setXAErrorFlag(false);
    }

    protected Control recreate(PropagationContext ctxt) {
        return this.getTxnFactory().recreate(ctxt);
    }

    public abstract void resumeTxn(PropagationContext var1) throws InvalidControl;

    public void sending_reply(int id, PropagationContextHolder ctx) {
        CurrentImpl c = this.getCurrentOrNull();
        if (c == null) {
            return;
        }
        ctx.value = c.get_context();
        if (ctx.value != null) {
            c.popContext();
            ((OracleConnection)this.getDefaultConnection()).setXAErrorFlag(true);
            this.suspendTxn(ctx.value);
        }
    }

    public void sending_request(int id, PropagationContextHolder ctx) {
        CurrentImpl c = this.getCurrentOrNull();
        if (c == null) {
            return;
        }
        ctx.value = c.get_context();
    }

    public abstract void suspendTxn(PropagationContext var1);
}

