/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.xml.parser;

import java.lang.reflect.Method;
import java.security.Identity;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import javax.ejb.deployment.AccessControlEntry;
import javax.ejb.deployment.ControlDescriptor;
import javax.ejb.deployment.DeploymentDescriptor;
import javax.ejb.deployment.EntityDescriptor;
import javax.ejb.deployment.SessionDescriptor;
import javax.naming.CompositeName;
import oracle.aurora.ejb.OracleEntityDescriptor;
import oracle.aurora.ejb.parser.ParseError;
import oracle.aurora.ejb.parser.ParsedBean;
import oracle.aurora.ejb.persistence.ocmp.OcmpBeanMapping;
import oracle.aurora.ejb.xml.parser.EjbXMLElement;
import oracle.aurora.ejb.xml.parser.EnterpriseBeansElement;
import oracle.aurora.ejb.xml.parser.EntityElement;
import oracle.aurora.ejb.xml.parser.FieldTable;
import oracle.aurora.ejb.xml.parser.MethodAclEntry;
import oracle.aurora.ejb.xml.parser.MethodElement;
import oracle.aurora.ejb.xml.parser.MethodTable;
import oracle.aurora.ejb.xml.parser.RoleNameElement;
import oracle.aurora.ejb.xml.parser.SecurityRoleElement;
import oracle.aurora.ejb.xml.parser.SessionElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Visitor {
    private Stack nodeStack;
    private DeploymentDescriptor descriptor;
    private Vector roleList = new Vector();
    private ClassLoader loader;
    Vector accessVector = new Vector();
    Vector controlVector = new Vector();
    Vector cmpFields = new Vector();
    Vector params = new Vector();
    Hashtable mappings = new Hashtable();
    Properties properties = new Properties();
    MethodTable homeMethodTable;
    MethodTable methodTable;
    FieldTable fieldTable;
    Hashtable aclMethods = new Hashtable();
    OcmpBeanMapping beanMapping;

    public Visitor() {
        this.nodeStack = new Stack();
    }

    public Visitor(ClassLoader loader) {
        this.nodeStack = new Stack();
        this.loader = loader;
    }

    private void addToRoleList(SecurityRoleElement node) {
        String roleName = node.getAttribute("role-name");
        if (!this.roleList.contains(roleName)) {
            this.roleList.addElement(roleName);
        }
    }

    private void buildDD(EntityElement node) throws Exception {
        this.descriptor = new OracleEntityDescriptor();
        this.descriptor.setEnterpriseBeanClassName(node.getAttribute("ejb-class"));
        this.descriptor.setHomeInterfaceClassName(node.getAttribute("home"));
        this.descriptor.setRemoteInterfaceClassName(node.getAttribute("remote"));
        this.descriptor.setBeanHomeName(new CompositeName(node.getAttribute("ejb-name")));
        ((EntityDescriptor)this.descriptor).setPrimaryKeyClassName(node.getAttribute("prim-key-class"));
        this.descriptor.setReentrant(node.getAttribute("reentrant").equalsIgnoreCase("false"));
        this.descriptor.setEnvironmentProperties(this.properties);
        ((OracleEntityDescriptor)this.descriptor).setPersistenceType(node.getAttribute("persistence-type"));
        if (this.cmpFields.size() > 0) {
            int i = 0;
            Enumeration e = this.cmpFields.elements();
            while (e.hasMoreElements()) {
                ((EntityDescriptor)this.descriptor).setContainerManagedFields(i++, this.getFieldTable().findField((String)e.nextElement()));
            }
        }
    }

    private void buildDD(SessionElement node) throws Exception {
        this.descriptor = new SessionDescriptor();
        this.descriptor.setEnterpriseBeanClassName(node.getAttribute("ejb-class"));
        this.descriptor.setHomeInterfaceClassName(node.getAttribute("home"));
        this.descriptor.setRemoteInterfaceClassName(node.getAttribute("remote"));
        this.descriptor.setBeanHomeName(new CompositeName(node.getAttribute("ejb-name")));
        ((SessionDescriptor)this.descriptor).setStateManagementType(node.getAttribute("session-type").equals("Stateful") ? 1 : 0);
        this.descriptor.setEnvironmentProperties(this.properties);
    }

    public DeploymentDescriptor getDD() {
        return this.descriptor;
    }

    private FieldTable getFieldTable() throws Exception {
        if (this.fieldTable != null) {
            return this.fieldTable;
        }
        this.fieldTable = this.makeFieldTable(this.loader, this.descriptor.getEnterpriseBeanClassName());
        return this.fieldTable;
    }

    private MethodTable getHomeMethodTable() throws Exception {
        if (this.homeMethodTable != null) {
            return this.homeMethodTable;
        }
        this.homeMethodTable = this.makeMethodTable(this.loader, this.descriptor.getHomeInterfaceClassName());
        return this.methodTable;
    }

    private MethodTable getMethodTable() throws Exception {
        if (this.methodTable != null) {
            return this.methodTable;
        }
        this.methodTable = this.makeMethodTable(this.loader, this.descriptor.getEnterpriseBeanClassName());
        return this.methodTable;
    }

    FieldTable makeFieldTable(ClassLoader loader, String className) throws Exception {
        FieldTable fieldTable = new FieldTable(loader);
        try {
            fieldTable.addFields(ParsedBean.findClass(loader, className).getFields());
            return fieldTable;
        }
        catch (ClassNotFoundException e) {
            ParseError.CANNOT_LOAD_CLASS(e.getMessage());
            return null;
        }
        catch (SecurityException e) {
            ParseError.CANNOT_ACCESS_CLASS_FIELDS(e.getMessage());
            return null;
        }
    }

    MethodTable makeMethodTable(ClassLoader loader, String className) throws Exception {
        MethodTable methodTable = new MethodTable(loader);
        try {
            methodTable.addMethods(ParsedBean.findClass(loader, className).getMethods());
            return methodTable;
        }
        catch (ClassNotFoundException e) {
            ParseError.CANNOT_LOAD_CLASS(e.getMessage());
            return null;
        }
        catch (SecurityException e) {
            ParseError.CANNOT_ACCESS_CLASS_METHODS(e.getMessage());
            return null;
        }
    }

    private int mapTxAttr(String tx) {
        if (tx.equals("NotSupported")) {
            return 0;
        }
        if (tx.equals("Supports")) {
            return 3;
        }
        if (tx.equals("Required")) {
            return 2;
        }
        if (tx.equals("RequiresNew")) {
            return 4;
        }
        if (tx.equals("Mandatory")) {
            return 5;
        }
        if (tx.equals("Never")) {
            return -1;
        }
        return -1;
    }

    public void visitAssemblyDescriptorElement(Node node) {
        Enumeration e = this.aclMethods.elements();
        while (e.hasMoreElements()) {
            MethodAclEntry m = (MethodAclEntry)e.nextElement();
            AccessControlEntry c = m.getMethod() == null ? new AccessControlEntry() : new AccessControlEntry(m.getMethod());
            Identity[] identities = m.getRoles();
            c.setAllowedIdentities(identities);
            this.accessVector.addElement(c);
        }
        Object[] accesses = new AccessControlEntry[this.accessVector.size()];
        this.accessVector.copyInto(accesses);
        this.descriptor.setAccessControlEntries((AccessControlEntry[])accesses);
        Object[] controls = new ControlDescriptor[this.controlVector.size()];
        this.controlVector.copyInto(controls);
        this.descriptor.setControlDescriptors((ControlDescriptor[])controls);
    }

    public void visitCmpFieldElement(Node node) throws Exception {
        NodeList children = node.getChildNodes();
        this.cmpFields.addElement(((Element)node).getAttribute("field-name"));
    }

    public void visitContainerTransactionElement(Node node) {
        String txAttr = null;
        Hashtable<Method, Method> methods = new Hashtable<Method, Method>();
        NodeList children = node.getChildNodes();
        boolean wildCard = false;
        if (children != null) {
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i).getNodeType() == 1) {
                    switch (((EjbXMLElement)((Object)children.item(i))).getEjbNodeType()) {
                        case 711: {
                            if (((MethodElement)((Object)children.item(i))).getMethodName().equals("*")) {
                                wildCard = true;
                                break;
                            }
                            methods.put(((MethodElement)((Object)children.item(i))).getMethod(), ((MethodElement)((Object)children.item(i))).getMethod());
                            break;
                        }
                    }
                }
                ++i;
            }
        }
        txAttr = ((Element)node).getAttribute("trans-attribute");
        if (wildCard) {
            ControlDescriptor c = new ControlDescriptor();
            if (!txAttr.equals("Supports")) {
                c.setTransactionAttribute(this.mapTxAttr(txAttr));
            }
            c.setRunAsMode(0);
            this.controlVector.addElement(c);
        }
        Enumeration e = methods.elements();
        while (e.hasMoreElements()) {
            ControlDescriptor c = new ControlDescriptor((Method)e.nextElement());
            if (!txAttr.equals("Supports")) {
                c.setTransactionAttribute(this.mapTxAttr(txAttr));
            }
            c.setRunAsMode(0);
            this.controlVector.addElement(c);
        }
    }

    public void visitDocument(Node node) throws Exception {
    }

    public void visitEjbJarElement(Node node) throws Exception {
    }

    public void visitElement(Node node) throws Exception {
    }

    public void visitEnterpriseBeans(EnterpriseBeansElement node) throws Exception {
    }

    public void visitEntity(Node node) throws Exception {
        this.buildDD((EntityElement)((Object)node));
    }

    public void visitEnvEntryElement(Node node) {
        ((Hashtable)this.properties).put(((Element)node).getAttribute("env-entry-name"), ((Element)node).getAttribute("env-entry-value"));
    }

    public void visitMappingElement(Node node) {
        this.mappings.put(((Element)node).getAttribute("field-name"), ((Element)node).getAttribute("column-name"));
    }

    public void visitMethodElement(Node node) throws Exception {
        NodeList children = node.getChildNodes();
        if (children != null) {
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i).getNodeType() == 1) {
                    switch (((EjbXMLElement)((Object)children.item(i))).getEjbNodeType()) {
                        case 718: {
                            ((MethodElement)((Object)node)).addMethodParam(((EjbXMLElement)((Object)children.item(i))).getAttribute("method-param"));
                            break;
                        }
                    }
                }
                ++i;
            }
        }
        ((MethodElement)((Object)node)).addEjbName(((Element)node).getAttribute("ejb-name"));
        ((MethodElement)((Object)node)).addMethodName(((Element)node).getAttribute("method-name"));
        ((MethodElement)((Object)node)).addMethodIntf(((Element)node).getAttribute("method-intf"));
        if (!((MethodElement)((Object)node)).getMethodName().equals("*")) {
            if (((MethodElement)((Object)node)).getMethodIntf().equalsIgnoreCase("Remote")) {
                Method m = this.getMethodTable().findMethod((MethodElement)((Object)node));
                ((MethodElement)((Object)node)).setMethod(m);
            } else {
                Method m = this.getHomeMethodTable().findMethod((MethodElement)((Object)node));
                ((MethodElement)((Object)node)).setMethod(m);
            }
        }
    }

    public void visitMethodParamElement(Node node) {
        NodeList children = node.getChildNodes();
        ((Element)node).setAttribute("method-param", children.item(0).getNodeValue());
    }

    public void visitMethodPermissionElement(Node node) throws Exception {
        Hashtable<String, String> roles = new Hashtable<String, String>();
        Hashtable<Method, Method> methods = new Hashtable<Method, Method>();
        NodeList children = node.getChildNodes();
        boolean wildCard = false;
        if (children != null) {
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i).getNodeType() == 1) {
                    switch (((EjbXMLElement)((Object)children.item(i))).getEjbNodeType()) {
                        case 711: {
                            if (((MethodElement)((Object)children.item(i))).getMethodName().equals("*")) {
                                wildCard = true;
                                break;
                            }
                            methods.put(((MethodElement)((Object)children.item(i))).getMethod(), ((MethodElement)((Object)children.item(i))).getMethod());
                            break;
                        }
                        case 714: {
                            roles.put(((RoleNameElement)((Object)children.item(i))).getAttribute("role-name"), ((RoleNameElement)((Object)children.item(i))).getAttribute("role-name"));
                            break;
                        }
                    }
                }
                ++i;
            }
        }
        if (wildCard) {
            MethodAclEntry m = new MethodAclEntry();
            m.addRoles(roles);
            this.aclMethods.put(m, m);
        }
        Enumeration e = methods.elements();
        while (e.hasMoreElements()) {
            MethodAclEntry m;
            Method method = (Method)e.nextElement();
            if (this.aclMethods.containsKey(method)) {
                m = (MethodAclEntry)this.aclMethods.get(method);
                m.addRoles(roles);
                continue;
            }
            m = new MethodAclEntry(method);
            m.addRoles(roles);
            this.aclMethods.put(method, m);
        }
    }

    public void visitNode(Node node) throws Exception {
    }

    public void visitOracleDescriptorElement(Node node) {
    }

    public void visitParamElement(Node node) {
        if (node.getNodeValue() != null) {
            this.params.add(node.getNodeValue());
        }
    }

    public void visitPersistenceDescriptorElement(Node node) {
        if (((Element)node).getAttribute("ejb-name").equals(this.descriptor.getBeanHomeName().toString())) {
            System.out.println("Adding params to DD " + this.params);
            ((OracleEntityDescriptor)this.descriptor).addParams(this.params);
        }
    }

    public void visitPersistenceMappingElement(Node node) {
        if (this.beanMapping == null) {
            this.beanMapping = new OcmpBeanMapping();
        }
        this.beanMapping.setSchema(((Element)node).getAttribute("schema"));
        this.beanMapping.setTable(((Element)node).getAttribute("table"));
        this.beanMapping.setMappings(this.mappings);
        System.out.println("Adding a beanmapping");
        this.params.add(this.beanMapping);
    }

    public void visitPersistenceProviderElement(Node node) {
        ((OracleEntityDescriptor)this.descriptor).setPersistenceProviderName(((Element)node).getAttribute("persistence-name"));
        ((OracleEntityDescriptor)this.descriptor).setPersistenceDeployer(((Element)node).getAttribute("persistence-deployer"));
    }

    public void visitRoleNameElement(Node node) {
        NodeList children = node.getChildNodes();
        ((Element)node).setAttribute("role-name", children.item(0).getNodeValue());
    }

    public void visitSecurityRole(Node node) throws Exception {
        this.addToRoleList((SecurityRoleElement)((Object)node));
    }

    public void visitSession(Node node) throws Exception {
        this.buildDD((SessionElement)((Object)node));
    }

    public void visitText(Node node) throws Exception {
        if (node.getNodeValue() != null) {
            Element parent = (Element)node.getParentNode();
            parent.setAttribute(parent.getTagName(), node.getNodeValue());
        }
    }

    public void visitTextElement(Node node) {
        Element parent = (Element)node.getParentNode();
        parent.setAttribute(((Element)node).getTagName(), ((Element)node).getAttribute(((Element)node).getTagName()));
    }
}

