/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.xml.parser;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.Identity;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.deployment.AccessControlEntry;
import javax.ejb.deployment.ControlDescriptor;
import javax.ejb.deployment.DeploymentDescriptor;
import javax.ejb.deployment.SessionDescriptor;
import oracle.aurora.ejb.xml.parser.EjbNodeFactory;
import oracle.aurora.ejb.xml.parser.EjbXMLElement;
import oracle.aurora.ejb.xml.parser.Visitor;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NodeFactory;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class EnterpriseBeanXMLParser {
    public static final String EJB_JAR_DTD_PUBLICID = "-//Sun Microsystems Inc.//DTD Enterprise JavaBeans 1.1//EN";
    static final String DTD = "ejb-jar.dtd";
    static final String ORACLE_DTD = "oracle-ejb-jar.dtd";
    Visitor visitor;
    DOMParser parser;

    public EnterpriseBeanXMLParser() {
        this.init(null, null);
    }

    public EnterpriseBeanXMLParser(ClassLoader loader) {
        this.init(loader, null);
    }

    public EnterpriseBeanXMLParser(ClassLoader loader, String dtdFile) {
        this.init(loader, dtdFile);
    }

    public Element createContainerTransaction(XMLDocument doc, String ejbName, Method m, int txAttr) {
        Element containerTransaction = doc.createElement("container-transaction");
        containerTransaction.appendChild(this.createTextElement(doc, "description", "no description"));
        containerTransaction.appendChild(this.createMethodElement(doc, ejbName, m));
        switch (txAttr) {
            case 5: {
                containerTransaction.appendChild(this.createTextElement(doc, "trans-attribute", "Mandatory"));
                break;
            }
            case 0: {
                containerTransaction.appendChild(this.createTextElement(doc, "trans-attribute", "NotSupported"));
                break;
            }
            case 2: {
                containerTransaction.appendChild(this.createTextElement(doc, "trans-attribute", "Required"));
                break;
            }
            case 4: {
                containerTransaction.appendChild(this.createTextElement(doc, "trans-attribute", "RequiresNew"));
                break;
            }
            case 3: {
                containerTransaction.appendChild(this.createTextElement(doc, "trans-attribute", "Supports"));
                break;
            }
        }
        return containerTransaction;
    }

    public Element createMethodElement(XMLDocument doc, String ejbName, Method m) {
        Element method = doc.createElement("method");
        method.appendChild(this.createTextElement(doc, "ejb-name", ejbName));
        method.appendChild(this.createTextElement(doc, "method-name", m == null ? "*" : m.getName()));
        return method;
    }

    public Element createMethodPermission(XMLDocument doc, Identity[] id, String ejbName, Method m) {
        Element methodPermission = doc.createElement("method-permission");
        methodPermission.appendChild(this.createTextElement(doc, "description", "no description"));
        int i = 0;
        while (i < id.length) {
            methodPermission.appendChild(this.createTextElement(doc, "role-name", id[i].getName()));
            ++i;
        }
        methodPermission.appendChild(this.createMethodElement(doc, ejbName, m));
        return methodPermission;
    }

    public Element createSecurityRole(XMLDocument doc, String roleName) {
        Element securityRole = doc.createElement("security-role");
        securityRole.appendChild(this.createTextElement(doc, "description", "no description"));
        securityRole.appendChild(this.createTextElement(doc, "role-name", roleName));
        return securityRole;
    }

    public Element createTextElement(XMLDocument doc, String tag, String name) {
        Text tx = doc.createTextNode(name);
        Element elem = doc.createElement(tag);
        elem.appendChild(tx);
        return elem;
    }

    public static DeploymentDescriptor generateDD(InputStream in, InputStream in2, ClassLoader loader) throws Exception {
        EnterpriseBeanXMLParser parser = new EnterpriseBeanXMLParser(loader);
        Document doc = parser.parse(in);
        parser.traverse(doc);
        if (in2 != null) {
            EnterpriseBeanXMLParser parser2 = new EnterpriseBeanXMLParser(loader, ORACLE_DTD);
            Document doc2 = parser2.parse(in2);
            parser.traverse(doc2);
        }
        return parser.getVisitor().getDD();
    }

    public static DeploymentDescriptor generateDD(InputStream in, ClassLoader loader) throws Exception {
        EnterpriseBeanXMLParser parser = new EnterpriseBeanXMLParser(loader);
        Document doc = parser.parse(in);
        parser.traverse(doc);
        return parser.getVisitor().getDD();
    }

    public static Document generateDocument(DeploymentDescriptor dd) throws Exception {
        EnterpriseBeanXMLParser parser = new EnterpriseBeanXMLParser();
        Document doc = parser.parseDD(dd);
        return doc;
    }

    public Visitor getVisitor() {
        return this.visitor;
    }

    public void init(ClassLoader loader, String dtdFile) {
        try {
            this.visitor = loader == null ? new Visitor() : new Visitor(loader);
            this.parser = new DOMParser();
            this.parser.setErrorStream((OutputStream)System.err);
            this.parser.setValidationMode(true);
            this.parser.showWarnings(true);
            if (dtdFile == null) {
                this.parser.setBaseURL(this.getClass().getResource(DTD));
            } else {
                this.parser.setBaseURL(this.getClass().getResource(dtdFile));
            }
            this.parser.setNodeFactory((NodeFactory)new EjbNodeFactory());
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public Document parse(InputStream in) throws Exception {
        try {
            this.parser.parse(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.parser.getDocument();
    }

    private Document parseDD(DeploymentDescriptor dd) throws Exception {
        XMLDocument doc = new XMLDocument();
        Object currentNode = doc;
        Element elem = doc.createElement("ejb-jar");
        currentNode.appendChild(elem);
        currentNode = elem;
        elem = doc.createElement("enterprise-beans");
        currentNode.appendChild(elem);
        currentNode = elem;
        Text sess_state = null;
        if (dd instanceof SessionDescriptor) {
            elem = doc.createElement("session");
            sess_state = ((SessionDescriptor)dd).getStateManagementType() == 1 ? doc.createTextNode("Stateful") : doc.createTextNode("Stateless");
        }
        currentNode.appendChild(elem);
        currentNode = elem;
        elem = doc.createElement("description");
        Text txt = doc.createTextNode("no description");
        elem.appendChild(txt);
        currentNode.appendChild(elem);
        elem = doc.createElement("ejb-name");
        txt = doc.createTextNode(dd.getBeanHomeName().toString());
        elem.appendChild(txt);
        currentNode.appendChild(elem);
        elem = doc.createElement("home");
        txt = doc.createTextNode(dd.getHomeInterfaceClassName());
        elem.appendChild(txt);
        currentNode.appendChild(elem);
        elem = doc.createElement("remote");
        txt = doc.createTextNode(dd.getRemoteInterfaceClassName());
        elem.appendChild(txt);
        currentNode.appendChild(elem);
        elem = doc.createElement("ejb-class");
        txt = doc.createTextNode(dd.getEnterpriseBeanClassName());
        elem.appendChild(txt);
        currentNode.appendChild(elem);
        if (sess_state != null) {
            elem = doc.createElement("session-type");
            elem.appendChild(sess_state);
            currentNode.appendChild(elem);
        }
        ControlDescriptor[] ctls = dd.getControlDescriptors();
        int i = 0;
        while (i < ctls.length) {
            Method m = ctls[i].getMethod();
            if (m == null) {
                elem = doc.createElement("transaction-type");
                txt = doc.createTextNode(ctls[i].getTransactionAttribute() == 1 ? "Bean" : "Container");
                elem.appendChild(txt);
                currentNode.appendChild(elem);
                break;
            }
            ++i;
        }
        Properties properties = dd.getEnvironmentProperties();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String envEntryName = (String)e.nextElement();
            elem = doc.createElement("env-entry");
            Element envEntry = doc.createElement("env-entry-name");
            txt = doc.createTextNode(envEntryName);
            envEntry.appendChild(txt);
            elem.appendChild(envEntry);
            envEntry = doc.createElement("env-entry-type");
            txt = doc.createTextNode(properties.getProperty(envEntryName).getClass().getName());
            envEntry.appendChild(txt);
            elem.appendChild(envEntry);
            envEntry = doc.createElement("env-entry-value");
            txt = doc.createTextNode(properties.getProperty(envEntryName));
            envEntry.appendChild(txt);
            elem.appendChild(envEntry);
            currentNode.appendChild(elem);
        }
        elem = doc.createElement("assembly-descriptor");
        currentNode = currentNode.getParentNode().getParentNode();
        currentNode.appendChild(elem);
        currentNode = elem;
        AccessControlEntry[] acls = dd.getAccessControlEntries();
        Hashtable<String, String> roleList = new Hashtable<String, String>();
        Vector<Element> permissionList = new Vector<Element>();
        int i2 = 0;
        while (i2 < acls.length) {
            Identity[] id = acls[i2].getAllowedIdentities();
            Method m = acls[i2].getMethod();
            if (id != null) {
                permissionList.addElement(this.createMethodPermission(doc, id, dd.getBeanHomeName().toString(), m));
                int j = 0;
                while (j < id.length) {
                    roleList.put(id[j].getName(), id[j].getName());
                    ++j;
                }
            }
            ++i2;
        }
        Enumeration e2 = roleList.elements();
        while (e2.hasMoreElements()) {
            currentNode.appendChild(this.createSecurityRole(doc, (String)e2.nextElement()));
        }
        Enumeration e3 = permissionList.elements();
        while (e3.hasMoreElements()) {
            currentNode.appendChild((Element)e3.nextElement());
        }
        int i3 = 0;
        while (i3 < ctls.length) {
            elem = this.createContainerTransaction(doc, dd.getBeanHomeName().toString(), ctls[i3].getMethod(), ctls[i3].getTransactionAttribute());
            currentNode.appendChild(elem);
            ++i3;
        }
        return doc;
    }

    public void traverse(Node node) throws Exception {
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                this.traverse(((Document)node).getDocumentElement());
                break;
            }
            case 3: 
            case 4: {
                this.visitor.visitText(node);
                break;
            }
            default: {
                NodeList children = node.getChildNodes();
                if (children != null) {
                    int len = children.getLength();
                    int i = 0;
                    while (i < len) {
                        this.traverse(children.item(i));
                        ++i;
                    }
                }
                ((EjbXMLElement)((Object)node)).accept(this.visitor);
            }
            case 5: 
            case 7: 
        }
    }
}

