/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.parser;

import java.io.PrintWriter;
import javax.ejb.deployment.AccessControlEntry;
import javax.ejb.deployment.ControlDescriptor;
import javax.ejb.deployment.DeploymentDescriptor;
import javax.ejb.deployment.Identity;
import javax.ejb.deployment.SessionDescriptor;
import javax.naming.CompositeName;
import oracle.aurora.ejb.parser.ParseError;
import oracle.aurora.ejb.parser.ParsedAttribute;
import oracle.aurora.ejb.parser.Util;

public class ParsedProperty
extends ParsedAttribute {
    public String value;

    public ParsedProperty(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public void checkNotMethod(ControlDescriptor control) throws Exception {
        if (control.getMethod() != null) {
            ParseError.PROPERTY_ONLY_FOR_BEAN(this.name);
        }
    }

    public void checkSessionBean(DeploymentDescriptor descriptor) throws Exception {
        if (!(descriptor instanceof SessionDescriptor)) {
            ParseError.PROPERTY_ONLY_FOR_SESSION_BEAN(this.name);
        }
    }

    public void dump(PrintWriter out, int indentation) {
        Util.indent(out, indentation);
        Util.dumpString(out, this.name);
        out.print(" = ");
        Util.dumpString(out, this.value);
        out.println(";");
    }

    public void populateDescriptors(DeploymentDescriptor descriptor, ControlDescriptor control, AccessControlEntry access) throws Exception {
        if (this.name.equals("BeanHomeName")) {
            this.checkNotMethod(control);
            descriptor.setBeanHomeName(new CompositeName(this.value));
        } else if (this.name.equals("HomeInterfaceClassName")) {
            this.checkNotMethod(control);
            descriptor.setHomeInterfaceClassName(this.value);
        } else if (this.name.equals("RemoteInterfaceClassName")) {
            this.checkNotMethod(control);
            descriptor.setRemoteInterfaceClassName(this.value);
        } else if (this.name.equals("Reentrant")) {
            this.checkNotMethod(control);
            if (this.value.equals("true")) {
                descriptor.setReentrant(true);
            } else if (this.value.equals("false")) {
                descriptor.setReentrant(false);
            } else {
                ParseError.REENTRANT_NOT_BOOLEAN(this.value);
            }
        } else if (this.name.equals("SessionTimeout")) {
            this.checkNotMethod(control);
            this.checkSessionBean(descriptor);
            try {
                int timeout = Integer.parseInt(this.value);
                ((SessionDescriptor)descriptor).setSessionTimeout(timeout);
            }
            catch (NumberFormatException numberFormatException) {
                ParseError.SESSION_TIMEOUT_NOT_INTEGER(this.value);
            }
        } else if (this.name.equals("StateManagementType")) {
            this.checkNotMethod(control);
            this.checkSessionBean(descriptor);
            if (this.value.equals("STATEFUL_SESSION")) {
                ((SessionDescriptor)descriptor).setStateManagementType(1);
            } else if (this.value.equals("STATELESS_SESSION")) {
                ((SessionDescriptor)descriptor).setStateManagementType(0);
            } else {
                ParseError.STATE_MANAGEMENT_NOT_VALID(this.value);
            }
        } else if (this.name.equals("TransactionAttribute")) {
            if (this.value.equals("TX_BEAN_MANAGED")) {
                control.setTransactionAttribute(1);
            } else if (this.value.equals("TX_MANDATORY")) {
                control.setTransactionAttribute(5);
            } else if (this.value.equals("TX_NOT_SUPPORTED")) {
                control.setTransactionAttribute(0);
            } else if (this.value.equals("TX_REQUIRED")) {
                control.setTransactionAttribute(2);
            } else if (this.value.equals("TX_REQUIRES_NEW")) {
                control.setTransactionAttribute(4);
            } else if (!this.value.equals("TX_SUPPORTS")) {
                ParseError.TRANSACTION_ATTRIBUTE_NOT_VALID(this.value);
            }
        } else if (this.name.equals("IsolationLevel")) {
            if (this.value.equals("TRANSACTION_READ_COMMITTED")) {
                control.setIsolationLevel(2);
            } else if (this.value.equals("TRANSACTION_READ_UNCOMMITTED")) {
                control.setIsolationLevel(1);
            } else if (this.value.equals("TRANSACTION_REPEATABLE_READ")) {
                control.setIsolationLevel(4);
            } else if (this.value.equals("TRANSACTION_SERIALIZABLE")) {
                control.setIsolationLevel(8);
            } else {
                ParseError.ISOLATION_LEVEL_NOT_VALID(this.value);
            }
        } else if (this.name.equals("RunAsMode")) {
            if (this.value.equals("CLIENT_IDENTITY")) {
                control.setRunAsMode(0);
            } else if (this.value.equals("SPECIFIED_IDENTITY")) {
                control.setRunAsMode(1);
            } else if (this.value.equals("SYSTEM_IDENTITY")) {
                control.setRunAsMode(2);
            } else {
                ParseError.RUN_AS_MODE_NOT_VALID(this.value);
            }
        } else if (this.name.equals("RunAsIdentity")) {
            control.setRunAsIdentity(new Identity(this.value));
        } else if (this.name.equals("AllowedIdentities")) {
            java.security.Identity[] identities = new java.security.Identity[]{new Identity(this.value)};
            access.setAllowedIdentities(identities);
        } else if (control.getMethod() != null) {
            ParseError.UNKNOWN_METHOD_PROPERTY(this.name);
        } else if (descriptor instanceof SessionDescriptor) {
            ParseError.UNKNOWN_SESSION_BEAN_PROPERTY(this.name);
        } else {
            ParseError.UNKNOWN_ENTITY_BEAN_PROPERTY(this.name);
        }
    }
}

