/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import sun.misc.BASE64Encoder;
import sun.net.www.MessageHeader;
import sun.tools.jar.JarException;

public class Manifest
extends sun.tools.jar.Manifest {
    public Manifest() {
    }

    public Manifest(InputStream is) throws IOException {
        super(is);
    }

    public Manifest(InputStream is, boolean compute) throws IOException {
        super(is, compute);
    }

    public Manifest(byte[] bytes) throws IOException {
        super(bytes);
    }

    public Manifest(String[] files) throws IOException {
        super(files);
    }

    public void addEjbEntry(String f, InputStream is) throws IOException {
        String stdName = f.replace(File.separatorChar, '/');
        if (this.getEntry(stdName) == null) {
            MessageHeader mh = new MessageHeader();
            mh.add("Name", stdName);
            mh.add("Enterprise-Bean", "True");
            this.doHashes(mh, is);
            this.addEntry(mh);
        }
    }

    public void addFileEntry(String f, InputStream is) throws IOException {
        String stdName = f.replace(File.separatorChar, '/');
        if (this.getEntry(stdName) == null) {
            MessageHeader mh = new MessageHeader();
            mh.add("Name", stdName);
            this.doHashes(mh, is);
            this.addEntry(mh);
        }
    }

    public void doHashes(MessageHeader mh, InputStream is) throws IOException {
        String[] hashes = new String[]{"SHA", "MD5"};
        byte[] tmpbuf = new byte[512];
        String name = mh.findValue("Name");
        if (name == null) {
            return;
        }
        BASE64Encoder enc = new BASE64Encoder();
        String hashVal = new String();
        int i = 0;
        while (i < hashes.length) {
            hashVal = String.valueOf(hashVal) + hashes[i] + " ";
            ++i;
        }
        mh.set("Digest-Algorithms", hashVal);
        int j = 0;
        while (j < hashes.length) {
            is.reset();
            try {
                int len;
                MessageDigest dig = MessageDigest.getInstance(hashes[j]);
                while ((len = is.read(tmpbuf, 0, tmpbuf.length)) != -1) {
                    dig.update(tmpbuf, 0, len);
                }
                mh.set(String.valueOf(hashes[j]) + "-Digest", enc.encode(dig.digest()));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new JarException("Digest algorithm " + hashes[j] + " not available.");
            }
            ++j;
        }
    }
}

