/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.deployment;

import com.visigenic.vbroker.ir.Repository;
import com.visigenic.vbroker.ir.RepositoryHelper;
import com.visigenic.vbroker.ir.Visitor;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.tools.ir.Factory;
import com.visigenic.vbroker.tools.ir.RepositoryManager;
import com.visigenic.vbroker.util.be.java.EjbJavaTraverser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ejb.deployment.AccessControlEntry;
import javax.ejb.deployment.ControlDescriptor;
import javax.ejb.deployment.DeploymentDescriptor;
import javax.ejb.deployment.Identity;
import javax.naming.Name;
import javax.naming.NamingException;
import oracle.aurora.AuroraServices.ArgsHolder;
import oracle.aurora.AuroraServices.DeployEJB;
import oracle.aurora.AuroraServices.EJBGenerationError;
import oracle.aurora.AuroraServices.schemaIdsHolder;
import oracle.aurora.ejb.OracleEntityDescriptor;
import oracle.aurora.ejb.deployment.CRC32OutputStream;
import oracle.aurora.ejb.deployment.DDVerifier;
import oracle.aurora.ejb.deployment.EjbDeploymentTool;
import oracle.aurora.ejb.deployment.EjbJarFileEditor;
import oracle.aurora.ejb.deployment.InputReader;
import oracle.aurora.ejb.deployment.JavaFrontEnd;
import oracle.aurora.ejb.deployment.Manifest;
import oracle.aurora.ejb.parser.EnterpriseBeanParser;
import oracle.aurora.ejb.persistence.EntityDeployer;
import oracle.aurora.ejb.xml.parser.EnterpriseBeanXMLParser;
import oracle.aurora.jndi.sess_iiop.SessionCtx;
import oracle.aurora.server.tools.sess_iiop.Loadjar;
import oracle.aurora.server.tools.sess_iiop.Publish;
import oracle.aurora.server.tools.sess_iiop.ToolImpl;
import oracle.aurora.server.tools.sess_iiop.ToolsException;
import org.omg.CORBA.BOA;
import org.omg.CORBA.Object;

public class GenerateEjb
extends EjbDeploymentTool {
    private DeployEJB deployer;
    String resolver;
    CRC32 crc32 = new CRC32();
    boolean verbose = false;
    boolean beanOnly = false;
    boolean republish = false;
    boolean keepGenFiles = false;
    EjbJarFileEditor editor;
    Name jar;
    Name generated;
    Name workDir;
    Name descriptor;
    File workDirectory;
    Hashtable userMap = new Hashtable();
    static final String DEPLOYEJB_NAME = "/etc/deployejb";
    Name oDescriptor;
    String osName = null;
    boolean windows = false;

    public void addAllJavaClassFilenamesTo(File file, Vector v) {
        if (!file.isDirectory()) {
            if (file.getName().endsWith(".class")) {
                if (this.isWindows()) {
                    v.addElement("\"" + file.getAbsolutePath() + "\"");
                } else {
                    v.addElement(file.getAbsolutePath());
                }
            }
            return;
        }
        String[] entries = file.list();
        if (entries == null) {
            return;
        }
        int i = 0;
        while (i < entries.length) {
            this.addAllJavaClassFilenamesTo(new File(file.getPath(), entries[i]), v);
            ++i;
        }
    }

    public void addAllJavaFilenamesTo(File file, Vector v) {
        if (!file.isDirectory()) {
            if (file.getName().endsWith(".java")) {
                if (this.isWindows()) {
                    v.addElement("\"" + file.getAbsolutePath() + "\"");
                } else {
                    v.addElement(file.getAbsolutePath());
                }
            }
            return;
        }
        String[] entries = file.list();
        if (entries == null) {
            return;
        }
        int i = 0;
        while (i < entries.length) {
            this.addAllJavaFilenamesTo(new File(file.getPath(), entries[i]), v);
            ++i;
        }
    }

    private void addAllSubDirectoriesTo(Vector v, String base, File file) {
        if (!file.isDirectory()) {
            return;
        }
        base = base.equals("") ? String.valueOf(file.getName()) + "/" : String.valueOf(base) + "/" + file.getName() + "/";
        v.addElement(base);
        String[] entries = file.list();
        if (entries == null) {
            return;
        }
        int i = 0;
        while (i < entries.length) {
            this.addAllSubDirectoriesTo(v, base, new File(file.getPath(), entries[i]));
            ++i;
        }
    }

    private void addFiles(Manifest manifest, ZipOutputStream zos) throws ToolsException {
        Vector files = new Vector();
        this.addAllJavaClassFilenamesTo(this.workDirectory, files);
        Enumeration elements = files.elements();
        while (elements.hasMoreElements()) {
            String file = (String)elements.nextElement();
            try {
                if (file.startsWith("\"")) {
                    file = file.substring(1);
                }
                if (file.endsWith("\"")) {
                    file = file.substring(0, file.length() - 1);
                }
                FileInputStream is = new FileInputStream(file);
                this.addStream(manifest, zos, is, this.stripWorkDirectory(file));
                is.close();
            }
            catch (FileNotFoundException e) {
                this.fail2("FILE_NOT_FOUND", file, e.getMessage());
            }
            catch (IOException e) {
                this.fail2("IO_EXCEPTION", file, e.getMessage());
            }
        }
    }

    private void addStream(Manifest manifest, ZipOutputStream zos, InputStream in, String entryName) throws IOException {
        byte[] buf = this.getStreamBytes(in);
        int len = buf.length;
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(buf));
        is.mark(len * 2);
        ZipEntry e = new ZipEntry(entryName.replace('\\', '/'));
        e.setSize(len);
        e.setMethod(0);
        this.crc32Entry(e, is);
        is.reset();
        zos.putNextEntry(e);
        zos.write(buf, 0, len);
        zos.closeEntry();
        manifest.addFileEntry(entryName, is);
        is.close();
    }

    private String[] allSubDirectories(File directory) {
        Vector v = new Vector();
        String[] entries = directory.list();
        if (entries == null) {
            entries = new String[]{};
        }
        int i = 0;
        while (i < entries.length) {
            this.addAllSubDirectoriesTo(v, "", new File(directory.getPath(), entries[i]));
            ++i;
        }
        java.lang.Object[] dirs = new String[v.size()];
        v.copyInto(dirs);
        return dirs;
    }

    private void checkJDKVersion() throws ToolsException {
    }

    private void cmpDeploy(OracleEntityDescriptor d) throws ToolsException {
        try {
            Class<?> cl = Class.forName(d.getPersistenceDeployer());
            EntityDeployer ed = (EntityDeployer)cl.newInstance();
            d.setPersistenceManager(ed.deploy(d, d.getParams()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ToolsException(e.getMessage());
        }
    }

    private String[] compilerArguments(File jarFilename) throws ToolsException {
        Vector<String> argVector = new Vector<String>();
        argVector.addElement("javac");
        argVector.addElement("-d");
        if (this.isWindows()) {
            argVector.addElement("\"" + this.workDirectory.getAbsolutePath() + "\"");
        } else {
            argVector.addElement(this.workDirectory.getAbsolutePath());
        }
        argVector.addElement("-classpath");
        argVector.addElement(System.getProperty("java.class.path"));
        this.addAllJavaFilenamesTo(this.workDirectory, argVector);
        java.lang.Object[] argv = new String[argVector.size()];
        argVector.copyInto(argv);
        return argv;
    }

    private void crc32Entry(ZipEntry e, BufferedInputStream is) throws IOException {
        byte[] buf = new byte[1024];
        this.crc32.reset();
        int r = 0;
        int nread = 0;
        long len = is.available();
        while ((r = is.read(buf)) != -1) {
            nread += r;
            this.crc32.update(buf, 0, r);
        }
        if (nread != (int)len) {
            throw new IOException("incorrect length while processing: ");
        }
        e.setCrc(this.crc32.getValue());
    }

    private void crc32Manifest(ZipEntry e, Manifest m) throws IOException {
        this.crc32.reset();
        CRC32OutputStream os = new CRC32OutputStream(this.crc32);
        PrintStream ps = new PrintStream(os);
        m.stream(ps);
        e.setSize(os.n);
        e.setCrc(this.crc32.getValue());
    }

    private void createJar() throws ToolsException {
        try {
            ZipEntry e;
            String MANIFEST = "META-INF/MANIFEST.MF";
            File generatedFilename = this.getGeneratedJarFile();
            generatedFilename.delete();
            FileOutputStream out = new FileOutputStream(generatedFilename);
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(out));
            zos.setMethod(0);
            Manifest manifest = new Manifest(null);
            this.addFiles(manifest, zos);
            String[] dirs = this.allSubDirectories(this.workDirectory);
            int i = 0;
            while (i < dirs.length) {
                e = new ZipEntry(dirs[i]);
                e.setMethod(0);
                e.setSize(0L);
                e.setCrc(0L);
                zos.putNextEntry(e);
                ++i;
            }
            e = new ZipEntry(MANIFEST);
            e.setTime(System.currentTimeMillis());
            e.setMethod(0);
            this.crc32Manifest(e, manifest);
            zos.putNextEntry(e);
            manifest.stream(zos);
            zos.closeEntry();
            zos.close();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            this.fail2("IO_EXCEPTION", this.getGeneratedJarFile().toString(), e.getMessage());
        }
    }

    private void deleteAll(File directory) {
        String[] entries;
        if (!directory.isDirectory()) {
            directory.delete();
        }
        if ((entries = directory.list()) == null) {
            return;
        }
        int i = 0;
        while (i < entries.length) {
            this.deleteAll(new File(directory.getPath(), entries[i]));
            ++i;
        }
        directory.delete();
    }

    public String description() throws ToolsException {
        return this.msg("DEPLOYEJB_DESCRIPTION", null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DeploymentDescriptor descriptor() throws ToolsException {
        block16: {
            block15: {
                block14: {
                    if (this.descriptor == null) {
                        return this.editor.getDeploymentDescriptors()[0];
                    }
                    inStream = null;
                    inStream2 = null;
                    try {
                        try {
                            inStream = new FileInputStream((File)ToolImpl.local_wd.lookup(this.descriptor));
                            if (this.oDescriptor != null) {
                                inStream2 = new FileInputStream((File)ToolImpl.local_wd.lookup(this.oDescriptor));
                            }
                            if (this.isDDXML(this.descriptor)) {
                                var3_3 = EnterpriseBeanXMLParser.generateDD(inStream, inStream2, this.editor.classLoader());
                                var5_5 = null;
                                break block14;
                            }
                            var3_4 = EnterpriseBeanParser.parseDescriptor(inStream, this.editor.classLoader());
                            break block15;
                        }
                        catch (NamingException v0) {
                            this.fail1("INVALID_NAME", this.descriptor.toString());
                            break block16;
                        }
                        catch (FileNotFoundException v1) {
                            this.fail1("FILE_NOT_FOUND", this.descriptor.toString());
                            break block16;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.fail2("CANNOT_PARSE", this.descriptor.toString(), e.getMessage());
                            break block16;
                        }
                    }
                    catch (Throwable var4_10) {
                        var5_8 = null;
                        try {
                            if (inStream == null) throw var4_10;
                            inStream.close();
                            throw var4_10;
                        }
                        catch (IOException v2) {
                            this.fail1("CANNOT_CLOSE_FILE", this.descriptor.toString());
                        }
                        throw var4_10;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [4 : 194->205)] { 
lbl41:
                // 1 sources

                if (inStream == null) return var3_3;
                inStream.close();
                return var3_3;
lbl44:
                // 1 sources

                catch (IOException v3) {
                    this.fail1("CANNOT_CLOSE_FILE", this.descriptor.toString());
                }
                return var3_3;
            }
            var5_6 = null;
            ** try [egrp 2[TRYBLOCK] [4 : 194->205)] { 
lbl50:
            // 1 sources

            if (inStream == null) return var3_4;
            inStream.close();
            return var3_4;
lbl53:
            // 1 sources

            catch (IOException v4) {
                this.fail1("CANNOT_CLOSE_FILE", this.descriptor.toString());
            }
            return var3_4;
        }
        var5_7 = null;
        try {}
        catch (IOException v5) {
            this.fail1("CANNOT_CLOSE_FILE", this.descriptor.toString());
            return null;
        }
        if (inStream == null) return null;
        inStream.close();
        return null;
    }

    private String gatherUsersExcept(String exclude) {
        Enumeration users = this.userMap.keys();
        Vector<String> gathered = new Vector<String>();
        while (users.hasMoreElements()) {
            String user = (String)users.nextElement();
            if (user.equals(exclude)) continue;
            gathered.addElement(user);
        }
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < gathered.size() - 1) {
            out.append((String)gathered.elementAt(i));
            out.append(',');
            ++i;
        }
        if (gathered.size() > 0) {
            out.append((String)gathered.lastElement());
        }
        return out.toString();
    }

    private String gatherUsersExceptAndIncluding(String exclude, String include) {
        exclude = exclude.toUpperCase();
        include = include.toUpperCase();
        Enumeration users = this.userMap.keys();
        Vector<String> gathered = new Vector<String>();
        while (users.hasMoreElements()) {
            String user = (String)users.nextElement();
            if (user.equals(exclude)) continue;
            gathered.addElement(user);
        }
        if (!gathered.contains(include)) {
            gathered.addElement(include);
        }
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < gathered.size() - 1) {
            out.append((String)gathered.elementAt(i));
            out.append(',');
            ++i;
        }
        if (gathered.size() > 0) {
            out.append((String)gathered.lastElement());
        }
        return out.toString();
    }

    private void generateBean(DeploymentDescriptor descriptor, String grantedUsers) throws ToolsException {
        ArgsHolder names = new ArgsHolder();
        this.stdErr.print(this.msg("GENERATING_HOME", null));
        try {
            this.deployer.generate(names, this.serialize(descriptor));
        }
        catch (EJBGenerationError e) {
            this.error(e.msg);
        }
        this.stdErr.println(this.msg("DONE", null));
        this.stdErr.print(this.msg("PUBLISHING_HOME", null));
        new Publish(descriptor.getBeanHomeName(), names.value[0], "SYS", names.value[1], false, this.republish, grantedUsers);
        this.stdErr.println(this.msg("DONE", null));
    }

    private void generateCommStubs(DeploymentDescriptor descriptor) throws ToolsException {
        ORB orb = (ORB)org.omg.CORBA.ORB.init((String[])new String[0], null);
        BOA boa = orb.BOA_init();
        JavaFrontEnd frontEnd = new JavaFrontEnd("deployejb");
        EjbJavaTraverser traverser = new EjbJavaTraverser("deployejb");
        boa.obj_is_ready((Object)traverser);
        traverser.fromJava(true);
        traverser.verbose(this.verbose);
        frontEnd.wide(true);
        frontEnd.verbose(this.verbose);
        traverser.examples(false);
        traverser.bind(false);
        traverser.rootDir(this.workDirectory.getAbsolutePath());
        Factory factory = new Factory("deployejb");
        boa.obj_is_ready((Object)factory);
        RepositoryManager manager = factory.create_transient_repository();
        Repository ir = RepositoryHelper.narrow((Object)manager.repository());
        Vector<Class> classes = new Vector<Class>();
        try {
            classes.addElement(this.editor.getClass(descriptor.getRemoteInterfaceClassName()));
            classes.addElement(this.editor.getClass(descriptor.getHomeInterfaceClassName()));
        }
        catch (ClassNotFoundException e) {
            this.fail1("CLASS_NOT_FOUND", e.getMessage());
        }
        frontEnd.ir((org.omg.CORBA.Repository)ir);
        frontEnd.parseClasses(classes);
        ir.traverse((Visitor)traverser);
        this.deleteAll(new File(this.workDirectory, "javax".replace('/', File.separatorChar)));
        this.deleteAll(new File(this.workDirectory, "oracle/aurora/ejb/EjbExceptions".replace('/', File.separatorChar)));
    }

    private File getGeneratedJarFile() throws ToolsException {
        if (this.generated != null) {
            String fn = ToolImpl.local_wd.transformName(ToolImpl.local_wd.wd_name(), this.generated).toString();
            fn = fn.replace('/', File.separatorChar);
            return new File(fn);
        }
        String jarName = ((File)ToolImpl.local_wd.lookup(this.jar)).toString();
        jarName = jarName.substring(0, jarName.indexOf(".jar"));
        return new File(String.valueOf(jarName) + "_generated.jar");
    }

    byte[] getStreamBytes(InputStream is) throws IOException {
        int read_this_time;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(is.available());
        byte[] buffer = new byte[4000];
        while ((read_this_time = is.read(buffer)) != -1) {
            baos.write(buffer, 0, read_this_time);
        }
        return baos.toByteArray();
    }

    private void get_deployer() throws ToolsException {
        block2: {
            if (this.deployer != null) break block2;
            try {
                this.deployer = (DeployEJB)((SessionCtx)ToolImpl.wd.ic()).activate(DEPLOYEJB_NAME);
            }
            catch (NamingException e) {
                this.fail1("DEPLOYEJB_NOT_FOUND", e.getMessage());
            }
        }
    }

    public String help() throws ToolsException {
        return this.msg("DEPLOYEJB_HELP", null);
    }

    private java.security.Identity[] identitiesFrom(java.security.Identity[] ids) {
        java.security.Identity[] newIds = new java.security.Identity[ids.length];
        int i = 0;
        while (i < ids.length) {
            newIds[i] = new Identity(ids[i].getName());
            ++i;
        }
        return newIds;
    }

    private java.security.Identity identityFrom(java.security.Identity id) {
        return new Identity(id.getName());
    }

    protected void invoke() throws ToolsException {
        this.checkJDKVersion();
        this.get_deployer();
        try {
            this.deleteAll(this.workDirectory);
            if (!(this.workDirectory.mkdirs() || this.workDirectory.exists() && this.workDirectory.isDirectory())) {
                this.fail1("CANT_CREATE_TEMP_DIR", this.workDirectory.toString());
            }
            File jarFilename = (File)ToolImpl.local_wd.lookup(this.jar);
            this.setClasspath(jarFilename);
            this.editor = new EjbJarFileEditor(jarFilename);
            this.stdErr.print(this.msg("READING_DESCRIPTOR", null));
            DeploymentDescriptor d = this.descriptor();
            this.stdErr.println(this.msg("DONE", null));
            this.stdErr.print(this.msg("VERIFYING_DESCRIPTOR", null));
            new DDVerifier(this.editor.classLoader(), d).verify();
            this.stdErr.println(this.msg("DONE", null));
            this.stdErr.print(this.msg("GATHERING_USERS", null));
            this.mapUsers(d);
            this.stdErr.println(this.msg("DONE", null));
            if (d instanceof OracleEntityDescriptor && ((OracleEntityDescriptor)d).getPersistenceType().equalsIgnoreCase("Container")) {
                this.stdErr.print(this.msg("PROCESSING_CMP", null));
                this.cmpDeploy((OracleEntityDescriptor)d);
                this.stdErr.println(this.msg("DONE", null));
            }
            if (!this.beanOnly) {
                String grants = this.username().toUpperCase().equals("SYS") ? this.gatherUsersExcept("SYS") : this.gatherUsersExceptAndIncluding(this.username(), "SYS");
                this.stdErr.print(this.msg("GENERATING_STUBS", null));
                this.generateCommStubs(d);
                this.stdErr.println(this.msg("DONE", null));
                this.stdErr.print(this.msg("COMPILING_STUBS", null));
                try {
                    Process compiling = Runtime.getRuntime().exec(this.compilerArguments(jarFilename));
                    InputStream in = compiling.getInputStream();
                    InputStream err = compiling.getErrorStream();
                    ByteArrayOutputStream errorOutput = new ByteArrayOutputStream();
                    InputReader inReader = new InputReader("input", in, errorOutput);
                    InputReader errReader = new InputReader("error", err, errorOutput);
                    inReader.start();
                    errReader.start();
                    compiling.waitFor();
                    if (compiling.exitValue() != 0) {
                        this.stdErr.println(this.msg("ERROR_COMPILING_STUBS", null));
                        inReader.waitToDie();
                        errReader.waitToDie();
                        throw new ToolsException(new String(errorOutput.toByteArray()));
                    }
                }
                catch (IOException e) {
                    throw new ToolsException("IOException during compilation: " + e.getMessage());
                }
                catch (InterruptedException interruptedException) {
                    throw new ToolsException("Compilation interrupted");
                }
                this.stdErr.println(this.msg("DONE", null));
                this.stdErr.print(this.msg("GENERATING_JAR", null));
                this.createJar();
                this.stdErr.println(this.msg("DONE", null));
                this.stdErr.print(this.msg("LOADING_EJB_JAR", null));
                File[] files = new File[]{jarFilename, this.getGeneratedJarFile()};
                if (this.resolver == null) {
                    new Loadjar(this.verbose, true, false, false, false, " ", " ", grants, null, files);
                } else {
                    new Loadjar(this.verbose, true, false, false, false, " ", " resolver " + this.resolver, grants, null, files);
                }
                this.stdErr.println(this.msg("DONE", null));
            }
            if (this.beanOnly) {
                this.stdErr.println(this.msg("DONE", null));
            }
            this.generateBean(d, this.gatherUsersExcept("SYS"));
        }
        finally {
            java.lang.Object var2_11 = null;
            if (!this.keepGenFiles) {
                this.deleteAll(this.workDirectory);
            }
        }
    }

    private boolean isDDXML(Name descriptor) {
        return ToolImpl.local_wd.last(descriptor).toString().endsWith(".xml");
    }

    private boolean isWindows() {
        if (this.osName == null) {
            try {
                this.osName = System.getProperty("os.name", "Unknown");
            }
            catch (SecurityException securityException) {}
            this.windows = this.osName.toUpperCase().startsWith("WINDOWS");
        }
        return this.windows;
    }

    public static void main(String[] args) {
        try {
            new GenerateEjb().invoke(args, System.in, System.out, System.err);
        }
        catch (ToolsException e) {
            System.err.println();
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private void mapUsers(DeploymentDescriptor d) throws ToolsException {
        ControlDescriptor[] cd = d.getControlDescriptors();
        Integer defaultMapping = new Integer(-1);
        int i = 0;
        while (i < cd.length) {
            switch (cd[i].getRunAsMode()) {
                case 2: {
                    if (!this.username().toUpperCase().equals("SYS")) {
                        this.fail0("MUST_BE_SYS_TO_RUNAS_SYS");
                    }
                    this.userMap.put("SYS", defaultMapping);
                    break;
                }
                case 1: {
                    java.security.Identity runAsId = cd[i].getRunAsIdentity();
                    if (!(runAsId instanceof Identity)) {
                        cd[i].setRunAsIdentity(this.identityFrom(runAsId));
                    }
                    String schema = runAsId.getName().toUpperCase();
                    if (!this.username().toUpperCase().equals("SYS") && !this.username().toUpperCase().equals(schema)) {
                        this.fail1("CANNOT_GRANT_RUNAS_TO", schema);
                    }
                    this.userMap.put(schema, defaultMapping);
                    break;
                }
            }
            ++i;
        }
        AccessControlEntry[] acl = d.getAccessControlEntries();
        int i2 = 0;
        while (i2 < acl.length) {
            java.security.Identity[] ids = acl[i2].getAllowedIdentities();
            acl[i2].setAllowedIdentities(this.identitiesFrom(ids));
            int j = 0;
            while (j < ids.length) {
                this.userMap.put(ids[j].getName().toUpperCase(), defaultMapping);
                ++j;
            }
            ++i2;
        }
        String[] user_names = new String[this.userMap.size()];
        Enumeration users = this.userMap.keys();
        int i3 = 0;
        while (i3 < user_names.length) {
            user_names[i3] = (String)users.nextElement();
            ++i3;
        }
        schemaIdsHolder schemas = new schemaIdsHolder();
        this.deployer.translateUsers(schemas, user_names);
        boolean badUser = false;
        int i4 = 0;
        while (i4 < schemas.value.length) {
            if (schemas.value[i4] == -1) {
                this.fail1("INVALID_USER", user_names[i4]);
            }
            this.userMap.put(user_names[i4], new Integer(schemas.value[i4]));
            ++i4;
        }
    }

    protected void parseArgs(String[] argv) throws ToolsException {
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-temp")) {
                if (argv.length == ++i) {
                    this.fail0("MISSING_TEMP_DIR");
                }
                this.workDir = ToolImpl.local_wd.parse(argv[i]);
            } else if (argv[i].equals("-generated")) {
                if (argv.length == ++i) {
                    this.fail0("MISSING_GENERATED_NAME");
                }
                this.generated = ToolImpl.local_wd.parse(argv[i]);
            } else if (argv[i].equals("-resolver")) {
                if (argv.length == ++i) {
                    this.fail0("MISSING_RESOLVER");
                }
                this.resolver = argv[i];
            } else if (argv[i].equals("-descriptor")) {
                if (argv.length == ++i) {
                    this.fail0("MISSING_DESCRIPTOR_FILE");
                }
                this.descriptor = ToolImpl.local_wd.parse(argv[i]);
            } else if (argv[i].equals("-verbose")) {
                this.verbose = true;
            } else if (argv[i].equals("-republish")) {
                this.republish = true;
            } else if (argv[i].equals("-beanonly")) {
                this.beanOnly = true;
            } else if (argv[i].equals("-keep")) {
                this.keepGenFiles = true;
            } else {
                if (!argv[i].equals("-oracledescriptor")) break;
                if (argv.length == ++i) {
                    this.fail0("MISSING_DESCRIPTOR_FILE");
                }
                this.oDescriptor = ToolImpl.local_wd.parse(argv[i]);
            }
            ++i;
        }
        if (argv.length == i) {
            this.error(this.usage());
        }
        this.jar = ToolImpl.local_wd.parse(argv[i]);
        if (this.workDir == null) {
            this.fail0("MUST_SUPPLY_WORK_DIR");
        }
        String dir = ToolImpl.local_wd.transformName(ToolImpl.local_wd.wd_name(), this.workDir).toString();
        dir = dir.replace('/', File.separatorChar);
        this.workDirectory = new File(dir);
    }

    private byte[] serialize(DeploymentDescriptor descriptor) throws ToolsException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            new ObjectOutputStream(out).writeObject(descriptor);
        }
        catch (IOException e) {
            this.fail1("ERROR_SERIALIZING_DESCRIPTOR", e.getMessage());
        }
        return out.toByteArray();
    }

    private void setClasspath(File jarFilename) throws ToolsException {
        String separator = System.getProperty("path.separator");
        String append = String.valueOf(this.workDirectory.getAbsolutePath()) + separator;
        String fn = jarFilename.getAbsolutePath();
        append = String.valueOf(append) + (fn.startsWith("///") ? fn.substring(2) : fn);
        String classpath = String.valueOf(System.getProperty("java.class.path")) + separator + append;
        ((Hashtable)System.getProperties()).put("java.class.path", classpath);
    }

    private String stripWorkDirectory(String filename) throws ToolsException {
        return filename.substring(this.workDirectory.toString().length() + 1);
    }

    public String usage() throws ToolsException {
        return this.msg("DEPLOYEJB_USAGE", null);
    }

    public String version() throws ToolsException {
        return this.msg("DEPLOYEJB_VERSION", null);
    }
}

