/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.deployment;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.ejb.deployment.DeploymentDescriptor;
import javax.ejb.deployment.SessionDescriptor;
import oracle.aurora.ejb.deployment.CRC32OutputStream;
import oracle.aurora.ejb.deployment.EjbJarFileClassLoader;
import oracle.aurora.ejb.deployment.Manifest;
import oracle.aurora.server.tools.sess_iiop.ToolsException;
import sun.net.www.MessageHeader;

public class EjbJarFileEditor {
    private static ResourceBundle resMessages = ResourceBundle.getBundle("oracle.aurora.ejb.deployment.Message");
    CRC32 crc32 = new CRC32();
    EjbJarFileClassLoader classLoader = new EjbJarFileClassLoader(this);
    File jarFilename;
    ZipFile jarFile;
    Hashtable descriptors = new Hashtable();
    String[] classList;
    boolean addIdentityClass = false;
    private static final byte[] identityClassBits;

    static {
        byte[] byArray = new byte[727];
        byArray[0] = -54;
        byArray[1] = -2;
        byArray[2] = -70;
        byArray[3] = -66;
        byArray[5] = 3;
        byArray[7] = 45;
        byArray[9] = 31;
        byArray[10] = 7;
        byArray[12] = 25;
        byArray[13] = 7;
        byArray[15] = 26;
        byArray[16] = 7;
        byArray[18] = 27;
        byArray[19] = 10;
        byArray[21] = 1;
        byArray[23] = 7;
        byArray[24] = 10;
        byArray[26] = 1;
        byArray[28] = 8;
        byArray[29] = 10;
        byArray[31] = 1;
        byArray[33] = 9;
        byArray[34] = 12;
        byArray[36] = 13;
        byArray[38] = 10;
        byArray[39] = 12;
        byArray[41] = 13;
        byArray[43] = 11;
        byArray[44] = 12;
        byArray[46] = 13;
        byArray[48] = 12;
        byArray[49] = 1;
        byArray[51] = 3;
        byArray[52] = 40;
        byArray[53] = 41;
        byArray[54] = 86;
        byArray[55] = 1;
        byArray[57] = 21;
        byArray[58] = 40;
        byArray[59] = 76;
        byArray[60] = 106;
        byArray[61] = 97;
        byArray[62] = 118;
        byArray[63] = 97;
        byArray[64] = 47;
        byArray[65] = 108;
        byArray[66] = 97;
        byArray[67] = 110;
        byArray[68] = 103;
        byArray[69] = 47;
        byArray[70] = 83;
        byArray[71] = 116;
        byArray[72] = 114;
        byArray[73] = 105;
        byArray[74] = 110;
        byArray[75] = 103;
        byArray[76] = 59;
        byArray[77] = 41;
        byArray[78] = 86;
        byArray[79] = 1;
        byArray[81] = 50;
        byArray[82] = 40;
        byArray[83] = 76;
        byArray[84] = 106;
        byArray[85] = 97;
        byArray[86] = 118;
        byArray[87] = 97;
        byArray[88] = 47;
        byArray[89] = 108;
        byArray[90] = 97;
        byArray[91] = 110;
        byArray[92] = 103;
        byArray[93] = 47;
        byArray[94] = 83;
        byArray[95] = 116;
        byArray[96] = 114;
        byArray[97] = 105;
        byArray[98] = 110;
        byArray[99] = 103;
        byArray[100] = 59;
        byArray[101] = 76;
        byArray[102] = 106;
        byArray[103] = 97;
        byArray[104] = 118;
        byArray[105] = 97;
        byArray[106] = 47;
        byArray[107] = 115;
        byArray[108] = 101;
        byArray[109] = 99;
        byArray[110] = 117;
        byArray[111] = 114;
        byArray[112] = 105;
        byArray[113] = 116;
        byArray[114] = 121;
        byArray[115] = 47;
        byArray[116] = 73;
        byArray[117] = 100;
        byArray[118] = 101;
        byArray[119] = 110;
        byArray[120] = 116;
        byArray[121] = 105;
        byArray[122] = 116;
        byArray[123] = 121;
        byArray[124] = 83;
        byArray[125] = 99;
        byArray[126] = 111;
        byArray[127] = 112;
        byArray[128] = 101;
        byArray[129] = 59;
        byArray[130] = 41;
        byArray[131] = 86;
        byArray[132] = 1;
        byArray[134] = 6;
        byArray[135] = 60;
        byArray[136] = 105;
        byArray[137] = 110;
        byArray[138] = 105;
        byArray[139] = 116;
        byArray[140] = 62;
        byArray[141] = 1;
        byArray[143] = 4;
        byArray[144] = 67;
        byArray[145] = 111;
        byArray[146] = 100;
        byArray[147] = 101;
        byArray[148] = 1;
        byArray[150] = 13;
        byArray[151] = 67;
        byArray[152] = 111;
        byArray[153] = 110;
        byArray[154] = 115;
        byArray[155] = 116;
        byArray[156] = 97;
        byArray[157] = 110;
        byArray[158] = 116;
        byArray[159] = 86;
        byArray[160] = 97;
        byArray[161] = 108;
        byArray[162] = 117;
        byArray[163] = 101;
        byArray[164] = 1;
        byArray[166] = 10;
        byArray[167] = 69;
        byArray[168] = 120;
        byArray[169] = 99;
        byArray[170] = 101;
        byArray[171] = 112;
        byArray[172] = 116;
        byArray[173] = 105;
        byArray[174] = 111;
        byArray[175] = 110;
        byArray[176] = 115;
        byArray[177] = 1;
        byArray[179] = 13;
        byArray[180] = 73;
        byArray[181] = 100;
        byArray[182] = 101;
        byArray[183] = 110;
        byArray[184] = 116;
        byArray[185] = 105;
        byArray[186] = 116;
        byArray[187] = 121;
        byArray[188] = 46;
        byArray[189] = 106;
        byArray[190] = 97;
        byArray[191] = 118;
        byArray[192] = 97;
        byArray[193] = 1;
        byArray[195] = 15;
        byArray[196] = 76;
        byArray[197] = 105;
        byArray[198] = 110;
        byArray[199] = 101;
        byArray[200] = 78;
        byArray[201] = 117;
        byArray[202] = 109;
        byArray[203] = 98;
        byArray[204] = 101;
        byArray[205] = 114;
        byArray[206] = 84;
        byArray[207] = 97;
        byArray[208] = 98;
        byArray[209] = 108;
        byArray[210] = 101;
        byArray[211] = 1;
        byArray[213] = 18;
        byArray[214] = 76;
        byArray[215] = 106;
        byArray[216] = 97;
        byArray[217] = 118;
        byArray[218] = 97;
        byArray[219] = 47;
        byArray[220] = 108;
        byArray[221] = 97;
        byArray[222] = 110;
        byArray[223] = 103;
        byArray[224] = 47;
        byArray[225] = 83;
        byArray[226] = 116;
        byArray[227] = 114;
        byArray[228] = 105;
        byArray[229] = 110;
        byArray[230] = 103;
        byArray[231] = 59;
        byArray[232] = 1;
        byArray[234] = 29;
        byArray[235] = 76;
        byArray[236] = 106;
        byArray[237] = 97;
        byArray[238] = 118;
        byArray[239] = 97;
        byArray[240] = 47;
        byArray[241] = 115;
        byArray[242] = 101;
        byArray[243] = 99;
        byArray[244] = 117;
        byArray[245] = 114;
        byArray[246] = 105;
        byArray[247] = 116;
        byArray[248] = 121;
        byArray[249] = 47;
        byArray[250] = 73;
        byArray[251] = 100;
        byArray[252] = 101;
        byArray[253] = 110;
        byArray[254] = 116;
        byArray[255] = 105;
        byArray[256] = 116;
        byArray[257] = 121;
        byArray[258] = 83;
        byArray[259] = 99;
        byArray[260] = 111;
        byArray[261] = 112;
        byArray[262] = 101;
        byArray[263] = 59;
        byArray[264] = 1;
        byArray[266] = 31;
        byArray[267] = 76;
        byArray[268] = 106;
        byArray[269] = 97;
        byArray[270] = 118;
        byArray[271] = 97;
        byArray[272] = 120;
        byArray[273] = 47;
        byArray[274] = 101;
        byArray[275] = 106;
        byArray[276] = 98;
        byArray[277] = 47;
        byArray[278] = 100;
        byArray[279] = 101;
        byArray[280] = 112;
        byArray[281] = 108;
        byArray[282] = 111;
        byArray[283] = 121;
        byArray[284] = 109;
        byArray[285] = 101;
        byArray[286] = 110;
        byArray[287] = 116;
        byArray[288] = 47;
        byArray[289] = 73;
        byArray[290] = 100;
        byArray[291] = 101;
        byArray[292] = 110;
        byArray[293] = 116;
        byArray[294] = 105;
        byArray[295] = 116;
        byArray[296] = 121;
        byArray[297] = 59;
        byArray[298] = 1;
        byArray[300] = 18;
        byArray[301] = 76;
        byArray[302] = 111;
        byArray[303] = 99;
        byArray[304] = 97;
        byArray[305] = 108;
        byArray[306] = 86;
        byArray[307] = 97;
        byArray[308] = 114;
        byArray[309] = 105;
        byArray[310] = 97;
        byArray[311] = 98;
        byArray[312] = 108;
        byArray[313] = 101;
        byArray[314] = 84;
        byArray[315] = 97;
        byArray[316] = 98;
        byArray[317] = 108;
        byArray[318] = 101;
        byArray[319] = 1;
        byArray[321] = 14;
        byArray[322] = 76;
        byArray[323] = 111;
        byArray[324] = 99;
        byArray[325] = 97;
        byArray[326] = 108;
        byArray[327] = 86;
        byArray[328] = 97;
        byArray[329] = 114;
        byArray[330] = 105;
        byArray[331] = 97;
        byArray[332] = 98;
        byArray[333] = 108;
        byArray[334] = 101;
        byArray[335] = 115;
        byArray[336] = 1;
        byArray[338] = 10;
        byArray[339] = 83;
        byArray[340] = 111;
        byArray[341] = 117;
        byArray[342] = 114;
        byArray[343] = 99;
        byArray[344] = 101;
        byArray[345] = 70;
        byArray[346] = 105;
        byArray[347] = 108;
        byArray[348] = 101;
        byArray[349] = 1;
        byArray[351] = 22;
        byArray[352] = 106;
        byArray[353] = 97;
        byArray[354] = 118;
        byArray[355] = 97;
        byArray[356] = 47;
        byArray[357] = 115;
        byArray[358] = 101;
        byArray[359] = 99;
        byArray[360] = 117;
        byArray[361] = 114;
        byArray[362] = 105;
        byArray[363] = 116;
        byArray[364] = 121;
        byArray[365] = 47;
        byArray[366] = 73;
        byArray[367] = 100;
        byArray[368] = 101;
        byArray[369] = 110;
        byArray[370] = 116;
        byArray[371] = 105;
        byArray[372] = 116;
        byArray[373] = 121;
        byArray[374] = 1;
        byArray[376] = 36;
        byArray[377] = 106;
        byArray[378] = 97;
        byArray[379] = 118;
        byArray[380] = 97;
        byArray[381] = 47;
        byArray[382] = 115;
        byArray[383] = 101;
        byArray[384] = 99;
        byArray[385] = 117;
        byArray[386] = 114;
        byArray[387] = 105;
        byArray[388] = 116;
        byArray[389] = 121;
        byArray[390] = 47;
        byArray[391] = 75;
        byArray[392] = 101;
        byArray[393] = 121;
        byArray[394] = 77;
        byArray[395] = 97;
        byArray[396] = 110;
        byArray[397] = 97;
        byArray[398] = 103;
        byArray[399] = 101;
        byArray[400] = 109;
        byArray[401] = 101;
        byArray[402] = 110;
        byArray[403] = 116;
        byArray[404] = 69;
        byArray[405] = 120;
        byArray[406] = 99;
        byArray[407] = 101;
        byArray[408] = 112;
        byArray[409] = 116;
        byArray[410] = 105;
        byArray[411] = 111;
        byArray[412] = 110;
        byArray[413] = 1;
        byArray[415] = 29;
        byArray[416] = 106;
        byArray[417] = 97;
        byArray[418] = 118;
        byArray[419] = 97;
        byArray[420] = 120;
        byArray[421] = 47;
        byArray[422] = 101;
        byArray[423] = 106;
        byArray[424] = 98;
        byArray[425] = 47;
        byArray[426] = 100;
        byArray[427] = 101;
        byArray[428] = 112;
        byArray[429] = 108;
        byArray[430] = 111;
        byArray[431] = 121;
        byArray[432] = 109;
        byArray[433] = 101;
        byArray[434] = 110;
        byArray[435] = 116;
        byArray[436] = 47;
        byArray[437] = 73;
        byArray[438] = 100;
        byArray[439] = 101;
        byArray[440] = 110;
        byArray[441] = 116;
        byArray[442] = 105;
        byArray[443] = 116;
        byArray[444] = 121;
        byArray[445] = 1;
        byArray[447] = 4;
        byArray[448] = 110;
        byArray[449] = 97;
        byArray[450] = 109;
        byArray[451] = 101;
        byArray[452] = 1;
        byArray[454] = 5;
        byArray[455] = 115;
        byArray[456] = 99;
        byArray[457] = 111;
        byArray[458] = 112;
        byArray[459] = 101;
        byArray[460] = 1;
        byArray[462] = 4;
        byArray[463] = 116;
        byArray[464] = 104;
        byArray[465] = 105;
        byArray[466] = 115;
        byArray[468] = 33;
        byArray[470] = 3;
        byArray[472] = 1;
        byArray[478] = 3;
        byArray[480] = 4;
        byArray[482] = 13;
        byArray[484] = 10;
        byArray[486] = 1;
        byArray[488] = 14;
        byArray[492] = 51;
        byArray[494] = 1;
        byArray[496] = 1;
        byArray[500] = 5;
        byArray[501] = 42;
        byArray[502] = -73;
        byArray[504] = 4;
        byArray[505] = -79;
        byArray[509] = 2;
        byArray[511] = 18;
        byArray[515] = 10;
        byArray[517] = 2;
        byArray[521] = 8;
        byArray[523] = 4;
        byArray[525] = 7;
        byArray[527] = 22;
        byArray[531] = 12;
        byArray[533] = 1;
        byArray[537] = 5;
        byArray[539] = 30;
        byArray[541] = 21;
        byArray[545] = 1;
        byArray[547] = 13;
        byArray[549] = 11;
        byArray[551] = 1;
        byArray[553] = 14;
        byArray[557] = 62;
        byArray[559] = 2;
        byArray[561] = 2;
        byArray[565] = 6;
        byArray[566] = 42;
        byArray[567] = 43;
        byArray[568] = -73;
        byArray[570] = 5;
        byArray[571] = -79;
        byArray[575] = 2;
        byArray[577] = 18;
        byArray[581] = 10;
        byArray[583] = 2;
        byArray[587] = 11;
        byArray[589] = 5;
        byArray[591] = 10;
        byArray[593] = 22;
        byArray[597] = 22;
        byArray[599] = 2;
        byArray[603] = 6;
        byArray[605] = 30;
        byArray[607] = 21;
        byArray[613] = 6;
        byArray[615] = 28;
        byArray[617] = 19;
        byArray[619] = 1;
        byArray[621] = 1;
        byArray[623] = 13;
        byArray[625] = 12;
        byArray[627] = 2;
        byArray[629] = 14;
        byArray[633] = 73;
        byArray[635] = 3;
        byArray[637] = 3;
        byArray[641] = 7;
        byArray[642] = 42;
        byArray[643] = 43;
        byArray[644] = 44;
        byArray[645] = -73;
        byArray[647] = 6;
        byArray[648] = -79;
        byArray[652] = 2;
        byArray[654] = 18;
        byArray[658] = 10;
        byArray[660] = 2;
        byArray[664] = 14;
        byArray[666] = 6;
        byArray[668] = 13;
        byArray[670] = 22;
        byArray[674] = 32;
        byArray[676] = 3;
        byArray[680] = 7;
        byArray[682] = 30;
        byArray[684] = 21;
        byArray[690] = 7;
        byArray[692] = 28;
        byArray[694] = 19;
        byArray[696] = 1;
        byArray[700] = 7;
        byArray[702] = 29;
        byArray[704] = 20;
        byArray[706] = 2;
        byArray[708] = 16;
        byArray[712] = 4;
        byArray[714] = 1;
        byArray[716] = 2;
        byArray[718] = 1;
        byArray[720] = 24;
        byArray[724] = 2;
        byArray[726] = 17;
        identityClassBits = byArray;
    }

    public EjbJarFileEditor() {
    }

    public EjbJarFileEditor(File fileName) throws ToolsException {
        this.open(fileName);
    }

    private void addBeanStream(Manifest manifest, ZipOutputStream zos, InputStream in, String entryName) throws IOException {
        int len;
        BufferedInputStream is = new BufferedInputStream(in);
        is.mark(in.available() * 2);
        ZipEntry e = new ZipEntry(entryName);
        e.setSize(is.available());
        e.setMethod(0);
        this.crc32Entry(e, is);
        zos.putNextEntry(e);
        is.reset();
        byte[] buf = new byte[1024];
        while ((len = is.read(buf, 0, buf.length)) != -1) {
            zos.write(buf, 0, len);
        }
        zos.closeEntry();
        is.reset();
        manifest.addEjbEntry(entryName, is);
        is.close();
    }

    public void addDeploymentDescriptor(String name, DeploymentDescriptor descriptor) {
        String beanName = this.purifyBeanName(name);
        this.descriptors.put(beanName, descriptor);
    }

    public void addIdentityClass() {
        this.addIdentityClass = true;
    }

    private void addStream(Manifest manifest, ZipOutputStream zos, InputStream in, String entryName) throws IOException {
        int len;
        BufferedInputStream is = new BufferedInputStream(in);
        is.mark(in.available() * 2);
        ZipEntry e = new ZipEntry(entryName);
        e.setSize(is.available());
        e.setMethod(0);
        this.crc32Entry(e, is);
        is.reset();
        zos.putNextEntry(e);
        byte[] buf = new byte[1024];
        while ((len = is.read(buf, 0, buf.length)) != -1) {
            zos.write(buf, 0, len);
        }
        is.reset();
        zos.closeEntry();
        manifest.addFileEntry(entryName, is);
        is.close();
    }

    private void addStreams(Manifest manifest, ZipOutputStream zos) throws IOException {
        Enumeration entries = this.allEntriesExceptBeans().elements();
        while (entries.hasMoreElements()) {
            ZipEntry entry = this.jarFile.getEntry((String)entries.nextElement());
            this.addStream(manifest, zos, this.jarFile.getInputStream(entry), entry.getName());
        }
        if (this.addIdentityClass && this.jarFile.getEntry("javax.ejb.deployment.Identity.class") == null) {
            this.addStream(manifest, zos, new ByteArrayInputStream(identityClassBits), "javax.ejb.deployment.Identity.class");
        }
        String[] beanNames = this.getDeploymentDescriptorNames();
        int i = 0;
        while (i < beanNames.length) {
            this.addBeanStream(manifest, zos, this.getBeanStream(beanNames[i]), this.beanEntryName(beanNames[i]));
            ++i;
        }
    }

    private Vector allEntriesExceptBeans() throws IOException {
        Vector<String> entries = new Vector<String>();
        InputStream manifest = this.jarFile.getInputStream(this.jarFile.getEntry("META-INF/MANIFEST.MF"));
        Enumeration manifestEntries = new Manifest(manifest, false).entries();
        while (manifestEntries.hasMoreElements()) {
            MessageHeader entry = (MessageHeader)manifestEntries.nextElement();
            String name = entry.findValue("Name");
            if (this.isEjbEntry(entry) || name == null) continue;
            entries.addElement(name);
        }
        return entries;
    }

    private String beanEntryName(String name) {
        String beanEntryName = new String(name).replace('.', '/');
        return String.valueOf(beanEntryName) + ".ser";
    }

    InputStream classBits(String className) throws IOException {
        String classFilename = String.valueOf(className.replace('.', '/')) + ".class";
        ZipEntry classEntry = this.jarFile.getEntry(classFilename);
        if (classEntry == null) {
            throw new FileNotFoundException(className);
        }
        return this.jarFile.getInputStream(classEntry);
    }

    public ClassLoader classLoader() {
        return this.classLoader;
    }

    private String classNameFrom(String name) {
        return new String(name).substring(0, name.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }

    public void close() throws ToolsException {
        if (this.jarFile == null) {
            return;
        }
        this.descriptors = null;
        this.classList = null;
        try {
            this.jarFile.close();
        }
        catch (IOException iOException) {
            throw new ToolsException(String.valueOf(resMessages.getString("UNABLE_TO_CLOSE_FILE")) + this.jarFilename);
        }
        this.jarFile = null;
    }

    private void crc32Entry(ZipEntry e, BufferedInputStream is) throws IOException {
        byte[] buf = new byte[1024];
        this.crc32.reset();
        int r = 0;
        int nread = 0;
        long len = is.available();
        while ((r = is.read(buf)) != -1) {
            nread += r;
            this.crc32.update(buf, 0, r);
        }
        is.close();
        if (nread != (int)len) {
            throw new IOException(resMessages.getString("INCORRECT_LENGTH"));
        }
        e.setCrc(this.crc32.getValue());
    }

    private void crc32Manifest(ZipEntry e, Manifest m) throws IOException {
        this.crc32.reset();
        CRC32OutputStream os = new CRC32OutputStream(this.crc32);
        PrintStream ps = new PrintStream(os);
        m.stream(ps);
        e.setSize(os.n);
        e.setCrc(this.crc32.getValue());
    }

    private SessionDescriptor deserializeDescriptor(String entryName) throws ToolsException {
        InputStream input;
        try {
            input = this.jarFile.getInputStream(this.jarFile.getEntry(entryName));
            if (input == null) {
                throw new ToolsException(String.valueOf(resMessages.getString("DESCRIPTOR_ENTRY_NOT_FOUND")) + entryName);
            }
        }
        catch (IOException e) {
            throw new ToolsException(String.valueOf(resMessages.getString("IOEXCEPTION_OPENING")) + entryName + " : " + e.getMessage());
        }
        try {
            return (SessionDescriptor)new ObjectInputStream(input).readObject();
        }
        catch (IOException e) {
            throw new ToolsException(String.valueOf(resMessages.getString("IOEXCEPTION_DESERIALIZING")) + entryName + " : " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new ToolsException(String.valueOf(resMessages.getString("CLASS_NOT_FOUND_DESERIALIZING")) + entryName + " : " + e.getMessage());
        }
        catch (Exception e) {
            throw new ToolsException(String.valueOf(resMessages.getString("UNEXPECTED_EXCEPTION_DESERIALIZING")) + entryName + " : " + e.getMessage());
        }
    }

    private String entryName(String name) {
        if ((name = new String(name).replace(File.separatorChar, '/')).startsWith("/")) {
            name = name.substring(1);
        } else if (name.startsWith("./")) {
            name = name.substring(2);
        }
        return name;
    }

    private InputStream getBeanStream(String beanName) throws IOException {
        ByteArrayOutputStream objBytes = new ByteArrayOutputStream(1024);
        new ObjectOutputStream(objBytes).writeObject(this.getDeploymentDescriptor(beanName));
        return new ByteArrayInputStream(objBytes.toByteArray());
    }

    public Class getClass(String className) throws ClassNotFoundException {
        return this.classLoader.loadClass(className);
    }

    public DeploymentDescriptor getDeploymentDescriptor(String name) {
        return (DeploymentDescriptor)this.descriptors.get(name);
    }

    public String[] getDeploymentDescriptorNames() {
        String[] names = new String[this.descriptors.size()];
        Enumeration keys = this.descriptors.keys();
        int i = 0;
        while (i < names.length) {
            names[i] = (String)keys.nextElement();
            ++i;
        }
        return names;
    }

    public DeploymentDescriptor[] getDeploymentDescriptors() {
        DeploymentDescriptor[] d = new DeploymentDescriptor[this.descriptors.size()];
        Enumeration elements = this.descriptors.elements();
        int i = 0;
        while (i < d.length) {
            d[i] = (DeploymentDescriptor)elements.nextElement();
            ++i;
        }
        return d;
    }

    public File getJarFilename() {
        return this.jarFilename;
    }

    private boolean isClassEntry(ZipEntry entry) {
        return entry.getName().endsWith(".class");
    }

    private boolean isEjbEntry(MessageHeader entry) {
        if (entry.findValue("Enterprise-Bean") == null) {
            return false;
        }
        return entry.findValue("Enterprise-Bean").equals("True");
    }

    private void loadClassList() throws ToolsException {
        Enumeration<ZipEntry> e = this.jarFile.entries();
        Vector<String> class_names = new Vector<String>();
        while (e.hasMoreElements()) {
            ZipEntry currentEntry = e.nextElement();
            if (currentEntry.isDirectory() || !this.isClassEntry(currentEntry)) continue;
            String className = this.classNameFrom(currentEntry.getName());
            class_names.addElement(className);
        }
        this.classList = new String[class_names.size()];
        e = class_names.elements();
        int i = 0;
        while (i < this.classList.length) {
            this.classList[i] = (String)((Object)e.nextElement());
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadDeploymentDescriptors() throws ToolsException {
        manifest = null;
        descriptorEntries = new Vector<String>();
        try {
            manifest = this.jarFile.getInputStream(this.jarFile.getEntry("META-INF/MANIFEST.MF"));
        }
        catch (IOException e) {
            throw new ToolsException(String.valueOf(EjbJarFileEditor.resMessages.getString("IOEXCEPTION_RETRIEVING_MANIFEST")) + e.getMessage());
        }
        if (manifest == null) {
            return;
        }
        entries = null;
        try {
            entries = new Manifest(manifest, false).entries();
            if (true) ** GOTO lbl22
        }
        catch (IOException e) {
            throw new ToolsException(String.valueOf(EjbJarFileEditor.resMessages.getString("IOEXCEPTION_READING_MANIFEST")) + e.getMessage());
        }
        do {
            if (!this.isEjbEntry(entry = (MessageHeader)entries.nextElement())) continue;
            theName = entry.findValue("Name");
            if (theName == null) {
                throw new ToolsException(String.valueOf(EjbJarFileEditor.resMessages.getString("INVALID_MANIFEST_ENTRY")) + entry);
            }
            descriptorEntries.addElement(theName);
lbl22:
            // 3 sources

        } while (entries.hasMoreElements());
        entries = descriptorEntries.elements();
        while (entries.hasMoreElements()) {
            descriptorName = (String)entries.nextElement();
            this.descriptors.put(this.purifyBeanName(descriptorName), this.deserializeDescriptor(descriptorName));
        }
    }

    public void open() throws ToolsException {
        this.close();
        try {
            this.jarFile = new ZipFile(this.jarFilename);
        }
        catch (IOException iOException) {
            throw new ToolsException(String.valueOf(resMessages.getString("CANNOT_OPEN")) + this.jarFilename);
        }
        Enumeration<? extends ZipEntry> e = this.jarFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry currentEntry = e.nextElement();
            if (currentEntry.getMethod() != 8) continue;
            throw new ToolsException("Unable to continue: " + this.jarFilename + resMessages.getString("CONTAINS_COMPRESSED_ENTRIES"));
        }
        this.loadDeploymentDescriptors();
        this.loadClassList();
    }

    public void open(File filename) throws ToolsException {
        this.setJarFilename(filename);
        this.open();
    }

    private String purifyBeanName(String name) {
        String beanName = new String(name);
        if (beanName.endsWith(".ser")) {
            beanName = beanName.substring(0, name.lastIndexOf(".ser"));
        }
        return beanName.replace('/', '.').replace('\\', '.');
    }

    public void save() throws ToolsException {
        this.saveAs(String.valueOf(String.valueOf(this.jarFilename)) + ".temp");
        this.jarFilename.delete();
        new File(String.valueOf(String.valueOf(this.jarFilename)) + ".temp").renameTo(this.jarFilename);
    }

    public void saveAs(String newJarFilename) throws ToolsException {
        if (newJarFilename.equals(this.jarFilename)) {
            this.save();
            return;
        }
        try {
            String MANIFEST = "META-INF/MANIFEST.MF";
            FileOutputStream out = new FileOutputStream(newJarFilename);
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(out));
            zos.setMethod(0);
            Manifest manifest = new Manifest(null);
            this.addStreams(manifest, zos);
            ZipEntry e = new ZipEntry(MANIFEST);
            e.setTime(System.currentTimeMillis());
            e.setMethod(0);
            this.crc32Manifest(e, manifest);
            zos.putNextEntry(e);
            manifest.stream(zos);
            zos.closeEntry();
            zos.close();
            ((OutputStream)out).close();
            this.close();
        }
        catch (IOException e) {
            throw new ToolsException(String.valueOf(resMessages.getString("IOERROR_SAVING")) + this.jarFilename + " : " + e.getMessage());
        }
    }

    public void setJarFilename(File filename) {
        this.jarFilename = filename;
    }
}

