/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.task;

import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.task.SMTaskRequestInfo;
import com.sun.symon.base.utility.UcInternationalizer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Locale;

public class SMTaskRequestData
extends SMTaskRequestInfo {
    private static final String version = "1.0";
    protected String owner;
    protected Date beginDate;
    protected long period;
    protected int units;

    public SMTaskRequestData() {
    }

    public SMTaskRequestData(SMDBObjectID sMDBObjectID) {
        super(sMDBObjectID);
    }

    public void clearStartDate() {
        this.beginDate = null;
        this.setChanged(true);
    }

    public Object clone() {
        return super.clone();
    }

    public String getOwner() {
        return this.owner;
    }

    public long getPeriod() {
        return this.period;
    }

    public int getPeriodUnits() {
        return this.units;
    }

    public Date getStartDate() {
        return this.beginDate;
    }

    public long getStartTime() {
        if (this.beginDate != null) {
            return this.beginDate.getTime();
        }
        return -1L;
    }

    public boolean isPeriodic() {
        return this.period != 0L && this.units != 0;
    }

    public boolean isScheduled() {
        return this.isScheduled;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        SMDBObject.readString(objectInputStream);
        this.owner = SMDBObject.readString(objectInputStream);
        this.beginDate = (Date)objectInputStream.readObject();
        this.period = objectInputStream.readLong();
        this.units = objectInputStream.readInt();
    }

    public void setDescription(String string) throws SMLengthException {
        if (string != null && string.length() > 256) {
            throw new SMLengthException();
        }
        this.description = string;
        this.setChanged(true);
    }

    public void setName(String string) throws SMLengthException {
        if (string != null && string.length() > 32) {
            throw new SMLengthException();
        }
        this.name = string;
        this.setChanged(true);
    }

    public void setObjectGroupName(String string) throws SMLengthException {
        if (string != null && string.length() > 32) {
            throw new SMLengthException();
        }
        this.groupName = string;
        this.setChanged(true);
    }

    public void setOwner(String string) throws SMLengthException {
        this.owner = string;
    }

    public void setPeriod(long l) {
        this.period = l;
    }

    public void setPeriodUnits(int n) {
        this.units = n;
    }

    public void setScheduled(boolean bl) {
        this.isScheduled = bl;
    }

    public void setStartDate(Date date) {
        this.beginDate = date;
        this.setChanged(true);
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void setTaskName(String string) throws SMLengthException {
        if (string != null && string.length() > 32) {
            throw new SMLengthException();
        }
        this.taskName = string;
        this.setChanged(true);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("Owner:" + this.owner + "\n").append("Start Date:" + this.beginDate + "\n").append("Period:" + this.period + "\n").append("Period units:" + this.units + "\n");
        return stringBuffer.toString();
    }

    public void validate() {
        this.validate(Locale.getDefault());
    }

    public void validate(Locale locale) {
        String string = this.getName();
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException(UcInternationalizer.translateKey((Locale)locale, (String)"base.client.ClientApiMessages:TaskRequest.InvalidRequestName"));
        }
        string = this.getTaskName();
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException(UcInternationalizer.translateKey((Locale)locale, (String)"base.client.ClientApiMessages:TaskRequest.InvalidTaskName"));
        }
        string = this.getObjectGroupName();
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException(UcInternationalizer.translateKey((Locale)locale, (String)"base.client.ClientApiMessages:TaskRequest.InvalidGroupName"));
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        SMDBObject.writeString(objectOutputStream, version);
        SMDBObject.writeString(objectOutputStream, this.owner);
        objectOutputStream.writeObject(this.beginDate);
        objectOutputStream.writeLong(this.period);
        objectOutputStream.writeInt(this.units);
    }
}

