/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.group;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.group.SMFilterCriteria;
import com.sun.symon.base.client.group.SMFilterData;
import com.sun.symon.base.client.group.SMIPRangeCriteria;
import com.sun.symon.base.client.group.SMModuleCriteria;
import com.sun.symon.base.client.group.SMNameCriteria;
import com.sun.symon.base.client.group.SMOSCriteria;
import com.sun.symon.base.client.group.SMObjectGroupData;
import com.sun.symon.base.client.group.SMPlatformCriteria;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.mgmtservice.common.MSDB;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.group.MgFilterImpl;
import com.sun.symon.base.mgmtservice.group.MgFilterService;
import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.utility.UcURL;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

class HostResolver {
    Connection con;
    static final String DOMAIN_BY_NAME = "select node_id from node where isDomain = 'T' and description=";
    static final String SELECT_NODE = "select node_id from node where description=";
    static final String SELECT_LEAF = "select leaf_id  from leaf where leaf_id in ( select leaf_id from node_entity_relator where node_id=";
    static final String SELECT_NAME_PORT = "select decode(hostname, NULL, ip_address, hostname), port  from leaf where leaf_id in ";
    static final String DOMAIN_NAME = "Default Domain";
    static final String LOAD_PLATFORMS = "select family, family_type_id from family_type where family is not null";
    static final String LOAD_IP_ADDRESSES = "select ip_address, leaf_id from leaf where leaf_id in ";
    static final String FIND_ID_BY_MODULE_PART1 = " select leaf_id from entity_moduleinstance where leaf_id in (";
    static final String FIND_ID_BY_MODULE_PART2 = ") and module_instance_id in (select module_instance_id from moduleinstance  where module_id in (select module_id from module where name in (";
    static final int SIZE = 20;
    HostTable result;
    SMObjectGroupData group;
    ScSecurityCredential security;
    boolean doLogSql = false;
    static Hashtable platform2id;
    MSLogPrintWriter errorWriter = MSLogPrintWriter.getErrorWriter();
    MSLogPrintWriter sqlWriter;
    private static String[] EMPTY;
    private String hostName;
    private String ip_address;

    static {
        EMPTY = new String[0];
    }

    protected HostResolver(SMObjectGroupData sMObjectGroupData, ScSecurityCredential scSecurityCredential, String string) {
        this.group = sMObjectGroupData;
        this.security = scSecurityCredential;
        this.hostName = string;
        try {
            this.sqlWriter = MSLogPrintWriter.getChannel((String)"sql");
        }
        catch (IOException iOException) {
            try {
                this.sqlWriter = MSLogPrintWriter.createChannel((String)"sql");
            }
            catch (IOException iOException2) {}
        }
        if (this.sqlWriter != null) {
            this.doLogSql = this.sqlWriter.isActive();
        }
    }

    private void addIPRangeCriteria(SMIPRangeCriteria sMIPRangeCriteria) throws SQLException {
        HostTable hostTable = new HostTable();
        Statement statement = this.con.createStatement();
        int n = 0;
        int n2 = this.result.size();
        Enumeration enumeration = this.result.keys();
        while (true) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(LOAD_IP_ADDRESSES).append("(");
            int n3 = n + 20;
            if (n3 > n2) {
                n3 = n2;
            }
            int n4 = n;
            while (n4 < n3) {
                object = enumeration.nextElement();
                if (n4 != n) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(object);
                ++n4;
            }
            stringBuffer.append(")");
            if (this.doLogSql) {
                this.sqlWriter.println(stringBuffer.toString());
            }
            object = statement.executeQuery(stringBuffer.toString());
            while (object.next()) {
                String string = object.getString(1);
                if (!sMIPRangeCriteria.isInRange(string)) continue;
                hostTable.put(new Long(object.getLong(2)));
            }
            object.close();
            if (n3 == n2) break;
            n += 20;
        }
        statement.close();
        this.result = hostTable;
    }

    private void addModuleCriteria(SMModuleCriteria sMModuleCriteria) throws SQLException {
        String[] stringArray = sMModuleCriteria.getList();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        HostTable hostTable = new HostTable();
        Statement statement = this.con.createStatement();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FIND_ID_BY_MODULE_PART1).append(this.result).append(FIND_ID_BY_MODULE_PART2);
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append("'").append(stringArray[n]).append("'");
            ++n;
        }
        stringBuffer.append(")))");
        if (this.doLogSql) {
            this.sqlWriter.println(stringBuffer.toString());
        }
        ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
        while (resultSet.next()) {
            hostTable.put(new Long(resultSet.getLong(1)));
        }
        if (sMModuleCriteria.isInclude()) {
            this.result = hostTable;
        } else {
            Enumeration enumeration = hostTable.keys();
            while (enumeration.hasMoreElements()) {
                this.result.remove(enumeration.nextElement());
            }
        }
        resultSet.close();
        statement.close();
    }

    private void addNameCriteria(SMNameCriteria sMNameCriteria, StringBuffer stringBuffer) throws SQLException {
        HostTable hostTable = new HostTable();
        String string = this.escapeSpecial(sMNameCriteria.getPattern());
        if (string == null || string.trim().length() == 0) {
            this.result = new HostTable();
            return;
        }
        if (!UcListUtil.isAsciiString((String)string)) {
            string = UcListUtil.UnicodeToAscii((String)string);
        }
        String string2 = sMNameCriteria.getMatchType();
        Statement statement = this.con.createStatement();
        StringBuffer stringBuffer2 = new StringBuffer("select entity_id from entity_info where description ");
        if (string2.equals("X")) {
            stringBuffer2.append("='").append(string).append("' ");
        } else if (string2.equals("C")) {
            stringBuffer2.append("like '%").append(string).append("%' ");
        } else if (string2.equals("S")) {
            stringBuffer2.append("like '").append(string).append("%' ");
        } else if (string2.equals("E")) {
            stringBuffer2.append("like '%").append(string).append("' ");
        }
        if (this.doLogSql) {
            this.sqlWriter.println((Object)stringBuffer2);
        }
        ResultSet resultSet = statement.executeQuery(stringBuffer2.toString());
        Vector<Long> vector = new Vector<Long>();
        while (resultSet.next()) {
            vector.addElement(new Long(resultSet.getLong(1)));
        }
        resultSet.close();
        int n = vector.size();
        if (n == 0) {
            this.result = new HostTable();
            return;
        }
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = n2 + 20) > n) {
                n3 = n;
            }
            stringBuffer2 = new StringBuffer("select leaf_id from node_entity_relator where  entity_id  in (");
            int n4 = n2;
            while (n4 < n3) {
                if (n4 != n2) {
                    stringBuffer2.append(",");
                }
                stringBuffer2.append(vector.elementAt(n4));
                ++n4;
            }
            stringBuffer2.append(")");
            if (this.doLogSql) {
                this.sqlWriter.println(stringBuffer2.toString());
            }
            resultSet = statement.executeQuery(stringBuffer2.toString());
            while (resultSet.next()) {
                hostTable.put(new Long(resultSet.getLong(1)));
            }
            resultSet.close();
            if (n3 == n) break;
            n2 += 20;
        }
        statement.close();
        if (hostTable.size() == 0) {
            this.result = new HostTable();
            return;
        }
        Enumeration enumeration = this.result.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (hostTable.get(k) != null) continue;
            this.result.remove(k);
        }
    }

    private void addOSCriteria(SMOSCriteria sMOSCriteria, StringBuffer stringBuffer) {
        String[] stringArray = sMOSCriteria.getList();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        stringBuffer.append(" and arch ");
        if (!sMOSCriteria.isInclude()) {
            stringBuffer.append(" not ");
        }
        stringBuffer.append(" in (");
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append("'").append(stringArray[n]).append("'");
            ++n;
        }
        stringBuffer.append(")");
    }

    private void addPlatformCriteria(SMPlatformCriteria sMPlatformCriteria, StringBuffer stringBuffer) throws SQLException {
        String[] stringArray;
        if (platform2id == null) {
            this.loadPlatforms();
        }
        if ((stringArray = sMPlatformCriteria.getList()) == null || stringArray.length == 0) {
            return;
        }
        stringBuffer.append(" and family_type_id ");
        if (!sMPlatformCriteria.isInclude()) {
            stringBuffer.append(" not ");
        }
        stringBuffer.append(" in (");
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            Object v = platform2id.get(stringArray[n]);
            if (v != null) {
                stringBuffer.append(v);
            }
            ++n;
        }
        stringBuffer.append(")");
    }

    private String[] doFilter() throws SQLException, SMAPIException, SMDatabaseException {
        int n;
        Object object;
        SMFilterCriteria sMFilterCriteria;
        int n2;
        SMFilterCriteria[] sMFilterCriteriaArray;
        Object object2;
        SMFilterData sMFilterData = null;
        if (this.result.size() == 0) {
            return EMPTY;
        }
        if (this.group.getFilter() != null) {
            object2 = null;
            try {
                object2 = MgFilterService.getFilterImpl(this.security);
            }
            catch (Exception exception) {
                this.errorWriter.println((Throwable)exception);
                throw new SMAPIException(exception.getMessage());
            }
            if (object2 == null) {
                throw new SMAPIException("Cannot find MgFilterImpl");
            }
            sMFilterData = ((MgFilterImpl)((Object)object2)).load(this.group.getFilter());
        }
        object2 = new StringBuffer();
        if (sMFilterData != null && (sMFilterCriteriaArray = sMFilterData.getFilterCriteria()) != null) {
            n2 = 0;
            while (n2 < sMFilterCriteriaArray.length) {
                sMFilterCriteria = sMFilterCriteriaArray[n2];
                if (sMFilterCriteria.isEnabled()) {
                    if (sMFilterCriteria instanceof SMNameCriteria) {
                        this.addNameCriteria((SMNameCriteria)sMFilterCriteria, (StringBuffer)object2);
                        if (this.result.size() == 0) {
                            return EMPTY;
                        }
                    }
                    if (sMFilterCriteria instanceof SMOSCriteria) {
                        this.addOSCriteria((SMOSCriteria)sMFilterCriteria, (StringBuffer)object2);
                        if (this.result.size() == 0) {
                            return EMPTY;
                        }
                    }
                    if (sMFilterCriteria instanceof SMPlatformCriteria) {
                        this.addPlatformCriteria((SMPlatformCriteria)sMFilterCriteria, (StringBuffer)object2);
                    }
                    if (sMFilterCriteria instanceof SMIPRangeCriteria) {
                        this.addIPRangeCriteria((SMIPRangeCriteria)sMFilterCriteria);
                        if (this.result.size() == 0) {
                            return EMPTY;
                        }
                    }
                    if (sMFilterCriteria instanceof SMModuleCriteria) {
                        this.addModuleCriteria((SMModuleCriteria)sMFilterCriteria);
                    }
                }
                ++n2;
            }
        }
        if (this.result.size() == 0) {
            return EMPTY;
        }
        int n3 = 0;
        n2 = this.result.size();
        sMFilterCriteria = this.result.keys();
        Statement statement = this.con.createStatement();
        TreeSet<String> treeSet = new TreeSet<String>();
        while (true) {
            Object object3;
            object = new StringBuffer();
            ((StringBuffer)object).append(SELECT_NAME_PORT).append("(");
            int n4 = n3 + 20;
            if (n4 > n2) {
                n4 = n2;
            }
            n = n3;
            while (n < n4) {
                object3 = sMFilterCriteria.nextElement();
                if (n != n3) {
                    ((StringBuffer)object).append(",");
                }
                ((StringBuffer)object).append(object3);
                ++n;
            }
            ((StringBuffer)object).append(")").append(object2).append(" order by hostname");
            if (this.doLogSql) {
                this.sqlWriter.println(((StringBuffer)object).toString());
            }
            object3 = statement.executeQuery(((StringBuffer)object).toString());
            while (object3.next()) {
                String string = object3.getString(1);
                int n5 = object3.getInt(2);
                String string2 = string;
                if (n5 > 0) {
                    string2 = String.valueOf(string) + ":" + n5;
                }
                treeSet.add(string2);
            }
            object3.close();
            if (n4 == n2) break;
            n3 += 20;
        }
        statement.close();
        n2 = treeSet.size();
        object = treeSet.iterator();
        String[] stringArray = new String[n2];
        n = 0;
        while (object.hasNext()) {
            stringArray[n++] = (String)object.next();
        }
        return stringArray;
    }

    private String escapeSpecial(String string) {
        int n = string.indexOf("'");
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n != -1) {
            stringBuffer.append(string.substring(0, n + 1));
            stringBuffer.append("'");
            string = string.substring(n + 1);
            n = string.indexOf("'");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private void getAllLeavesForView(long l) throws SQLException {
        Object object;
        CharSequence charSequence;
        Vector<Long> vector = new Vector<Long>();
        String string = "select description,entity_id,poll_type,url from entity_info where  entity_id in (select entity_id from view_entity_relator where view_id=" + l + ")";
        if (this.doLogSql) {
            this.sqlWriter.println(string);
        }
        Statement statement = this.con.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            charSequence = resultSet.getString("poll_type");
            if (((String)charSequence).equals("aview")) {
                int n;
                object = resultSet.getString("url");
                UcURL ucURL = new UcURL((String)object);
                String string2 = ucURL.getHost();
                if (!string2.equals(this.hostName) && !string2.equals(this.ip_address) || (n = ((String)object).lastIndexOf("view-")) == -1) continue;
                String string3 = ((String)object).substring(n + 5);
                if ((n = string3.indexOf("/")) != -1) {
                    string3 = string3.substring(0, n);
                }
                long l2 = Long.parseLong(string3);
                this.getAllLeavesForView(l2);
                continue;
            }
            vector.add(new Long(resultSet.getLong("entity_id")));
        }
        resultSet.close();
        if (!vector.isEmpty()) {
            charSequence = new StringBuffer();
            object = vector.elements();
            boolean bl = true;
            while (object.hasMoreElements()) {
                if (bl) {
                    bl = false;
                } else {
                    ((StringBuffer)charSequence).append(",");
                }
                ((StringBuffer)charSequence).append(object.nextElement());
            }
            string = SELECT_LEAF + l + " and entity_id  in (" + ((StringBuffer)charSequence).toString() + "))";
            if (this.doLogSql) {
                this.sqlWriter.println(string);
            }
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                this.result.put(new Long(resultSet.getLong("leaf_id")));
            }
        }
        resultSet.close();
        statement.close();
    }

    private void getAllObjectLeaves(String string, long l) throws SQLException, SMAPIException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            vector.addElement(string2);
        }
        int n = vector.size();
        long l2 = l;
        if (n > 1) {
            int n2 = 0;
            while (n2 < n - 1) {
                l2 = this.getViewByParentAndName((String)vector.elementAt(n2), l2);
                if (l2 < 0L) {
                    return;
                }
                ++n2;
            }
        }
        if (n > 0) {
            long l3 = this.getViewByParentAndName((String)vector.lastElement(), l2);
            if (l3 > 0L) {
                this.getAllLeavesForView(l3);
            } else {
                this.getLeaveByParentAndName((String)vector.lastElement(), l2);
            }
        } else {
            this.getAllLeavesForView(l2);
        }
    }

    private long getDomainNodeId(String string) throws SQLException, SMAPIException {
        ResultSet resultSet;
        long l = -1L;
        if (!UcListUtil.isAsciiString((String)string)) {
            string = UcListUtil.UnicodeToAscii((String)string);
        }
        Statement statement = this.con.createStatement();
        String string2 = "select node_id from node where isDomain = 'T' and description='" + string + "'";
        if (this.doLogSql) {
            this.sqlWriter.println(string2);
        }
        if (!(resultSet = statement.executeQuery(string2)).next()) {
            throw new SMDatabaseException("Domain is not available");
        }
        l = resultSet.getLong(1);
        resultSet.close();
        statement.close();
        return l;
    }

    private String getIpAddress() throws SQLException {
        String string = "";
        String string2 = "select ip_address from leaf where hostname = '" + this.hostName + "'";
        Statement statement = this.con.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        while (resultSet.next()) {
            string = resultSet.getString("ip_address");
        }
        resultSet.close();
        statement.close();
        return string;
    }

    private void getLeaveByParentAndName(String string, long l) throws SQLException, SMAPIException {
        string = this.escapeSpecial(string);
        Statement statement = this.con.createStatement();
        if (!UcListUtil.isAsciiString((String)string)) {
            string = UcListUtil.UnicodeToAscii((String)string);
        }
        String string2 = "select entity_id from entity_info where description ='" + string + "'";
        ResultSet resultSet = statement.executeQuery(string2);
        if (this.doLogSql) {
            this.sqlWriter.println(string2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (resultSet.next()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(resultSet.getLong(1));
        }
        resultSet.close();
        if (bl) {
            if (!string.equals(DOMAIN_NAME) && !string.equals("base.console.ConsoleTopology:domain.defaultdomain")) {
                throw new SMDatabaseException(String.valueOf(string) + " - No such Object in topology.");
            }
            return;
        }
        string2 = SELECT_LEAF + l + " and entity_id  in (" + stringBuffer.toString() + "))";
        if (this.doLogSql) {
            this.sqlWriter.println(string2);
        }
        if ((resultSet = statement.executeQuery(string2)).next()) {
            this.result.put(new Long(resultSet.getLong(1)));
        }
        resultSet.close();
        statement.close();
    }

    private long getViewByParentAndName(String string, long l) throws SQLException, SMAPIException {
        string = this.escapeSpecial(string);
        String string2 = "select description,entity_id,poll_type,url from entity_info where description='" + string + "' and entity_id " + "in (select entity_id from view_entity_relator where view_id=" + l + ")";
        Statement statement = this.con.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        long l2 = -1L;
        while (resultSet.next()) {
            int n;
            String string3;
            UcURL ucURL;
            String string4;
            String string5 = resultSet.getString("poll_type");
            if (!string5.equals("aview") || !(string4 = (ucURL = new UcURL(string3 = resultSet.getString("url"))).getHost()).equals(this.hostName) && !string4.equals(this.ip_address) || (n = string3.lastIndexOf("view-")) == -1) continue;
            String string6 = string3.substring(n + 5);
            if ((n = string6.indexOf("/")) != -1) {
                string6 = string6.substring(0, n);
            }
            l2 = Long.parseLong(string6);
        }
        resultSet.close();
        statement.close();
        return l2;
    }

    private void loadPlatforms() throws SQLException {
        platform2id = new Hashtable();
        Statement statement = this.con.createStatement();
        if (this.doLogSql) {
            this.sqlWriter.println(LOAD_PLATFORMS);
        }
        ResultSet resultSet = statement.executeQuery(LOAD_PLATFORMS);
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            platform2id.put(string, new Long(resultSet.getLong(2)));
        }
        resultSet.close();
        statement.close();
    }

    public String[] resolve() throws SMAPIException, SMDatabaseException {
        String string = this.group.getDomain();
        if (string.equals("base.console.ConsoleTopology:domain.defaultdomain")) {
            string = DOMAIN_NAME;
        }
        string = this.escapeSpecial(string);
        String[] stringArray = null;
        try {
            try {
                this.con = MSDB.getConnection();
                this.ip_address = this.getIpAddress();
                long l = this.getDomainNodeId(string);
                this.result = new HostTable();
                if (this.group.isAllObjectsInDomain()) {
                    this.getAllObjectLeaves("", l);
                } else {
                    String[] stringArray2 = this.group.getObjects();
                    int n = 0;
                    if (stringArray2 != null) {
                        n = stringArray2.length;
                    }
                    int n2 = 0;
                    while (n2 < n) {
                        this.getAllObjectLeaves(stringArray2[n2], l);
                        ++n2;
                    }
                }
                stringArray = this.doFilter();
            }
            catch (Exception exception) {
                this.errorWriter.println((Throwable)exception);
                if (exception instanceof SMAPIException) {
                    throw (SMAPIException)((Object)exception);
                }
                throw new SMDatabaseException((Throwable)exception);
            }
            Object var4_10 = null;
        }
        catch (Throwable throwable) {
            Object var4_11 = null;
            try {
                this.con.close();
            }
            catch (SQLException sQLException) {
                this.errorWriter.println((Throwable)sQLException);
                throw new SMDatabaseException((Throwable)sQLException);
            }
            throw throwable;
        }
        try {
            this.con.close();
        }
        catch (SQLException sQLException) {
            this.errorWriter.println((Throwable)sQLException);
            throw new SMDatabaseException((Throwable)sQLException);
        }
        return stringArray;
    }

    class HostTable
    extends Hashtable {
        HostTable() {
        }

        public void put(Long l) {
            super.put(l, "");
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (HostResolver.this.result.size() == 0) {
                stringBuffer.append("No results");
            } else {
                boolean bl = true;
                Enumeration enumeration = this.keys();
                while (enumeration.hasMoreElements()) {
                    if (bl) {
                        bl = false;
                        stringBuffer.append(enumeration.nextElement());
                        continue;
                    }
                    stringBuffer.append(",").append(enumeration.nextElement());
                }
            }
            return stringBuffer.toString();
        }
    }
}

