/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.graph;

import java.util.Observable;
import java.util.Vector;
import jclass.chart.ChartDataModel;
import jclass.chart.ChartDataModelUpdate;

public class CvGraphModel
extends ChartDataModel {
    private Vector rows = null;
    private String name = "";
    private String seriesLabel = "test";
    private Vector seriesLabels = new Vector();

    public CvGraphModel() {
        this.rows = new Vector();
    }

    public int addDataItem(int n, Object object) {
        if (n < 0 || object == null) {
            return 0;
        }
        this.addRows(n);
        Vector vector = (Vector)this.rows.elementAt(n);
        vector.addElement(object);
        if (vector.size() == 1) {
            vector.addElement(object);
        }
        this.updateObservers();
        return vector.size();
    }

    public int addDataPoint(int n, Object object, Object object2) {
        int n2 = -1;
        if (this.addDataItem(n, object) != -1) {
            n2 = this.addDataItem(n + 1, object2);
        }
        return n2;
    }

    private void addRows(int n) {
        while (n >= this.rows.size()) {
            this.rows.addElement(new Vector());
        }
    }

    public void addSeriesLabel(String string) {
        this.seriesLabels.addElement(string);
        this.updateObservers();
    }

    public void dumpValues() {
        int n = 0;
        while (n < this.rows.size()) {
            System.out.println("Row " + n);
            Vector vector = (Vector)this.rows.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                System.out.println("    " + vector.elementAt(n2));
                ++n2;
            }
            ++n;
        }
    }

    public int getDataInterpretation() {
        return 1;
    }

    public Object getDataItem(int n, int n2) {
        if (n < 0 || n >= this.rows.size() || n2 < 0) {
            return null;
        }
        Vector vector = (Vector)this.rows.elementAt(n);
        return n2 < vector.size() ? vector.elementAt(n2) : null;
    }

    public String getName() {
        return this.name;
    }

    public int getNumRows() {
        return this.rows.size();
    }

    public String[] getPointLabels() {
        return null;
    }

    public Vector getRow(int n) {
        return n < 0 || n > this.rows.size() ? null : (Vector)this.rows.elementAt(n);
    }

    public String getSeriesLabel(int n) {
        if (this.seriesLabels != null && this.seriesLabels.size() > n) {
            return (String)this.seriesLabels.elementAt(n);
        }
        return "";
    }

    public String getSeriesName(int n) {
        return null;
    }

    public void printLabels() {
        int n = 0;
        while (n < this.seriesLabels.size()) {
            System.out.println("label " + n + " is " + this.seriesLabels.elementAt(n));
            ++n;
        }
    }

    public void removeAllData() {
        this.rows = new Vector();
        this.updateObservers();
    }

    public void removeSeriesLabels() {
        this.seriesLabels.removeAllElements();
        this.updateObservers();
    }

    public boolean setDataItem(int n, int n2, Object object) {
        if (n < 0 || n2 < 0 || object == null) {
            return false;
        }
        this.addRows(n);
        Vector vector = (Vector)this.rows.elementAt(n);
        while (n2 > vector.size()) {
            vector.addElement(new Double(-123456.789));
        }
        vector.addElement(object);
        this.updateObservers();
        return true;
    }

    public void setName(String string) {
        this.name = string != null ? string : "";
        this.updateObservers();
    }

    public void setSeriesLabel(int n, String string) {
        this.seriesLabels.setElementAt(string, n);
        this.updateObservers();
    }

    private void updateObservers() {
        ((Observable)((Object)this)).setChanged();
        ((Observable)((Object)this)).notifyObservers(new ChartDataModelUpdate(14, 0, 0));
    }
}

