/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.services.logger;

import com.sun.symon.base.console.services.logger.CsDDLBuffer;
import com.sun.symon.base.console.services.logger.CsDDLBufferListener;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.FileWriter;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class CsDDLBufferViewer
extends JScrollPane
implements CsDDLBufferListener {
    private String LineSeparator = System.getProperty("line.separator");
    private JTextArea MyText = new JTextArea();
    private CsDDLBuffer MyBuffer;
    private static String BaseDir = "/tmp";

    public CsDDLBufferViewer() {
        this.getViewport().add(this.MyText);
        this.MyText.setEditable(false);
        this.MyText.setColumns(80);
    }

    public void clearBuffer() {
        if (this.MyBuffer != null) {
            this.MyBuffer.LogInfoLength = 0;
        }
        if (this.MyText != null) {
            this.MyText.setText("");
        }
    }

    public void disconnect() {
        if (this.MyBuffer != null) {
            this.MyBuffer.removeCsDDLBufferListener(this);
        }
    }

    public void saveBuffer() {
        if (this.MyText == null) {
            return;
        }
        Window window = SwingUtilities.windowForComponent(this.MyText);
        if (!(window instanceof Frame)) {
            return;
        }
        String string = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:diag.save.title");
        FileDialog fileDialog = new FileDialog((Frame)window, string, 1);
        fileDialog.setDirectory(BaseDir);
        fileDialog.pack();
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() == null || fileDialog.getFile().trim().length() == 0) {
            return;
        }
        BaseDir = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (fileDialog.getDirectory().trim().length() != 0) {
            string2 = String.valueOf(fileDialog.getDirectory().trim()) + string2;
        }
        try {
            FileWriter fileWriter = new FileWriter(string2);
            String string3 = this.MyText.getText();
            fileWriter.write(string3, 0, string3.length());
            fileWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Object[] objectArray = new String[]{UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.ok")};
            JOptionPane.showOptionDialog(window, UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:diag.saverr.text"), UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:diag.saverr.title"), -1, 0, null, objectArray, objectArray[0]);
        }
    }

    public void sendLine(String string, int n) {
        if (this.MyText != null) {
            this.MyText.append(String.valueOf(string) + this.LineSeparator);
        }
    }

    public void setDDLBuffer(Object object) {
        this.MyBuffer = (CsDDLBuffer)object;
        this.MyBuffer.addCsDDLBufferListener(this);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.MyBuffer.LogInfoLength) {
            stringBuffer.append(this.MyBuffer.LogInfo[n]);
            stringBuffer.append(this.LineSeparator);
            ++n;
        }
        if (this.MyText != null) {
            this.MyText.setText(stringBuffer.toString());
        }
    }
}

