/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.mcp;

import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.console.mcp.CpMCPManager;
import com.sun.symon.base.server.types.StObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CpEditParcelDialog
extends JDialog
implements ListSelectionListener,
Runnable {
    private TreeSet excludedData_ = new TreeSet();
    private TreeSet includedData_ = new TreeSet();
    private Hashtable oI18NtoKey_ = new Hashtable();
    private boolean ok_ = false;
    private String name_;
    private String title_;
    private String host_;
    private int port_;
    JPanel bodyPanel_ = new JPanel();
    JPanel bottomPanel_ = new JPanel();
    JButton okButton_ = new JButton();
    JButton cancelButton_ = new JButton();
    JButton helpButton_ = new JButton();
    GridLayout bodyGridLayout_ = new GridLayout();
    JPanel addRemovePanel_ = new JPanel();
    JButton addButton_ = new JButton();
    JList excludedList_ = new JList();
    JList includedList_ = new JList();
    JButton removeButton_ = new JButton();
    JScrollPane excludedPane_ = new JScrollPane();
    JScrollPane includedPane_ = new JScrollPane();
    GridBagLayout addRemoveGridBagLayout_ = new GridBagLayout();
    JPanel buttonPanel_ = new JPanel();
    FlowLayout buttonFlowLayout_ = new FlowLayout();
    JLabel statusLabel_ = new JLabel();
    GridBagLayout bottomGridBagLayout_ = new GridBagLayout();
    JSeparator separator_ = new JSeparator();
    JPanel contentPanel_ = new JPanel();
    BorderLayout contentBorderLayout_ = new BorderLayout();
    JPanel excludedPanel_ = new JPanel();
    JPanel includedPanel_ = new JPanel();
    JLabel excludedLabel_ = new JLabel();
    BorderLayout excludedBorderLayout_ = new BorderLayout();
    JLabel includedLabel_ = new JLabel();
    BorderLayout includedBorderLayout_ = new BorderLayout();
    private Hashtable localizedModule_ = null;

    public CpEditParcelDialog(String string, int n, Hashtable hashtable) {
        super((Frame)null, "", true);
        this.host_ = string;
        this.port_ = n;
        this.localizedModule_ = hashtable;
        this.setTitle(this.localize("editParcelTitle"));
        try {
            this.jbInit();
        }
        catch (Exception exception) {}
        this.statusLabel_.setForeground(Color.black);
        this.localize();
        this.excludedPane_.setViewportView(this.excludedList_);
        this.includedPane_.setViewportView(this.includedList_);
        this.excludedList_.addListSelectionListener(this);
        this.includedList_.addListSelectionListener(this);
        this.includedList_.setBackground(this.contentPanel_.getBackground());
        this.excludedList_.setBackground(this.contentPanel_.getBackground());
        this.pack();
        ((Component)this).setSize(520, 275);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((int)(dimension.getWidth() - (double)this.getWidth()) / 2, (int)(dimension.getHeight() - (double)this.getHeight()) / 2);
        new Thread(this).start();
        ((Component)this).setVisible(true);
    }

    void addButton__actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.excludedList_.getSelectedValues();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.includedData_.add(objectArray[n]);
                this.excludedData_.remove(objectArray[n]);
                ++n;
            }
            this.excludedList_.setListData(this.excludedData_.toArray());
            this.includedList_.setListData(this.includedData_.toArray());
            this.updateButtons();
        }
    }

    void cancelButton__actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void getAllModules() {
        Object var1_1 = null;
        this.setStatusMessage("retrieving");
        if (!CpMCPManager.isTesting()) {
            try {
                SMRawDataRequest sMRawDataRequest = SMConsoleContext.getInstance().getAPIHandle();
                SMModuleRequest sMModuleRequest = new SMModuleRequest(sMRawDataRequest);
                if (!sMModuleRequest.isModuleLoaded(this.host_, this.port_, "mcp")) {
                    this.showError("mcpModuleNotLoadedError");
                    this.dispose();
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("snmp://");
                stringBuffer.append(this.host_);
                stringBuffer.append(":");
                stringBuffer.append(this.port_);
                stringBuffer.append("/mod/mcp/");
                stringBuffer.append("moduleRegistryTable/moduleRegistryEntry/module");
                StObject[][] stObjectArray = sMRawDataRequest.getURLValue(new String[]{stringBuffer.toString()});
                StringTokenizer stringTokenizer = new StringTokenizer(stObjectArray[0][0].toString());
                while (stringTokenizer.hasMoreTokens()) {
                    this.excludedData_.add(this.localizeModule(stringTokenizer.nextToken()));
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
                this.showError("moduleRetrieveError");
                this.dispose();
                return;
            }
        } else {
            this.excludedData_.add(this.localizeModule("kernel-reader"));
            this.excludedData_.add(this.localizeModule("fscan+syslog"));
            this.excludedData_.add(this.localizeModule("health-monitor"));
        }
        this.excludedList_.setListData(this.excludedData_.toArray());
    }

    public String[] getModules() {
        if (!this.ok_) {
            return null;
        }
        String[] stringArray = new String[this.includedData_.size()];
        Iterator iterator = this.includedData_.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n++] = (String)this.oI18NtoKey_.get((String)iterator.next());
        }
        return stringArray;
    }

    void helpButton__actionPerformed(ActionEvent actionEvent) {
        CmConsoleSession.getInstance().launchHelp("mcp-new-help");
    }

    private void jbInit() throws Exception {
        this.okButton_.setEnabled(false);
        this.okButton_.setMaximumSize(new Dimension(71, 27));
        this.okButton_.setMinimumSize(new Dimension(71, 27));
        this.okButton_.setPreferredSize(new Dimension(71, 27));
        this.okButton_.setText("ok");
        this.okButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CpEditParcelDialog.this.okButton__actionPerformed(actionEvent);
            }
        });
        this.cancelButton_.setText("cancel");
        this.cancelButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CpEditParcelDialog.this.cancelButton__actionPerformed(actionEvent);
            }
        });
        this.helpButton_.setMaximumSize(new Dimension(71, 27));
        this.helpButton_.setMinimumSize(new Dimension(71, 27));
        this.helpButton_.setNextFocusableComponent(this.excludedList_);
        this.helpButton_.setPreferredSize(new Dimension(71, 27));
        this.helpButton_.setText("help");
        this.helpButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CpEditParcelDialog.this.helpButton__actionPerformed(actionEvent);
            }
        });
        this.setDefaultCloseOperation(2);
        this.bottomPanel_.setLayout(this.bottomGridBagLayout_);
        this.bodyPanel_.setLayout(this.bodyGridLayout_);
        this.addButton_.setEnabled(false);
        this.addButton_.setMaximumSize(new Dimension(85, 27));
        this.addButton_.setMinimumSize(new Dimension(85, 27));
        this.addButton_.setPreferredSize(new Dimension(85, 27));
        this.addButton_.setText("add >");
        this.addButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CpEditParcelDialog.this.addButton__actionPerformed(actionEvent);
            }
        });
        this.removeButton_.setEnabled(false);
        this.removeButton_.setText("< remove");
        this.removeButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CpEditParcelDialog.this.removeButton__actionPerformed(actionEvent);
            }
        });
        this.addRemovePanel_.setLayout(this.addRemoveGridBagLayout_);
        this.excludedList_.setBackground(Color.white);
        this.includedList_.setBackground(Color.white);
        this.includedPane_.setBorder(BorderFactory.createLoweredBevelBorder());
        this.bodyGridLayout_.setColumns(3);
        this.bodyGridLayout_.setHgap(5);
        this.bodyGridLayout_.setVgap(5);
        this.bottomPanel_.setMinimumSize(new Dimension(0, 0));
        this.bottomPanel_.setPreferredSize(new Dimension(200, 85));
        this.excludedPane_.setBorder(BorderFactory.createLoweredBevelBorder());
        this.buttonPanel_.setLayout(this.buttonFlowLayout_);
        this.buttonFlowLayout_.setAlignment(2);
        this.buttonFlowLayout_.setHgap(10);
        this.buttonFlowLayout_.setVgap(0);
        this.statusLabel_.setMaximumSize(new Dimension(200, 30));
        this.statusLabel_.setMinimumSize(new Dimension(200, 30));
        this.statusLabel_.setPreferredSize(new Dimension(200, 30));
        this.statusLabel_.setHorizontalTextPosition(0);
        this.buttonPanel_.setMinimumSize(new Dimension(0, 0));
        this.buttonPanel_.setPreferredSize(new Dimension(0, 0));
        this.bodyPanel_.setBorder(BorderFactory.createEmptyBorder(15, 15, 10, 15));
        this.contentPanel_.setLayout(this.contentBorderLayout_);
        this.excludedPanel_.setLayout(this.excludedBorderLayout_);
        this.includedPanel_.setLayout(this.includedBorderLayout_);
        this.excludedLabel_.setText("exclude");
        this.includedLabel_.setText("include");
        this.contentPanel_.add((Component)this.bottomPanel_, "South");
        this.bottomPanel_.add((Component)this.buttonPanel_, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.buttonPanel_.add((Component)this.okButton_, null);
        this.buttonPanel_.add((Component)this.cancelButton_, null);
        this.buttonPanel_.add((Component)this.helpButton_, null);
        this.bottomPanel_.add((Component)this.statusLabel_, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 206, 0));
        this.bottomPanel_.add((Component)this.separator_, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 15, 0), 0, 0));
        this.contentPanel_.add((Component)this.bodyPanel_, "Center");
        this.bodyPanel_.add((Component)this.excludedPanel_, null);
        this.excludedPanel_.add((Component)this.excludedPane_, "Center");
        this.excludedPanel_.add((Component)this.excludedLabel_, "North");
        this.bodyPanel_.add((Component)this.addRemovePanel_, null);
        this.addRemovePanel_.add((Component)this.addButton_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.addRemovePanel_.add((Component)this.removeButton_, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.bodyPanel_.add((Component)this.includedPanel_, null);
        this.includedPanel_.add((Component)this.includedPane_, "Center");
        this.includedPanel_.add((Component)this.includedLabel_, "North");
        this.getContentPane().add(this.contentPanel_);
    }

    private void localize() {
        this.addButton_.setText(String.valueOf(this.localize("add")) + " >>");
        this.removeButton_.setText("<< " + this.localize("delete"));
        this.okButton_.setText(this.localize("standard.ok"));
        this.cancelButton_.setText(this.localize("standard.cancel"));
        this.helpButton_.setText(this.localize("standard.help"));
        this.excludedLabel_.setText(String.valueOf(this.localize("availableModules")) + ":");
        this.includedLabel_.setText(String.valueOf(this.localize("modulesInParcel")) + ":");
    }

    private String localize(String string) {
        return CpMCPManager.localize(string);
    }

    private String localizeModule(String string) {
        int n = string.indexOf("+");
        String string2 = n == -1 ? string : string.substring(0, n);
        String string3 = (String)this.localizedModule_.get(string2);
        if (string3 == null) {
            string3 = string;
        }
        String string4 = n == -1 ? string3 : String.valueOf(string3) + " [" + string.substring(n + 1) + "]";
        this.oI18NtoKey_.put(string4, string);
        return string4;
    }

    void okButton__actionPerformed(ActionEvent actionEvent) {
        this.ok_ = true;
        this.dispose();
    }

    void removeButton__actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.includedList_.getSelectedValues();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.includedData_.remove(objectArray[n]);
                this.excludedData_.add(objectArray[n]);
                ++n;
            }
            this.excludedList_.setListData(this.excludedData_.toArray());
            this.includedList_.setListData(this.includedData_.toArray());
            this.updateButtons();
        }
    }

    public void run() {
        try {
            this.getAllModules();
            this.updateButtons();
        }
        finally {
            Object var2_1 = null;
            this.setStatusMessage("");
        }
    }

    private void setStatusMessage(String string) {
        this.statusLabel_.setText(this.localize(string));
    }

    private void showError(String string) {
        CpMCPManager.showError(string);
    }

    private void updateButtons() {
        if (this.excludedList_.isSelectionEmpty()) {
            this.addButton_.setEnabled(false);
        } else {
            this.addButton_.setEnabled(true);
        }
        if (this.includedList_.isSelectionEmpty()) {
            this.removeButton_.setEnabled(false);
        } else {
            this.removeButton_.setEnabled(true);
        }
        if (this.includedData_.size() == 0) {
            this.okButton_.setEnabled(false);
        } else {
            this.okButton_.setEnabled(true);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionEvent.getSource() == this.excludedList_ && !this.includedList_.isSelectionEmpty()) {
            this.includedList_.clearSelection();
        } else if (listSelectionEvent.getSource() == this.includedList_ && !this.excludedList_.isSelectionEmpty()) {
            this.excludedList_.clearSelection();
        }
        this.updateButtons();
    }
}

