/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.search;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.group.SMFilter;
import com.sun.symon.base.client.group.SMFilterInfo;
import com.sun.symon.base.client.group.SMObjectGroup;
import com.sun.symon.base.client.group.SMObjectGroupData;
import com.sun.symon.base.client.topology.SMHierarchyViewData;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.console.grouping.CgUtil;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.console.manager.CmTopologyPath;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcThreadWorker;
import com.sun.symon.base.utility.UcURL;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CgSearchDialog
extends JDialog
implements ActionListener,
Runnable {
    private JButton helpBtn;
    private JButton searchBtn;
    private JButton closeBtn;
    private JButton stopBtn;
    private JButton gotoBtn;
    private JRadioButton olRBtn;
    private JRadioButton fnRBtn;
    private Thread searchThread = null;
    private JTextField objLabelFld;
    private JLabel domainNameLbl;
    private JLabel statusLbl;
    private JList resultLst;
    private JComboBox filterBox;
    private SMFilter filterHandle;
    private SMObjectGroup ogHandle;
    private SMFilterInfo[] filters;
    boolean bSearchFilter;
    private CmTopologyPath DomainRootPath;
    private Vector TargetMatches = new Vector();
    private SMRawDataRequest request = null;
    private SMTopologyRequest RequestHandle = null;
    private String domain = SMConsoleContext.getInstance().getCurrentDomain();

    public CgSearchDialog(Frame frame) {
        super(frame);
        this.createGUI();
        this.installListeners();
        CmConsoleSession cmConsoleSession = CmConsoleSession.getInstance();
        this.setStartPath(cmConsoleSession.getConsoleParameter("mainNavPath"));
        this.request = SMConsoleContext.getInstance().getAPIHandle();
        this.setRequestHandle(this.request);
        this.domainNameLbl.setText(" " + this.DomainRootPath.toString());
        this.setTitle(CgUtil.getI18nMsg("searchDlg.title"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CgSearchDialog.this.close();
            }
        });
        UcThreadWorker ucThreadWorker = new UcThreadWorker(){

            public void doWork() {
                CgSearchDialog.this.initData();
            }
        };
        ucThreadWorker.start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeBtn) {
            this.close();
        } else if (object == this.helpBtn) {
            CmConsoleSession.getInstance().launchHelp("topology-search-help");
        } else if (object == this.searchBtn) {
            this.beginSearch();
        } else if (object == this.gotoBtn) {
            this.gotoSelection();
        } else if (object == this.stopBtn) {
            this.stopSearch();
        }
    }

    public void beginSearch() {
        this.bSearchFilter = false;
        if (this.fnRBtn.isSelected()) {
            this.bSearchFilter = true;
        }
        CgSearchDialog cgSearchDialog = this;
        synchronized (cgSearchDialog) {
            if (this.searchThread != null) {
                Object var2_2 = null;
                return;
            }
            this.searchThread = new Thread((Runnable)this, "search");
        }
        this.searchBtn.setEnabled(false);
        this.stopBtn.setEnabled(true);
        this.objLabelFld.setEnabled(false);
        this.olRBtn.setEnabled(false);
        this.fnRBtn.setEnabled(false);
        this.filterBox.setEnabled(false);
        this.searchThread.start();
    }

    void close() {
        ((Component)this).setVisible(false);
        try {
            if (this.ogHandle != null) {
                this.ogHandle.close();
            }
            if (this.filterHandle != null) {
                this.filterHandle.close();
            }
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
        }
        CgUtil.removeDialogFromPool("search");
        this.dispose();
    }

    private void createGUI() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 0, 10));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(0, 0, 10, 3);
        JLabel jLabel = new JLabel(CgUtil.getI18nMsg("searchDlg.domain"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.domainNameLbl = new JLabel();
        gridBagLayout.setConstraints(this.domainNameLbl, gridBagConstraints);
        jPanel.add(this.domainNameLbl);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1, 0, 10));
        this.olRBtn = new JRadioButton(CgUtil.getI18nMsg("searchDlg.objLbl"));
        this.olRBtn.setSelected(true);
        jPanel3.add(this.olRBtn);
        this.fnRBtn = new JRadioButton(CgUtil.getI18nMsg("searchDlg.fltName"));
        jPanel3.add(this.fnRBtn);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.olRBtn);
        buttonGroup.add(this.fnRBtn);
        jPanel2.add((Component)jPanel3, "West");
        jPanel3 = new JPanel(new GridLayout(2, 1, 0, 10));
        jPanel3.setBorder(new EmptyBorder(0, 2, 0, 0));
        this.objLabelFld = new JTextField(30);
        jPanel3.add(this.objLabelFld);
        this.filterBox = new JComboBox();
        this.filterBox.setEnabled(false);
        jPanel3.add(this.filterBox);
        jPanel2.add(jPanel3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add(jPanel2);
        jPanel3.setBorder(new TitledBorder(LineBorder.createGrayLineBorder(), CgUtil.getI18nMsg("searchDlg.searchUsing")));
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.searchBtn = new JButton(CgUtil.getI18nMsg("searchDlg.search"));
        this.searchBtn.setEnabled(false);
        this.searchBtn.addActionListener(this);
        gridBagLayout.setConstraints(this.searchBtn, gridBagConstraints);
        jPanel.add(this.searchBtn);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jLabel = new JLabel(CgUtil.getI18nMsg("searchDlg.result"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.resultLst = new JList();
        this.resultLst.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.resultLst);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        JPanel jPanel4 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel4, 0);
        jPanel4.setLayout(boxLayout);
        jPanel4.add(Box.createHorizontalGlue());
        this.gotoBtn = new JButton(CgUtil.getI18nMsg("searchDlg.goto"));
        this.gotoBtn.setEnabled(false);
        this.gotoBtn.addActionListener(this);
        jPanel4.add(this.gotoBtn);
        jPanel4.add(Box.createHorizontalStrut(3));
        this.stopBtn = new JButton(CgUtil.getI18nMsg("searchDlg.stop"));
        this.stopBtn.setEnabled(false);
        this.stopBtn.addActionListener(this);
        jPanel4.add(this.stopBtn);
        jPanel4.add(Box.createHorizontalStrut(3));
        this.closeBtn = new JButton(CgUtil.getI18nMsg("searchDlg.close"));
        this.closeBtn.addActionListener(this);
        jPanel4.add(this.closeBtn);
        jPanel4.add(Box.createHorizontalStrut(3));
        this.helpBtn = new JButton(CgUtil.getI18nMsg("help"));
        this.helpBtn.addActionListener(this);
        jPanel4.add(this.helpBtn);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel.add(jPanel4);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.statusLbl = new JLabel(" ");
        this.statusLbl.setForeground(Color.black);
        gridBagLayout.setConstraints(this.statusLbl, gridBagConstraints);
        jPanel.add(this.statusLbl);
        this.setContentPane(jPanel);
    }

    void gotoSelection() {
        int n = this.resultLst.getSelectedIndex();
        if (n < 0) {
            return;
        }
        Object var2_2 = null;
        CmTopologyPath cmTopologyPath = (CmTopologyPath)this.TargetMatches.elementAt(n);
        if (cmTopologyPath == null) {
            return;
        }
        String string = CmConsoleSession.pathRegister(null, cmTopologyPath);
        CmConsoleSession cmConsoleSession = CmConsoleSession.getInstance();
        cmConsoleSession.navigateToPathByName("true", string);
        this.close();
    }

    void initData() {
        try {
            this.filterHandle = new SMFilter(this.request);
            this.ogHandle = new SMObjectGroup(this.request);
            UcCommon.isServiceLicenseAvailable((String)"Group_ObjectGroup", (Component)this);
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)CgUtil.getI18nMsg("searchDlg.serviceErr"));
            return;
        }
        try {
            this.filters = this.filterHandle.getAll();
            if (this.filters != null) {
                int n = 0;
                while (n < this.filters.length) {
                    this.filterBox.addItem(this.filters[n].getName());
                    ++n;
                }
            }
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
        }
    }

    void installListeners() {
        this.objLabelFld.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            void handleStartButton() {
                if (CgSearchDialog.this.objLabelFld.getText().length() == 0) {
                    CgSearchDialog.this.searchBtn.setEnabled(false);
                } else {
                    CgSearchDialog.this.searchBtn.setEnabled(true);
                }
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.handleStartButton();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.handleStartButton();
            }
        });
        this.resultLst.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (CgSearchDialog.this.resultLst.getSelectedIndex() < 0) {
                    CgSearchDialog.this.gotoBtn.setEnabled(false);
                } else {
                    CgSearchDialog.this.gotoBtn.setEnabled(true);
                }
            }
        });
        this.resultLst.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    CgSearchDialog.this.gotoSelection();
                }
            }
        });
        this.olRBtn.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (CgSearchDialog.this.olRBtn.isSelected()) {
                    CgSearchDialog.this.objLabelFld.setEnabled(true);
                    CgSearchDialog.this.filterBox.setEnabled(false);
                    if (CgSearchDialog.this.objLabelFld.getText().length() == 0) {
                        CgSearchDialog.this.searchBtn.setEnabled(false);
                    } else {
                        CgSearchDialog.this.searchBtn.setEnabled(true);
                    }
                } else {
                    CgSearchDialog.this.objLabelFld.setEnabled(false);
                    CgSearchDialog.this.filterBox.setEnabled(true);
                    if (CgSearchDialog.this.filterBox.getSelectedIndex() == -1) {
                        CgSearchDialog.this.searchBtn.setEnabled(false);
                    } else {
                        CgSearchDialog.this.searchBtn.setEnabled(true);
                    }
                }
            }
        });
    }

    public static void main(String[] stringArray) {
        UcThreadWorker ucThreadWorker = new UcThreadWorker(){

            public void doWork() {
                CgSearchDialog.showUniqueInstance();
            }
        };
        ucThreadWorker.start();
    }

    public void run() {
        boolean bl = false;
        this.resultLst.setListData(new Object[0]);
        this.TargetMatches.removeAllElements();
        String string = UcInternationalizer.translateKey((String)"base.console.ConsoleTopology:search.working");
        String[] stringArray = new String[]{string};
        this.statusLbl.setText(UcInternationalizer.translateKey((String)stringArray[0]));
        bl = this.bSearchFilter ? this.searchByFilter() : this.searchByLblOrHost(this.objLabelFld.getText().trim(), true);
        if (this.searchThread == null) {
            stringArray[0] = UcInternationalizer.translateKey((String)"base.console.ConsoleTopology:search.interrupt");
            this.statusLbl.setText(stringArray[0]);
        } else if (bl) {
            stringArray[0] = UcInternationalizer.translateKey((String)"base.console.ConsoleTopology:search.completeerr");
            this.statusLbl.setText(stringArray[0]);
        } else {
            stringArray[0] = UcInternationalizer.translateKey((String)"base.console.ConsoleTopology:search.complete");
            this.statusLbl.setText(MessageFormat.format(stringArray[0], new Integer(this.TargetMatches.size())));
        }
        this.searchBtn.setEnabled(true);
        this.stopBtn.setEnabled(false);
        this.objLabelFld.setEnabled(true);
        this.olRBtn.setEnabled(true);
        this.fnRBtn.setEnabled(true);
        this.filterBox.setEnabled(true);
        this.searchThread = null;
    }

    boolean searchByFilter() {
        boolean bl = false;
        int n = this.filterBox.getSelectedIndex();
        SMObjectGroupData sMObjectGroupData = new SMObjectGroupData();
        try {
            sMObjectGroupData.setName("temp");
            sMObjectGroupData.setDomain(this.domain);
        }
        catch (Exception exception) {}
        sMObjectGroupData.setAllObjectsInDomain(true);
        sMObjectGroupData.setFilter(this.filters[n].getObjectID());
        String[] stringArray = null;
        try {
            stringArray = this.ogHandle.resolve(sMObjectGroupData);
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
            bl = true;
            return bl;
        }
        if (stringArray != null) {
            Vector<String> vector = new Vector<String>();
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string = stringArray[n2];
                n = string.lastIndexOf(58);
                if (n != -1) {
                    string = string.substring(0, n);
                }
                if (!vector.contains(string)) {
                    vector.addElement(string);
                }
                ++n2;
            }
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                bl = this.searchByLblOrHost((String)vector.elementAt(n4), false);
                if (bl) {
                    return bl;
                }
                ++n4;
            }
        }
        return bl;
    }

    boolean searchByLblOrHost(String string, boolean bl) {
        Object[] objectArray;
        boolean bl2 = false;
        boolean bl3 = false;
        Vector<CmTopologyPath> vector = new Vector<CmTopologyPath>();
        Vector<Object> vector2 = new Vector<Object>();
        vector.addElement(this.DomainRootPath);
        vector2.addElement(new Hashtable());
        String string2 = UcInternationalizer.translateKey((String)"base.console.ConsoleTopology:search.count");
        String string3 = UcInternationalizer.translateKey((String)"base.console.ConsoleTopology:search.noaccess");
        String string4 = UcInternationalizer.translateKey((String)"base.console.ConsoleTopology:search.noaccess.title");
        String string5 = string;
        String string6 = " ";
        while (vector.size() != 0) {
            objectArray = new Vector();
            Vector vector3 = new Vector();
            try {
                Object object;
                CmTopologyPath cmTopologyPath = (CmTopologyPath)vector.elementAt(0);
                String string7 = cmTopologyPath.getEnd().getNodeUrl();
                string7 = UcURL.standardizeURL((String)string7);
                Hashtable hashtable = (Hashtable)vector2.elementAt(0);
                if (hashtable.containsKey(string7)) {
                    vector.removeElementAt(0);
                    vector2.removeElementAt(0);
                    continue;
                }
                hashtable.put(string7, string7);
                if (bl) {
                    this.RequestHandle.topologySearch(string7, string5, (Vector)objectArray, vector3);
                } else {
                    this.RequestHandle.topologySearchByHost(string7, string5, (Vector)objectArray, vector3);
                }
                string6 = String.valueOf(string6) + ".";
                int n = 0;
                while (n < objectArray.size()) {
                    object = (SMHierarchyViewData)objectArray.elementAt(n);
                    CmTopologyPath cmTopologyPath2 = new CmTopologyPath(cmTopologyPath);
                    cmTopologyPath2.push(object.getObjectId(), object.getName(), object.getTargetUrl());
                    this.TargetMatches.addElement(cmTopologyPath2);
                    ++n;
                }
                if (this.TargetMatches.size() == 1) {
                    this.statusLbl.setText(UcInternationalizer.translateKey((String)"base.console.ConsoleTopology:search.countone"));
                } else if (this.TargetMatches.size() > 1) {
                    this.statusLbl.setText(MessageFormat.format(string2, new Integer(this.TargetMatches.size())));
                }
                object = new Vector();
                int n2 = 0;
                while (n2 < this.TargetMatches.size()) {
                    ((Vector)object).addElement(((CmTopologyPath)this.TargetMatches.elementAt(n2)).getNextStep().toString());
                    ++n2;
                }
                this.resultLst.setListData(object);
                this.resultLst.revalidate();
                this.resultLst.repaint();
                int n3 = 0;
                while (n3 < vector3.size()) {
                    SMHierarchyViewData sMHierarchyViewData = (SMHierarchyViewData)vector3.elementAt(n3);
                    CmTopologyPath cmTopologyPath3 = new CmTopologyPath(cmTopologyPath);
                    cmTopologyPath3.push(sMHierarchyViewData.getObjectId(), sMHierarchyViewData.getName(), sMHierarchyViewData.getTargetUrl());
                    vector.addElement(cmTopologyPath3);
                    vector2.addElement(hashtable.clone());
                    ++n3;
                }
            }
            catch (SMAPIException sMAPIException) {
                if (sMAPIException.getReasonCode() == 1) {
                    string3 = String.valueOf(string3) + "\n" + ((CmTopologyPath)vector.elementAt(0)).toString();
                    bl3 = true;
                }
                string6 = String.valueOf(string6) + ".";
                bl2 = true;
            }
            if (string6.length() > 10) {
                string6 = " ";
            }
            if (this.searchThread == null) break;
            vector.removeElementAt(0);
            vector2.removeElementAt(0);
        }
        if (bl3) {
            objectArray = new String[]{UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.ok")};
            JOptionPane.showOptionDialog(null, string3, string4, -1, 2, null, objectArray, objectArray[0]);
        }
        return bl2;
    }

    public void setRequestHandle(SMRawDataRequest sMRawDataRequest) {
        this.RequestHandle = new SMTopologyRequest(sMRawDataRequest);
    }

    public void setStartPath(String string) {
        CmTopologyPath cmTopologyPath = CmTopologyPath.decode(string);
        if (cmTopologyPath != null) {
            this.DomainRootPath = new CmTopologyPath("root", cmTopologyPath.getNodeName(), cmTopologyPath.getNodeUrl());
        }
    }

    public static void showUniqueInstance() {
        JDialog jDialog = CgUtil.getDialogFromPool("search");
        if (jDialog == null) {
            CmConsoleSession cmConsoleSession = CmConsoleSession.getInstance();
            Frame frame = cmConsoleSession.getMainWindowFrame();
            if (frame == null) {
                frame = JOptionPane.getRootFrame();
            }
            jDialog = new CgSearchDialog(frame);
            CgUtil.addDialogToPool("search", jDialog);
            jDialog.pack();
            jDialog.setLocationRelativeTo(frame);
        }
        ((Component)jDialog).setVisible(true);
    }

    void stopSearch() {
        this.searchThread = null;
    }
}

