/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors;

import com.sun.symon.base.beans.BcTreeNode;
import com.sun.symon.base.security.SySecurity;
import com.sun.symon.base.server.emitters.cfile.SeCFileEmitter;
import com.sun.symon.base.server.emitters.control.SeControlEmitter;
import com.sun.symon.base.server.emitters.file.SeFileFileEmitter;
import com.sun.symon.base.server.emitters.snmp.SeSnmpEmitter;
import com.sun.symon.base.server.emitters.xfile.SeXFileEmitter;
import com.sun.symon.base.server.events.SvRequestListener;
import com.sun.symon.base.server.receptors.SrReceptor;
import com.sun.symon.base.server.remitters.crosscontext.SmCrossContextRemitter;
import com.sun.symon.base.server.remitters.snmpjob.SmSnmpJobRemitter;
import com.sun.symon.base.utility.UcBeanIntrospector;
import com.sun.symon.base.utility.UcDDL;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.tree.MutableTreeNode;

public class SrBaseReceptor
extends SrReceptor {
    protected SySecurity sySecurity = new SySecurity();
    protected String securityURL = null;
    protected int securityFlag = 1;
    protected String privateKey = null;
    protected String publicId = "public";
    protected String publicPassword = "public";
    protected String privateId = "private";
    protected String privatePassword = "maplesyrup";
    protected String topologyHost = null;
    protected int topologyPort = -1;
    protected String mdrHost = null;
    protected int mdrPort = -1;
    protected String configurationHost = null;
    protected int configurationPort = -1;
    protected String eventHost = null;
    protected int eventPort = -1;
    protected String cstHost = null;
    protected int cstPort = -1;
    protected int sessionLimit = 0;
    protected int numSessions = 0;
    protected boolean sunHostOnly = true;
    private String imageSubpath = null;

    public boolean addNewSession() {
        SrBaseReceptor srBaseReceptor = this;
        synchronized (srBaseReceptor) {
            UcDDL.logDebugMessage((String)("sessionLimit=" + this.sessionLimit));
            UcDDL.logDebugMessage((String)("numSessions=" + this.numSessions));
        }
        if (this.sessionLimit == -1 || this.numSessions < this.sessionLimit) {
            ++this.numSessions;
            return true;
        }
        return false;
    }

    public void addSvRequestListener(SvRequestListener svRequestListener) {
        super.addSvRequestListener(svRequestListener);
    }

    void calculateSessionLimit() {
        block3: {
            if (this.sessionLimit != 0) break block3;
            String string = null;
            try {
                string = System.getProperty("NUM_FDS");
                int n = Integer.parseInt(string);
                this.sessionLimit = (n - 30) / 4;
                if (this.sessionLimit < 1) {
                    this.sessionLimit = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                UcDDL.logErrorMessage((String)("can't parse NUM_FDS: '" + string + "'"), (Throwable)numberFormatException);
                this.sessionLimit = -1;
            }
        }
    }

    public synchronized void clientDied() {
        --this.numSessions;
        UcDDL.logDebugMessage((String)("client died ... numSessions=" + this.numSessions));
    }

    public String getCSTBaseURL() {
        String string = "";
        if (this.cstHost != null && this.cstPort != -1) {
            string = "snmp://" + this.cstHost + ":" + this.cstPort + "/";
        }
        return string;
    }

    public String getConfigurationBaseURL() {
        String string = "";
        if (this.configurationHost != null && this.configurationPort != -1) {
            string = "snmp://" + this.configurationHost + ":" + this.configurationPort + "/";
        }
        return string;
    }

    public String getESDIR() {
        return System.getProperty("ESDIR");
    }

    public String getEventBaseURL() {
        String string = "";
        if (this.eventHost != null && this.eventPort != -1) {
            string = "snmp://" + this.eventHost + ":" + this.eventPort + "/";
        }
        return string;
    }

    public String getImageSubpath() {
        return this.imageSubpath;
    }

    public String getMDRBaseURL() {
        String string = "";
        if (this.mdrHost != null && this.mdrPort != -1) {
            string = "snmp://" + this.mdrHost + ":" + this.mdrPort + "/";
        }
        return string;
    }

    public String getPrivateId() {
        return this.privateId;
    }

    public String getPrivatePassword() {
        return this.privatePassword;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getPublicPassword() {
        return this.publicPassword;
    }

    public String getTopologyBaseURL() {
        String string = "";
        if (this.topologyHost != null && this.topologyPort != -1) {
            string = "snmp://" + this.topologyHost + ":" + this.topologyPort + "/";
        }
        return string;
    }

    protected void initialize() throws Exception {
        SeSnmpEmitter seSnmpEmitter;
        SeSnmpEmitter seSnmpEmitter2;
        SeControlEmitter seControlEmitter;
        SeSnmpEmitter seSnmpEmitter3;
        SeFileFileEmitter seFileFileEmitter;
        SeCFileEmitter seCFileEmitter;
        BcTreeNode bcTreeNode;
        UcBeanIntrospector ucBeanIntrospector = new UcBeanIntrospector();
        ucBeanIntrospector.readProperties("domain-config.x", 0);
        ucBeanIntrospector.readProperties("server-config.x", 0);
        ucBeanIntrospector.readProperties("javaserver.properties");
        ucBeanIntrospector.readProperties("server-global-keys.x", 2);
        ucBeanIntrospector.apply((Object)this);
        boolean bl = BcTreeNode.isDebugOn();
        BcTreeNode bcTreeNode2 = null;
        if (bl) {
            bcTreeNode = BcTreeNode.getRootNode();
            bcTreeNode2 = new BcTreeNode("receptor", (Object)this);
            bcTreeNode.add((MutableTreeNode)bcTreeNode2);
        }
        bcTreeNode = new SmSnmpJobRemitter();
        ucBeanIntrospector.apply((Object)bcTreeNode);
        this.addSvRequestListener((SvRequestListener)bcTreeNode);
        BcTreeNode bcTreeNode3 = null;
        if (bl) {
            bcTreeNode3 = new BcTreeNode("snmpjobremitter", (Object)bcTreeNode);
            bcTreeNode2.add((MutableTreeNode)bcTreeNode3);
        }
        SmCrossContextRemitter smCrossContextRemitter = new SmCrossContextRemitter();
        ucBeanIntrospector.apply((Object)smCrossContextRemitter);
        bcTreeNode.addSvRequestListener((SvRequestListener)smCrossContextRemitter);
        BcTreeNode bcTreeNode4 = null;
        if (bl) {
            bcTreeNode4 = new BcTreeNode("crossContext", (Object)smCrossContextRemitter);
            bcTreeNode3.add((MutableTreeNode)bcTreeNode4);
        }
        SeXFileEmitter seXFileEmitter = new SeXFileEmitter();
        bcTreeNode.addSvRequestListener((SvRequestListener)seXFileEmitter);
        if (bl) {
            seCFileEmitter = new BcTreeNode("xfile", (Object)seXFileEmitter);
            bcTreeNode3.add((MutableTreeNode)seCFileEmitter);
        }
        seCFileEmitter = new SeCFileEmitter();
        ucBeanIntrospector.apply((Object)seCFileEmitter);
        bcTreeNode.addSvRequestListener((SvRequestListener)seCFileEmitter);
        if (bl) {
            seFileFileEmitter = new BcTreeNode("cfile", (Object)seCFileEmitter);
            bcTreeNode3.add((MutableTreeNode)seFileFileEmitter);
        }
        seFileFileEmitter = new SeFileFileEmitter();
        ucBeanIntrospector.apply((Object)seFileFileEmitter);
        bcTreeNode.addSvRequestListener((SvRequestListener)seFileFileEmitter);
        if (bl) {
            seSnmpEmitter3 = new BcTreeNode("ffile", (Object)seFileFileEmitter);
            bcTreeNode3.add((MutableTreeNode)seSnmpEmitter3);
        }
        seSnmpEmitter3 = new SeSnmpEmitter();
        ucBeanIntrospector.apply((Object)seSnmpEmitter3, "snmpv1");
        bcTreeNode.addSvRequestListener((SvRequestListener)seSnmpEmitter3);
        if (bl) {
            seControlEmitter = new BcTreeNode("snmpv1", (Object)seSnmpEmitter3);
            bcTreeNode3.add((MutableTreeNode)seControlEmitter);
        }
        seControlEmitter = new SeControlEmitter();
        ucBeanIntrospector.apply((Object)seControlEmitter);
        bcTreeNode.addSvRequestListener((SvRequestListener)seControlEmitter);
        if (bl) {
            seSnmpEmitter2 = new BcTreeNode("controller", (Object)seControlEmitter);
            bcTreeNode3.add((MutableTreeNode)seSnmpEmitter2);
        }
        seSnmpEmitter2 = new SeSnmpEmitter();
        ucBeanIntrospector.apply((Object)seSnmpEmitter2, "snmp");
        smCrossContextRemitter.addSvRequestListener((SvRequestListener)seSnmpEmitter2);
        if (bl) {
            seSnmpEmitter = new BcTreeNode("snmp", (Object)seSnmpEmitter2);
            bcTreeNode4.add((MutableTreeNode)seSnmpEmitter);
        }
        seSnmpEmitter = new SeSnmpEmitter();
        ucBeanIntrospector.apply((Object)seSnmpEmitter, "snmppublic");
        smCrossContextRemitter.addSvRequestListener((SvRequestListener)seSnmpEmitter);
        if (bl) {
            BcTreeNode bcTreeNode5 = new BcTreeNode("snmppublic", (Object)seSnmpEmitter);
            bcTreeNode4.add((MutableTreeNode)bcTreeNode5);
        }
        seControlEmitter.setScheme("control");
        seControlEmitter.setSnmpEmitter((Object)seSnmpEmitter2);
        seControlEmitter.setSnmppublicEmitter((Object)seSnmpEmitter);
        seControlEmitter.setSnmpv1Emitter((Object)seSnmpEmitter3);
        seControlEmitter.setSnmpJobRemitter((Object)bcTreeNode);
        seControlEmitter.setCrossContextRemitter((Object)smCrossContextRemitter);
    }

    public boolean isSunHostOnly() {
        return this.sunHostOnly;
    }

    public void removeSvRequestListener(SvRequestListener svRequestListener) {
        super.removeSvRequestListener(svRequestListener);
    }

    protected void restart() {
        if (this.securityFlag != -1 && this.privateKey != null && this.privatePassword != null && this.configurationPort > 0 && this.configurationHost != null && !this.configurationHost.equals("")) {
            this.startServer();
        }
    }

    public void setCSTHost(String string) {
        block2: {
            this.cstHost = string;
            if (this.cstPort == -1) break block2;
            try {
                String string2 = InetAddress.getByName(this.cstHost).getHostAddress();
                UcDDL.logInfoMessage((String)("cstservice server host and port = " + this.cstHost + " (" + string2 + ") port " + this.cstPort));
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    public void setCSTPort(int n) {
        block2: {
            this.cstPort = n;
            if (this.cstHost == null) break block2;
            try {
                String string = InetAddress.getByName(this.cstHost).getHostAddress();
                UcDDL.logInfoMessage((String)("cstservice server host and port = " + this.cstHost + " (" + string + ") port " + this.cstPort));
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    public void setConfigurationHost(String string) {
        block2: {
            this.configurationHost = string;
            if (this.configurationPort == -1) break block2;
            try {
                String string2 = InetAddress.getByName(this.configurationHost).getHostAddress();
                UcDDL.logInfoMessage((String)("configuration server host and port = " + this.configurationHost + " (" + string2 + ") port " + this.configurationPort));
                this.restart();
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    public void setConfigurationPort(int n) {
        block2: {
            this.configurationPort = n;
            if (this.configurationHost == null) break block2;
            try {
                String string = InetAddress.getByName(this.configurationHost).getHostAddress();
                UcDDL.logInfoMessage((String)("configuration server host and port = " + this.configurationHost + " (" + string + ") port " + this.configurationPort));
                this.restart();
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    public void setEnabledSecuritySchemes(String string) {
        this.sySecurity.keepSchemes(string);
    }

    public void setEventHost(String string) {
        block2: {
            this.eventHost = string;
            if (this.eventPort == -1) break block2;
            try {
                String string2 = InetAddress.getByName(this.eventHost).getHostAddress();
                UcDDL.logInfoMessage((String)("event manager host and port = " + this.eventHost + " (" + string2 + ") port " + this.eventPort));
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    public void setEventPort(int n) {
        block2: {
            this.eventPort = n;
            if (this.eventHost == null) break block2;
            try {
                String string = InetAddress.getByName(this.eventHost).getHostAddress();
                UcDDL.logInfoMessage((String)("event manager host and port = " + this.eventHost + " (" + string + ") port " + this.eventPort));
                this.restart();
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    public void setImageSubpath(String string) {
        this.imageSubpath = string;
    }

    public void setMDRHost(String string) {
        block2: {
            this.mdrHost = string;
            if (this.mdrPort == -1) break block2;
            try {
                String string2 = InetAddress.getByName(this.mdrHost).getHostAddress();
                UcDDL.logInfoMessage((String)("mdr agent host and port = " + this.mdrHost + " (" + string2 + ") port " + this.mdrPort));
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    public void setMDRPort(int n) {
        block2: {
            this.mdrPort = n;
            if (this.mdrHost == null) break block2;
            try {
                String string = InetAddress.getByName(this.mdrHost).getHostAddress();
                UcDDL.logInfoMessage((String)("mdr agent host and port = " + this.mdrHost + " (" + string + ") port " + this.mdrPort));
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    public void setPrivateId(String string) {
        this.privateId = string;
    }

    public void setPrivateKey(String string) {
        this.privateKey = string;
        this.restart();
    }

    public void setPrivatePassword(String string) {
        this.privatePassword = string;
    }

    public void setPublicId(String string) {
        this.publicId = string;
    }

    public void setPublicPassword(String string) {
        this.publicPassword = string;
    }

    public void setSecurityFlag(int n) {
        this.securityFlag = n;
        this.restart();
    }

    public void setSecurityURL(String string) {
        this.securityURL = string;
        this.restart();
    }

    public void setSessionLimit(int n) {
        this.sessionLimit = n;
        this.calculateSessionLimit();
    }

    public void setSunHostOnly(boolean bl) {
        this.sunHostOnly = bl;
    }

    public void setTopologyHost(String string) {
        block2: {
            this.topologyHost = string;
            if (this.topologyPort == -1) break block2;
            try {
                String string2 = InetAddress.getByName(this.topologyHost).getHostAddress();
                UcDDL.logInfoMessage((String)("topology agent host and port = " + this.topologyHost + " (" + string2 + ") port " + this.topologyPort));
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    public void setTopologyPort(int n) {
        block2: {
            this.topologyPort = n;
            if (this.topologyHost == null) break block2;
            try {
                String string = InetAddress.getByName(this.topologyHost).getHostAddress();
                UcDDL.logInfoMessage((String)("topology agent host and port = " + this.topologyHost + " (" + string + ") port " + this.topologyPort));
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    protected void startServer() {
        if (this.securityURL.compareTo("") == 0) {
            this.securityURL = String.valueOf(this.getConfigurationBaseURL()) + "oid/1.3.6.1.4.1.42.2.12.2.2.34.1.0";
        }
        this.calculateSessionLimit();
        UcDDL.logInfoMessage((String)("Number of client sessions that will be allowed to connect: " + (this.sessionLimit == -1 ? "unlimited" : String.valueOf(this.sessionLimit))));
    }
}

