/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.common;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.server.common.ScProbeInterface;
import com.sun.symon.base.server.common.ScProbeListener;
import com.sun.symon.base.utility.UcDDL;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public class ScBaseProbeImpl
implements ScProbeInterface {
    static int numberOfOpenConnection = 0;
    static final int INIT_CAPACITY = 12000;
    static final int LIMIT = 4000;
    Socket sock = null;
    Socket sock1 = null;
    OutputStream os = null;
    InputStream ip = null;
    Reader reader;
    ScProbeListener listener;
    String endOfStream = null;
    String host;
    int port;
    boolean isConnected = false;

    public void close() throws SMAPIException {
        this.listener = null;
        if (this.isConnected()) {
            try {
                if (this.reader != null) {
                    this.reader.stopit();
                }
                this.reader = null;
                if (this.os != null) {
                    this.os.flush();
                    this.os.close();
                    this.os = null;
                }
                if (this.ip != null) {
                    this.ip.close();
                    this.ip = null;
                }
                if (this.sock != null) {
                    this.sock.close();
                    this.sock = null;
                    UcDDL.logInfoMessage((String)("Probe on host :" + this.host + " Port:" + this.port + " was closed"));
                    UcDDL.logInfoMessage((String)("Number of open probes:" + --numberOfOpenConnection));
                }
                if (this.sock1 != null) {
                    this.sock1.close();
                    this.sock1 = null;
                    UcDDL.logInfoMessage((String)("Number of open probes:" + --numberOfOpenConnection));
                }
                if (this.isConnected()) {
                    this.isConnected = false;
                }
                return;
            }
            catch (IOException iOException) {
                UcDDL.logErrorMessage((String)"IOException while close:", (Throwable)iOException);
                throw new SMAPIException("Close probe", (Throwable)iOException);
            }
        }
    }

    public void connect(String string, int n, String string2, ScProbeListener scProbeListener) throws SMAPIException {
        this.host = string;
        this.port = n;
        this.listener = scProbeListener;
        this.sock = this.establish(string, n, string2);
        try {
            this.ip = this.sock.getInputStream();
        }
        catch (Throwable throwable) {
            String string3 = "Error connecting to host: '" + string + "'";
            UcDDL.logErrorMessage((String)string3, (Throwable)throwable);
            throw new SMAPIException(string3, throwable);
        }
    }

    public void connectWithErr(String string, int n, String string2, ScProbeListener scProbeListener) throws SMAPIException {
        this.host = string;
        this.port = n;
        this.listener = scProbeListener;
        this.sock = this.establish(string, n, string2);
        this.sock1 = this.establish(string, n, string2);
        this.isConnected = true;
        try {
            this.ip = this.sock.getInputStream();
        }
        catch (Throwable throwable) {
            String string3 = "Error connecting to host: '" + string + "'";
            UcDDL.logErrorMessage((String)string3, (Throwable)throwable);
            throw new SMAPIException(string3, throwable);
        }
    }

    protected Socket establish(String string, int n, String string2) throws SMAPIException {
        Socket socket = null;
        try {
            socket = new Socket(string, n);
            socket.setSoTimeout(60000);
            this.os = socket.getOutputStream();
            this.os.write(string2.getBytes());
            this.os.flush();
            this.isConnected = true;
            UcDDL.logInfoMessage((String)("Probe was opened on host " + string + " port:" + n));
            UcDDL.logInfoMessage((String)("Number of open probes:" + ++numberOfOpenConnection));
        }
        catch (Throwable throwable) {
            String string3 = "Error connecting to host: '" + string + "'";
            UcDDL.logErrorMessage((String)string3, (Throwable)throwable);
            throw new SMAPIException(string3, throwable);
        }
        return socket;
    }

    protected void finalize() {
        if (this.isConnected()) {
            UcDDL.logInfoMessage((String)("Number of open probes(fin):" + --numberOfOpenConnection));
        }
    }

    boolean isConnected() {
        return this.isConnected;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readLines(int n) throws SMAPIException {
        if (n > 1) {
            String string = "Illegal channel: '" + n + "'";
            UcDDL.logErrorMessage((String)string);
            throw new SMAPIException(string);
        }
        Socket socket = null;
        socket = n == 0 ? this.sock : this.sock1;
        if (socket == null) {
            String string = "Attempt to read from closed socket '";
            UcDDL.logErrorMessage((String)string);
            throw new SMAPIException(string);
        }
        try {
            String string;
            InputStreamReader inputStreamReader = new InputStreamReader(socket.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.append("\n");
                try {
                    if (this.listener == null) continue;
                    this.listener.receiveData(stringBuffer.toString());
                }
                catch (Throwable throwable) {
                    String string2 = "Failed to deliver data to listener '";
                    UcDDL.logErrorMessage((String)string2, (Throwable)throwable);
                    throw new SMAPIException(string2, throwable);
                    return;
                }
            }
        }
        catch (IOException iOException) {
            String string = "Failed to read from  socket '";
            UcDDL.logErrorMessage((String)string, (Throwable)iOException);
            throw new SMAPIException(string, (Throwable)iOException);
        }
    }

    public void setEndOfStream(String string) {
        this.endOfStream = string;
    }

    public void setTimeOut(int n) throws SMAPIException {
        if (this.sock == null) {
            throw new SMAPIException("Set timeout for null socket");
        }
        try {
            this.sock.setSoTimeout(n);
        }
        catch (SocketException socketException) {
            throw new SMAPIException("Setting timeout", (Throwable)socketException);
        }
    }

    public void startReader() throws SMAPIException {
        if (this.ip == null) {
            String string = "Probe is not ready ";
            UcDDL.logErrorMessage((String)string);
            throw new SMAPIException(string);
        }
        this.reader = new Reader();
        this.reader.start();
    }

    public void write2probe(String string) throws SMAPIException {
        try {
            if (this.os == null) {
                String string2 = "Output Stream is not initialized";
                UcDDL.logErrorMessage((String)string2);
                throw new SMAPIException(string2);
            }
            this.os.write(string.getBytes());
            this.os.flush();
        }
        catch (Throwable throwable) {
            String string3 = "Error while writing to stream";
            UcDDL.logErrorMessage((String)string3, (Throwable)throwable);
            throw new SMAPIException(string3, throwable);
        }
    }

    class Reader
    extends Thread {
        boolean isStop;

        Reader() {
        }

        public void run() {
            this.isStop = false;
            while (!this.isStop) {
                boolean bl = true;
                StringBuffer stringBuffer = new StringBuffer(4000);
                byte[] byArray = new byte[4096];
                int n = -1;
                while (true) {
                    try {
                        n = ScBaseProbeImpl.this.ip.read(byArray);
                    }
                    catch (Throwable throwable) {
                        if (this.isStop || ScBaseProbeImpl.this.endOfStream == null && throwable instanceof InterruptedIOException) break;
                        try {
                            if (ScBaseProbeImpl.this.listener != null) {
                                ScBaseProbeImpl.this.listener.receiveException(new SMAPIException("Error while reading from stream", throwable));
                            }
                        }
                        catch (Throwable throwable2) {}
                    }
                    if (this.isStop || n == -1) break;
                    String string = new String(byArray, 0, n);
                    stringBuffer.append(string);
                    if (ScBaseProbeImpl.this.endOfStream != null && string.endsWith(ScBaseProbeImpl.this.endOfStream)) break;
                    if (stringBuffer.length() <= 4000) continue;
                    try {
                        if (bl) {
                            bl = false;
                            if (ScBaseProbeImpl.this.listener != null) {
                                ScBaseProbeImpl.this.listener.receiveBeginData();
                            }
                        }
                        if (ScBaseProbeImpl.this.listener != null) {
                            ScBaseProbeImpl.this.listener.receiveDataPortion(stringBuffer.toString());
                        }
                        stringBuffer = new StringBuffer(4000);
                    }
                    catch (Throwable throwable) {
                        this.isStop = true;
                    }
                }
                if (this.isStop) break;
                if (n == -1) {
                    try {
                        if (ScBaseProbeImpl.this.listener != null) {
                            ScBaseProbeImpl.this.listener.receiveException(new SMAPIException("No data in stream"));
                        }
                    }
                    catch (Throwable throwable) {}
                    return;
                }
                if (stringBuffer.length() == 0) {
                    try {
                        if (ScBaseProbeImpl.this.listener == null) continue;
                        ScBaseProbeImpl.this.listener.receiveException(new SMAPIException("Got timeout"));
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                try {
                    if (ScBaseProbeImpl.this.listener == null) continue;
                    if (bl) {
                        ScBaseProbeImpl.this.listener.receiveData(stringBuffer.toString());
                        continue;
                    }
                    ScBaseProbeImpl.this.listener.receiveDataPortion(stringBuffer.toString());
                    ScBaseProbeImpl.this.listener.receiveEndData();
                }
                catch (Throwable throwable) {}
            }
        }

        public void stopit() {
            this.isStop = true;
        }
    }
}

