/*
    File:    toeInt.h
    Author:  Andrew Hillier
    Version: 1.4 97/07/03 13:55:05     

    Copyright (c) 1993-1997 Halcyon Inc.
*/


#ifndef _TOEINT
#define _TOEINT

#include "converters.h"
#include "cvt-string.h"
#include "cvt-boolean.h"
#include "cvt-int.h"
#include "cvt-ptr.h"
#include "toe.h"

#define ACTIVE_CONTEXT_KEY	"_ACTIVE_TOE_CONTEXT_"

#define TOE_COMMAND	1
#define TOE_DICTIONARY	2

/* WARNING: the sprintf call used to generate the slice keys is
 *          extremely expensive...a special call is now coded in
 *          toeDict.c.  If you modify this definition, change
 *          that method!!!!!
 */

#define TOE_DICT_KEY_FORMAT	"%s:%s"
#define TOE_DICT_ENTRIES_SLICE	"entries"
 

typedef struct ToeObject {
    Tcl_HashTable 	commands;
    Tcl_HashTable 	dictionary;
    struct ToeObject 	**parents;
    struct ToeObject 	*superior;
    char		*id;
    short		refCount;
    short		destructFlag;
} ToeObject;


typedef struct ToeContext {
    ToeObject	 	*cObject;
    ToeObject	 	*dObject;
    struct ToeContext 	*previous;
    struct ToeContext 	*next;
} ToeContext;



Tcl_HashEntry
    *Toe_FindObjectHashEntry(ToePtr object, char *key, int table, int strategy);
Tcl_HashEntry *
    Toe_CreateHashEntry(Tcl_HashTable *tablePtr, char *key, int *new);
Tcl_HashEntry *
    Toe_FindHashEntry(Tcl_HashTable *tablePtr, char *key);

ToeContext	*toeGetContextByTable (Tcl_HashTable *table);
ToeContext	*toeGetContext (Tcl_Interp *interp);
int	toeSetContextByTable(Tcl_HashTable *table, ToeContext *context);
int	toeSetContext(Tcl_Interp *interp, ToeContext *context);
ToePtr	toeGetCurrentObjectByTable(Tcl_HashTable *table, int type);
ToePtr	toeGetCurrentObject(Tcl_Interp *interp, int type);
int	toePushContext(Tcl_Interp *interp, ToePtr cObject, ToePtr dObject);
int	toePopContext(Tcl_Interp *interp);

int	toeCleanOutObject(Tcl_Interp *interp, ToePtr object);


void toeDecrRefCount(ToePtr object);
void toeIncrRefCount(ToePtr object);


#endif /* _TOEINT */
