#!/bin/sh 
# 
#  @(#)hd-server.sh	1.31 01/01/22
#
#  Copyright (c) 01/22/01 Sun Microsystems, Inc.  All Rights Reserved
#
#  @version 1.31 01/01/22 17:27:10
#
#

##jdk/jre

# All the L10N variables will be exported from start-diag

set -k

# Let's see if an other server runs. If yes exit

PWD=`/bin/pwd`

thisIsme=`/usr/ucb/whoami`
if [ "root" != $thisIsme ] ; then
	# sunmc reason
	/bin/gettext "Hardware Diagnostic Suite can be started only by root"
	echo ""
	exit 1
fi

#-A- Let's see if /var/opt/SUNWhwdiag/logs/hwdserver.pid exists and if the pid
#    is the pid of a runing process

if [ -f "/var/opt/SUNWhwdiag/logs/hwdserver.pid" ]; then
	set EDS_PID=
	EDS_PID=`cat /var/opt/SUNWhwdiag/logs/hwdserver.pid`

 	if [ ${EDS_PID} ] ; then
		# is this a process still active ?
		set EDS_PID_A= 
		EDS_PID_A=`/bin/ps -efo pid | /bin/grep ${EDS_PID}`
		if [ $EDS_PID_A ] ; then
			## server already runs. exit.
			/bin/gettext "Hardware Diagnostic Suite Server is already running."
			echo ""
			exit 0;
		else
			# the pid in /var/opt/SUNWhwdiag/logs/hwdserver.pid is useless
			/bin/rm -f /var/opt/SUNWhwdiag/logs/hwdserver.pid
		fi
 	fi
fi

##-B- ED Server is not running or /var/opt/SUNWhwdiag/logs/hwdserver.pid is not present
#     Figure out if is running and /var/opt/SUNWhwdiag/logs/hwdserver is not present
set EDS_PID=
## Started by rc3.d may not update /var/opt/SUNWhwdiag/logs/hwdserver.pid
	EDS_PID=`/bin/ps -ef | /bin/fgrep "SUNWsymon/addons/AdvancedMonitoring/classes/./jre2/bin/../bin/sparc/native_threads/java -Djava." | /bin/fgrep -v fgrep | /bin/awk '{ print $2 }'`

if [ $EDS_PID ] ; then
	## server already runs. Update the /var/opt/SUNWhwdiag/logs/hwdserver.pid & exit.
	/bin/echo ${EDS_PID} > /var/opt/SUNWhwdiag/logs/hwdserver.pid
	/bin/gettext  "Hardware Diagnostic Suite Server is already running."
	echo ""
	exit 0;
else
	EDS_PID=-1
fi

unset JAVA_HOME
PATH=""
unset LD_LIBRARY_PATH
unset CLASSPATH
unset JAVA_COMPILER
unset THREADS_FLAG
LANGHWD2=$LANG
JAVA_HOME=/usr/java1.2

/bin/gettext  "Hardware Diagnostic Suite Server Start Procedure"
echo ""
SCRIPT_DIR=`/bin/dirname $0`
DEV_CLASSES=${SCRIPT_DIR}/../../classes
PRO_CLASSES=${SCRIPT_DIR}/../../../../apps/classes
SunMC_CLASSES=/opt/SUNWsymon/classes
if [ -d "${DEV_CLASSES}" ]; then
    # Working in developement environment
    CLASSES_DIR=${DEV_CLASSES}
    cd ${CLASSES_DIR}
elif [ -d "${PRO_CLASSES}" ]; then
    # Working in production environment
    CLASSES_DIR=${PRO_CLASSES}
else
    echo "ERROR: can not find HWDS classes directory. "
    echo ""
    exit 1
fi

OS_V=`/usr/bin/uname -r | /usr/bin/sed -e 1,1s/5/2/`

PATH=${JAVA_HOME}/bin:/bin:/etc:$PATH
LD_LIBRARY_PATH=${CLASSES_DIR}/com/sun/entdiag/server:${JAVA_HOME}/lib:/opt/SUNWsymon/util/lib/sparc-sun-solaris${OS_V}:/opt/SUNWsymon/base/lib:/opt/SUNWsymon/base/lib/sparc-sun-solaris${OS_V}:/opt/SUNWsymon/sbin/export2x:/opt/SUNWsymon/base/lib/sparc-sun-solaris${OS_V}:/opt/SUNWsymon/base/lib/sparc-sun-solaris${OS_V}/libNcClog.so
export LD_LIBRARY_PATH

INTERFACE_PATH=/var/opt/SUNWsymon/cfg:/opt/SUNWsymon/classes/base/server/cfg:/opt/SUNWsymon/apps/classes:/opt/SUNWsymon/classes:/var/opt/SUNWsymon/classes
export INTERFACE_PATH

CLASSPATH=${JAVA_HOME}/lib/classes.zip:${CLASSES_DIR}:${CLASSES_DIR}/hdsrv.jar:
CLASSPATH=$CLASSPATH:${SunMC_CLASSES}/essrv.jar:${SunMC_CLASSES}/esjrm.jar:
CLASSPATH=$CLASSPATH:${SunMC_CLASSES}/essfx.jar:${SunMC_CLASSES}/escom.jar:${SunMC_CLASSES}/esclt.jar:${SunMC_CLASSES}/escom.jar
CLASSPATH=$CLASSPATH:${SunMC_CLASSES}/escon.jar:${SunMC_CLASSES}/esmigrate.jar:${SunMC_CLASSES}/esmsg.jar
JAVA_COMPILER=NONE
export JAVA_COMPILER PATH
export CLASSPATH

THREADS_FLAG=native
export THREADS_FLAG
/bin/rm -f /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log

if [ ! -f $BASE_PATH/lib/server/hdserversec.policy ]; then
	echo "grant { permission java.security.AllPermission;};" > $BASE_PATH/lib/server/hdserversec.policy
fi

unset LANG
# check /var/opt/SUNWsymon/cfg/javaserver.properties for AlternateRmiHosts
/usr/bin/grep AlternateRmiHosts /var/opt/SUNWsymon/cfg/javaserver.properties |  /usr/bin/grep -v "\#" | /usr/bin/sed -e 1,1s/AlternateRmiHosts.*=// > /var/opt/SUNWhwdiag/logs/sunmcipport.txt
/usr/bin/chmod 666 /var/opt/SUNWhwdiag/logs/sunmcipport.txt

reply=`java -Djava.compiler=NONE -Djava.security.policy=$BASE_PATH/lib/server/hdserversec.policy -DINTERFACE_PATH=${INTERFACE_PATH} -classpath ${CLASSPATH}  com.sun.entdiag.server.EDServerRMIServer > /tmp/edserver1099   & `

sleep 5
/usr/bin/chmod 666 /tmp/edserver1099

## fix bugid 4350403
LANG=$LANGHWD2
export LANG

if [ ! -f /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log ]; then
	sleep 10
	if [ ! -f /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log ]; then
		sleep 15
	fi
	if [ ! -f /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log ]; then
		echo "*********************************"
		/bin/gettext  "ERROR in Hardware Diagnostic Suite Server start procedure"
		echo ""
		echo "*********************************"
		exit 1
	fi
fi


/bin/chmod -f 666 /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log
set muErr=
muErr=`/bin/grep ERROR /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log | /bin/awk '{ print $1 }'`
if [ $muErr ] ; then
	echo "*********************************"
	/bin/gettext  "ERROR in Hardware Diagnostic Suite Server start procedure"
	echo ""
	echo "*********************************"
	/bin/cat /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log 
	/bin/gettext  "EXIT"
	echo ""
	$BASE_PATH/sbin/ed-stop > /dev/null
	exit 1
else
	## Store the ED Server pid in /var/opt/SUNWhwdiag/logs/hwdserver.pid
	/bin/rm -f /var/opt/SUNWhwdiag/logs/hwdserver.pid
	EDS_PID2=`/usr/ucb/ps -gww | /bin/fgrep EDServ | /bin/fgrep -v fgrep | /bin/awk '{ print $1 }'`
	# Work around for the case when EDS_PID2 is null at boot time.
	EDS_PID3=`/usr/bin/ps -ef | /bin/fgrep "AdvancedMonitoring/classes/./jre2/bin" | /bin/fgrep -v fgrep | /bin/awk '{ print $2 }'`
	if [ ${EDS_PID2} ]; then
		/bin/echo ${EDS_PID2} > /var/opt/SUNWhwdiag/logs/hwdserver.pid
		/bin/chmod 666 /var/opt/SUNWhwdiag/logs/hwdserver.pid
		/bin/gettext  "Hardware Diagnostic Suite Server started OK"
	elif [ ${EDS_PID3} ]; then
		/bin/echo ${EDS_PID3} > /var/opt/SUNWhwdiag/logs/hwdserver.pid
		/bin/chmod 666 /var/opt/SUNWhwdiag/logs/hwdserver.pid
		/bin/gettext  "Hardware Diagnostic Suite Server started OK"
	else
		/bin/gettext  "ERROR in Hardware Diagnostic Suite Server start procedure"
	fi
	echo ""
	exit 0
fi

