/*
 * Decompiled with CFR 0.152.
 */
package com.sun.entdiag.ui;

import com.sun.entdiag.ui.MsgTranslator;
import com.sun.entdiag.ui.TestingEvent;
import com.sun.entdiag.ui.TestingListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DiagPanel {
    public JPanel panel;
    private JPanel titlePanel;
    private JPanel infoPanel;
    private JPanel progressPanel;
    private JPanel progressLabel;
    private String diagHost;
    private Vector diagTests = new Vector();
    Font boldFont = new Font("Dialog", 1, 12);
    Font plainFont = new Font("Dialog", 0, 12);
    private JProgressBar progressBar;
    private GridBagLayout panelBag = new GridBagLayout();
    private GridBagLayout infoBag = new GridBagLayout();
    private GridBagLayout progressBag = new GridBagLayout();
    private Vector listeners = new Vector();
    private JLabel statusLabel = null;
    private JLabel statusLine = null;
    private Object[][] testData = new Object[100][2];
    private boolean firstInfo = true;
    private boolean lastPassed = true;
    private String lastDevice;
    private String previousTest = new String(" ");
    private JLabel msgLabel = null;
    private JLabel location = null;
    JLabel progressLine1;
    JLabel progressLine2;
    JLabel progressLine3;
    MyTableModel myModel = null;
    private JPanel tablePanel;
    public Vector hasDiag = new Vector();
    private boolean testingHost = false;
    private JTable table = null;
    private MsgTranslator rb = null;
    private boolean debug = false;
    static int connProgress = 0;

    public DiagPanel(MsgTranslator msgTranslator) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panel = new JPanel(true);
        this.rb = msgTranslator;
        this.titlePanel = new JPanel(true);
        this.titlePanel.setLayout(new FlowLayout(0, 0, 0));
        this.createTitle();
        this.myModel = new MyTableModel();
        this.table = new JTable(this.myModel);
        this.table.setPreferredScrollableViewportSize(new Dimension(398, 150));
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(2, 2));
        TableColumn tableColumn = this.table.getColumn(this.myModel.getColumnName(0));
        TableColumn tableColumn2 = this.table.getColumn(this.myModel.getColumnName(1));
        tableColumn.setCellRenderer(new ColumnRenderer(4));
        tableColumn.setResizable(true);
        ColumnRenderer columnRenderer = new ColumnRenderer(2);
        columnRenderer.setFont(new Font(columnRenderer.getFont().getName(), 1, 12));
        tableColumn2.setCellRenderer(columnRenderer);
        tableColumn2.setResizable(true);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.tablePanel = new JPanel(new BorderLayout());
        this.tablePanel.add((Component)jScrollPane, "Center");
        this.tablePanel.setBackground(Color.white);
        this.progressPanel = new JPanel(true);
        this.progressPanel.setLayout(new BorderLayout(10, 10));
        this.progressLabel = new JPanel(true);
        this.progressLabel.setLayout(new BorderLayout(10, 10));
        this.progressPanel.setBorder(new TitledBorder(this.rb.getString("Progress")));
        this.createProgress();
        this.panel.setLayout(new BorderLayout());
        this.panel.add("North", this.titlePanel);
        this.panel.add(this.tablePanel);
        this.panel.validate();
        this.panel.repaint();
    }

    public void addTestingListener(TestingListener testingListener) {
        this.listeners.addElement(testingListener);
    }

    private void createProgress() {
        this.progressLine1 = new JLabel(String.valueOf(this.rb.getString("Notesting")) + "                                              ");
        this.progressLine2 = new JLabel("...                                                                            ");
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressLine3 = new JLabel(String.valueOf(this.rb.getString("Previous")) + " " + this.rb.getString("Noresults") + "                         ");
        this.progressLine1.setForeground(Color.blue.darker().darker());
        this.progressLine2.setForeground(Color.blue.darker().darker());
        this.progressLine3.setForeground(Color.blue.darker().darker());
        this.progressBar.setForeground(Color.blue.darker().darker());
        this.progressLabel.add((Component)this.progressLine1, "North");
        this.progressLabel.add((Component)this.progressLine2, "Center");
        this.progressBar.setValue(0);
        this.progressPanel.add((Component)this.progressLabel, "North");
        this.progressPanel.add((Component)this.progressBar, "Center");
        this.progressPanel.add((Component)this.progressLine3, "South");
    }

    private void createTitle() {
        JLabel jLabel = new JLabel(this.rb.getString("Location")){

            public Insets getInsets() {
                Insets insets = new Insets(15, 10, 15, 15);
                return insets;
            }
        };
        this.titlePanel.add("West", jLabel);
        Border border = BorderFactory.createRaisedBevelBorder();
        this.titlePanel.setBorder(border);
    }

    protected void notifyTestingEvent(int n, String string, int n2, String string2) {
        Vector vector;
        TestingEvent testingEvent = new TestingEvent(this, n, string, n2, string2);
        DiagPanel diagPanel = this;
        synchronized (diagPanel) {
            vector = (Vector)this.listeners.clone();
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            TestingListener testingListener = (TestingListener)vector.elementAt(n3);
            testingListener.testingAction(testingEvent);
            ++n3;
        }
    }

    public void removeTestingListener(TestingListener testingListener) {
        this.listeners.removeElement(testingListener);
    }

    public void resetPanel(int n) {
        switch (n) {
            case 0: {
                this.progressLine1.setText(this.rb.getString("Suspendtest"));
                this.progressLine1.repaint();
                break;
            }
            case 1: {
                this.progressLine1.setText(this.rb.getString("Notesting"));
                this.progressLine1.repaint();
                break;
            }
        }
    }

    public void selectHost() {
        this.notifyTestingEvent(6, null, 0, null);
    }

    public void setHost(String string) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.diagHost = string;
        this.testingHost = true;
    }

    public void setInfo(String string, Vector vector, int n) {
        Object object;
        this.setTitle(string);
        int n2 = vector.size();
        String string2 = new String("None");
        Color color = new Color(0);
        switch (n) {
            case 0: {
                string2 = new String("None");
                color = Color.black;
                break;
            }
            case 1: {
                string2 = new String("Passed");
                color = Color.green.darker();
                break;
            }
            case 2: {
                string2 = new String("Failed");
                color = Color.red;
                break;
            }
        }
        boolean bl = true;
        Vector<Object> vector2 = new Vector<Object>();
        int n3 = 0;
        while (n3 < n2) {
            object = (String)vector.elementAt(n3);
            int n4 = ((String)object).indexOf(":");
            Vector<Object> vector3 = new Vector<Object>();
            int n5 = 0;
            while (n5 < 2) {
                if (n4 > 0) {
                    String string3 = ((String)object).substring(0, n4 + 1);
                    String string4 = ((String)object).substring(n4 + 1, ((String)object).length());
                    vector3.addElement(string3);
                    vector3.addElement(string4);
                } else {
                    vector3.addElement(" ");
                    vector3.addElement(object);
                }
                ++n5;
            }
            vector2.addElement(vector3);
            ++n3;
        }
        object = new Vector<String>();
        ((Vector)object).addElement(" ");
        ((Vector)object).addElement(" ");
        vector2.addElement(object);
        Vector<String> vector4 = new Vector<String>();
        vector4.addElement("Status: ");
        vector4.addElement(string2);
        vector2.addElement(vector4);
        this.myModel.setTableData(vector2, n2);
        this.table.tableChanged(new TableModelEvent(this.table.getModel()));
    }

    public void setProgress(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (!bl) {
            this.panel.remove(this.progressPanel);
            return;
        }
        Dimension dimension = new Dimension(398, 120);
        this.progressPanel.setMinimumSize(dimension);
        this.progressPanel.setPreferredSize(dimension);
        this.panel.add("South", this.progressPanel);
        this.progressLine1.setText(String.valueOf(this.rb.getString("Notesting")) + "                                             ");
        this.progressLine1.repaint();
        this.progressLine2.setText("...                                                                            ");
        this.progressLine2.repaint();
        this.progressBar.setValue(0);
        this.progressLine3.setText(String.valueOf(this.rb.getString("Previous")) + " " + this.rb.getString("Noresults") + "                         ");
        this.progressLine3.repaint();
        this.panel.validate();
        this.panel.repaint();
    }

    public void setTests(Vector vector) {
        this.lastPassed = true;
        this.previousTest = new String(" ");
        this.diagTests = vector;
        this.lastDevice = new String((String)this.diagTests.lastElement());
        if (this.debug) {
            System.out.println("tests " + this.diagTests.toString());
            System.out.println("last test " + this.lastDevice);
        }
    }

    private void setTitle(String string) {
        if (this.location != null) {
            if (this.debug) {
                System.out.println("remove old location");
            }
            this.titlePanel.remove(this.location);
        }
        if (this.debug) {
            System.out.println("new location" + string);
        }
        this.location = new JLabel(string);
        this.location.setForeground(Color.black);
        this.titlePanel.add(this.location);
        this.titlePanel.repaint();
    }

    public void updateConnect(String string, String string2, String string3) {
        if (string == null) {
            if (string3.startsWith("Connection test starting")) {
                String string4 = this.rb.getString("ConnS");
                if (string4 == null) {
                    string4 = string3;
                }
                String string5 = (String)this.diagTests.elementAt(0);
                String string6 = new String(String.valueOf(this.rb.getString("Checking")) + " " + string5);
                this.progressLine1.setText(string6);
                this.progressLine1.repaint();
                connProgress = 100 / this.diagTests.size();
                String string7 = new String(String.valueOf(string4) + "...");
                this.progressLine2.setText(string7);
                this.progressLine2.repaint();
                this.progressBar.setValue(0);
            } else if (string3.startsWith("Connection test complete")) {
                String string8 = this.rb.getString("ConnE");
                if (string8 == null) {
                    string8 = string3;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    System.err.println("sleep error:" + exception);
                }
                this.notifyTestingEvent(16, this.previousTest, 0, null);
                String string9 = new String(String.valueOf(string8) + "...");
                this.progressLine2.setText(string9);
                this.progressLine2.repaint();
                this.progressBar.setValue(100);
                this.progressLine1.setText(this.rb.getString("Notesting"));
                this.progressLine1.repaint();
                this.notifyTestingEvent(1, null, 0, null);
            }
            return;
        }
        int n = this.diagTests.indexOf(string) + 1;
        String string10 = n < this.diagTests.size() ? (String)this.diagTests.elementAt(n) : "complete";
        if (!this.previousTest.equals(string)) {
            if (!this.previousTest.equals(" ")) {
                this.notifyTestingEvent(16, this.previousTest, 0, null);
            }
            this.notifyTestingEvent(5, string, 0, null);
            this.previousTest = string;
        }
        String string11 = new String("Checking " + string10);
        this.progressLine1.setText(string11);
        this.progressLine1.repaint();
        String string12 = new String(String.valueOf(string3) + "...");
        this.progressLine2.setText(string12);
        this.progressLine2.repaint();
        this.progressBar.setValue(this.progressBar.getValue() + connProgress);
        String string13 = new String(String.valueOf(this.rb.getString("Previous")) + " " + string + " " + string2);
        this.progressLine3.setText(string13);
        this.progressLine3.repaint();
    }

    public void updateFailure(String string, String string2) {
        this.lastPassed = false;
        String string3 = new String(string2);
        this.progressLine2.setText(string3);
        this.progressLine2.repaint();
        this.updateResults(string);
    }

    public void updateProgress(int n, String string, String string2, String string3) {
        int n2 = 0;
        if (string2 == null || string3 == null || string == null) {
            return;
        }
        if (!this.previousTest.equals(string)) {
            if (!this.previousTest.equals(" ")) {
                this.notifyTestingEvent(16, this.previousTest, 0, null);
            }
            this.notifyTestingEvent(5, string, 0, null);
            this.previousTest = string;
        }
        String string4 = new String(String.valueOf(this.rb.getString("Testing")) + " " + string);
        this.progressLine1.setText(string4);
        this.progressLine1.repaint();
        String string5 = new String(String.valueOf(string2) + "...");
        this.progressLine2.setText(string5);
        this.progressLine2.repaint();
        this.progressBar.setValue(n);
        if (this.debug) {
            System.out.println("msgEDA=" + string3 + "<<==");
        }
        try {
            n2 = string3.indexOf("Stopped successfully");
        }
        catch (Exception exception) {
            n2 = -1;
        }
        if (n2 > -1) {
            this.updateResults(string);
            this.progressBar.setValue(100);
        }
    }

    private void updateResults(String string) {
        String string2;
        boolean bl = false;
        if (this.lastPassed) {
            string2 = new String(String.valueOf(this.rb.getString("Previous")) + " " + string + " " + this.rb.getString("Passed"));
            this.notifyTestingEvent(4, string, 1, null);
        } else {
            string2 = new String(String.valueOf(this.rb.getString("Previous")) + " " + string + " " + this.rb.getString("Failed"));
            this.notifyTestingEvent(4, string, 2, null);
            this.lastPassed = true;
        }
        this.progressLine3.setText(string2);
        this.progressLine3.repaint();
        if (string.equals(this.lastDevice)) {
            bl = true;
        }
        if (bl) {
            this.progressLine1.setText(this.rb.getString("Notesting"));
            this.progressLine1.repaint();
            this.notifyTestingEvent(1, null, 0, null);
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        Object tableData;
        final String[] columnNames;

        MyTableModel() {
            this.columnNames = new String[]{DiagPanel.this.rb.getString("Property"), DiagPanel.this.rb.getString("Value")};
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            int n = 0;
            if (this.tableData instanceof Vector) {
                n = ((Vector)this.tableData).size();
            } else if (this.tableData instanceof String[][]) {
                n = ((String[][])this.tableData).length;
            }
            return n;
        }

        public Object getValueAt(int n, int n2) {
            Object object = new Object();
            if (this.tableData != null && this.tableData instanceof Vector) {
                Vector vector = (Vector)((Vector)this.tableData).elementAt(n);
                object = vector.elementAt(n2);
            }
            if (this.tableData != null && this.tableData instanceof String[][]) {
                object = ((String[][])this.tableData)[n][n2];
            }
            return object;
        }

        public void setTableData(Object object, int n) {
            this.tableData = object;
        }
    }

    class ColumnRenderer
    extends JLabel
    implements TableCellRenderer {
        int align = 2;

        public ColumnRenderer(int n) {
            this.align = n;
            this.setOpaque(true);
            this.setFont(new Font(this.getFont().getName(), 0, 12));
            this.setForeground(Color.black);
        }

        public Insets getInsets() {
            return new Insets(2, 3, 2, 3);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText(object == null ? "" : (String)object);
            this.setHorizontalAlignment(this.align);
            this.setBackground(Color.white);
            return this;
        }
    }
}

