/*
 * Decompiled with CFR 0.152.
 */
package com.sun.entdiag.ui;

import com.sun.entdiag.server.EDServerRMI;
import com.sun.entdiag.server.HandleMessageRMI;
import com.sun.entdiag.ui.CommEvent;
import com.sun.entdiag.ui.CommListener;
import com.sun.entdiag.ui.FRUFilter;
import com.sun.entdiag.ui.Schedule;
import com.sun.symon.base.client.SMRawDataRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.util.Vector;

public class Communicator {
    private Vector listeners = new Vector();
    public FRUFilter filter = new FRUFilter();
    public Vector fileData;
    private String middleware;
    private String middleHost;
    private Messenger messenger = null;
    private boolean messageOn = false;
    private EDServerRMI server;
    private HandleMessageRMI handler;
    private Registry genRegistry = null;
    private int udpPort;
    private Socket socket;
    private BufferedReader input;
    private boolean debug = false;
    static /* synthetic */ Class class$java$lang$String;

    public Communicator(SMRawDataRequest sMRawDataRequest, int n, String string) throws Exception {
        File file = new File("/tmp/eddebug");
        if (file.exists()) {
            this.debug = true;
        }
        this.middleHost = new String(string);
        if (this.debug) {
            System.out.println("socket host=" + this.middleHost);
        }
        this.udpPort = n;
        if (this.debug) {
            System.out.println("UDP port=" + this.udpPort);
        }
        System.err.println("Try to get EDServerRMI service");
        if (this.server == null) {
            this.server = (EDServerRMI)sMRawDataRequest.getService("HDServerRMI", null);
            if (this.server == null) {
                throw new RemoteException("stub_ is null-getService failed");
            }
            System.err.println("Got EDServerRMI service. server=" + this.server.toString());
        } else {
            System.err.println("Got EDServerRMI service. Not null initialy");
        }
    }

    public Communicator(String string, int n) throws Exception {
        File file = new File("/tmp/eddebug");
        if (file.exists()) {
            this.debug = true;
        }
        boolean bl = false;
        this.udpPort = n;
        if (this.debug) {
            System.out.println("UDP port=" + this.udpPort);
        }
        this.middleHost = new String(string);
        this.middleware = new String("rmi://" + string);
        if (this.debug) {
            System.out.println("middleware=" + this.middleware);
        }
        this.RmiReg(this.middleHost);
        if (this.genRegistry == null) {
            System.err.println("ERROR: Can't connect to server " + this.middleHost);
            throw new Exception();
        }
    }

    private void RmiReg(String string) {
        int[] nArray = new int[]{30099, 31099, 32099, 33099, 34099, 35099, 36099, 37099, 38099, 39099};
        int n = 0;
        this.genRegistry = null;
        int n2 = 0;
        while (n2 < nArray.length) {
            n = nArray[n2];
            if (this.debug) {
                System.out.println("RmiReg: check port " + n);
            }
            try {
                this.genRegistry = LocateRegistry.getRegistry(string, n);
                String[] stringArray = this.genRegistry.list();
                if (stringArray != null) {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        if (stringArray[n3].indexOf("EDServer2509") > -1) {
                            if (this.debug) {
                                System.out.println("RmiReg:  Found rmiport= " + n);
                            }
                            return;
                        }
                        ++n3;
                    }
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        this.genRegistry = null;
        if (this.debug) {
            System.out.println("ERROR RmiReg: CAN'T find EDServer on " + string);
        }
    }

    public Socket SRSreturnSocket(String string, String string2, Integer n) {
        Object[] objectArray;
        Socket socket = null;
        Class<?> clazz = null;
        Method method = null;
        Constructor<?> constructor = null;
        if (string == null || string2 == null || n == null) {
            return null;
        }
        if (this.debug) {
            System.out.println("getFile: open socket for SRS-SunMC");
        }
        try {
            clazz = Class.forName("com.sun.symon.base.server.receptors.rmi.ProbeProxyConnection");
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.debug) {
                System.out.println("getFile: Class com.sun.symon.base.server.receptors.rmi.ProbeProxyConnection not present. Check SRS installation: " + classNotFoundException);
            }
            return null;
        }
        try {
            objectArray = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Communicator.class$("java.lang.String")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Communicator.class$("java.lang.String"))};
            method = clazz.getDeclaredMethod("addProxy", (Class<?>[])objectArray);
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("getFile: getDeclaredMethod failed: " + exception);
            }
            return null;
        }
        catch (Throwable throwable) {
            if (this.debug) {
                System.out.println("getFile: getDeclaredMethod Throwable:" + throwable);
            }
            return null;
        }
        try {
            objectArray = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Communicator.class$("java.lang.String")), Integer.TYPE};
            constructor = clazz.getConstructor((Class<?>[])objectArray);
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("getFile: getConstructor failed: " + exception);
            }
            return null;
        }
        catch (Throwable throwable) {
            if (this.debug) {
                System.out.println("getFile: getConstructor Throwable:" + throwable);
            }
            return null;
        }
        if (method != null) {
            try {
                if (this.debug) {
                    System.out.println("getFile: SERVER=" + string + " target:" + string2 + " Port:" + n);
                }
                objectArray = new Object[]{string, string2};
                method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                if (this.debug) {
                    System.out.println("getFile: addProxy.invoke failed: " + exception);
                }
                return null;
            }
            catch (Throwable throwable) {
                if (this.debug) {
                    System.out.println("getFile: addProxy.invoke Throwable:" + throwable);
                }
                return null;
            }
        } else {
            if (this.debug) {
                System.out.println("getFile: addProxy is NULL");
            }
            return null;
        }
        try {
            if (constructor == null) {
                if (this.debug) {
                    System.out.println("getFile: proxyConn is NULL");
                }
                return null;
            }
            objectArray = new Object[]{string2, n};
            socket = (Socket)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("getFile: Can not open SRS socket to: " + string2 + " port:" + n + " Exception:" + exception);
            }
            return null;
        }
        catch (Throwable throwable) {
            if (this.debug) {
                System.out.println("getFile: sock Throwable:" + throwable);
            }
            return null;
        }
        return socket;
    }

    public void addCommListener(CommListener commListener) {
        this.listeners.addElement(commListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void connectCheck(String string, Vector vector) {
        String string2;
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = string2 = this.filter.getFRU((String)vector.elementAt(n));
            ++n;
        }
        try {
            string2 = this.server.SetTesting(string, 0, "START", stringArray, 101);
        }
        catch (Exception exception) {
            System.err.println("Remote ERROR: " + exception);
        }
    }

    public String getBasicInfo(String string) {
        String string2 = new String("");
        if (string.equals("Enterprise")) {
            String string3 = new String("Enterprise");
            return string3;
        }
        try {
            string2 = this.server.GetBasicInfo(string, 0);
        }
        catch (Exception exception) {
            System.err.println("Remote ERROR: " + exception);
            return null;
        }
        if (string2 == null) {
            return null;
        }
        int n = string2.indexOf("[") + 1;
        int n2 = string2.indexOf("]");
        if (n < 1 || n2 < n) {
            return new String(" ");
        }
        String string4 = string2.substring(n, n2);
        return string4;
    }

    public String getConfig(String string, String string2) {
        int n;
        String string3 = new String("");
        try {
            string3 = this.server.GetConfig(string, 0);
        }
        catch (Exception exception) {
            System.err.println("Remote ERROR: " + exception);
        }
        if (string3 == null) {
            return "ERROR: getting configuration";
        }
        while ((n = string3.indexOf("{}")) > 0) {
            int n2 = string3.lastIndexOf(125, n - 1);
            int n3 = string3.lastIndexOf(123, n - 1);
            if (n3 > n2) {
                n2 = n3;
            }
            String string4 = string3.substring(0, n2 + 1);
            String string5 = string3.substring(n + 2);
            string3 = String.valueOf(string4) + string5;
        }
        n = string3.indexOf(":");
        String string6 = String.valueOf(string2) + "{";
        String string7 = String.valueOf(string6) + string3.substring(n + 1) + "}";
        this.filter.setList(string7);
        String string8 = this.filter.getList();
        return string8;
    }

    public String getDetailedInfo(String string, String string2) {
        String string3 = new String("");
        String string4 = this.filter.getFRU(string2);
        try {
            string3 = this.server.GetDetailedInfo(string, 1, string4);
        }
        catch (Exception exception) {
            System.err.println("Remote ERROR: " + exception);
            return null;
        }
        if (string3 == null) {
            return null;
        }
        int n = string3.indexOf("[") + 1;
        int n2 = string3.indexOf("]");
        if (n2 < 0 || n < 0) {
            return null;
        }
        String string5 = new String("Device: " + this.filter.deviceName(string4) + "," + string3.substring(n, n2));
        return string5;
    }

    public String getError(String string, String string2) {
        String string3 = new String("hi");
        return string3;
    }

    public void getFile(String string, String string2) {
        this.fileData = new Vector();
        Socket socket = null;
        boolean bl = false;
        boolean bl2 = false;
        Integer n = null;
        if (string == null || string2 == null) {
            return;
        }
        try {
            String string3 = this.server.GetFile(string, string2);
            if (this.debug) {
                System.out.println("getFile: From:" + string + " Port:" + string3 + " File:" + string2);
            }
            try {
                n = new Integer(string3);
            }
            catch (Exception exception) {
                System.err.println("getFile: Wrong port:" + exception + " sPort=" + string3);
                this.fileData.addElement(String.valueOf(new String("getFile: The file " + string2 + " is not available on machine: " + string).trim()) + "\n");
            }
            File file = new File("/tmp/.srsconsolelock");
            if (file.exists()) {
                file = null;
                bl = true;
                bl2 = true;
                socket = this.SRSreturnSocket(this.middleHost, string, n);
                if (socket == null) {
                    bl = false;
                }
            }
            if (!bl) {
                socket = new Socket(string, (int)n);
            }
            socket.setSoTimeout(30000);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            if (this.debug) {
                System.out.println("open socket " + socket.toString());
            }
            String string4 = null;
            while (true) {
                block18: {
                    try {
                        string4 = bufferedReader.readLine();
                    }
                    catch (Exception exception) {
                        if (string4 != null) {
                            System.err.println("Can't read socket: " + string4 + " Exception:" + exception);
                            this.fileData.addElement(new String(String.valueOf(string4.trim()) + "\n"));
                        } else {
                            System.err.println("Can't read socket:" + exception);
                            this.fileData.addElement(new String(String.valueOf(("Can't read socket:" + exception).trim()) + "\n"));
                        }
                        if (!bl2) break block18;
                        this.fileData.addElement(new String(String.valueOf("Check SRS-SunMC Proxy Server".trim()) + "\n"));
                    }
                }
                if (string4 == null) break;
                this.fileData.addElement(new String(String.valueOf(string4.trim()) + "\n"));
            }
            if (this.debug) {
                System.out.println("close file in");
            }
            bufferedReader.close();
            if (this.debug) {
                System.out.println("close socket");
            }
            socket.close();
        }
        catch (Exception exception) {
            System.err.println("getFile: Can't open socket:" + exception);
            if (bl2) {
                System.err.println("getFile: Check SRS-SunMC Proxy Server");
                this.fileData.addElement(new String(String.valueOf("getFile: Can't open socket. Check SRS-SunMC Proxy Server".trim()) + "\n"));
            }
            String string5 = "Can NOT open socket to agent to get the requested file. Exception=" + exception;
            this.fileData.addElement(new String(String.valueOf(string5.trim()) + "\n"));
        }
    }

    public String getGenericInfo(String string) {
        return this.filter.getInfo(string);
    }

    public Vector getSchedule(String string) {
        Vector<Schedule> vector = new Vector<Schedule>();
        Vector vector2 = new Vector();
        if (string == null) {
            return null;
        }
        try {
            vector2 = this.server.GetSchedule(string);
        }
        catch (Exception exception) {
            System.err.println("Remote ERROR: " + exception);
            return null;
        }
        if (vector2 == null) {
            if (this.debug) {
                System.out.println("schedLines == null");
            }
            return null;
        }
        int n = 0;
        while (n < vector2.size()) {
            Schedule schedule;
            String string2 = (String)vector2.elementAt(n);
            if (this.debug) {
                System.out.println("line " + string2);
            }
            if ((schedule = new Schedule(string2)) != null) {
                vector.addElement(schedule);
            }
            ++n;
        }
        return vector;
    }

    public int getStatus(String string, String string2) {
        String string3 = new String("");
        String string4 = null;
        if (string2 == null) {
            return -1;
        }
        if (string2 != null) {
            string4 = this.filter.getFRU(string2);
        }
        if (string4 == null) {
            return -1;
        }
        try {
            string3 = this.server.GetStatus(string, 0, string4);
        }
        catch (Exception exception) {
            System.err.println("Remote ERROR: " + exception);
        }
        if (string3 == null) {
            return -1;
        }
        Integer n = new Integer(-1);
        try {
            n = new Integer(string3);
        }
        catch (Exception exception) {
            System.out.println("Can't convert:" + exception);
        }
        return n;
    }

    public boolean getVersion(String string) {
        String string2 = new String("");
        try {
            string2 = this.server.GetEdaVersion(string);
        }
        catch (Exception exception) {
            System.err.println("Remote ERROR: " + exception);
            return false;
        }
        if (this.debug) {
            System.out.println("Version " + string2);
        }
        return string2.indexOf("ERROR") < 0;
    }

    public void handleMessages(SMRawDataRequest sMRawDataRequest, String string) {
        try {
            System.err.println("Try to get HDHandleMessageRMI service");
            if (this.handler == null) {
                this.handler = (HandleMessageRMI)sMRawDataRequest.getService("HDHandleMessageRMI", null);
            }
        }
        catch (Exception exception) {
            System.err.println("ERROR: Can't connect to HDHandleMessageRMI service" + exception);
        }
        if (this.handler == null) {
            System.err.println("ERROR: stub_ is null-getService failed");
        }
        if (this.messenger != null) {
            this.messenger.finished();
            try {
                this.messenger.join();
            }
            catch (Exception exception) {
                System.err.println("ERROR: thread interrupted" + exception);
            }
            this.messenger = null;
        }
        this.messenger = new Messenger(string, this.handler, this.middleHost);
        this.messenger.start();
        this.messageOn = true;
    }

    protected void notifyCommEvent(int n, String string) {
        Vector vector;
        CommEvent commEvent = new CommEvent(this, n, string);
        if (this.debug) {
            System.out.println("comm event " + string);
        }
        Communicator communicator = this;
        synchronized (communicator) {
            vector = (Vector)this.listeners.clone();
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            CommListener commListener = (CommListener)vector.elementAt(n2);
            commListener.commAction(commEvent);
            ++n2;
        }
    }

    public void removeCommListener(CommListener commListener) {
        this.listeners.removeElement(commListener);
    }

    public void reprobeDevices(String string) {
        try {
            String string2 = this.server.SetTesting(string, 0, "REPROBE", null, 0);
        }
        catch (Exception exception) {
            System.err.println("Remote ERROR: " + exception);
        }
    }

    public void resetTesting(String string) {
        try {
            String string2 = this.server.SetTesting(string, 0, "RESET", null, 0);
        }
        catch (Exception exception) {
            System.err.println("Remote ERROR: " + exception);
        }
    }

    public void resumeTesting(String string) {
        try {
            String string2 = this.server.SetTesting(string, 0, "RESUME", null, 0);
        }
        catch (Exception exception) {
            System.err.println("Remote ERROR: " + exception);
        }
    }

    public void schedTesting(String string, Vector vector) {
        String string2;
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = string2 = this.filter.getFRU((String)vector.elementAt(n));
            ++n;
        }
        try {
            string2 = this.server.SetTesting(string, 0, "SCHED", stringArray, 0);
        }
        catch (Exception exception) {
            System.err.println("Remote ERROR: " + exception);
        }
    }

    public boolean setConnect(String string) {
        String string2 = new String("");
        try {
            if (this.debug) {
                System.out.println("comm.setConnect Agent=" + string + "udpPort=" + this.udpPort);
            }
            string2 = this.server.SetConnect(string, this.udpPort, 0);
        }
        catch (Exception exception) {
            System.err.println("Remote ERROR in comm.setConnect: " + exception.toString());
            return false;
        }
        if (this.debug) {
            System.out.println("Connect response " + string2);
        }
        return string2.indexOf("ERROR") < 0;
    }

    public void setSchedule(String string, Schedule schedule, String string2) {
        if (this.debug) {
            System.out.println(String.valueOf(string2) + " : " + schedule.getSchedule());
        }
        String string3 = new String(schedule.getSchedule());
        try {
            this.server.SetSchedule(string, 0, string3, string2);
        }
        catch (Exception exception) {
            System.err.println("Remote ERROR: " + exception);
        }
    }

    public void startMessages() {
        if (!this.messageOn) {
            this.messageOn = true;
        }
    }

    public String startTesting(String string, Vector vector) {
        String[] stringArray = new String[vector.size()];
        String string2 = new String(" ");
        int n = 0;
        while (n < vector.size()) {
            String string3;
            stringArray[n] = string3 = this.filter.getFRU((String)vector.elementAt(n));
            ++n;
        }
        try {
            string2 = this.server.SetTesting(string, 0, "START", stringArray, 0);
        }
        catch (Exception exception) {
            System.err.println("Remote ERROR: " + exception);
        }
        return string2;
    }

    public void stopMessages() {
        if (this.messageOn) {
            if (this.debug) {
                System.out.println("stopping messages");
            }
            this.messenger.finished();
            try {
                this.messenger.join();
            }
            catch (Exception exception) {
                System.err.println("ERROR: thread interrupted" + exception);
            }
            this.messenger = null;
            this.messageOn = false;
            if (this.debug) {
                System.out.println("stopped messages");
            }
        }
    }

    public void stopTesting(String string) {
        try {
            String string2 = this.server.SetTesting(string, 0, "STOP", null, 0);
        }
        catch (Exception exception) {
            System.err.println("Remote ERROR: " + exception);
        }
    }

    public void suspendTesting(String string) {
        try {
            String string2 = this.server.SetTesting(string, 0, "SUSPEND", null, 0);
        }
        catch (Exception exception) {
            System.err.println("Remote ERROR: " + exception);
        }
    }

    class Messenger
    extends Thread {
        HandleMessageRMI source;
        String text;
        String sourceHost;
        String hostName;
        private int retries = 0;
        private boolean done = false;
        Socket socket;
        BufferedReader input;

        public Messenger(String string, HandleMessageRMI handleMessageRMI, String string2) {
            this.source = handleMessageRMI;
            this.hostName = new String(string);
            this.sourceHost = new String(string2);
        }

        public void closeMsg() {
            try {
                this.input.close();
                if (Communicator.this.debug) {
                    System.out.println("close msg socket " + this.socket.toString());
                }
                this.socket.close();
                this.input = null;
                this.socket = null;
            }
            catch (Exception exception) {
                System.err.println("Can't close socket:" + exception);
            }
        }

        public void finished() {
            this.done = true;
        }

        private void openSocket() {
            try {
                String string = this.source.HandleMessage(this.hostName);
                if (Communicator.this.debug) {
                    System.out.println("Using port " + string);
                }
                Integer n = new Integer(string);
                File file = new File("/tmp/.srsconsolelock");
                if (file.exists()) {
                    file = null;
                    if (Communicator.this.debug) {
                        System.out.println("open socket for SRS-SunMC");
                    }
                    try {
                        this.socket = RMISocketFactory.getSocketFactory().createSocket(this.sourceHost, n);
                    }
                    catch (Exception exception) {
                        if (Communicator.this.debug) {
                            System.out.println("open socket for SRS-SunMC-NoNAT-");
                        }
                        this.socket = new Socket(this.sourceHost, (int)n);
                    }
                } else {
                    if (Communicator.this.debug) {
                        System.out.println("Try to open socket for Verbose Messages");
                    }
                    if (Communicator.this.debug) {
                        System.out.println("HWDS Server=" + this.sourceHost);
                    }
                    try {
                        this.socket = new Socket(this.sourceHost, (int)n);
                    }
                    catch (Exception exception) {
                        String string2 = null;
                        string2 = Communicator.this.server.retMultiIp();
                        if (string2 == null) {
                            if (Communicator.this.debug) {
                                System.out.println("No HWDS Server Found in multi-ip");
                            }
                            this.socket = null;
                        }
                        if (Communicator.this.debug) {
                            System.out.println("Try HWDS Server(multi)=" + string2);
                        }
                        try {
                            this.socket = new Socket(string2, (int)n);
                        }
                        catch (Exception exception2) {
                            if (Communicator.this.debug) {
                                System.out.println("ERROR for HWD Server=" + string2 + " " + exception2);
                            }
                            string2 = null;
                        }
                    }
                }
                if (this.socket == null) {
                    this.input = null;
                    System.err.println("openSocket:Can't open socket to HWDS Server for Verbose Messages");
                    return;
                }
                this.socket.setSoTimeout(5000);
                this.input = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                if (Communicator.this.debug) {
                    System.out.println("openSocket succesfull=" + this.socket.toString());
                }
            }
            catch (Exception exception) {
                System.err.println("openSocket: Can't open socket:" + exception);
                this.input = null;
            }
        }

        public void run() {
            boolean bl = false;
            if (Communicator.this.debug) {
                System.out.println("Waiting for sims");
            }
            this.openSocket();
            if (this.input == null) {
                this.done = true;
            }
            while (!this.done) {
                String string;
                int n;
                int n2;
                try {
                    this.text = this.input.readLine();
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (!this.done) continue;
                    break;
                }
                catch (Exception exception) {
                    System.err.println("Can't read socket:" + exception);
                    if (this.retries >= 3) {
                        Communicator.this.notifyCommEvent(4, null);
                        break;
                    }
                    ++this.retries;
                    bl = true;
                }
                if (bl) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println(interruptedException.toString());
                    }
                    this.closeMsg();
                    this.openSocket();
                    bl = false;
                    continue;
                }
                if (this.text == null) {
                    Communicator.this.notifyCommEvent(4, null);
                    break;
                }
                if (this.text.equals("Close HandleMessage Thread")) {
                    if (Communicator.this.debug) {
                        System.out.println("Close connection to sims");
                    }
                    this.done = true;
                    break;
                }
                if (this.text.equals("")) {
                    if (Communicator.this.debug) {
                        System.out.println("Lost connection to sims");
                    }
                    this.closeMsg();
                    this.openSocket();
                    continue;
                }
                if (this.text.length() < 3) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println(interruptedException.toString());
                    }
                    continue;
                }
                if (this.text.startsWith("IGNORE")) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println(interruptedException.toString());
                    }
                    continue;
                }
                if (Communicator.this.debug) {
                    System.out.println("data=" + this.text);
                }
                if ((n2 = this.text.indexOf("==")) < 0) continue;
                int n3 = this.text.lastIndexOf("==");
                if (n3 > n2) {
                    if (Communicator.this.debug) {
                        System.out.println("multiple messages");
                    }
                    n2 = n3;
                    if (Communicator.this.debug) {
                        System.out.println("length " + this.text.length() + ", newline " + this.text.lastIndexOf("\n"));
                    }
                }
                if ((n = (string = this.text.substring(n2)).indexOf("VERBOSE-DR-")) >= 0) {
                    Communicator.this.notifyCommEvent(5, string);
                    continue;
                }
                n = string.indexOf("VERBOSE-DRDONE-");
                if (n >= 0) {
                    Communicator.this.notifyCommEvent(6, string);
                    continue;
                }
                n = string.indexOf("VERBOSE-DRERROR-");
                if (n >= 0) {
                    Communicator.this.notifyCommEvent(7, string);
                    continue;
                }
                int n4 = string.indexOf("VERBOSE");
                int n5 = string.indexOf("WARNING");
                int n6 = string.indexOf("INFO");
                int n7 = this.text.indexOf("=66666=");
                int n8 = this.text.indexOf("=77777=");
                if (n4 > 0 || n5 > 0) {
                    Communicator.this.notifyCommEvent(0, string);
                    continue;
                }
                if (n8 > 0) {
                    Communicator.this.notifyCommEvent(3, this.text);
                    continue;
                }
                if (n6 > 0) {
                    Communicator.this.notifyCommEvent(1, string);
                    continue;
                }
                if (n7 > 0) {
                    Communicator.this.notifyCommEvent(2, this.text);
                    continue;
                }
                if (!Communicator.this.debug) continue;
                System.out.println("got " + this.text);
            }
            this.closeMsg();
        }
    }
}

