/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.filter;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.config.SMConfig;
import com.sun.symon.base.client.config.SMPlatformName;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.group.SMFilter;
import com.sun.symon.base.client.group.SMFilterCriteria;
import com.sun.symon.base.client.group.SMFilterData;
import com.sun.symon.base.client.group.SMFilterInfo;
import com.sun.symon.base.client.group.SMIPRangeCriteria;
import com.sun.symon.base.client.group.SMModuleCriteria;
import com.sun.symon.base.client.group.SMNameCriteria;
import com.sun.symon.base.client.group.SMOSCriteria;
import com.sun.symon.base.client.group.SMPlatformCriteria;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDBChangeListener;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMHandle;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.console.grouping.CgDialogContainer;
import com.sun.symon.base.console.grouping.CgDialogInterface;
import com.sun.symon.base.console.grouping.CgUtil;
import com.sun.symon.base.console.grouping.filter.CgFilterDataPanel;
import com.sun.symon.base.console.grouping.filter.CgFilterSubPanel;
import com.sun.symon.base.console.grouping.table.CgData;
import com.sun.symon.base.console.grouping.table.CgRowSaveEvent;
import com.sun.symon.base.console.grouping.table.CgRowSaveListener;
import com.sun.symon.base.console.grouping.table.CgRowTransEvent;
import com.sun.symon.base.console.grouping.table.CgTable;
import com.sun.symon.base.console.grouping.table.CgTblColumnFormat;
import com.sun.symon.base.console.grouping.table.CgTblPane;
import com.sun.symon.base.console.grouping.table.CgTblSelectEvent;
import com.sun.symon.base.console.grouping.table.CgTblSelectListener;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcConfirmDialog;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcThreadWorker;
import com.sun.symon.base.utility.UcURL;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.PlainDocument;

public class CgFilterManagerDlg
extends JDialog
implements ActionListener,
SMDBChangeListener,
CgTblSelectListener,
CgRowSaveListener,
CgDialogInterface,
DocumentListener {
    static final String FILTER = "filter";
    private JTextArea descArea;
    private JCheckBox host;
    private JTextField hostPattern = new JTextField("", 18);
    private JComboBox hostMenu = new JComboBox();
    private JButton delete;
    private JButton save;
    private JButton ok;
    private JButton apply;
    private JButton cancel;
    private JButton help;
    private JCheckBox iPAddress;
    private JTextField fromIP;
    private JTextField toIP;
    private JLabel status = new JLabel("");
    private CgFilterDataPanel filterDataPanel;
    private CgFilterSubPanel platformPanel;
    private CgFilterSubPanel osPanel;
    private CgFilterSubPanel modulePanel;
    private SMRawDataRequest rawRequest;
    private SMFilter filter = null;
    private SMFilterInfo[] filterInfo;
    Hashtable platformHash;
    private CgTblPane fltTable;
    private CgTable cgTable;
    private Frame owner;
    private boolean selfFilter = false;
    CgFilterManagerDlg filterManager;
    private int workingRow = -1;
    String exactMatch;
    String contains;
    String startsWith;
    String endsWith;
    String hostpattern;
    Hashtable moduleName2InterHash = new Hashtable();
    Hashtable moduleInter2NameHash = new Hashtable();
    static final String MDR_INSTANCE_NAME = "[Metadata Repository]";
    boolean isClose = true;

    public CgFilterManagerDlg(Frame frame) throws SMAPIException {
        this(frame, (SMFilter)null);
    }

    public CgFilterManagerDlg(Frame frame, SMFilter sMFilter) throws SMAPIException {
        super(frame);
        this.setDefaultCloseOperation(0);
        this.owner = frame;
        this.filterManager = this;
        this.rawRequest = SMConsoleContext.getInstance().getAPIHandle();
        UcCommon.isServiceLicenseAvailable((String)"Group_Filter", (Component)this);
        if (sMFilter == null) {
            this.filter = new SMFilter(this.rawRequest);
            this.selfFilter = true;
        } else {
            this.filter = sMFilter;
        }
        try {
            this.filter.addDBChangeListener((SMDBChangeListener)this);
            this.exactMatch = this.translate("exactMatch");
            this.contains = this.translate("contains");
            this.startsWith = this.translate("startsWith");
            this.endsWith = this.translate("endsWith");
            this.hostpattern = this.translate("hostPattern");
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)this.translate("noService"));
        }
        this.createGUI();
        this.initGUI();
        this.pack();
        this.addListener();
        this.cgTable.setRowSelectionInterval(0, 0);
    }

    static /* synthetic */ CgFilterSubPanel access$10(CgFilterManagerDlg cgFilterManagerDlg) {
        return cgFilterManagerDlg.modulePanel;
    }

    static /* synthetic */ JComboBox access$11(CgFilterManagerDlg cgFilterManagerDlg) {
        return cgFilterManagerDlg.hostMenu;
    }

    static /* synthetic */ JTextField access$12(CgFilterManagerDlg cgFilterManagerDlg) {
        return cgFilterManagerDlg.hostPattern;
    }

    static /* synthetic */ JTextArea access$4(CgFilterManagerDlg cgFilterManagerDlg) {
        return cgFilterManagerDlg.descArea;
    }

    static /* synthetic */ CgTblPane access$5(CgFilterManagerDlg cgFilterManagerDlg) {
        return cgFilterManagerDlg.fltTable;
    }

    static /* synthetic */ JTextField access$6(CgFilterManagerDlg cgFilterManagerDlg) {
        return cgFilterManagerDlg.fromIP;
    }

    static /* synthetic */ JTextField access$7(CgFilterManagerDlg cgFilterManagerDlg) {
        return cgFilterManagerDlg.toIP;
    }

    static /* synthetic */ CgFilterSubPanel access$8(CgFilterManagerDlg cgFilterManagerDlg) {
        return cgFilterManagerDlg.platformPanel;
    }

    static /* synthetic */ CgFilterSubPanel access$9(CgFilterManagerDlg cgFilterManagerDlg) {
        return cgFilterManagerDlg.osPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.iPAddress) {
            this.iPAddressActivated(this.iPAddress.isSelected());
        } else if (object == this.delete) {
            this.deleteActivated();
        } else if (object == this.ok) {
            this.saveActivated();
        } else if (object == this.apply) {
            this.applyActivated();
        } else if (object == this.cancel) {
            this.close();
        } else if (object == this.help) {
            this.helpActivated();
        } else if (object == this.host) {
            this.hostActivated(this.host.isSelected());
        }
    }

    public void addListener() {
        this.delete.addActionListener(this);
        this.host.addActionListener(this);
        this.iPAddress.addActionListener(this);
        this.ok.addActionListener(this);
        this.apply.addActionListener(this);
        this.cancel.addActionListener(this);
        this.help.addActionListener(this);
        this.fltTable.addCgTblSelectListener(this);
        this.fltTable.addCgRowSaveListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CgFilterManagerDlg.this.cancel.doClick();
            }
        });
    }

    public void applyActivated() {
        int n = this.cgTable.getSelectedRow();
        if (n < 0) {
            this.isClose = false;
            UcDialog.showError((Component)this, (Object)this.translate("noSelRowError"));
            return;
        }
        Vector vector = this.fltTable.getRowData(n);
        if (vector.elementAt(0) == null) {
            this.isClose = false;
            UcDialog.showError((Component)this, (Object)this.translate("nullFilterName"));
            return;
        }
        String string = ((CgData)vector.elementAt(0)).getLabel();
        if (string == null || string.length() == 0) {
            UcDialog.showError((Component)this, (Object)this.translate("nullFilterName"));
            this.isClose = false;
            return;
        }
        if (string.length() > 32) {
            UcDialog.showError((Component)this, (Object)(String.valueOf(this.translate("filterNameError")) + " " + 32));
            this.isClose = false;
            return;
        }
        SMFilterData sMFilterData = this.createFilterData(n);
        if (sMFilterData != null && CgUtil.saveObj((SMHandle)this.filter, (SMDBObject)sMFilterData)) {
            this.fltTable.transactionFinished(new CgRowTransEvent(this, 0));
        }
    }

    public void cgTableActivated() {
        if (this.workingRow == this.cgTable.getSelectedRow()) {
            return;
        }
        this.cleanGUI();
        this.ok.setEnabled(true);
        this.apply.setEnabled(true);
        this.workingRow = this.cgTable.getSelectedRow();
        if (this.filterInfo != null && (this.workingRow < 0 || this.workingRow >= this.filterInfo.length)) {
            this.delete.setEnabled(false);
            return;
        }
        this.delete.setEnabled(true);
        Runnable runnable = new Runnable(){

            public void run() {
                String string = ((CgData)CgFilterManagerDlg.this.cgTable.getValueAt(CgFilterManagerDlg.this.workingRow, 0)).getLabel();
                SMFilterData sMFilterData = null;
                try {
                    sMFilterData = CgFilterManagerDlg.this.filter.load(string);
                }
                catch (SMAPIException sMAPIException) {
                    CgUtil.handleAPIException(sMAPIException, CgFilterManagerDlg.this.filterManager);
                    return;
                }
                SMFilterData sMFilterData2 = sMFilterData;
                Runnable runnable = new Runnable(sMFilterData2, CgFilterManagerDlg.this){
                    private final /* synthetic */ SMFilterData val$filterData;
                    private final /* synthetic */ CgFilterManagerDlg this$0;
                    {
                        this.val$filterData = sMFilterData;
                        this.this$0 = cgFilterManagerDlg;
                    }

                    public void run() {
                        CgFilterManagerDlg.access$4(this.this$0).setText(this.val$filterData.getDescription());
                        CgFilterManagerDlg.access$5(this.this$0).setTableDataUpdated(false);
                        SMFilterCriteria[] sMFilterCriteriaArray = this.val$filterData.getFilterCriteria();
                        if (sMFilterCriteriaArray == null) {
                            return;
                        }
                        int n = 0;
                        while (n < sMFilterCriteriaArray.length) {
                            int n2;
                            Object object;
                            Object object2;
                            if (sMFilterCriteriaArray[n] instanceof SMIPRangeCriteria) {
                                this.this$0.iPAddressActivated(true);
                                CgFilterManagerDlg.access$6(this.this$0).setText(((SMIPRangeCriteria)sMFilterCriteriaArray[n]).getFromAddress());
                                CgFilterManagerDlg.access$7(this.this$0).setText(((SMIPRangeCriteria)sMFilterCriteriaArray[n]).getToAddress());
                            } else if (sMFilterCriteriaArray[n] instanceof SMPlatformCriteria) {
                                CgFilterManagerDlg.access$8(this.this$0).setStatus(true);
                                object2 = (DefaultListModel)CgFilterManagerDlg.access$8(this.this$0).getList().getModel();
                                object = ((SMPlatformCriteria)sMFilterCriteriaArray[n]).getList();
                                n2 = 0;
                                while (n2 < ((String[])object).length) {
                                    SMPlatformName sMPlatformName = (SMPlatformName)this.this$0.platformHash.get(object[n2]);
                                    if (sMPlatformName != null) {
                                        ((DefaultListModel)object2).addElement(sMPlatformName);
                                    }
                                    ++n2;
                                }
                                CgFilterManagerDlg.access$8(this.this$0).getList().setModel(object2);
                                if (CgFilterManagerDlg.access$8(this.this$0).getList().isShowing()) {
                                    CgFilterManagerDlg.access$8(this.this$0).getList().revalidate();
                                }
                                if (((SMPlatformCriteria)sMFilterCriteriaArray[n]).isInclude()) {
                                    CgFilterManagerDlg.access$8(this.this$0).setIncludeSelected();
                                } else {
                                    CgFilterManagerDlg.access$8(this.this$0).setExcludeSelected();
                                }
                            } else if (sMFilterCriteriaArray[n] instanceof SMOSCriteria) {
                                CgFilterManagerDlg.access$9(this.this$0).setStatus(true);
                                object2 = (DefaultListModel)CgFilterManagerDlg.access$9(this.this$0).getList().getModel();
                                object = ((SMOSCriteria)sMFilterCriteriaArray[n]).getList();
                                n2 = 0;
                                while (n2 < ((String[])object).length) {
                                    ((DefaultListModel)object2).addElement(object[n2]);
                                    ++n2;
                                }
                                CgFilterManagerDlg.access$9(this.this$0).getList().setModel(object2);
                                if (CgFilterManagerDlg.access$9(this.this$0).getList().isShowing()) {
                                    CgFilterManagerDlg.access$9(this.this$0).getList().revalidate();
                                }
                                if (((SMOSCriteria)sMFilterCriteriaArray[n]).isInclude()) {
                                    CgFilterManagerDlg.access$9(this.this$0).setIncludeSelected();
                                } else {
                                    CgFilterManagerDlg.access$9(this.this$0).setExcludeSelected();
                                }
                            } else if (sMFilterCriteriaArray[n] instanceof SMModuleCriteria) {
                                CgFilterManagerDlg.access$10(this.this$0).setStatus(true);
                                object2 = (DefaultListModel)CgFilterManagerDlg.access$10(this.this$0).getList().getModel();
                                object = ((SMModuleCriteria)sMFilterCriteriaArray[n]).getList();
                                n2 = 0;
                                while (n2 < ((String[])object).length) {
                                    ((DefaultListModel)object2).addElement(this.this$0.moduleInter2NameHash.get(object[n2]));
                                    ++n2;
                                }
                                CgFilterManagerDlg.access$10(this.this$0).getList().setModel(object2);
                                if (CgFilterManagerDlg.access$10(this.this$0).getList().isShowing()) {
                                    CgFilterManagerDlg.access$10(this.this$0).getList().revalidate();
                                }
                                if (((SMModuleCriteria)sMFilterCriteriaArray[n]).isInclude()) {
                                    CgFilterManagerDlg.access$10(this.this$0).setIncludeSelected();
                                } else {
                                    CgFilterManagerDlg.access$10(this.this$0).setExcludeSelected();
                                }
                            } else if (sMFilterCriteriaArray[n] instanceof SMNameCriteria) {
                                this.this$0.hostActivated(true);
                                object2 = ((SMNameCriteria)sMFilterCriteriaArray[n]).getMatchType();
                                object = this.this$0.exactMatch;
                                if (((String)object2).equals("C")) {
                                    object = this.this$0.contains;
                                } else if (((String)object2).equals("S")) {
                                    object = this.this$0.startsWith;
                                } else if (((String)object2).equals("E")) {
                                    object = this.this$0.endsWith;
                                }
                                CgFilterManagerDlg.access$11(this.this$0).setSelectedItem(object);
                                CgFilterManagerDlg.access$12(this.this$0).setText(((SMNameCriteria)sMFilterCriteriaArray[n]).getPattern());
                            }
                            ++n;
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        };
        new Thread(runnable).start();
    }

    public void changed(SMDBChangeEvent sMDBChangeEvent) {
        this.setFilterTableData();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.fltTable.setTableDataUpdated(true);
    }

    public void cleanGUI() {
        this.descArea.setText("");
        this.fltTable.setTableDataUpdated(false);
        this.hostActivated(false);
        this.platformPanel.setStatus(false);
        this.osPanel.setStatus(false);
        this.modulePanel.setStatus(false);
        this.iPAddressActivated(false);
    }

    /*
     * Unable to fully structure code
     */
    public void close() {
        if (this.fltTable.isTableDataUpdated() && (var2_2 = UcDialog.showOkCancel((String)(var1_1 = CgUtil.getI18nMsg("TaskManager.closeMsg")))) == 1) {
            return;
        }
        CgUtil.removeDialogFromPool("filter");
        if (this.selfFilter) {
            try {
                if (this.filter == null) ** GOTO lbl18
                this.filter.close();
                this.filter = null;
            }
            catch (SMAPIException v0) {
                UcDialog.showError((Component)this, (Object)this.translate("APIError"));
                return;
            }
        } else {
            try {
                this.filter.removeDBChangeListener((SMDBChangeListener)this);
            }
            catch (Exception v1) {}
        }
lbl18:
        // 4 sources

        if (this.owner != null && this.owner instanceof CgDialogContainer) {
            ((CgDialogContainer)this.owner).removeDialogFromPool("filter");
        }
        this.dispose();
    }

    public SMFilterCriteria[] createCriteria() {
        int n;
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        if (this.host.isSelected() && this.hostPattern.getText().trim().length() != 0) {
            object2 = (Object[])this.hostMenu.getSelectedItem();
            object = "X";
            if (((String)object2).equals(this.contains)) {
                object = "C";
            } else if (((String)object2).equals(this.startsWith)) {
                object = "S";
            } else if (((String)object2).equals(this.endsWith)) {
                object = "E";
            }
            try {
                vector.addElement(new SMNameCriteria((String)object, this.hostPattern.getText(), true));
            }
            catch (SMLengthException sMLengthException) {
                UcDialog.showError((Component)this, (Object)(String.valueOf(this.hostpattern) + " " + sMLengthException.getMessage()));
                return null;
            }
        }
        if (this.platformPanel.getCheckBoxSelected() && ((Object[])(object2 = ((DefaultListModel)this.platformPanel.getList().getModel()).toArray())).length != 0) {
            try {
                object = new String[((Object[])object2).length];
                n = 0;
                while (n < ((Object[])object2).length) {
                    object[n] = ((SMPlatformName)object2[n]).getName();
                    ++n;
                }
                vector.addElement(new SMPlatformCriteria((String[])object, this.platformPanel.getIncludeSelected(), true));
            }
            catch (SMLengthException sMLengthException) {
                UcDialog.showError((Component)this, (Object)(String.valueOf(this.translate("platformType")) + " " + sMLengthException.getMessage()));
                return null;
            }
        }
        if (this.osPanel.getCheckBoxSelected() && ((Object[])(object2 = ((DefaultListModel)this.osPanel.getList().getModel()).toArray())).length != 0) {
            try {
                object = new String[((Object[])object2).length];
                n = 0;
                while (n < ((Object)object2).length) {
                    object[n] = (String)object2[n];
                    ++n;
                }
                vector.addElement(new SMOSCriteria((String[])object, this.osPanel.getIncludeSelected(), true));
            }
            catch (SMLengthException sMLengthException) {
                UcDialog.showError((Component)this, (Object)(String.valueOf(this.translate("os")) + " " + sMLengthException.getMessage()));
                return null;
            }
        }
        if (this.modulePanel.getCheckBoxSelected() && ((Object[])(object2 = ((DefaultListModel)this.modulePanel.getList().getModel()).toArray())).length != 0) {
            try {
                object = new String[((Object[])object2).length];
                n = 0;
                while (n < ((Object)object2).length) {
                    String string = (String)object2[n];
                    object[n] = (String)this.moduleName2InterHash.get(string);
                    ++n;
                }
                vector.addElement(new SMModuleCriteria((String[])object, this.modulePanel.getIncludeSelected(), true));
            }
            catch (SMLengthException sMLengthException) {
                UcDialog.showError((Component)this, (Object)(String.valueOf(this.translate("modules")) + " " + sMLengthException.getMessage()));
                return null;
            }
        }
        if (this.iPAddress.isSelected()) {
            object2 = this.fromIP.getText().trim();
            object = this.toIP.getText().trim();
            n = 1;
            if (((String)object2).length() > 0 && !UcURL.validateIpAddress((String)object2)) {
                n = 0;
            }
            if (((String)object).length() > 0 && !UcURL.validateIpAddress((String)object)) {
                n = 0;
            }
            if (n == 0) {
                UcDialog.showError((Component)this, (Object)this.translate("ipAddressInvalid"));
                return null;
            }
            if (((String)object).length() > 0 && ((String)object2).length() > 0) {
                try {
                    vector.addElement(new SMIPRangeCriteria(this.fromIP.getText(), this.toIP.getText(), true));
                }
                catch (SMLengthException sMLengthException) {
                    UcDialog.showError((Component)this, (Object)(String.valueOf(this.translate("ipAddresses")) + ": " + sMLengthException.getMessage()));
                    return null;
                }
            }
        }
        int n2 = vector.size();
        object = new SMFilterCriteria[n2];
        n = 0;
        while (n < n2) {
            object[n] = (SMFilterCriteria)vector.get(n);
            ++n;
        }
        return object;
    }

    SMFilterData createFilterData(int n) {
        if (n == -1) {
            return null;
        }
        Vector vector = this.fltTable.getRowData(n);
        if (vector.elementAt(0) == null) {
            return null;
        }
        String string = ((CgData)vector.elementAt(0)).getLabel();
        SMFilterData sMFilterData = null;
        if (this.filterInfo == null) {
            return sMFilterData;
        }
        if (n >= this.filterInfo.length) {
            sMFilterData = new SMFilterData();
            try {
                sMFilterData.setName(string);
            }
            catch (SMLengthException sMLengthException) {
                return null;
            }
        }
        SMFilterCriteria[] sMFilterCriteriaArray = this.filterInfo[n].getName();
        try {
            sMFilterData = this.filter.load((String)sMFilterCriteriaArray);
        }
        catch (SMAPIException sMAPIException) {
            CgUtil.handleAPIException(sMAPIException, this);
            return null;
        }
        try {
            sMFilterData.setName(string);
            sMFilterData.setDescription(this.descArea.getText());
        }
        catch (SMLengthException sMLengthException) {
            UcDialog.showError((Component)this, (Object)(String.valueOf(this.translate("filterDescriptionError")) + " " + 256 + "\n" + sMLengthException.getMessage()));
            return null;
        }
        sMFilterCriteriaArray = this.createCriteria();
        if (sMFilterCriteriaArray != null) {
            sMFilterData.setFilterCriteria(sMFilterCriteriaArray);
        }
        return sMFilterData;
    }

    public void createGUI() {
        this.host = new JCheckBox(this.translate("hostOrObjectLabel"));
        this.ok = new JButton(this.translate("ok"));
        this.apply = new JButton(this.translate("apply"));
        this.cancel = new JButton(this.translate("cancel"));
        this.help = new JButton(this.translate("help"));
        this.iPAddress = new JCheckBox(String.valueOf(this.translate("ipAddresses")) + ":");
        this.fromIP = new JTextField(this.translate("ipDigitAddress"), 16);
        this.fromIP.setBackground(UcCommon.getLightGrayColor());
        this.toIP = new JTextField(this.translate("ipDigitAddress"), 16);
        this.toIP.setBackground(UcCommon.getLightGrayColor());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(12, 6, 12, 6));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(this.translate("filters"));
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 12);
        gridBagConstraints.fill = 1;
        CgTblColumnFormat[] cgTblColumnFormatArray = new CgTblColumnFormat[]{new CgTblColumnFormat(this.translate("name"), true, null, null)};
        this.fltTable = new CgTblPane(cgTblColumnFormatArray, true);
        this.cgTable = this.fltTable.getTable();
        this.cgTable.setRowHeight(17);
        this.cgTable.setPreferredScrollableViewportSize(new Dimension(400, 68));
        jPanel2.add((Component)this.fltTable, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        gridBagConstraints.fill = 2;
        this.delete = new JButton(this.translate("delete"));
        jPanel2.add((Component)this.delete, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.translate("description"));
        jPanel2.add((Component)jLabel, gridBagConstraints);
        PlainDocument plainDocument = new PlainDocument();
        plainDocument.addDocumentListener(this);
        this.descArea = new JTextArea(plainDocument);
        this.descArea.setRows(2);
        this.descArea.setLineWrap(true);
        this.descArea.setWrapStyleWord(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 0, 12);
        JScrollPane jScrollPane = new JScrollPane(this.descArea);
        jPanel2.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.host, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 24, 0, 6);
        gridBagConstraints.fill = 2;
        this.hostMenu.addItem(this.exactMatch);
        this.hostMenu.addItem(this.contains);
        this.hostMenu.addItem(this.startsWith);
        this.hostMenu.addItem(this.endsWith);
        this.hostMenu.setPreferredSize(new Dimension(220, 25));
        jPanel2.add((Component)this.hostMenu, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 12);
        gridBagConstraints.fill = 2;
        this.hostPattern.setBackground(UcCommon.getLightGrayColor());
        jPanel2.add((Component)this.hostPattern, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        this.filterDataPanel = new CgFilterDataPanel(null);
        jPanel2.add((Component)this.filterDataPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.iPAddress, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new JLabel(this.translate("from")));
        jPanel3.add(this.fromIP);
        jPanel3.add(new JLabel(this.translate("to")));
        jPanel3.add(this.toIP);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel3, "West");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 18, 0, 0);
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new EmptyBorder(12, 12, 12, 12));
        jPanel5.add(this.ok);
        jPanel5.add(this.apply);
        jPanel5.add(this.cancel);
        jPanel5.add(this.help);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)new JSeparator(), "North");
        jPanel6.add((Component)jPanel5, "East");
        jPanel.add(jPanel6);
        this.getContentPane().add(jPanel);
        this.setTitle(this.translate("fltTitle"));
    }

    public void deleteActivated() {
        String[] stringArray = new String[]{this.translate("delete"), this.translate("cancel")};
        JLabel jLabel = new JLabel(this.translate("confirmDelete"));
        jLabel.setFont(new Font("Dialog", 0, 12));
        jLabel.setForeground(Color.black);
        String[] stringArray2 = new String[]{CgUtil.getI18nMsg("standard.delete"), CgUtil.getI18nMsg("standard.cancel")};
        UcConfirmDialog ucConfirmDialog = new UcConfirmDialog((Dialog)this, CgUtil.getI18nMsg("standard.warning"), CgUtil.getI18nMsg("standard.deleteBoldMsg"), CgUtil.getI18nMsg("fltMgr.delPlainMsg"), stringArray2);
        ucConfirmDialog.pack();
        ucConfirmDialog.setLocationRelativeTo(this);
        ucConfirmDialog.setVisible(true);
        if (ucConfirmDialog.getClicked() == 1) {
            return;
        }
        SMFilterData sMFilterData = null;
        try {
            sMFilterData = this.filter.load(((CgData)this.fltTable.getValueAt(this.fltTable.getSelectedRow(), 0)).getLabel());
        }
        catch (SMAPIException sMAPIException) {
            CgUtil.handleAPIException(sMAPIException, this);
            return;
        }
        if (sMFilterData != null) {
            try {
                this.filter.delete(sMFilterData.getObjectID());
            }
            catch (SMAPIException sMAPIException) {
                CgUtil.handleAPIException(sMAPIException, this);
                return;
            }
        }
        this.cleanGUI();
        this.cgTable.setRowSelectionInterval(0, 0);
        if (this.cgTable.getRowCount() <= 1) {
            this.delete.setEnabled(false);
        }
    }

    public SMFilterInfo[] getFilterInfo() {
        SMFilterInfo[] sMFilterInfoArray = null;
        try {
            sMFilterInfoArray = this.filter.getAll();
        }
        catch (SMAPIException sMAPIException) {
            final SMAPIException sMAPIException2 = sMAPIException;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CgUtil.handleAPIException(sMAPIException2, filterManager);
                }
            });
        }
        return sMFilterInfoArray;
    }

    public static String[] getMDRModNames(SMRawDataRequest sMRawDataRequest, Hashtable hashtable, Hashtable hashtable2) {
        String string = sMRawDataRequest.getMDRBaseURL();
        if (string == null && string.equals("")) {
            return null;
        }
        UcURL ucURL = new UcURL(string);
        String string2 = ucURL.getHost();
        String string3 = ucURL.getPort();
        String[][] stringArray = null;
        try {
            SMModuleRequest sMModuleRequest = new SMModuleRequest(sMRawDataRequest);
            stringArray = sMModuleRequest.getLoadedModuleInfo(string2, Integer.parseInt(string3));
        }
        catch (SMAPIException sMAPIException) {
            return null;
        }
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string4;
            String string5 = stringArray[n2][0];
            int n3 = string5.indexOf(MDR_INSTANCE_NAME);
            if (n3 > 0) {
                string5 = stringArray[n2][0].substring(0, n3);
            }
            stringArray2[n2] = string5;
            String string6 = stringArray[n2][1];
            UcAgentURL ucAgentURL = new UcAgentURL(string6);
            String string7 = string4 = ucAgentURL.getModuleId();
            int n4 = string4.indexOf(43);
            if (n4 > 0) {
                string7 = string4.substring(0, n4);
            }
            hashtable.put(string5, string7);
            hashtable2.put(string7, string5);
            ++n2;
        }
        return stringArray2;
    }

    public void helpActivated() {
        CmConsoleSession.getInstance().launchHelp("grouping-filter-manager-help");
    }

    public void hostActivated(boolean bl) {
        this.host.setSelected(bl);
        this.hostMenu.setEnabled(bl);
        this.hostPattern.setEnabled(bl);
        this.hostPattern.setText("");
    }

    public void iPAddressActivated(boolean bl) {
        this.iPAddress.setSelected(bl);
        this.fromIP.setEnabled(bl);
        this.fromIP.setText("");
        this.toIP.setEnabled(bl);
        this.toIP.setText("");
    }

    public void initGUI() throws SMAPIException {
        this.setFilterTableData();
        SMConfig sMConfig = new SMConfig(this.rawRequest);
        this.platformPanel = this.filterDataPanel.getPlatformPanel();
        this.osPanel = this.filterDataPanel.getOSPanel();
        this.modulePanel = this.filterDataPanel.getModulePanel();
        Object[] objectArray = sMConfig.getPlatformNames();
        this.platformHash = new Hashtable();
        int n = 0;
        while (n < objectArray.length) {
            this.platformHash.put(objectArray[n].getName(), objectArray[n]);
            ++n;
        }
        this.platformPanel.setTypeList(objectArray);
        this.osPanel.setTypeList(sMConfig.getOperatingSystems());
        sMConfig.close();
        Object[] objectArray2 = CgFilterManagerDlg.getMDRModNames(this.rawRequest, this.moduleName2InterHash, this.moduleInter2NameHash);
        if (objectArray2 != null) {
            this.modulePanel.setTypeList(objectArray2);
        }
        this.host.setSelected(true);
        this.delete.setEnabled(false);
        this.hostActivated(false);
        this.fromIP.setEnabled(false);
        this.toIP.setEnabled(false);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.fltTable.setTableDataUpdated(true);
    }

    public static void main(String[] stringArray) {
        UcThreadWorker ucThreadWorker = new UcThreadWorker(){

            public void doWork() {
                CgFilterManagerDlg.showUniqueInstance();
            }
        };
        ucThreadWorker.start();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.fltTable.setTableDataUpdated(true);
    }

    public void saveActivated() {
        this.applyActivated();
        if (this.isClose) {
            this.close();
        }
        this.isClose = true;
    }

    public boolean saveData(CgRowSaveEvent cgRowSaveEvent) {
        int n = this.cgTable.getSelectedRow();
        if (n < 0) {
            UcDialog.showError((Component)this, (Object)this.translate("noSelRowError"));
            return false;
        }
        Vector vector = this.fltTable.getRowData(n);
        if (vector.elementAt(0) == null) {
            UcDialog.showError((Component)this, (Object)this.translate("nullFilterName"));
            return false;
        }
        String string = ((CgData)vector.elementAt(0)).getLabel();
        if (string == null || string.length() == 0) {
            UcDialog.showError((Component)this, (Object)this.translate("nullFilterName"));
            return false;
        }
        if (string.length() > 32) {
            UcDialog.showError((Component)this, (Object)(String.valueOf(this.translate("filterNameError")) + " " + 32));
            return false;
        }
        SMFilterData sMFilterData = this.createFilterData(n);
        if (sMFilterData != null && CgUtil.saveObj((SMHandle)this.filter, (SMDBObject)sMFilterData)) {
            this.fltTable.transactionFinished(new CgRowTransEvent(this, 0));
            return true;
        }
        return false;
    }

    public void selectionOccurred(CgTblSelectEvent cgTblSelectEvent) {
        this.cgTableActivated();
    }

    public void setFilterTableData() {
        this.filterInfo = null;
        this.filterInfo = this.getFilterInfo();
        if (this.filterInfo == null) {
            return;
        }
        CgData[][] cgDataArray = new CgData[this.filterInfo.length][1];
        int n = 0;
        while (n < this.filterInfo.length) {
            cgDataArray[n][0] = new CgData(this.filterInfo[n].getName());
            ++n;
        }
        this.fltTable.setData(cgDataArray);
        this.fltTable.setRowSelectionInterval(0, 0);
    }

    public static void showUniqueInstance() {
        JDialog jDialog = CgUtil.getDialogFromPool(FILTER);
        if (jDialog == null) {
            CmConsoleSession cmConsoleSession = CmConsoleSession.getInstance();
            Frame frame = cmConsoleSession.getMainWindowFrame();
            if (frame == null) {
                frame = JOptionPane.getRootFrame();
            }
            frame.setCursor(new Cursor(3));
            try {
                jDialog = new CgFilterManagerDlg(frame);
            }
            catch (SMAPIException sMAPIException) {
                UcDialog.showError((Component)frame, (Object)UcInternationalizer.translateKey((String)"com.sun.symon.base.console.grouping.filter.CgFilterBundle:noService"));
                frame.setCursor(new Cursor(0));
                return;
            }
            jDialog.pack();
            jDialog.setLocationRelativeTo(frame);
            frame.setCursor(new Cursor(0));
            CgUtil.addDialogToPool(FILTER, jDialog);
        }
        ((Component)jDialog).setVisible(true);
    }

    public String translate(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.base.console.grouping.filter.CgFilterBundle:" + string));
    }
}

