/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.view;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.service.SMDBChangeListener;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDBRemoteChangeListener;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMHandle;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.service.SMStaleDataException;
import com.sun.symon.base.client.service.SMWrongTypeException;
import com.sun.symon.base.client.view.SMRemoteView;
import com.sun.symon.base.client.view.SMViewConstants;
import com.sun.symon.base.client.view.SMViewData;
import com.sun.symon.base.client.view.SMViewInfo;
import java.rmi.RemoteException;
import java.util.Locale;

public class SMView
extends SMHandle
implements SMViewConstants {
    protected SMRemoteView serviceHandle;
    protected SMRawDataRequest handle;
    protected Locale locale;
    protected int serviceType;

    public SMView(SMRawDataRequest sMRawDataRequest) throws SMAPIException {
        super(sMRawDataRequest);
        this.handle = sMRawDataRequest;
        this.locale = this.handle.getLocale();
        this.serviceType = 0;
        this.serviceHandle = (SMRemoteView)this.handle.getService("View_ViewService");
        this.setHandle(this.serviceHandle);
    }

    public void addViewChangeListener(SMDBChangeListener sMDBChangeListener) throws SMAPIException {
        try {
            SMDBRemoteChangeListener sMDBRemoteChangeListener = this.newRemoteChangeListener(sMDBChangeListener);
            this.serviceHandle.addViewChangeListener(sMDBRemoteChangeListener, this.serviceType);
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            throw new SMAPIException(exception.getMessage());
        }
    }

    public void close() throws SMAPIException {
        try {
            super.close();
            this.serviceHandle.close();
            this.serviceHandle = null;
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException);
        }
    }

    public void delete(SMDBObjectID sMDBObjectID) throws SMAPIException, SMSecurityException, SMDatabaseException, SMNoSuchObjectException {
        try {
            this.serviceHandle.delete(sMDBObjectID, this.serviceType);
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException.getMessage());
        }
    }

    public void delete(SMViewInfo sMViewInfo) throws SMAPIException, SMSecurityException, SMDatabaseException, SMNoSuchObjectException {
        try {
            this.serviceHandle.delete(sMViewInfo.getObjectID(), this.serviceType);
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException.getMessage());
        }
    }

    public SMViewInfo[] getAll() throws SMAPIException, SMSecurityException, SMDatabaseException {
        try {
            return this.serviceHandle.getAll();
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException.getMessage());
        }
    }

    public SMDBObject[] getAllObjs() throws SMAPIException, SMSecurityException, SMDatabaseException {
        return this.getAll();
    }

    public SMViewData load(SMDBObjectID sMDBObjectID) throws SMAPIException, SMSecurityException, SMDatabaseException {
        try {
            return this.serviceHandle.load(sMDBObjectID);
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException.getMessage());
        }
    }

    public SMViewData load(SMViewInfo sMViewInfo) throws SMAPIException, SMSecurityException, SMDatabaseException {
        try {
            return this.serviceHandle.load(sMViewInfo.getObjectID());
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException.getMessage());
        }
    }

    public SMViewData load(String string, String string2) throws SMAPIException, SMSecurityException, SMDatabaseException {
        try {
            return this.serviceHandle.load(string, string2, this.serviceType);
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException.getMessage());
        }
    }

    public SMDBObject loadInfoObj(SMDBObjectID sMDBObjectID) throws SMAPIException, SMDatabaseException, SMSecurityException {
        return this.load(sMDBObjectID);
    }

    public SMDBObject loadObj(SMDBObjectID sMDBObjectID) throws SMAPIException, SMDatabaseException, SMSecurityException {
        return this.load(sMDBObjectID);
    }

    public SMDBObject loadObj(String string) throws SMAPIException, SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        return this.load(string, this.getDomainName());
    }

    public void removeViewChangeListener(SMDBChangeListener sMDBChangeListener) throws SMAPIException {
        try {
            SMDBRemoteChangeListener sMDBRemoteChangeListener = this.findRemoteChangeListener(sMDBChangeListener);
            if (sMDBRemoteChangeListener != null) {
                this.serviceHandle.removeViewChangeListener(sMDBRemoteChangeListener, this.serviceType);
            }
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            throw new SMAPIException(exception.getMessage());
        }
    }

    public SMDBObjectID save(SMViewData sMViewData) throws SMAPIException, SMSecurityException, SMStaleDataException, SMNoSuchObjectException, SMDatabaseException, SMDuplicateException {
        try {
            if (!sMViewData.isChanged()) {
                return sMViewData.getObjectID();
            }
            if (sMViewData.getViewType() == 0) {
                sMViewData.setViewType(this.serviceType);
            }
            SMDBObject sMDBObject = this.serviceHandle.save(sMViewData);
            sMViewData.refresh(sMDBObject);
            return sMDBObject.getObjectID();
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException.getMessage());
        }
    }

    public SMViewData saveAs(SMViewData sMViewData, String string) throws SMAPIException, SMSecurityException, SMDatabaseException, SMDuplicateException {
        SMViewData sMViewData2 = (SMViewData)sMViewData.clone();
        sMViewData2.setName(string);
        this.save(sMViewData2);
        return sMViewData2;
    }

    public SMViewData saveAs(SMViewData sMViewData, String string, boolean bl) throws SMAPIException, SMSecurityException, SMDatabaseException, SMDuplicateException {
        return this.saveAs(sMViewData, string);
    }

    public SMDBObject saveAsObj(SMDBObject sMDBObject, String string) throws SMAPIException, SMDatabaseException, SMSecurityException, SMWrongTypeException {
        if (!(sMDBObject instanceof SMViewData)) {
            throw new SMWrongTypeException();
        }
        return this.saveAs((SMViewData)sMDBObject, string);
    }

    public SMDBObjectID saveObj(SMDBObject sMDBObject) throws SMAPIException, SMDatabaseException, SMSecurityException, SMWrongTypeException {
        if (!(sMDBObject instanceof SMViewData)) {
            throw new SMWrongTypeException();
        }
        return this.save((SMViewData)sMDBObject);
    }

    public void setType(int n) {
        this.serviceType = n;
    }
}

