/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client;

import com.sun.symon.base.bootstrap.BsRMIClassLoader;
import com.sun.symon.base.client.GetBulkResponser;
import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMConnectionLostEvent;
import com.sun.symon.base.client.SMConnectionLostListener;
import com.sun.symon.base.client.SMLicenseStatus;
import com.sun.symon.base.client.SMPeriodicRequestHandler;
import com.sun.symon.base.client.SMRawDataBulkResponse;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRawDataResponse;
import com.sun.symon.base.client.SMRawDataResponseAdapter;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.server.receptors.local.LocalClientLevel1;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1BulkResponse;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1Response;
import com.sun.symon.base.server.receptors.rmi.RMIProbeInterface;
import com.sun.symon.base.server.receptors.rmi.RMISecurityException;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.utility.UcURL;
import com.sun.symon.base.xobject.XObjectBase;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JOptionPane;

public class SMRawDataRequest {
    private RMIClientLevel1 handle;
    private LocalClientLevel1 localHandle;
    private Hashtable clientDataCache;
    private boolean isLocal = true;
    private ResourceBundle resBundle;
    private static Hashtable bundles;
    private Locale locale;
    private boolean guiMode = true;
    String eventurl;
    String configurl;
    String topourl;
    String mdrurl;
    String csturl;
    String serverESDIR;
    String imageSubpath;
    boolean hostChecked = false;
    boolean sunHostOnly = true;
    private XObjectBase serverVersionXObject;
    private Method exitMethod = null;
    private Object exitObject = null;
    private Object[] exitArgs = null;
    public boolean timeoutDialogShowing = false;
    private Vector smConnectionLostListeners_ = null;
    private static String invalidReturnKey;
    private static String noServiceKey;
    private static String noLicenseKey;
    private String invalidReturnMsg = null;
    private String noServiceMsg = null;
    private String noLicenseMsg = null;
    public static final int LIC_OK = 0;
    public static final int LIC_MISSING = 1;
    public static final int LIC_EXPIRED = 2;

    static {
        invalidReturnKey = "base.client.ClientApiMessages:RawDataRequest.InvalidReturnValue";
        noServiceKey = "base.client.ClientApiMessages:RawDataRequest.NoServiceAvailable";
        noLicenseKey = "base.client.ClientApiMessages:RawDataRequest.NoLicense";
        bundles = new Hashtable();
    }

    public SMRawDataRequest(ScSecurityCredential scSecurityCredential) {
        this(scSecurityCredential, Locale.getDefault());
    }

    public SMRawDataRequest(ScSecurityCredential scSecurityCredential, Locale locale) {
        this(locale);
        this.localHandle = new LocalClientLevel1(scSecurityCredential);
        this.isLocal = true;
        this.initRequest();
    }

    public SMRawDataRequest(LocalClientLevel1 localClientLevel1) {
        this(localClientLevel1, Locale.getDefault());
    }

    public SMRawDataRequest(LocalClientLevel1 localClientLevel1, Locale locale) {
        this(locale);
        this.localHandle = localClientLevel1;
        this.isLocal = true;
        this.initRequest();
    }

    public SMRawDataRequest(RMIClientLevel1 rMIClientLevel1) {
        this(rMIClientLevel1, Locale.getDefault());
    }

    public SMRawDataRequest(RMIClientLevel1 rMIClientLevel1, Locale locale) {
        this(locale);
        this.handle = rMIClientLevel1;
        this.isLocal = false;
        this.initRequest();
    }

    private SMRawDataRequest(Locale locale) {
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.clientDataCache = new Hashtable();
        this.eventurl = null;
        this.configurl = null;
        this.topourl = null;
        this.csturl = null;
    }

    static /* synthetic */ Locale access$0(SMRawDataRequest sMRawDataRequest) {
        return sMRawDataRequest.locale;
    }

    public synchronized void addSMConnectionLostListener(SMConnectionLostListener sMConnectionLostListener) {
        if (this.smConnectionLostListeners_ == null) {
            this.smConnectionLostListeners_ = new Vector();
            this.smConnectionLostListeners_.addElement(sMConnectionLostListener);
        } else if (!this.smConnectionLostListeners_.contains(sMConnectionLostListener)) {
            this.smConnectionLostListeners_.addElement(sMConnectionLostListener);
        }
    }

    public static String buildShadowURL(String string, String string2, String string3) {
        if (string == null) {
            return "";
        }
        String string4 = null;
        int n = string.lastIndexOf(35);
        if (n >= 0) {
            string4 = string.substring(n);
            string = string.substring(0, n);
        }
        String string5 = null;
        n = string.lastIndexOf(63);
        if (n >= 0) {
            string5 = string.substring(n);
            string = string.substring(0, n);
        }
        if (string2 != null) {
            string5 = "?" + string2;
        }
        if (string5 == null) {
            string5 = "";
        }
        if (string3 != null) {
            string4 = "#" + string3;
        }
        if (string4 == null) {
            string4 = "";
        }
        return String.valueOf(string) + string5 + string4;
    }

    public static String buildShadowURL(String string, String string2, String string3, String string4) {
        String string5 = SMRawDataRequest.buildShadowURL(string, string2, string3);
        if (string5.equals("")) {
            return string5;
        }
        if (string4 == null || string4.length() == 0) {
            return string5;
        }
        UcAgentURL ucAgentURL = new UcAgentURL(string5);
        String string6 = ucAgentURL.getInstance();
        string6 = string6 == null ? ":" + string4 : String.valueOf(string6) + ":" + string4;
        String string7 = null;
        try {
            string7 = SMRawDataRequest.createURL(ucAgentURL.getHost(), ucAgentURL.getAgentPort(), ucAgentURL.getModuleId(), string6, ucAgentURL.getManagedObject(), ucAgentURL.getProperty(), ucAgentURL.getPropertyType(), ucAgentURL.getAttribute(), ucAgentURL.getPropertyInstance());
        }
        catch (SMAPIException sMAPIException) {}
        return string7;
    }

    public void cacheClientData(String string, String string2, Object object) {
        this.clientDataCache.put(String.valueOf(string) + string2, object);
    }

    public static String createURL(String string, int n, String string2, String string3, String string4, String string5) throws SMAPIException {
        Locale locale = Locale.getDefault();
        return SMRawDataRequest.createURL(string, n, string2, string3, string4, string5, locale);
    }

    public static String createURL(String string, int n, String string2, String string3, String string4, String string5, String string6, String string7) throws SMAPIException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (n == 0) {
            n = 161;
        }
        stringBuffer.append("snmp://" + string + ":" + n);
        if (string2 == null || string2.length() == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append("/mod/");
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append(String.valueOf(string2) + "+" + string3);
        } else {
            stringBuffer.append(string2);
        }
        if (string4 == null || string4.length() == 0) {
            return stringBuffer.toString();
        }
        if (string4.charAt(0) != '/') {
            stringBuffer.append("/");
        }
        stringBuffer.append(string4);
        if (!string4.endsWith("/")) {
            stringBuffer.append("/");
        }
        if (string5 == null || string5.length() == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append(string5);
        if (string6 != null && string6.length() > 0) {
            stringBuffer.append("?" + string6);
        }
        if (string7 != null && string7.length() > 0) {
            stringBuffer.append("#" + string7);
        }
        return stringBuffer.toString();
    }

    public static String createURL(String string, int n, String string2, String string3, String string4, String string5, Locale locale) throws SMAPIException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (n == 0) {
            n = 17010;
        }
        stringBuffer.append("probe://" + string + ":" + n + "/mod/");
        if (string2 == null || string2.length() == 0) {
            String string6 = "base.client.ClientApiMessages:RawDataRequest.ModuleNameParameterIsInvalid";
            throw new SMAPIException(2, UcInternationalizer.translateKey((Locale)locale, (String)string6));
        }
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append(String.valueOf(string2) + "+" + string3 + "/");
        } else {
            stringBuffer.append(String.valueOf(string2) + "/");
        }
        if (string4 == null || string4.length() == 0) {
            String string7 = "base.client.ClientApiMessages:RawDataRequest.KeyParameterIsInvalid";
            throw new SMAPIException(2, UcInternationalizer.translateKey((Locale)locale, (String)string7));
        }
        stringBuffer.append(string4);
        if (string5 == null || string5.length() == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append(";args=" + string5);
        return stringBuffer.toString();
    }

    public static String createURL(String string, int n, String string2, String string3, String string4, String string5, boolean bl, String string6, String string7) throws SMAPIException {
        if (bl && string5 != null && !string5.equals("")) {
            string7 = "0";
        }
        return SMRawDataRequest.createURL(string, n, string2, string3, string4, string5, string6, string7);
    }

    public static String createURL(String string, String string2, String string3, String string4, String string5) throws SMAPIException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(string);
        if (!string.endsWith("/")) {
            stringBuffer.append("/");
        }
        if (string2 == null || string2.length() == 0) {
            return stringBuffer.toString();
        }
        if (string2.charAt(0) == '/') {
            string2 = string2.substring(1);
        }
        stringBuffer.append(string2);
        if (!string2.endsWith("/")) {
            stringBuffer.append("/");
        }
        if (string3 == null || string3.length() == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append(string3);
        if (string4 != null && string4.length() > 0) {
            stringBuffer.append("?" + string4);
        }
        if (string5 != null && string5.length() > 0) {
            stringBuffer.append("#" + string5);
        }
        return stringBuffer.toString();
    }

    public static String createURL(String string, String string2, String string3, boolean bl, String string4, String string5) throws SMAPIException {
        if (bl && string3 != null && !string3.equals("")) {
            string5 = "0";
        }
        return SMRawDataRequest.createURL(string, string2, string3, string4, string5);
    }

    public void disconnect() {
        if (!this.isLocal) {
            String[] stringArray = new String[]{"exit://clientIsExiting/"};
            StObject[][] stObjectArray = new StString[1][1];
            stObjectArray[0][0] = new StString("goodbye");
            SMRawDataResponseAdapter sMRawDataResponseAdapter = new SMRawDataResponseAdapter();
            SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(1, stringArray, null, sMRawDataResponseAdapter, new Object(), true);
            try {
                this.dispatchRequest(1, stringArray, stObjectArray, null, sMPeriodicRequestHandler);
            }
            catch (SMAPIException sMAPIException) {}
        } else {
            this.localHandle.disconnect();
            this.localHandle = null;
            this.isLocal = false;
        }
    }

    private final void dispatchRequest(int n, String[] stringArray, int n2, int n3, String string, RMIClientLevel1BulkResponse rMIClientLevel1BulkResponse) throws SMAPIException {
        try {
            this.handle.newBulkRequest(n2, n3, stringArray, string, rMIClientLevel1BulkResponse);
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
    }

    private final void dispatchRequest(int n, String[] stringArray, StObject[][] stObjectArray, String string, RMIClientLevel1Response rMIClientLevel1Response) throws SMAPIException {
        try {
            switch (n) {
                case 0: {
                    if (this.isLocal) {
                        this.localHandle.newRequest(1, stringArray, null, string, rMIClientLevel1Response);
                    } else {
                        this.handle.newRequest(1, stringArray, null, string, rMIClientLevel1Response);
                    }
                    break;
                }
                case 1: {
                    if (this.isLocal) {
                        this.localHandle.newRequest(0, stringArray, stObjectArray, null, rMIClientLevel1Response);
                    } else {
                        this.handle.newRequest(0, stringArray, stObjectArray, null, rMIClientLevel1Response);
                    }
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (RMISecurityException rMISecurityException) {
            String string2 = "base.client.ClientApiMessages:";
            switch (rMISecurityException.getReason()) {
                case 1: {
                    string2 = String.valueOf(string2) + "RawDataRequest.AuthenticationHasNotBeenPerformedOrTicketIsLost";
                    break;
                }
                case 2: {
                    string2 = String.valueOf(string2) + "RawDataRequest.DataRequestHasBeenDenied";
                    this.fireSMConnectionLost();
                    break;
                }
                default: {
                    string2 = String.valueOf(string2) + "RawDataRequest.UnknownException";
                }
            }
            throw new SMAPIException(1, UcInternationalizer.translateKey((Locale)this.locale, (String)string2));
        }
        catch (ConnectException connectException) {
            this.fireSMConnectionLost();
            throw new SMAPIException(connectException.getMessage());
        }
        catch (UnmarshalException unmarshalException) {
            this.fireSMConnectionLost();
            throw new SMAPIException(unmarshalException.getMessage());
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException.getMessage());
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
    }

    protected void fireSMConnectionLost() {
        Vector vector = null;
        if (this.smConnectionLostListeners_ == null) {
            return;
        }
        Object object = this.smConnectionLostListeners_;
        synchronized (object) {
            vector = (Vector)this.smConnectionLostListeners_.clone();
        }
        object = new SMConnectionLostEvent(this);
        int n = 0;
        while (n < vector.size()) {
            SMConnectionLostListener sMConnectionLostListener = (SMConnectionLostListener)vector.elementAt(n);
            sMConnectionLostListener.connectionLost((SMConnectionLostEvent)object);
            ++n;
        }
    }

    public String getAgentVersion(String string, int n, String string2) throws SMAPIException {
        String[] stringArray = new String[]{"snmp://" + string + ":" + Integer.toString(n) + "/sym/base/info/agent/general/oaversion#0"};
        StObject[][] stObjectArray = this.getURLValue(stringArray);
        if (stObjectArray.length == 1 && stObjectArray[0].length == 1 && stObjectArray[0][0] != null) {
            Vector vector = new Vector();
            String string3 = ((StString)stObjectArray[0][0]).toString();
            UcListUtil.decomposeList((String)string3, vector);
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            if (string3.equals("PrimeAlert v4.1")) {
                string4 = "2.0";
                string8 = "2_0_00_00";
            } else if (vector.size() == 6) {
                string9 = (String)vector.elementAt(0);
                string4 = (String)vector.elementAt(1);
                string5 = (String)vector.elementAt(2);
                string6 = (String)vector.elementAt(3);
                string7 = (String)vector.elementAt(4);
                string8 = (String)vector.elementAt(5);
            } else {
                throw new SMAPIException(3, this.invalidReturnMsg);
            }
            if (string2.equals("overall")) {
                return string4;
            }
            if (string2.equals("date")) {
                return string5;
            }
            if (string2.equals("buildnumber")) {
                return string6;
            }
            if (string2.equals("desc")) {
                return string7;
            }
            if (string2.equals("revision")) {
                return string8;
            }
            if (string2.equals("name")) {
                return string9;
            }
            return null;
        }
        throw new SMAPIException("Invald return value when requesting version of agent at " + string + ":" + n);
    }

    public String getAgentVersion(String string, String string2) throws SMAPIException {
        UcURL ucURL = new UcURL(string);
        String string3 = ucURL.getHost();
        String string4 = ucURL.getPort();
        if (string3 == null || string4 == null) {
            String string5 = "base.client.ClientApiMessages:RawDataRequest.ExteractAgentInfoFail";
            throw new SMAPIException(String.valueOf(UcInternationalizer.translateKey((Locale)this.locale, (String)string5)) + " " + string);
        }
        int n = Integer.parseInt(ucURL.getPort());
        return this.getAgentVersion(string3, n, string2);
    }

    public String[] getAllAlarmActions(String string, int n) throws SMAPIException {
        String string2 = this.getAgentVersion(string, n, "overall");
        if (string2.compareTo("3.0") < 0) {
            return new String[0];
        }
        String string3 = "snmp://" + string + ":" + n + "/sym/base.info.agent.fileinfo.alarmactionfiles#0";
        String[] stringArray = new String[]{string3};
        StObject[][] stObjectArray = this.getURLValue(stringArray);
        if (stObjectArray == null || stObjectArray.length == 0) {
            String string4 = UcInternationalizer.translateKey((Locale)this.locale, (String)"base.client.ClientApiMessages:RawDataRequest.ErrorInGetAllAlarmActions");
            throw new SMAPIException(3, string4);
        }
        Vector vector = new Vector();
        if (!UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), vector)) {
            String string5 = UcInternationalizer.translateKey((Locale)this.locale, (String)"base.client.ClientApiMessages:RawDataRequest.ErrorInGetAllAlarmActions");
            throw new SMAPIException(3, string5);
        }
        String[] stringArray2 = new String[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            stringArray2[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray2;
    }

    public String getCSTBaseURL() {
        if (this.csturl != null) {
            return this.csturl;
        }
        try {
            this.csturl = this.handle.getCSTBaseURL();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"Unable to obtain cst server location. Using localhost: instead", (Throwable)exception);
            return "snmp://localhost:167/";
        }
        return this.csturl;
    }

    public Object getCachedClientData(String string, String string2) {
        return this.clientDataCache.get(String.valueOf(string) + string2);
    }

    public String getConfigurationBaseURL() {
        if (this.configurl != null) {
            return this.configurl;
        }
        try {
            this.configurl = this.handle.getConfigurationBaseURL();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"Unable to obtain cfgserver location. Using localhost:165 instead", (Throwable)exception);
            return "snmp://localhost:165/";
        }
        return this.configurl;
    }

    public String getConsoleHint(String string, String string2) throws SMAPIException {
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "consoleHintKey", null)};
        StObject[][] stObjectArray = new StObject[1][1];
        stObjectArray[0][0] = new StString(string2);
        StObject[][] stObjectArray2 = this.setURLValue(stringArray, stObjectArray);
        if (stObjectArray2 == null || stObjectArray2.length != 1 || stObjectArray2[0] == null || stObjectArray2[0].length != 1) {
            throw new SMAPIException(3, this.invalidReturnMsg);
        }
        return stObjectArray2[0][0].toString();
    }

    public String getEventBaseURL() {
        if (this.eventurl != null) {
            return this.eventurl;
        }
        try {
            this.eventurl = this.handle.getEventBaseURL();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"Unable to obtain event server location. Using localhost:163 instead", (Throwable)exception);
            return "snmp://localhost:163/";
        }
        return this.eventurl;
    }

    public Method getExitMethod() {
        return this.exitMethod;
    }

    public Object[] getExitMethodArgs() {
        return this.exitArgs;
    }

    public Object getExitTarget() {
        return this.exitObject;
    }

    public RMIClientLevel1 getHandle() {
        return this.handle;
    }

    public String getImageSubpath() {
        if (this.imageSubpath != null) {
            return this.imageSubpath;
        }
        try {
            this.imageSubpath = this.handle.getImageSubpath();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"Unable to obtain the image subpath");
        }
        return this.imageSubpath;
    }

    public SMLicenseStatus getLicenseStatus() throws SMAPIException {
        UcURL ucURL = null;
        try {
            ucURL = new UcURL(this.getTopologyBaseURL());
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
        String string = ucURL.getHost();
        String string2 = ucURL.getPort();
        String string3 = "snmp://" + string + ":" + string2 + "/mod/topology-license/topoObjectStats/";
        Vector vector = new Vector();
        String[] stringArray = new String[]{new String(String.valueOf(string3) + "topoLicenseStatus#0"), new String(String.valueOf(string3) + "topoAvailLic#0"), new String(String.valueOf(string3) + "topoUsedLic#0"), new String(String.valueOf(string3) + "topoMaxLic#0"), new String(String.valueOf(string3) + "topoValidUntil#0")};
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        StObject[][] stObjectArray = null;
        SMLicenseStatus sMLicenseStatus = null;
        try {
            stObjectArray = this.getURLValue(stringArray);
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
        string4 = stObjectArray[0][0].toString();
        string6 = stObjectArray[1][0].toString();
        string7 = stObjectArray[2][0].toString();
        string5 = stObjectArray[3][0].toString();
        string8 = stObjectArray[4][0].toString();
        sMLicenseStatus = new SMLicenseStatus(string4, string5, string7, string6, string8);
        return sMLicenseStatus;
    }

    public LocalClientLevel1 getLocalHandle() {
        return this.localHandle;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getMDRBaseURL() {
        if (this.mdrurl != null) {
            return this.mdrurl;
        }
        try {
            this.mdrurl = this.isLocal ? this.localHandle.getMDRBaseURL() : this.handle.getMDRBaseURL();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"Unable to obtain mdr server location. Using localhost: instead", (Throwable)exception);
            return "snmp://localhost:168/";
        }
        return this.mdrurl;
    }

    public int getModuleLicense() throws SMAPIException {
        try {
            int n = this.handle.getModuleLicense();
            return n;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string.indexOf("NoSuchMethodError") != -1 && string.indexOf("getModuleLicense") != -1) {
                throw new SMAPIException(3, this.noLicenseMsg);
            }
            throw new SMAPIException(string);
        }
    }

    public String getProbeCookie(String string) throws SMAPIException {
        return this.getProbeCookie(string, null);
    }

    public String getProbeCookie(String string, String[] stringArray) throws SMAPIException {
        try {
            return this.handle.getProbeCookie(string, stringArray);
        }
        catch (RMISecurityException rMISecurityException) {
            String string2 = "base.client.ClientApiMessages:";
            switch (rMISecurityException.getReason()) {
                case 1: {
                    string2 = String.valueOf(string2) + "RawDataRequest.AuthenticationHasNotBeenPerformedOrTicketIsLost";
                    break;
                }
                case 2: {
                    string2 = String.valueOf(string2) + "RawDataRequest.DataRequestHasBeenDenied";
                    this.fireSMConnectionLost();
                    break;
                }
                default: {
                    string2 = String.valueOf(string2) + "RawDataRequest.UnknownException";
                }
            }
            throw new SMAPIException(1, UcInternationalizer.translateKey((Locale)this.locale, (String)string2));
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException.getMessage());
        }
    }

    public String getProbeErrCookie(String string) throws SMAPIException {
        return this.getProbeErrCookie(string, null);
    }

    public String getProbeErrCookie(String string, String[] stringArray) throws SMAPIException {
        try {
            return this.handle.getProbeErrCookie(string, stringArray);
        }
        catch (RMISecurityException rMISecurityException) {
            String string2 = "base.client.ClientApiMessages:";
            switch (rMISecurityException.getReason()) {
                case 1: {
                    string2 = String.valueOf(string2) + "RawDataRequest.AuthenticationHasNotBeenPerformedOrTicketIsLost";
                    break;
                }
                case 2: {
                    string2 = String.valueOf(string2) + "RawDataRequest.DataRequestHasBeenDenied";
                    this.fireSMConnectionLost();
                    break;
                }
                default: {
                    string2 = String.valueOf(string2) + "RawDataRequest.UnknownException";
                }
            }
            throw new SMAPIException(1, UcInternationalizer.translateKey((Locale)this.locale, (String)string2));
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException.getMessage());
        }
    }

    public RMIProbeInterface getProbeService() throws SMAPIException {
        try {
            return this.handle.getProbeService();
        }
        catch (Throwable throwable) {
            throw new SMAPIException(throwable.getMessage());
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resBundle;
    }

    public String getServerESDIR() {
        if (this.serverESDIR != null) {
            return this.serverESDIR;
        }
        try {
            this.serverESDIR = this.handle.getESDIR();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"Unable to obtain server's ESDIR property");
        }
        return this.serverESDIR;
    }

    public String getServerVersion(String string) {
        Object object;
        if (this.serverVersionXObject == null) {
            try {
                object = this.getURLValue(new String[]{"xfile:/version-j.x"});
                String string2 = object[0][0].toString();
                this.serverVersionXObject = XObjectBase.createRoot();
                boolean bl = UcDDL.channelIsActive((int)UcDDL.channelLookup((String)"info"));
                UcDDL.channelActivate((String)"info", (boolean)false);
                this.serverVersionXObject.importData(true, "version", string2);
                if (bl) {
                    UcDDL.channelActivate((String)"info", (boolean)true);
                }
            }
            catch (Exception exception) {
                UcDDL.logWarningMessage((String)("Unable to request server version: " + exception));
                return null;
            }
        }
        if (string.equals("overall") || string.equals("date") || string.equals("buildnumber") || string.equals("desc") || string.equals("revision")) {
            object = this.serverVersionXObject.ilookup("version", string, null);
            if (object == null && string.equals("revision")) {
                object = "2_0_00_00";
            }
            return object;
        }
        return null;
    }

    public Object getService(String string) throws SMAPIException {
        try {
            Object object = this.handle.getService(string, null);
            return object;
        }
        catch (Throwable throwable) {
            throw new SMAPIException(throwable.getMessage());
        }
    }

    public Object getService(String string, String[] stringArray) throws SMAPIException {
        try {
            Object object = this.handle.getService(string, stringArray);
            if (object == null) {
                UcDDL.logWarningMessage((String)("getServices: " + this.noServiceMsg));
                throw new SMAPIException(this.noServiceMsg);
            }
            return object;
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2.indexOf("NoSuchMethodError") != -1 && string2.indexOf("getService") != -1) {
                UcDDL.logWarningMessage((String)("getServices: " + this.noServiceMsg));
                throw new SMAPIException(this.noServiceMsg);
            }
            throw new SMAPIException(string2);
        }
    }

    public int getServiceLicense(String string) throws SMAPIException {
        try {
            int n = this.handle.getServiceLicense(string);
            return n;
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2.indexOf("NoSuchMethodError") != -1 && string2.indexOf("getServiceLicense") != -1) {
                throw new SMAPIException(3, this.noLicenseMsg);
            }
            throw new SMAPIException(string2);
        }
    }

    public String[] getServices() throws SMAPIException {
        try {
            String[] stringArray = this.handle.getServices();
            if (stringArray == null) {
                UcDDL.logWarningMessage((String)("getServices: " + this.noServiceMsg));
                throw new SMAPIException(this.noServiceMsg);
            }
            return stringArray;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string.indexOf("NoSuchMethodError") != -1 && string.indexOf("getService") != -1) {
                UcDDL.logWarningMessage((String)("getServices: " + this.noServiceMsg));
                throw new SMAPIException(this.noServiceMsg);
            }
            throw new SMAPIException(string);
        }
    }

    public String getTopologyBaseURL() {
        if (this.topourl != null && !this.topourl.equals("")) {
            return this.topourl;
        }
        try {
            this.topourl = this.isLocal ? this.localHandle.getTopologyBaseURL() : this.handle.getTopologyBaseURL();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"Unable to obtain topology server location. Using localhost:164 instead", (Throwable)exception);
            return "snmp://localhost:164/";
        }
        return this.topourl;
    }

    public Vector getURLValue(Vector vector) throws SMAPIException {
        Vector[] vectorArray = new Vector[1];
        SMRequestStatus[] sMRequestStatusArray = new SMRequestStatus[1];
        Object object = new Object();
        vectorArray[0] = null;
        sMRequestStatusArray[0] = null;
        class InnerMOResponseImpl
        extends SMRawDataResponseAdapter {
            private final /* synthetic */ SMRequestStatus[] val$stat;
            private final /* synthetic */ Vector[] val$data;

            InnerMOResponseImpl(Vector[] vectorArray, SMRequestStatus[] sMRequestStatusArray) {
                this.val$data = vectorArray;
                this.val$stat = sMRequestStatusArray;
            }

            public void getURLResponse(SMRequestStatus sMRequestStatus, StObject[][] stObjectArray, Object object) {
                InnerMOResponseImpl innerMOResponseImpl2 = this;
                synchronized (innerMOResponseImpl2) {
                    if (sMRequestStatus.getReturnCode() == 0) {
                        Vector<Vector<E>> vector = new Vector<Vector<E>>();
                        if (stObjectArray != null) {
                            int n = 0;
                            while (n < stObjectArray.length) {
                                Vector<StObject> vector2 = new Vector<StObject>();
                                int n2 = 0;
                                while (stObjectArray[n].length == 0 || n2 < stObjectArray[n].length) {
                                    vector2.addElement(stObjectArray[n][n2]);
                                    if (stObjectArray[n].length == 0) break;
                                    ++n2;
                                }
                                vector.addElement(vector2);
                                ++n;
                            }
                        }
                        this.val$data[0] = vector;
                    } else {
                        this.val$stat[0] = sMRequestStatus;
                    }
                    this.notify();
                }
            }

            public final void waitForMessage() throws SMAPIException {
                InnerMOResponseImpl innerMOResponseImpl2 = this;
                synchronized (innerMOResponseImpl2) {
                    try {
                        if (this.val$data[0] == null && this.val$stat[0] == null) {
                            this.wait();
                        }
                    }
                    catch (Exception exception) {
                        throw new SMAPIException(exception.getMessage());
                    }
                }
            }
        }
        InnerMOResponseImpl innerMOResponseImpl2 = new InnerMOResponseImpl(vectorArray, sMRequestStatusArray);
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = vector.elementAt(n).toString();
            ++n;
        }
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(0, stringArray, null, innerMOResponseImpl2, object, true);
        this.dispatchRequest(0, stringArray, null, null, sMPeriodicRequestHandler);
        innerMOResponseImpl2.waitForMessage();
        if (vectorArray[0] == null) {
            throw new SMAPIException(sMRequestStatusArray[0].getReturnCode(), sMRequestStatusArray[0].getMessageText());
        }
        return vectorArray[0];
    }

    public Object getURLValue(Vector vector, int n, String string, SMRawDataBulkResponse sMRawDataBulkResponse, Object object) throws SMAPIException {
        String[] stringArray = new String[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            stringArray[n2] = vector.elementAt(n2).toString();
            ++n2;
        }
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(2, stringArray, string, sMRawDataBulkResponse, object, false);
        this.dispatchRequest(2, stringArray, 0, n, string, sMPeriodicRequestHandler);
        return sMPeriodicRequestHandler;
    }

    public Object getURLValue(Vector vector, String string, SMRawDataResponse sMRawDataResponse, Object object) throws SMAPIException {
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = vector.elementAt(n).toString();
            ++n;
        }
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(0, stringArray, string, sMRawDataResponse, object, false);
        this.dispatchRequest(0, stringArray, null, string, sMPeriodicRequestHandler);
        return sMPeriodicRequestHandler;
    }

    public StObject[][] getURLValue(String[] stringArray) throws SMAPIException {
        StObject[][][] stObjectArray = new StObject[1][][];
        SMRequestStatus[] sMRequestStatusArray = new SMRequestStatus[1];
        Object object = new Object();
        stObjectArray[0] = null;
        sMRequestStatusArray[0] = null;
        class InnerMOResponseImpl
        extends SMRawDataResponseAdapter {
            private final /* synthetic */ SMRequestStatus[] val$stat;
            private final /* synthetic */ StObject[][][] val$data;

            InnerMOResponseImpl(StObject[][][] stObjectArray, SMRequestStatus[] sMRequestStatusArray) {
                this.val$data = stObjectArray;
                this.val$stat = sMRequestStatusArray;
            }

            public void getURLResponse(SMRequestStatus sMRequestStatus, StObject[][] stObjectArray, Object object) {
                InnerMOResponseImpl innerMOResponseImpl2 = this;
                synchronized (innerMOResponseImpl2) {
                    if (sMRequestStatus.getReturnCode() == 0) {
                        this.val$data[0] = stObjectArray;
                    } else {
                        this.val$stat[0] = sMRequestStatus;
                    }
                    this.notify();
                }
            }

            public final void waitForMessage() throws SMAPIException {
                InnerMOResponseImpl innerMOResponseImpl2 = this;
                synchronized (innerMOResponseImpl2) {
                    try {
                        if (this.val$data[0] == null && this.val$stat[0] == null) {
                            this.wait();
                        }
                    }
                    catch (Exception exception) {
                        throw new SMAPIException(exception.getMessage());
                    }
                }
            }
        }
        InnerMOResponseImpl innerMOResponseImpl2 = new InnerMOResponseImpl(stObjectArray, sMRequestStatusArray);
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(0, stringArray, null, innerMOResponseImpl2, object, true);
        this.dispatchRequest(0, stringArray, null, null, sMPeriodicRequestHandler);
        innerMOResponseImpl2.waitForMessage();
        if (stObjectArray[0] == null) {
            throw new SMAPIException(sMRequestStatusArray[0].getReturnCode(), sMRequestStatusArray[0].getMessageText());
        }
        return stObjectArray[0];
    }

    public Object getURLValue(String[] stringArray, int n, String string, SMRawDataBulkResponse sMRawDataBulkResponse, Object object) throws SMAPIException {
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(2, stringArray, string, sMRawDataBulkResponse, object, true);
        this.dispatchRequest(2, stringArray, 0, n, string, sMPeriodicRequestHandler);
        return sMPeriodicRequestHandler;
    }

    public StObject[][] getURLValue(String[] stringArray, int n, String[][][] stringArray2, SMRequestStatus[] sMRequestStatusArray) throws SMAPIException {
        Object object = new Object();
        GetBulkResponser getBulkResponser = new GetBulkResponser();
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(2, stringArray, null, getBulkResponser, object, false);
        this.dispatchRequest(2, stringArray, 0, n, null, sMPeriodicRequestHandler);
        getBulkResponser.waitForMessage();
        StObject[][] stObjectArray = getBulkResponser.getData();
        sMRequestStatusArray[0] = getBulkResponser.getStat();
        StObject[][] stObjectArray2 = getBulkResponser.getOids();
        if (stObjectArray == null || stObjectArray.length == 0 || stObjectArray2 == null || stObjectArray2.length == 0) {
            throw new SMAPIException(sMRequestStatusArray[0].getReturnCode(), sMRequestStatusArray[0].getMessageText());
        }
        String[][] stringArray3 = null;
        if (sMRequestStatusArray[0].getReturnCode() == 0) {
            int n2 = stObjectArray2.length;
            int n3 = stObjectArray2[0].length;
            stringArray3 = new String[n2][n3];
            int n4 = 0;
            while (n4 < n2) {
                int n5 = 0;
                while (n5 < n3) {
                    stringArray3[n4][n5] = stObjectArray2[n4][n5].toString();
                    ++n5;
                }
                ++n4;
            }
        }
        stringArray2[0] = stringArray3;
        return stObjectArray;
    }

    public Object getURLValue(String[] stringArray, String string, SMRawDataResponse sMRawDataResponse, Object object) throws SMAPIException {
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(0, stringArray, string, sMRawDataResponse, object, true);
        this.dispatchRequest(0, stringArray, null, string, sMPeriodicRequestHandler);
        return sMPeriodicRequestHandler;
    }

    public String getUserId() {
        if (this.isLocal) {
            return this.localHandle.getUserId();
        }
        return this.handle.getUserId();
    }

    private void initRequest() {
        Object v;
        if (this.handle != null) {
            UcInternationalizer.setLoader((ClassLoader)BsRMIClassLoader.getClassLoader((RMIClientLevel1)this.handle));
        }
        if ((v = bundles.get(this.locale)) == null) {
            this.resBundle = ResourceBundle.getBundle("com.sun.symon.base.client.ClientApiMessages", this.locale);
            bundles.put(this.locale, this.resBundle);
        } else {
            this.resBundle = (ResourceBundle)v;
        }
        this.invalidReturnMsg = UcInternationalizer.translateKey((Locale)this.locale, (String)invalidReturnKey);
        this.noServiceMsg = UcInternationalizer.translateKey((Locale)this.locale, (String)noServiceKey);
        this.noLicenseMsg = UcInternationalizer.translateKey((Locale)this.locale, (String)noLicenseKey);
    }

    public boolean isAgentVersionNotLower(String string, int n, String string2) throws SMAPIException {
        String string3 = this.getAgentVersion(string, n, "overall");
        return string3.compareTo(string2) >= 0;
    }

    public boolean isAgentVersionNotLower(String string, String string2) throws SMAPIException {
        String string3 = this.getAgentVersion(string, "overall");
        return string3.compareTo(string2) >= 0;
    }

    public boolean isClientDataCached(String string, String string2) {
        return this.clientDataCache.containsKey(String.valueOf(string) + string2);
    }

    public boolean isGUIMode() {
        return this.guiMode;
    }

    public boolean isSunHost(String string) throws SMAPIException {
        UcURL ucURL = new UcURL(string);
        String string2 = ucURL.getHost();
        String string3 = ucURL.getPort();
        if (string2 == null || string3 == null) {
            String string4 = "base.client.ClientApiMessages:RawDataRequest.ExteractAgentInfoFail";
            throw new SMAPIException(String.valueOf(UcInternationalizer.translateKey((Locale)this.locale, (String)string4)) + " " + string);
        }
        String[] stringArray = new String[]{"snmp://" + string2 + ":" + string3 + "/oid/1.3.6.1.2.1.1.2.0"};
        StObject[][] stObjectArray = this.getURLValue(stringArray);
        if (stObjectArray.length == 1 && stObjectArray[0].length == 1 && stObjectArray[0][0] != null) {
            String string5;
            int n;
            String string6 = ((StString)stObjectArray[0][0]).toString();
            return string6.substring(0, n = (string5 = new String("1.3.6.1.4.1.42")).length()).equals(string5);
        }
        throw new SMAPIException(3, this.invalidReturnMsg);
    }

    public boolean isSunHostOnly() {
        if (this.hostChecked) {
            return this.sunHostOnly;
        }
        try {
            this.sunHostOnly = this.handle.isSunHostOnly();
            this.hostChecked = true;
            return this.sunHostOnly;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"Unable to check whether only allow SunMC agent.");
            return true;
        }
    }

    public void launchTimeoutNotification(String string) {
        if (this.timeoutDialogShowing) {
            return;
        }
        class SMTimeoutNotify
        implements Runnable {
            private final /* synthetic */ SMRawDataRequest this$0;
            private SMRawDataRequest Parent;
            private String Component;

            public SMTimeoutNotify(SMRawDataRequest sMRawDataRequest, SMRawDataRequest sMRawDataRequest2, String string) {
                this.this$0 = sMRawDataRequest;
                this.Parent = sMRawDataRequest2;
                this.Component = string;
            }

            public void run() {
                this.Parent.timeoutDialogShowing = true;
                UcURL ucURL = null;
                String string = null;
                if (this.Component.equals("topology")) {
                    ucURL = new UcURL(this.Parent.getTopologyBaseURL());
                    string = String.valueOf(ucURL.getHost()) + ":" + ucURL.getPort();
                } else if (this.Component.equals("cfgserver")) {
                    ucURL = new UcURL(this.Parent.getConfigurationBaseURL());
                    string = String.valueOf(ucURL.getHost()) + ":" + ucURL.getPort();
                } else if (this.Component.equals("both")) {
                    ucURL = new UcURL(this.Parent.getTopologyBaseURL());
                    string = String.valueOf(ucURL.getHost()) + ":" + ucURL.getPort();
                    ucURL = new UcURL(this.Parent.getConfigurationBaseURL());
                    string = String.valueOf(string) + "\n" + "                    " + ucURL.getHost() + ":" + ucURL.getPort();
                } else {
                    return;
                }
                String string2 = "base.console.ConsoleMessages:timeout." + this.Component + "1";
                String string3 = "base.console.ConsoleMessages:timeout." + this.Component + "2";
                String string4 = String.valueOf(UcInternationalizer.translateKey((Locale)SMRawDataRequest.access$0(this.this$0), (String)string2)) + "\n" + "                    " + string + "\n" + UcInternationalizer.translateKey((Locale)SMRawDataRequest.access$0(this.this$0), (String)string3);
                String string5 = UcInternationalizer.translateKey((Locale)SMRawDataRequest.access$0(this.this$0), (String)"base.console.ConsoleMessages:timeout.title");
                Object[] objectArray = new String[]{UcInternationalizer.translateKey((Locale)SMRawDataRequest.access$0(this.this$0), (String)"base.console.ConsoleGeneric:standard.ok")};
                JOptionPane.showOptionDialog(null, string4, string5, -1, 2, null, objectArray, objectArray[0]);
                this.Parent.timeoutDialogShowing = false;
            }
        }
        Thread thread = new Thread((Runnable)new SMTimeoutNotify(this, this, string), "TimeoutNotify");
        thread.start();
    }

    public Socket probeConnect(String string, String[] stringArray) throws SMAPIException {
        Socket socket;
        try {
            socket = this.handle.probeConnect(string, stringArray);
        }
        catch (RMISecurityException rMISecurityException) {
            String string2 = "base.client.ClientApiMessages:";
            switch (rMISecurityException.getReason()) {
                case 1: {
                    string2 = String.valueOf(string2) + "RawDataRequest.AuthenticationHasNotBeenPerformedOrTicketIsLost";
                    break;
                }
                case 2: {
                    string2 = String.valueOf(string2) + "RawDataRequest.DataRequestHasBeenDenied";
                    this.fireSMConnectionLost();
                    break;
                }
                default: {
                    string2 = String.valueOf(string2) + "RawDataRequest.UnknownException";
                }
            }
            throw new SMAPIException(1, UcInternationalizer.translateKey((Locale)this.locale, (String)string2));
        }
        catch (ConnectException connectException) {
            this.fireSMConnectionLost();
            throw new SMAPIException(connectException.getMessage());
        }
        catch (UnmarshalException unmarshalException) {
            this.fireSMConnectionLost();
            throw new SMAPIException(unmarshalException.getMessage());
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException.getMessage());
        }
        catch (IOException iOException) {
            UcDDL.logWarningMessage((String)"Probe socket connection failed. Retrying...");
            String string3 = iOException.getMessage();
            try {
                Thread.sleep(1000L);
                socket = this.handle.probeConnect(string, stringArray);
            }
            catch (Exception exception) {
                UcDDL.logWarningMessage((String)"Probe socket connection failed on second attempt.");
                throw new SMAPIException(string3);
            }
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
        return socket;
    }

    public Socket[] probeConnectWithStderr(String string, String[] stringArray) throws SMAPIException {
        Socket[] socketArray = null;
        try {
            socketArray = this.handle.probeConnectWithStderr(string, stringArray);
        }
        catch (RMISecurityException rMISecurityException) {
            String string2 = "base.client.ClientApiMessages:";
            switch (rMISecurityException.getReason()) {
                case 1: {
                    string2 = String.valueOf(string2) + "RawDataRequest.AuthenticationHasNotBeenPerformedOrTicketIsLost";
                    break;
                }
                case 2: {
                    string2 = String.valueOf(string2) + "RawDataRequest.DataRequestHasBeenDenied";
                    this.fireSMConnectionLost();
                    break;
                }
                default: {
                    string2 = String.valueOf(string2) + "RawDataRequest.UnknownException";
                }
            }
            throw new SMAPIException(1, UcInternationalizer.translateKey((Locale)this.locale, (String)string2));
        }
        catch (ConnectException connectException) {
            this.fireSMConnectionLost();
            throw new SMAPIException(connectException.getMessage());
        }
        catch (UnmarshalException unmarshalException) {
            this.fireSMConnectionLost();
            throw new SMAPIException(unmarshalException.getMessage());
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException.getMessage());
        }
        catch (IOException iOException) {
            UcDDL.logWarningMessage((String)"Probe socket connection failed. Retrying...");
            String string3 = iOException.getMessage();
            try {
                Thread.sleep(1000L);
                socketArray = this.handle.probeConnectWithStderr(string, stringArray);
            }
            catch (Exception exception) {
                UcDDL.logWarningMessage((String)"Probe socket connection failed on second attempt.");
                throw new SMAPIException(string3);
            }
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
        return socketArray;
    }

    public void removeCachedClientData(String string, String string2) {
        this.clientDataCache.remove(String.valueOf(string) + string2);
    }

    public synchronized void removeSMConnectionLostListener(SMConnectionLostListener sMConnectionLostListener) {
        if (this.smConnectionLostListeners_ == null) {
            return;
        }
        this.smConnectionLostListeners_.removeElement(sMConnectionLostListener);
    }

    public void removeURLRequest(Object object) throws SMAPIException {
        try {
            Object object2 = object;
            synchronized (object2) {
                if (object instanceof RMIClientLevel1Response) {
                    if (this.isLocal) {
                        this.localHandle.deleteRequest((RMIClientLevel1Response)object);
                    } else {
                        this.handle.deleteRequest((RMIClientLevel1Response)object);
                    }
                }
                ((SMPeriodicRequestHandler)object).detachOriginator();
            }
        }
        catch (RMISecurityException rMISecurityException) {
            String string = "base.client.ClientApiMessages:";
            switch (rMISecurityException.getReason()) {
                case 1: {
                    string = String.valueOf(string) + "RawDataRequest.AuthenticationHasNotBeenPerformedOrTicketIsLost";
                    break;
                }
                case 2: {
                    string = String.valueOf(string) + "RawDataRequest.DataRequestHasBeenDenied";
                    this.fireSMConnectionLost();
                    break;
                }
                default: {
                    string = String.valueOf(string) + "RawDataRequest.UnknownException";
                }
            }
            throw new SMAPIException(1, UcInternationalizer.translateKey((Locale)this.locale, (String)string));
        }
        catch (ConnectException connectException) {
            this.fireSMConnectionLost();
            throw new SMAPIException(connectException.getMessage());
        }
        catch (UnmarshalException unmarshalException) {
            this.fireSMConnectionLost();
            throw new SMAPIException(unmarshalException.getMessage());
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException.getMessage());
        }
    }

    public void setExitAction(Object object, String string, Object[] objectArray) throws SMAPIException {
        Class[] classArray;
        if (objectArray != null) {
            classArray = new Class[objectArray.length - 1];
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] == null) {
                    throw new SMAPIException(new IllegalArgumentException().getMessage());
                }
                classArray[n] = objectArray[n].getClass();
                ++n;
            }
            this.exitArgs = objectArray;
        } else {
            classArray = null;
            this.exitArgs = null;
        }
        if (object == null) {
            throw new SMAPIException(new IllegalArgumentException().getMessage());
        }
        try {
            this.exitMethod = object.getClass().getDeclaredMethod(string, classArray);
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
        this.exitObject = object;
    }

    public void setGUIMode(boolean bl) {
        this.guiMode = bl;
    }

    public boolean setURLValue(Vector vector, Vector vector2) throws SMAPIException {
        Object object;
        boolean[] blArray = new boolean[1];
        SMRequestStatus[] sMRequestStatusArray = new SMRequestStatus[1];
        Object object2 = new Object();
        blArray[0] = false;
        sMRequestStatusArray[0] = null;
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = vector.elementAt(n).toString();
            ++n;
        }
        StObject[][] stObjectArray = new StObject[vector2.size()][];
        int n2 = 0;
        while (n2 < vector2.size()) {
            object = (Vector)vector2.elementAt(n2);
            stObjectArray[n2] = new StObject[((Vector)object).size()];
            int n3 = 0;
            while (n3 < ((Vector)object).size()) {
                stObjectArray[n2][n3] = (StObject)((Vector)object).elementAt(n3);
                ++n3;
            }
            ++n2;
        }
        class InnersetMOResponseImpl
        extends SMRawDataResponseAdapter {
            private final /* synthetic */ SMRequestStatus[] val$stat;
            private final /* synthetic */ boolean[] val$result;

            InnersetMOResponseImpl(boolean[] blArray, SMRequestStatus[] sMRequestStatusArray) {
                this.val$result = blArray;
                this.val$stat = sMRequestStatusArray;
            }

            public void setURLResponse(SMRequestStatus sMRequestStatus, StObject[][] stObjectArray, Object object) {
                InnersetMOResponseImpl innersetMOResponseImpl2 = this;
                synchronized (innersetMOResponseImpl2) {
                    if (sMRequestStatus.getReturnCode() == 0) {
                        this.val$result[0] = true;
                    } else {
                        this.val$stat[0] = sMRequestStatus;
                    }
                    this.notify();
                }
            }

            public final void waitForMessage() throws SMAPIException {
                InnersetMOResponseImpl innersetMOResponseImpl2 = this;
                synchronized (innersetMOResponseImpl2) {
                    try {
                        if (this.val$stat[0] == null && !this.val$result[0]) {
                            this.wait();
                        }
                    }
                    catch (Exception exception) {
                        throw new SMAPIException(exception.getMessage());
                    }
                }
            }
        }
        object = new InnersetMOResponseImpl(blArray, sMRequestStatusArray);
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(1, stringArray, null, object, object2, true);
        this.dispatchRequest(1, stringArray, stObjectArray, null, sMPeriodicRequestHandler);
        ((InnersetMOResponseImpl)object).waitForMessage();
        if (sMRequestStatusArray[0] != null) {
            throw new SMAPIException(sMRequestStatusArray[0].getReturnCode(), sMRequestStatusArray[0].getMessageText());
        }
        return blArray[0];
    }

    public Object setURLValue(Vector vector, Vector vector2, SMRawDataResponse sMRawDataResponse, Object object) throws SMAPIException {
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = vector.elementAt(n).toString();
            ++n;
        }
        StObject[][] stObjectArray = new StObject[vector2.size()][];
        int n2 = 0;
        while (n2 < vector2.size()) {
            Vector vector3 = (Vector)vector2.elementAt(n2);
            stObjectArray[n2] = new StObject[vector3.size()];
            int n3 = 0;
            while (n3 < vector3.size()) {
                stObjectArray[n2][n3] = (StObject)vector3.elementAt(n3);
                ++n3;
            }
            ++n2;
        }
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(1, stringArray, null, sMRawDataResponse, object, false);
        this.dispatchRequest(1, stringArray, stObjectArray, null, sMPeriodicRequestHandler);
        return sMPeriodicRequestHandler;
    }

    public StObject[][] setURLValue(String[] stringArray, StObject[][] stObjectArray) throws SMAPIException {
        StObject[][][] stObjectArray2 = new StObject[1][][];
        SMRequestStatus[] sMRequestStatusArray = new SMRequestStatus[1];
        boolean[] blArray = new boolean[1];
        Object object = new Object();
        blArray[0] = true;
        stObjectArray2[0] = null;
        sMRequestStatusArray[0] = null;
        class InnersetMOResponseImpl
        extends SMRawDataResponseAdapter {
            private final /* synthetic */ boolean[] val$timeoutflag;
            private final /* synthetic */ SMRequestStatus[] val$stat;
            private final /* synthetic */ StObject[][][] val$result;

            InnersetMOResponseImpl(StObject[][][] stObjectArray, SMRequestStatus[] sMRequestStatusArray, boolean[] blArray) {
                this.val$result = stObjectArray;
                this.val$stat = sMRequestStatusArray;
                this.val$timeoutflag = blArray;
            }

            public void setURLResponse(SMRequestStatus sMRequestStatus, StObject[][] stObjectArray, Object object) {
                InnersetMOResponseImpl innersetMOResponseImpl2 = this;
                synchronized (innersetMOResponseImpl2) {
                    if (sMRequestStatus.getReturnCode() == 0) {
                        this.val$result[0] = stObjectArray;
                    } else {
                        this.val$stat[0] = sMRequestStatus;
                    }
                    this.val$timeoutflag[0] = false;
                    this.notify();
                }
            }

            public final void waitForMessage() throws SMAPIException {
                InnersetMOResponseImpl innersetMOResponseImpl2 = this;
                synchronized (innersetMOResponseImpl2) {
                    try {
                        if (this.val$stat[0] == null && this.val$result[0] == null) {
                            this.wait();
                        }
                    }
                    catch (Exception exception) {
                        throw new SMAPIException(exception.getMessage());
                    }
                }
            }
        }
        InnersetMOResponseImpl innersetMOResponseImpl2 = new InnersetMOResponseImpl(stObjectArray2, sMRequestStatusArray, blArray);
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(1, stringArray, null, innersetMOResponseImpl2, object, true);
        this.dispatchRequest(1, stringArray, stObjectArray, null, sMPeriodicRequestHandler);
        innersetMOResponseImpl2.waitForMessage();
        if (sMRequestStatusArray[0] != null) {
            throw new SMAPIException(sMRequestStatusArray[0].getReturnCode(), sMRequestStatusArray[0].getMessageText());
        }
        if (blArray[0]) {
            String string = "base.client.ClientApiMessages:RawDataRequest.TimeoutHasOccurred";
            throw new SMAPIException(3, UcInternationalizer.translateKey((Locale)this.locale, (String)string));
        }
        return stObjectArray2[0];
    }

    public Object setURLValue(String[] stringArray, StObject[][] stObjectArray, SMRawDataResponse sMRawDataResponse, Object object) throws SMAPIException {
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(1, stringArray, null, sMRawDataResponse, object, true);
        this.dispatchRequest(1, stringArray, stObjectArray, null, sMPeriodicRequestHandler);
        return sMPeriodicRequestHandler;
    }

    public void versionCheck(String string) {
    }
}

