/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.dataview.table;

import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.client.console.SMContextPopupEvent;
import com.sun.symon.base.client.console.SMTblSelectionInfo;
import com.sun.symon.base.client.table.SMTableColumnFormatInfo;
import com.sun.symon.base.console.views.dataview.base.DataviewTableFormatListener;
import com.sun.symon.base.console.views.dataview.data.DataCollectorListener;
import com.sun.symon.base.console.views.dataview.table.CellRowFormat;
import com.sun.symon.base.console.views.dataview.table.CvDvTableModel;
import com.sun.symon.base.console.views.dataview.table.DataviewTableFormatContext;
import com.sun.symon.base.console.views.dataview.util.DataviewUtil;
import com.sun.symon.base.console.views.dataview.util.MetaEvent;
import com.sun.symon.base.console.views.table.CvCommonTable;
import com.sun.symon.base.console.views.table.CvTableContainer;
import com.sun.symon.base.console.views.table.CvTableSelectEvent;
import com.sun.symon.base.console.views.table.CvTableSelectListener;
import com.sun.symon.base.console.views.table.CvTblTableColumn;
import com.sun.symon.base.console.views.table.CvTblTableEvent;
import com.sun.symon.base.console.views.table.CvTblTableEventListener;
import com.sun.symon.base.console.views.table.CvTblTableHeader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class CvDvTablePane
extends JScrollPane
implements CvTblTableEventListener,
CvTableContainer,
DataviewTableFormatListener,
DataCollectorListener {
    private JPanel tableHolder = new JPanel();
    private CvCommonTable table;
    private CvDvTableModel model;
    private JLabel title;
    private Vector headerNames = new Vector();
    private Vector selectListeners = new Vector();
    private boolean selectClearInProgress = false;
    protected static final int DEFAULT_TABLE_WIDTH = 335;
    protected static final int DEFAULT_COLUMN_WIDTH = 120;
    protected static final int MIN_COLUMN_WIDTH = -1;
    public static final String ALARMMODE_BACKGROUND = "background";
    protected static final String DEFAULT_ALARM_MODE = "background";
    protected static final Font DEFAULT_ALARM_FONT = new Font("dialog", 0, 12);
    protected static final Font DEFAULT_HEADER_FONT = new Font("dialog", 1, 12);
    protected static final Font DEFAULT_NORMAL_FONT = new Font("dialog", 0, 12);
    protected static final Font DEFAULT_TITLE_FONT = new Font("dialog", 3, 14);
    protected static final int DEFAULT_TITLE_JUSTIFICATION = 2;
    protected int tableWidth = 335;
    protected int maxDataWidth = 0;
    protected Color tableBackground = Color.white;
    protected Color tableForeground = Color.black;
    protected Color gridColor = Color.black;
    protected Font normalFont = DEFAULT_NORMAL_FONT;
    protected Font alarmFont = DEFAULT_ALARM_FONT;
    protected Font headerFont = DEFAULT_HEADER_FONT;
    protected Font titleFont = DEFAULT_TITLE_FONT;
    protected int titleJustification = 2;
    protected Color titleBackground = new Color(102, 96, 170);
    protected Color titleForeground = Color.white;
    protected String alarmMode = "background";
    protected boolean showHeader = true;
    protected boolean showHorizontalLines = true;
    protected boolean showVerticalLines = true;
    protected Icon acknowledgedIcon = null;
    protected boolean cellSelectionAllowed = true;
    protected int defaultColumnWidth = 120;
    protected String i18nHostname = DataviewUtil.translateI18nMsg("CvDvTablePane.i18nHostname");
    protected String i18nProperty = DataviewUtil.translateI18nMsg("CvDvTablePane.i18nProperty");
    protected String i18nValue = DataviewUtil.translateI18nMsg("CvDvTablePane.i18nValue");

    public CvDvTablePane() {
        this.tableHolder.setLayout(new BoxLayout(this.tableHolder, 1));
        this.tableHolder.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getViewport().add(this.tableHolder);
        this.tableHolder.setOpaque(true);
        int n = ((Component)this).getFontMetrics(this.normalFont).getAscent() + ((Component)this).getFontMetrics(this.normalFont).getDescent() + 4;
        this.getHorizontalScrollBar().setUnitIncrement(n);
        this.getVerticalScrollBar().setUnitIncrement(n);
    }

    public void addCvTableSelectListener(CvTableSelectListener cvTableSelectListener) {
        this.selectListeners.addElement(cvTableSelectListener);
    }

    public void addFixedPartInRows(DataviewTableFormatContext dataviewTableFormatContext) {
        int n;
        int n2;
        if (dataviewTableFormatContext == null) {
            return;
        }
        int[] nArray = dataviewTableFormatContext.getAddRows();
        if (nArray == null || nArray.length == 0) {
            n2 = dataviewTableFormatContext.getNumRows();
            nArray = new int[n2];
            n = 0;
            while (n < n2) {
                nArray[n] = n;
                ++n;
            }
        }
        n2 = nArray.length;
        n = 0;
        while (n < nArray.length) {
            CellRowFormat cellRowFormat = (CellRowFormat)dataviewTableFormatContext.getRow(nArray[n]);
            CvDvTablePane cvDvTablePane = this;
            synchronized (cvDvTablePane) {
                this.model.insertRow(cellRowFormat.getHostName(), cellRowFormat.getPortNo(), cellRowFormat.getAuxInfo(), cellRowFormat.getURL(), nArray[n]);
            }
            ++n;
        }
    }

    public void clearSelection() {
        this.table.clearSelection();
    }

    public int convertRowToModel(int n) {
        return this.model.convertRowToModel(n);
    }

    public void dataviewChanged(MetaEvent metaEvent, int n) {
        DataviewTableFormatContext dataviewTableFormatContext = (DataviewTableFormatContext)metaEvent.getData();
        switch (n) {
            case 0: {
                this.setupTable(dataviewTableFormatContext);
                this.addFixedPartInRows(dataviewTableFormatContext);
                this.revalidate();
                this.repaint();
                break;
            }
            case 1: {
                this.addFixedPartInRows(dataviewTableFormatContext);
                break;
            }
            case 2: {
                this.deleteRows(dataviewTableFormatContext);
                break;
            }
        }
    }

    public void deleteRows(DataviewTableFormatContext dataviewTableFormatContext) {
        int n = dataviewTableFormatContext.getNumRowsToDelete();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.model.deleteRow(dataviewTableFormatContext.getDeleteRow(n2));
            --n2;
        }
        this.table.revalidate();
        this.table.repaint();
    }

    public void doLayout() {
        this.tableHolder.setSize(this.tableHolder.getPreferredSize());
        this.layoutTitles();
        super.doLayout();
    }

    public Icon getAcknowledgedIcon() {
        return this.acknowledgedIcon;
    }

    public Font getAlarmFont() {
        return this.alarmFont;
    }

    public String getAlarmMode() {
        return this.alarmMode;
    }

    public String getColumnHeading(int n, int n2) {
        return (String)this.headerNames.get(n2);
    }

    public String getExclusionsFor(int n, int n2) {
        return null;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public SMContextPopupEvent getSelectContext() {
        SMTblSelectionInfo sMTblSelectionInfo;
        if (this.table != null && (sMTblSelectionInfo = this.table.getContextSelection()) != null && sMTblSelectionInfo.getSelectionType() == 2) {
            int n = sMTblSelectionInfo.getSelectedRow();
            int n2 = sMTblSelectionInfo.getSelectedColumn();
            int n3 = this.table.convertColumnIndexToModel(n2);
            String string = this.model.getFullURL(n, n3);
            String string2 = this.model.getFullName(n, n3);
            SMContextPopupEvent sMContextPopupEvent = new SMContextPopupEvent(this.table, sMTblSelectionInfo, string2, string, n, n2, null);
            return sMContextPopupEvent;
        }
        return null;
    }

    public boolean getShowHeader() {
        return this.showHeader;
    }

    public Color getTableBackground() {
        return this.tableBackground == null ? this.getBackground() : this.tableBackground;
    }

    public Color getTableForeground() {
        return this.tableForeground == null ? this.getForeground() : this.tableForeground;
    }

    public int getTableWidth() {
        return this.tableWidth;
    }

    public Color getTitleBackground() {
        return this.titleBackground;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public Color getTitleForeground() {
        return this.titleForeground;
    }

    public int getTitleJustification() {
        return this.titleJustification;
    }

    protected void layoutTitles() {
        if (this.title != null && this.table != null) {
            Dimension dimension = this.title.getSize();
            Dimension dimension2 = new Dimension(dimension.width, dimension.height);
            this.title.setSize(dimension2);
        }
    }

    public void receiveTableDataEvent(MetaEvent metaEvent) {
        String[][] stringArray = (String[][])metaEvent.getData();
        CvDvTablePane cvDvTablePane = this;
        synchronized (cvDvTablePane) {
            this.model.setDataValues(stringArray);
        }
        this.table.revalidate();
        this.table.repaint();
    }

    public void receiveTableStatusDataEvent(MetaEvent metaEvent) {
        SMAlarmStatusData[][] sMAlarmStatusDataArray = (SMAlarmStatusData[][])metaEvent.getData();
        CvDvTablePane cvDvTablePane = this;
        synchronized (cvDvTablePane) {
            this.model.setStatusValues(sMAlarmStatusDataArray);
        }
        this.table.revalidate();
        this.table.repaint();
    }

    public void removeCvTableSelectListener(CvTableSelectListener cvTableSelectListener) {
        this.selectListeners.removeElement(cvTableSelectListener);
    }

    public void setAcknowledgedIcon(Icon icon) {
        this.acknowledgedIcon = icon;
        this.table.setAcknowledgedIcon(icon);
    }

    public void setAlarmFont(Font font) {
        this.alarmFont = font != null ? font : DEFAULT_ALARM_FONT;
        this.updateModelProperties();
    }

    public void setAllowCellSelect(boolean bl) {
        this.cellSelectionAllowed = bl;
        this.updateTableProperties();
    }

    public void setGridColor(Color color) {
        if (color != null) {
            this.gridColor = color;
            this.updateTableProperties();
        }
    }

    public void setShowHeader(boolean bl) {
        this.showHeader = bl;
    }

    public void setShowHorizontalLines(boolean bl) {
        this.showHorizontalLines = bl;
        this.updateTableProperties();
    }

    public void setShowVerticalLines(boolean bl) {
        this.showVerticalLines = bl;
        this.updateTableProperties();
    }

    public void setTableWidth(int n) {
        this.tableWidth = n > 0 ? n : 335;
    }

    public void setTitleBackground(Color color) {
        this.titleBackground = color != null ? color : this.titleBackground;
        this.title.setBackground(this.titleBackground);
    }

    public void setTitleFont(Font font) {
        this.titleFont = font != null ? font : DEFAULT_TITLE_FONT;
        this.title.setFont(this.titleFont);
    }

    public void setTitleForeground(Color color) {
        this.titleForeground = color != null ? color : this.titleBackground;
        this.title.setForeground(this.titleForeground);
    }

    public void setTitleJustification(int n) {
        if (n == 2 || n == 4 || n == 0) {
            this.titleJustification = n;
            this.title.setHorizontalAlignment(this.titleJustification);
        }
    }

    public void setupTable(DataviewTableFormatContext dataviewTableFormatContext) {
        try {
            Object object;
            this.tableHolder.removeAll();
            this.tableHolder.revalidate();
            this.tableHolder.repaint();
            if (dataviewTableFormatContext == null) {
                this.table = null;
                this.model = null;
                return;
            }
            this.table = new CvCommonTable();
            int n = dataviewTableFormatContext.getNumColumns();
            int n2 = 0;
            this.model = new CvDvTableModel(this, 0);
            if (dataviewTableFormatContext.getType() == 1) {
                this.model.setVertical(false);
                this.model.setRealNumColumns(n + 1);
            } else {
                this.model.setVertical(true);
            }
            this.model.setBackground(this.getTableBackground());
            this.model.setForeground(this.getTableForeground());
            this.model.setAllProperties(this.getHeaderFont(), this.getNormalFont(), this.getAlarmFont(), this.getAlarmMode());
            this.model.addTableEventListener(this);
            this.model.setAllowEdit(false);
            this.table.setModel((TableModel)((Object)this.model));
            this.table.setBackground(this.getTableBackground());
            this.table.setForeground(this.getTableForeground());
            this.table.setShowHorizontalLines(this.showHorizontalLines);
            this.table.setShowVerticalLines(this.showVerticalLines);
            this.table.setAcknowledgedIcon(this.acknowledgedIcon);
            this.table.setAllowCellSelect(this.cellSelectionAllowed);
            this.table.setColumnSelectionAllowed(false);
            this.table.addTableEventListener((CvTblTableEventListener)this);
            this.model.setOwnTable(this.table);
            if (this.gridColor != null) {
                this.table.setGridColor(this.gridColor);
            }
            this.title = new JLabel(dataviewTableFormatContext.getTitle());
            this.title.setForeground(this.titleForeground);
            this.title.setBackground(this.titleBackground);
            this.title.setFont(this.titleFont);
            this.title.setHorizontalAlignment(this.titleJustification);
            this.title.setLabelFor((Component)this.table);
            this.title.setOpaque(true);
            CvTblTableColumn cvTblTableColumn = new CvTblTableColumn(0, this.i18nHostname, "string", this.defaultColumnWidth);
            this.headerNames.addElement(this.i18nHostname);
            this.table.addColumn((TableColumn)cvTblTableColumn);
            cvTblTableColumn.addTableEventListener((CvTblTableEventListener)this);
            if (!this.model.getVertical()) {
                this.model.setURLs(0, null, null);
                int n3 = 0;
                while (n3 < n) {
                    object = (SMTableColumnFormatInfo)dataviewTableFormatContext.getColumn(n3);
                    n2 = this.defaultColumnWidth;
                    if (n2 < 1) {
                        n2 = this.defaultColumnWidth;
                    }
                    this.model.setURLs(n3 + 1, object.getDataURL(), SMRawDataRequest.buildShadowURL((String)object.getDataURL(), (String)"status", null));
                    cvTblTableColumn = new CvTblTableColumn(n3 + 1, object.getColumnHeading(), "string", n2);
                    this.headerNames.addElement(object.getColumnHeading());
                    this.table.addColumn((TableColumn)cvTblTableColumn);
                    cvTblTableColumn.addTableEventListener((CvTblTableEventListener)this);
                    ++n3;
                }
            } else {
                cvTblTableColumn = new CvTblTableColumn(1, this.i18nProperty, "string", this.defaultColumnWidth);
                this.headerNames.addElement(this.i18nProperty);
                this.table.addColumn((TableColumn)cvTblTableColumn);
                cvTblTableColumn.addTableEventListener((CvTblTableEventListener)this);
                cvTblTableColumn = new CvTblTableColumn(2, this.i18nValue, "string", this.defaultColumnWidth);
                this.headerNames.addElement(this.i18nValue);
                this.table.addColumn((TableColumn)cvTblTableColumn);
                cvTblTableColumn.addTableEventListener((CvTblTableEventListener)this);
            }
            this.tableHolder.add(this.title);
            this.tableHolder.add(Box.createRigidArea(new Dimension(3, 3)));
            if (this.showHeader) {
                CvTblTableHeader cvTblTableHeader = new CvTblTableHeader(this.table.getColumnModel());
                this.table.setTableHeader((JTableHeader)cvTblTableHeader);
                object = cvTblTableHeader.getSize();
                int n4 = this.table.getColumnModel().getTotalColumnWidth();
                int n5 = this.table.getRowHeight();
                object.width = n4;
                object.height = n5;
                cvTblTableHeader.setPreferredSize((Dimension)object);
                cvTblTableHeader.addMouseListener((MouseListener)this.table);
                cvTblTableHeader.setAlignmentX(0.0f);
                cvTblTableHeader.setAlignmentY(0.0f);
                this.tableHolder.add((Component)cvTblTableHeader);
            }
            this.table.reallyDraw();
            this.tableHolder.add((Component)this.table);
            this.tableHolder.setSize(this.getPreferredSize());
            this.tableHolder.validate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void tableEventOccurred(CvTblTableEvent cvTblTableEvent) {
        switch (cvTblTableEvent.getEventType()) {
            case 1: {
                int n;
                this.tableHolder.validate();
                this.tableHolder.setSize(this.tableHolder.getSize());
                this.layoutTitles();
                this.table.reallyDraw();
                JTableHeader jTableHeader = this.table.getTableHeader();
                Dimension dimension = jTableHeader.getSize();
                dimension.width = n = this.table.getColumnModel().getTotalColumnWidth();
                jTableHeader.setPreferredSize(dimension);
                break;
            }
            case 5: 
            case 7: {
                CvTableSelectEvent cvTableSelectEvent = new CvTableSelectEvent((Object)this, cvTblTableEvent.getEventType() == 7 ? -1 : 1);
                int n = 0;
                while (n < this.selectListeners.size()) {
                    CvTableSelectListener cvTableSelectListener = (CvTableSelectListener)this.selectListeners.elementAt(n);
                    cvTableSelectListener.selectionOccurred(cvTableSelectEvent);
                    ++n;
                }
                cvTableSelectEvent = (CvCommonTable)cvTblTableEvent.getSource();
                cvTableSelectEvent.repaint();
                break;
            }
            case 6: {
                if (this.selectClearInProgress) break;
                CvTableSelectEvent cvTableSelectEvent = new CvTableSelectEvent((Object)this, 1);
                int n = 0;
                while (n < this.selectListeners.size()) {
                    CvTableSelectListener cvTableSelectListener = (CvTableSelectListener)this.selectListeners.elementAt(n);
                    cvTableSelectListener.selectionOccurred(cvTableSelectEvent);
                    ++n;
                }
                break;
            }
        }
    }

    protected void updateModelProperties() {
        if (this.model == null) {
            return;
        }
        this.model.setAllProperties(this.headerFont, this.normalFont, this.alarmFont, this.alarmMode);
    }

    protected void updateTableProperties() {
        if (this.gridColor != null) {
            this.table.setGridColor(this.gridColor);
        }
        this.table.setShowHorizontalLines(this.showHorizontalLines);
        this.table.setShowVerticalLines(this.showVerticalLines);
        this.table.setAllowCellSelect(this.cellSelectionAllowed);
    }
}

