/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.groupOperation;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.group.SMFilter;
import com.sun.symon.base.client.group.SMObjectGroup;
import com.sun.symon.base.client.group.SMObjectGroupInfo;
import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDBChangeListener;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMHandle;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.task.SMTask;
import com.sun.symon.base.client.task.SMTaskInfo;
import com.sun.symon.base.client.task.SMTaskRequest;
import com.sun.symon.base.client.task.SMTaskRequestData;
import com.sun.symon.base.client.task.SMTaskRequestInfo;
import com.sun.symon.base.console.grouping.CgDialogContainer;
import com.sun.symon.base.console.grouping.CgDialogInterface;
import com.sun.symon.base.console.grouping.CgUtil;
import com.sun.symon.base.console.grouping.filter.CgFilterManagerDlg;
import com.sun.symon.base.console.grouping.groupOperation.CgGroupPane;
import com.sun.symon.base.console.grouping.groupOperation.CgRequestLogViewDialog;
import com.sun.symon.base.console.grouping.groupOperation.CgSchedEditor;
import com.sun.symon.base.console.grouping.groupOperation.CgTaskSummPane;
import com.sun.symon.base.console.grouping.groupOperation.ChangeNotifier;
import com.sun.symon.base.console.grouping.objectgroup.CgOGManagerDialog;
import com.sun.symon.base.console.grouping.table.CgData;
import com.sun.symon.base.console.grouping.table.CgRowSaveEvent;
import com.sun.symon.base.console.grouping.table.CgRowSaveListener;
import com.sun.symon.base.console.grouping.table.CgTblColumnFormat;
import com.sun.symon.base.console.grouping.table.CgTblPane;
import com.sun.symon.base.console.grouping.table.CgTblSelectEvent;
import com.sun.symon.base.console.grouping.table.CgTblSelectListener;
import com.sun.symon.base.console.grouping.task.CgTaskManager;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.console.mcp.CpMCPManager;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcThreadWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumnModel;

public class CgGpFrame
extends JFrame
implements CgTblSelectListener,
CgRowSaveListener,
CgDialogContainer {
    Hashtable dlgHash = new Hashtable();
    final String GROUP = "group";
    final String FILTER = "filter";
    final String TASK = "task";
    final String MCP = "mcp";
    final String VIEWLOG = "viewLog";
    private static final int VIEW_ITEM = 5;
    private static final int DELETE = 0;
    private static final int RESUME = 1;
    private static final int SUSPEND = 2;
    Vector buttons = new Vector();
    JComboBox groupCombo;
    JComboBox taskCombo;
    CgGroupPane groupPane;
    CgTblPane requestPane;
    JMenuItem suspend;
    JMenuItem resume;
    JButton resumeButton;
    JButton suspendButton;
    JMenuItem delItem;
    JButton delButton;
    SMRawDataRequest handle;
    CgGpFrame own;
    Hashtable statIcons;
    Hashtable statTexts;
    SMTask taskHandle;
    JPanel taskSummaryPane;
    SMTaskRequestData requestData;
    SMObjectGroup groupHandle;
    SMTaskRequest requestHandle;
    SMFilter filterHandle;
    SMTaskRequestInfo[] taskRequestInfos = null;
    ImageIcon schedIcon;
    ImageIcon noSchedIcon;
    JLabel schedSummLabel;
    JTextArea despArea;
    boolean bSaving = false;
    boolean filterRunning = false;
    String selectedRequestName = " ";
    final String[] newItems = new String[]{"standard.newGroup", "standard.newFilter", "standard.newTask", "standard.newMCP"};
    final String[] createItems = new String[]{"standard.createGroup", "standard.createFilter", "standard.createTask", "standard.createMCP"};
    boolean bNotRefresh = false;

    public CgGpFrame() throws SMAPIException {
        this((SMRawDataRequest)null);
    }

    public CgGpFrame(SMRawDataRequest sMRawDataRequest) throws SMAPIException {
        this.setDefaultCloseOperation(0);
        this.own = this;
        this.handle = sMRawDataRequest == null ? SMConsoleContext.getInstance().getAPIHandle() : sMRawDataRequest;
        this.checkLicense();
        this.groupPane = new CgGroupPane(this, this.groupHandle, this.filterHandle);
        this.initIconsAndTexts();
        this.createGroupCombo();
        this.createTaskCombo();
        this.createGUI();
        this.fillRequestTable();
        this.installListeners();
        SMResourceAccess sMResourceAccess = new SMResourceAccess(this.handle);
        Image image = sMResourceAccess.getImage("stdimages/symon-small.gif");
        ((Frame)this).setIconImage(image);
        CgUtil.registerMainGroupWindow((JFrame)this.own);
    }

    public void addDialogToPool(JDialog jDialog, String string) {
        this.dlgHash.put(string, jDialog);
    }

    public void checkLicense() throws SMAPIException {
        try {
            this.requestHandle = new SMTaskRequest(this.handle);
            this.groupHandle = new SMObjectGroup(this.handle);
            this.filterHandle = new SMFilter(this.handle);
            this.taskHandle = new SMTask(this.handle);
            UcCommon.isServiceLicenseAvailable((String)"Task_TaskRequest", (Component)this.own);
        }
        catch (SMAPIException sMAPIException) {
            throw new SMAPIException(sMAPIException.getReasonCode(), CgUtil.getI18nMsg((String)"rqstMgr.requestErr"));
        }
    }

    private CgTblColumnFormat[] createColumnFormats() {
        CgTblColumnFormat[] cgTblColumnFormatArray = new CgTblColumnFormat[5];
        cgTblColumnFormatArray[0] = new CgTblColumnFormat(CgUtil.getI18nMsg((String)"standard.name"), true, null);
        cgTblColumnFormatArray[0].setToolTip(CgUtil.getI18nMsg((String)"standard.click"));
        cgTblColumnFormatArray[1] = new CgTblColumnFormat(CgUtil.getI18nMsg((String)"standard.group"), true, new DefaultCellEditor(this.groupCombo));
        cgTblColumnFormatArray[1].setToolTip(CgUtil.getI18nMsg((String)"rqstMgr.group_tooltip"));
        cgTblColumnFormatArray[2] = new CgTblColumnFormat(CgUtil.getI18nMsg((String)"standard.task"), true, new DefaultCellEditor(this.taskCombo));
        cgTblColumnFormatArray[2].setToolTip(CgUtil.getI18nMsg((String)"rqstMgr.task_tooltip"));
        CgSchedEditor cgSchedEditor = new CgSchedEditor(this, this.schedIcon, this.noSchedIcon);
        cgTblColumnFormatArray[3] = new CgTblColumnFormat(CgUtil.getI18nMsg((String)"schTab"), true, (DefaultCellEditor)cgSchedEditor);
        cgTblColumnFormatArray[4] = new CgTblColumnFormat(CgUtil.getI18nMsg((String)"rqstMgr.State"), false, null);
        return cgTblColumnFormatArray;
    }

    private JMenu createEditMenu() {
        String string = CgUtil.getI18nMsg((String)"standard.edit");
        JMenu jMenu = new JMenu(string);
        String[] stringArray = new String[]{"standard.editGroup", "standard.editFilter", "standard.editTask"};
        string = CgUtil.getI18nMsg((String)"standard.delete");
        this.delItem = new JMenuItem(string);
        this.buttons.add(this.delItem);
        this.delItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgGpFrame.this.deleteRequest();
            }
        });
        jMenu.add(this.delItem);
        jMenu.addSeparator();
        int n = 0;
        while (n < stringArray.length) {
            string = CgUtil.getI18nMsg((String)stringArray[n]);
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(new NewMenuItemListener(n, 1));
            jMenu.add(jMenuItem);
            ++n;
        }
        return jMenu;
    }

    private JMenu createFileMenu() {
        JMenuItem jMenuItem;
        String string = CgUtil.getI18nMsg((String)"standard.file");
        JMenu jMenu = new JMenu(string);
        string = CgUtil.getI18nMsg((String)"standard.new");
        JMenu jMenu2 = new JMenu(string);
        int n = 0;
        while (n < this.newItems.length) {
            string = CgUtil.getI18nMsg((String)this.newItems[n]);
            jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(new NewMenuItemListener(n, 0));
            jMenu2.add(jMenuItem);
            ++n;
        }
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        string = CgUtil.getI18nMsg((String)"rqstMgr.suspend");
        this.suspend = new JMenuItem(string);
        this.buttons.add(this.suspend);
        this.suspend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgGpFrame.this.suspendRequest();
            }
        });
        jMenu.add(this.suspend);
        string = CgUtil.getI18nMsg((String)"rqstMgr.resume");
        this.resume = new JMenuItem(string);
        this.buttons.add(this.resume);
        this.resume.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgGpFrame.this.resumeRequest();
            }
        });
        jMenu.add(this.resume);
        jMenu.addSeparator();
        string = CgUtil.getI18nMsg((String)"rqstMgr.save");
        jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgGpFrame.this.saveRequest();
            }
        });
        jMenu.add(jMenuItem);
        string = CgUtil.getI18nMsg((String)"standard.close");
        JMenuItem jMenuItem2 = new JMenuItem(string);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgGpFrame.this.dispose();
            }
        });
        jMenu.add(jMenuItem2);
        return jMenu;
    }

    private void createGUI() {
        this.setTitle(CgUtil.getI18nMsg((String)"rqstMgr.groupLabel"));
        JPanel jPanel = new JPanel();
        this.setJMenuBar(this.createMenuBar());
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JToolBar jToolBar = this.createToolBar();
        jToolBar.setBorder(new EmptyBorder(5, 12, 5, 12));
        jPanel.add(jToolBar);
        jPanel.add(new JSeparator());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setBorder(new TitledBorder(LineBorder.createGrayLineBorder()));
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(CgUtil.getI18nMsg((String)"rqstMgr.groupLabel"));
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        CgTblColumnFormat[] cgTblColumnFormatArray = this.createColumnFormats();
        this.requestPane = new CgTblPane(cgTblColumnFormatArray, true);
        this.requestPane.setPreferredSize(new Dimension(520, 90));
        this.requestPane.addCgTblSelectListener((CgTblSelectListener)this);
        this.requestPane.addCgRowSaveListener((CgRowSaveListener)this);
        TableColumnModel tableColumnModel = this.requestPane.getTable().getColumnModel();
        tableColumnModel.getColumn(3).setPreferredWidth(40);
        tableColumnModel.getColumn(4).setPreferredWidth(80);
        tableColumnModel.getColumn(0).setPreferredWidth(125);
        jPanel2.add((Component)this.requestPane, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        jLabel = new JLabel(CgUtil.getI18nMsg((String)"standard.descLabel"));
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.despArea = new JTextArea(2, 20);
        JScrollPane jScrollPane = new JScrollPane(this.despArea);
        jPanel2.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        jPanel3.setBorder(new TitledBorder(LineBorder.createGrayLineBorder()));
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)this.groupPane, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.taskSummaryPane = new JPanel(new BorderLayout());
        this.taskSummaryPane.setAlignmentX(0.0f);
        this.taskSummaryPane.setBorder(new TitledBorder(LineBorder.createGrayLineBorder(), CgUtil.getI18nMsg((String)"rqstMgr.taskTitle")));
        this.taskSummaryPane.setPreferredSize(new Dimension(520, 100));
        jPanel3.add((Component)this.taskSummaryPane, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.schedSummLabel = new JLabel(" ");
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(new TitledBorder(LineBorder.createGrayLineBorder(), CgUtil.getI18nMsg((String)"rqstMgr.schedTitle")));
        jPanel4.add(this.schedSummLabel);
        jPanel3.add((Component)jPanel4, gridBagConstraints);
        Dimension dimension = jPanel3.getPreferredSize();
        dimension = new Dimension(dimension.width, dimension.height + 10);
        jPanel3.setPreferredSize(dimension);
        JScrollPane jScrollPane2 = new JScrollPane(jPanel3);
        JSplitPane jSplitPane = new JSplitPane(0, false, jPanel2, jScrollPane2);
        jSplitPane.setBorder(new EmptyBorder(5, 12, 20, 12));
        jPanel.add(jSplitPane);
        this.getContentPane().add(jPanel);
    }

    private void createGroupCombo() {
        this.groupCombo = new JComboBox();
        Runnable runnable = new Runnable(){

            public void run() {
                CgGpFrame.this.groupChanged(null);
                try {
                    ChangeNotifier changeNotifier = new ChangeNotifier(1, CgGpFrame.this.own);
                    CgGpFrame.this.groupHandle.addDBChangeListener((SMDBChangeListener)changeNotifier);
                }
                catch (SMAPIException sMAPIException) {
                    UcDialog.showError((Component)CgGpFrame.this.own, (Object)sMAPIException.getMessage());
                }
            }
        };
        new Thread(runnable).start();
    }

    private JMenu createHelpMenu() {
        String string = CgUtil.getI18nMsg((String)"standard.help");
        JMenu jMenu = new JMenu(string);
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CmConsoleSession.getInstance().launchHelp("grouping-request-manager-help");
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.createFileMenu());
        jMenuBar.add(this.createEditMenu());
        jMenuBar.add(this.createViewMenu());
        jMenuBar.add(Box.createHorizontalGlue());
        jMenuBar.add(this.createHelpMenu());
        return jMenuBar;
    }

    private void createTaskCombo() {
        this.taskCombo = new JComboBox();
        Runnable runnable = new Runnable(){

            public void run() {
                CgGpFrame.this.taskChanged(null);
                try {
                    ChangeNotifier changeNotifier = new ChangeNotifier(0, CgGpFrame.this.own);
                    CgGpFrame.this.taskHandle.addDBChangeListener((SMDBChangeListener)changeNotifier);
                }
                catch (SMAPIException sMAPIException) {
                    UcDialog.showError((Component)CgGpFrame.this.own, (Object)sMAPIException.getMessage());
                }
            }
        };
        new Thread(runnable).start();
    }

    private JToolBar createToolBar() {
        Accessible accessible;
        String string;
        SMResourceAccess sMResourceAccess = new SMResourceAccess(this.handle);
        JToolBar jToolBar = new JToolBar();
        ImageIcon[] imageIconArray = new ImageIcon[]{new ImageIcon(sMResourceAccess.getImage("stdimages/CreateEditGroup-24x24.gif")), new ImageIcon(sMResourceAccess.getImage("stdimages/CreateEditFilter-24x24.gif")), new ImageIcon(sMResourceAccess.getImage("stdimages/CreateEditTask-24x24.gif")), new ImageIcon(sMResourceAccess.getImage("stdimages/CreateMCPParcel-24x24.gif"))};
        int n = 0;
        while (n < this.createItems.length) {
            string = CgUtil.getI18nMsg((String)this.createItems[n]);
            accessible = new JButton(imageIconArray[n]);
            ((JComponent)((Object)accessible)).setToolTipText(string);
            ((AbstractButton)((Object)accessible)).addActionListener(new NewMenuItemListener(n, 2));
            jToolBar.add((Component)((Object)accessible));
            ((JComponent)((Object)accessible)).setToolTipText(string);
            ++n;
        }
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        accessible = new ImageIcon(sMResourceAccess.getImage("stdimages/DeleteGroupOperation-24x24.gif"));
        string = CgUtil.getI18nMsg((String)"standard.deleteGroup");
        this.delButton = new JButton((Icon)((Object)accessible));
        this.delButton.setToolTipText(string);
        jToolBar.add(this.delButton);
        this.delButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgGpFrame.this.deleteRequest();
            }
        });
        this.buttons.add(this.delButton);
        ImageIcon imageIcon = new ImageIcon(sMResourceAccess.getImage("stdimages/SuspendGroupOperation-24x24.gif"));
        string = CgUtil.getI18nMsg((String)"rqstMgr.suspendGroup");
        this.suspendButton = new JButton(imageIcon);
        this.suspendButton.setToolTipText(string);
        jToolBar.add(this.suspendButton);
        this.suspendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgGpFrame.this.suspendRequest();
            }
        });
        this.buttons.add(this.suspendButton);
        ImageIcon imageIcon2 = new ImageIcon(sMResourceAccess.getImage("stdimages/ResumeGroupOperation-24x24.gif"));
        string = CgUtil.getI18nMsg((String)"rqstMgr.resumeGroup");
        this.resumeButton = new JButton(imageIcon2);
        this.resumeButton.setToolTipText(string);
        jToolBar.add(this.resumeButton);
        this.resumeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgGpFrame.this.resumeRequest();
            }
        });
        this.buttons.add(this.resumeButton);
        ImageIcon imageIcon3 = new ImageIcon(sMResourceAccess.getImage("stdimages/SaveGroupOperation-24x24.gif"));
        string = CgUtil.getI18nMsg((String)"standard.saveGroup");
        JButton jButton = new JButton(imageIcon3);
        jButton.setToolTipText(string);
        jToolBar.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgGpFrame.this.saveRequest();
            }
        });
        jToolBar.setAlignmentX(0.0f);
        return jToolBar;
    }

    private JMenu createViewMenu() {
        String string = CgUtil.getI18nMsg((String)"standard.view");
        JMenu jMenu = new JMenu(string);
        string = CgUtil.getI18nMsg((String)"standard.viewLog");
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new NewMenuItemListener(5, 0));
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private final void deleteRequest() {
        int n = this.requestPane.getSelectedRow();
        if (n >= 0 && n < this.taskRequestInfos.length) {
            SMTaskRequestInfo sMTaskRequestInfo = this.taskRequestInfos[n];
            String string = String.valueOf(CgUtil.getI18nMsg((String)"DeleteConfirmation.msgLabel")) + CgUtil.getI18nMsg((String)"rqstMgr.delPlainMsg");
            int n2 = UcDialog.showOkCancel((String)string);
            if (n2 == 0) {
                this.threadWorkOnRequest(sMTaskRequestInfo, 0);
            }
        }
    }

    public void dispose() {
        Object object;
        int n;
        if ((this.requestPane.isTableDataUpdated() || this.requestPane.getTable().isEditing()) && (n = UcDialog.showOkCancel((String)(object = CgUtil.getI18nMsg((String)"TaskManager.closeMsg")))) == 1) {
            return;
        }
        CgUtil.removeMainGroupWindow();
        object = this.dlgHash.keys();
        while (object.hasMoreElements()) {
            Dialog dialog;
            String string = (String)object.nextElement();
            if (this.dlgHash.get(string) == null || !(dialog = (Dialog)this.dlgHash.get(string)).isDisplayable()) continue;
            if (dialog instanceof CgDialogInterface) {
                ((CgDialogInterface)dialog).close();
                continue;
            }
            dialog.dispose();
        }
        try {
            if (this.requestHandle != null) {
                this.requestHandle.close();
                this.requestHandle = null;
            }
            if (this.groupHandle != null) {
                this.groupHandle.close();
                this.groupHandle = null;
            }
            if (this.filterHandle != null) {
                this.filterHandle.close();
                this.filterHandle = null;
            }
            if (this.taskHandle != null) {
                this.taskHandle.close();
                this.taskHandle = null;
            }
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
        }
        super.dispose();
    }

    private void fillRequestTable() {
        Runnable runnable = new Runnable(){

            public void run() {
                CgGpFrame.this.requestChanged(null);
                try {
                    ChangeNotifier changeNotifier = new ChangeNotifier(2, CgGpFrame.this.own);
                    CgGpFrame.this.requestHandle.addDBChangeListener((SMDBChangeListener)changeNotifier);
                }
                catch (SMAPIException sMAPIException) {
                    UcDialog.showError((Component)CgGpFrame.this.own, (Object)sMAPIException.getMessage());
                }
            }
        };
        new Thread(runnable).start();
    }

    public SMTaskRequestData getCurrentRequestData() {
        return this.requestData;
    }

    public JDialog getDialogFromPool(String string) {
        return (JDialog)this.dlgHash.get(string);
    }

    public SMTaskRequest getRequestHandle() {
        return this.requestHandle;
    }

    public String getRequestName(int n) {
        if (this.taskRequestInfos == null) {
            return null;
        }
        if (n < 0 || n >= this.taskRequestInfos.length) {
            return null;
        }
        return this.taskRequestInfos[n].getName();
    }

    public String getSchedSummury(SMTaskRequestData sMTaskRequestData) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(CgUtil.getI18nMsg((String)"standard.start")) + " ");
        stringBuffer.append(DateFormat.getInstance().format(sMTaskRequestData.getStartDate()));
        return stringBuffer.toString();
    }

    private ImageIcon getStatusIcon(int n) {
        return (ImageIcon)this.statIcons.get(new Integer(n));
    }

    private String getStatusText(int n) {
        return (String)this.statTexts.get(new Integer(n));
    }

    public void groupChanged(SMDBChangeEvent sMDBChangeEvent) {
        SMObjectGroupInfo[] sMObjectGroupInfoArray;
        String[] stringArray = null;
        try {
            sMObjectGroupInfoArray = this.groupHandle.getAll();
            stringArray = new String[sMObjectGroupInfoArray.length];
            int n = 0;
            while (n < sMObjectGroupInfoArray.length) {
                stringArray[n] = sMObjectGroupInfoArray[n].getName();
                ++n;
            }
        }
        catch (SMAPIException sMAPIException) {}
        sMObjectGroupInfoArray = stringArray;
        Runnable runnable = new Runnable((String[])sMObjectGroupInfoArray, this){
            private final /* synthetic */ CgGpFrame this$0;
            private final /* synthetic */ String[] val$names;
            {
                this.val$names = stringArray;
                this.this$0 = cgGpFrame;
            }

            public void run() {
                String[] stringArray = new String[]{};
                if (this.val$names != null) {
                    stringArray = this.val$names;
                }
                this.this$0.groupCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void initIconsAndTexts() {
        SMResourceAccess sMResourceAccess = new SMResourceAccess(this.handle);
        this.schedIcon = new ImageIcon(sMResourceAccess.getImage("stdimages/SetSchedule-16x16.gif"));
        this.noSchedIcon = new ImageIcon(sMResourceAccess.getImage("stdimages/ActivateOnSave-16x16.gif"));
        this.statIcons = new Hashtable();
        this.statTexts = new Hashtable();
        ImageIcon imageIcon = new ImageIcon(sMResourceAccess.getImage("stdimages/Failed-16x16.gif"));
        Integer n = new Integer(16);
        this.statIcons.put(n, imageIcon);
        this.statTexts.put(n, CgUtil.getI18nMsg((String)"rqstMgr.fail"));
        ImageIcon imageIcon2 = new ImageIcon(sMResourceAccess.getImage("stdimages/success.gif"));
        n = new Integer(8);
        this.statIcons.put(n, imageIcon2);
        this.statTexts.put(n, CgUtil.getI18nMsg((String)"rqstMgr.suc"));
        ImageIcon imageIcon3 = new ImageIcon(sMResourceAccess.getImage("stdimages/MissedSchedule-16x16.gif"));
        n = new Integer(32);
        this.statIcons.put(n, imageIcon3);
        this.statTexts.put(n, CgUtil.getI18nMsg((String)"rqstMgr.miss"));
        ImageIcon imageIcon4 = new ImageIcon(sMResourceAccess.getImage("stdimages/Run-Failure-16x16.gif"));
        n = new Integer(18);
        this.statIcons.put(n, imageIcon4);
        this.statTexts.put(n, CgUtil.getI18nMsg((String)"rqstMgr.runfail"));
        ImageIcon imageIcon5 = new ImageIcon(sMResourceAccess.getImage("stdimages/Success-Suspended-16x16.gif"));
        n = new Integer(12);
        this.statIcons.put(n, imageIcon5);
        this.statTexts.put(n, CgUtil.getI18nMsg((String)"rqstMgr.sucSuspend"));
        ImageIcon imageIcon6 = new ImageIcon(sMResourceAccess.getImage("stdimages/Suspend-16x16.gif"));
        n = new Integer(4);
        this.statIcons.put(n, imageIcon6);
        this.statTexts.put(n, CgUtil.getI18nMsg((String)"rqstMgr.suspended"));
        ImageIcon imageIcon7 = new ImageIcon(sMResourceAccess.getImage("stdimages/Running-16x16.gif"));
        n = new Integer(2);
        this.statIcons.put(n, imageIcon7);
        this.statTexts.put(n, CgUtil.getI18nMsg((String)"rqstMgr.running"));
    }

    void installListeners() {
        this.requestPane.getTable().addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component == CgGpFrame.this.groupCombo) {
                    if (CgGpFrame.this.groupCombo.getItemCount() == 0) {
                        UcDialog.showError((Component)CgGpFrame.this, (Object)CgUtil.getI18nMsg((String)"rqstMgr.group_emptyPrompt"));
                    }
                } else if (component == CgGpFrame.this.taskCombo && CgGpFrame.this.taskCombo.getItemCount() == 0) {
                    UcDialog.showError((Component)CgGpFrame.this, (Object)CgUtil.getI18nMsg((String)"rqstMgr.task_emptyPrompt"));
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
            }
        });
        this.taskCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && itemEvent.getItem() instanceof String) {
                    CgGpFrame.this.showTaskData((String)itemEvent.getItem());
                }
            }
        });
        this.groupCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && itemEvent.getItem() instanceof String) {
                    String string = (String)itemEvent.getItem();
                    CgGpFrame.this.groupPane.refreshGroup(string);
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CgGpFrame.this.dispose();
            }
        });
    }

    public void removeDialogFromPool(String string) {
        this.dlgHash.remove(string);
    }

    public void requestChanged(SMDBChangeEvent sMDBChangeEvent) {
        Object object;
        SMTaskRequestInfo[] sMTaskRequestInfoArray = null;
        if (this.requestPane.isTableDataUpdated() && !this.bSaving) {
            if (this.bNotRefresh) {
                return;
            }
            this.bNotRefresh = true;
            object = CgUtil.getI18nMsg((String)"rqstMgr.refreshWarning");
            int n = UcDialog.showOkCancel((String)object);
            this.bNotRefresh = false;
            if (n == 0) {
                this.saveRequest();
                return;
            }
        }
        try {
            sMTaskRequestInfoArray = this.requestHandle.getAll();
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this.own, (Object)sMAPIException.getMessage());
        }
        this.taskRequestInfos = sMTaskRequestInfoArray;
        object = new Runnable(){

            public void run() {
                CgGpFrame.this.requestPane.clearSelection();
                CgGpFrame.this.requestPane.removeAllRows();
                if (CgGpFrame.this.taskRequestInfos != null) {
                    int n = 0;
                    CgData[][] cgDataArray = new CgData[CgGpFrame.this.taskRequestInfos.length][5];
                    int n2 = 0;
                    while (n2 < CgGpFrame.this.taskRequestInfos.length) {
                        cgDataArray[n2] = new CgData[5];
                        String string = CgGpFrame.this.taskRequestInfos[n2].getName();
                        boolean bl = CgGpFrame.this.taskRequestInfos[n2].isScheduled();
                        if (string.equals(CgGpFrame.this.selectedRequestName)) {
                            n = n2;
                        }
                        cgDataArray[n2][0] = new CgData(string);
                        cgDataArray[n2][1] = new CgData(CgGpFrame.this.taskRequestInfos[n2].getObjectGroupName());
                        cgDataArray[n2][2] = new CgData(CgGpFrame.this.taskRequestInfos[n2].getTaskName());
                        cgDataArray[n2][3] = bl ? new CgData(CgGpFrame.this.schedIcon) : new CgData(CgGpFrame.this.noSchedIcon);
                        int n3 = CgGpFrame.this.taskRequestInfos[n2].getStatus();
                        cgDataArray[n2][4] = new CgData(CgGpFrame.this.getStatusText(n3), CgGpFrame.this.getStatusIcon(n3));
                        ++n2;
                    }
                    CgGpFrame.this.requestPane.setData(cgDataArray);
                    CgGpFrame.this.requestPane.setRowSelectionInterval(n, n);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            object.run();
        } else {
            SwingUtilities.invokeLater((Runnable)object);
        }
    }

    private final void resumeRequest() {
        int n = this.requestPane.getSelectedRow();
        if (n >= 0 && n < this.taskRequestInfos.length) {
            SMTaskRequestInfo sMTaskRequestInfo = this.taskRequestInfos[n];
            this.threadWorkOnRequest(sMTaskRequestInfo, 1);
        }
    }

    public boolean saveData(CgRowSaveEvent cgRowSaveEvent) {
        this.saveRequest(cgRowSaveEvent.getSaveData(), true);
        return true;
    }

    private final boolean saveRequest() {
        int n = this.requestPane.getSelectedRow();
        Vector vector = this.requestPane.getRowData(n);
        return this.saveRequest(vector, true);
    }

    private final boolean saveRequest(Vector vector, boolean bl) {
        boolean bl2 = false;
        if (this.requestPane.isTableDataUpdated() || this.despArea.getText() != this.requestData.getDescription()) {
            String string;
            if (vector.get(0) == null || ((CgData)vector.get(0)).toString() == null) {
                UcDialog.showError((Component)this.own, (Object)CgUtil.getI18nMsg((String)"rqstMgr.noName"));
                return false;
            }
            if (vector.get(1) == null || ((CgData)vector.get(1)).toString() == null) {
                UcDialog.showError((Component)this.own, (Object)CgUtil.getI18nMsg((String)"rqstMgr.noGroup"));
                return false;
            }
            if (vector.get(2) == null || ((CgData)vector.get(2)).toString() == null) {
                UcDialog.showError((Component)this.own, (Object)CgUtil.getI18nMsg((String)"rqstMgr.noTask"));
                return false;
            }
            this.selectedRequestName = string = ((CgData)vector.get(0)).toString();
            String string2 = ((CgData)vector.get(1)).toString();
            String string3 = ((CgData)vector.get(2)).toString();
            try {
                this.requestData.setName(string);
                this.requestData.setDescription(this.despArea.getText());
                this.requestData.setObjectGroupName(string2);
                this.requestData.setTaskName(string3);
            }
            catch (SMLengthException sMLengthException) {
                UcDialog.showError((Component)this.own, (Object)sMLengthException.getMessage());
            }
            CgData cgData = (CgData)vector.get(3);
            SMTaskRequestData sMTaskRequestData = null;
            if (cgData != null) {
                sMTaskRequestData = (SMTaskRequestData)cgData.getUserData();
            }
            if (sMTaskRequestData != null && sMTaskRequestData.isScheduled()) {
                bl2 = true;
                this.requestData.setStartDate(sMTaskRequestData.getStartDate());
                this.requestData.setPeriod(sMTaskRequestData.getPeriod());
                this.requestData.setPeriodUnits(sMTaskRequestData.getPeriodUnits());
            }
            if (!bl2) {
                this.requestData.setStartDate(null);
                this.requestData.setPeriodUnits(0);
                this.requestData.setPeriod(1L);
            }
            this.requestData.setScheduled(bl2);
            final SMTaskRequestData sMTaskRequestData2 = this.requestData;
            final boolean bl3 = bl2;
            Runnable runnable = new Runnable(){

                public void run() {
                    bSaving = true;
                    if (CgUtil.saveObj((SMHandle)requestHandle, (SMDBObject)sMTaskRequestData2) && !bl3) {
                        this.threadWorkOnRequest((SMTaskRequestInfo)sMTaskRequestData2, 1);
                    }
                    bSaving = false;
                }
            };
            new Thread(runnable).start();
        }
        return true;
    }

    public void selectionOccurred(CgTblSelectEvent cgTblSelectEvent) {
        if (cgTblSelectEvent.getEventType() == CgTblSelectEvent.DESELECT) {
            int n = 0;
            while (n < this.buttons.size()) {
                ((AbstractButton)this.buttons.get(n)).setEnabled(false);
                ++n;
            }
        } else {
            Object object;
            final int n = cgTblSelectEvent.getSelectedRow();
            if (n != this.requestPane.getRowCount() - 1) {
                object = this.taskRequestInfos[n];
                boolean bl = object.isSuspended();
                boolean bl2 = object.isScheduled();
                this.selectedRequestName = object.getName();
                int n2 = 0;
                while (n2 < this.buttons.size()) {
                    ((AbstractButton)this.buttons.get(n2)).setEnabled(true);
                    ++n2;
                }
                this.suspendButton.setEnabled(bl2 && !bl);
                this.suspend.setEnabled(bl2 && !bl);
                this.resumeButton.setEnabled(bl);
                this.resume.setEnabled(bl);
            } else {
                int n3 = 0;
                while (n3 < this.buttons.size()) {
                    ((AbstractButton)this.buttons.get(n3)).setEnabled(false);
                    ++n3;
                }
            }
            if (n == this.requestPane.getRowCount() - 1) {
                this.requestData = new SMTaskRequestData();
                this.groupPane.setObjectGroupInfo(null);
                this.groupPane.setFilter(null);
                this.showTaskData("");
                this.schedSummLabel.setText(" ");
                this.despArea.setText(" ");
                return;
            }
            this.groupPane.refreshGroup(this.taskRequestInfos[n].getObjectGroupName());
            object = new Runnable(){

                public void run() {
                    try {
                        requestData = requestHandle.load(taskRequestInfos[n]);
                        this.showTaskData(requestData.getTaskName());
                        Runnable runnable = new Runnable(n, this){
                            private final /* synthetic */ int val$row;
                            private final /* synthetic */ CgGpFrame this$0;
                            {
                                this.val$row = n;
                                this.this$0 = cgGpFrame;
                            }

                            public void run() {
                                String string = " ";
                                if (this.this$0.requestData.isScheduled()) {
                                    CgData cgData = new CgData(null, this.this$0.schedIcon, (Object)this.this$0.requestData);
                                    CgData cgData2 = (CgData)this.this$0.requestPane.getValueAt(this.val$row, 3);
                                    this.this$0.requestPane.setValueAt((Object)cgData, this.val$row, 3);
                                    string = this.this$0.getSchedSummury(this.this$0.requestData);
                                }
                                this.this$0.schedSummLabel.setText(string);
                                this.this$0.despArea.setText(this.this$0.requestData.getDescription());
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                    catch (SMAPIException sMAPIException) {
                        UcDialog.showError((Component)own, (Object)sMAPIException.getMessage());
                    }
                }
            };
            new Thread((Runnable)object).start();
        }
    }

    private void showTaskData(String string) {
        if (string == null || string.trim().equals("")) {
            this.taskSummaryPane.removeAll();
            return;
        }
        string = string.trim();
        CgTaskSummPane cgTaskSummPane = new CgTaskSummPane(this.taskHandle, this.handle, string);
        this.taskSummaryPane.removeAll();
        this.taskSummaryPane.add(cgTaskSummPane);
    }

    private final void suspendRequest() {
        int n = this.requestPane.getSelectedRow();
        if (n >= 0 && n < this.taskRequestInfos.length) {
            SMTaskRequestInfo sMTaskRequestInfo = this.taskRequestInfos[n];
            this.threadWorkOnRequest(sMTaskRequestInfo, 2);
        }
    }

    public void taskChanged(SMDBChangeEvent sMDBChangeEvent) {
        SMTaskInfo[] sMTaskInfoArray;
        String[] stringArray = null;
        try {
            sMTaskInfoArray = this.taskHandle.getAll();
            stringArray = new String[sMTaskInfoArray.length];
            int n = 0;
            while (n < sMTaskInfoArray.length) {
                stringArray[n] = sMTaskInfoArray[n].getName();
                ++n;
            }
        }
        catch (SMAPIException sMAPIException) {}
        sMTaskInfoArray = stringArray;
        Runnable runnable = new Runnable((String[])sMTaskInfoArray, this){
            private final /* synthetic */ CgGpFrame this$0;
            private final /* synthetic */ String[] val$names;
            {
                this.val$names = stringArray;
                this.this$0 = cgGpFrame;
            }

            public void run() {
                String[] stringArray = new String[]{};
                if (this.val$names != null) {
                    stringArray = this.val$names;
                }
                this.this$0.taskCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void threadWorkOnRequest(final SMTaskRequestInfo sMTaskRequestInfo, final int n) {
        UcThreadWorker ucThreadWorker = new UcThreadWorker(){

            public void doWork() {
                try {
                    if (n == 0) {
                        requestHandle.delete(sMTaskRequestInfo);
                    } else if (n == 1) {
                        requestHandle.resume(sMTaskRequestInfo);
                    } else if (n == 2) {
                        requestHandle.suspend(sMTaskRequestInfo);
                    }
                }
                catch (SMAPIException sMAPIException) {
                    UcDialog.showError((Component)own, (Object)sMAPIException.getMessage());
                }
            }
        };
        ucThreadWorker.start();
    }

    class NewMenuItemListener
    implements ActionListener {
        int taskType;
        int actionType;

        public NewMenuItemListener(int n, int n2) {
            this.taskType = n;
            this.actionType = n2;
        }

        static /* synthetic */ CgGpFrame access$0(NewMenuItemListener newMenuItemListener) {
            return newMenuItemListener.CgGpFrame.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = -1;
            Vector vector = null;
            boolean bl = true;
            if (this.actionType == 2 || CgGpFrame.this.requestPane.getSelectedRowCount() != 0 && this.actionType == 3) {
                bl = false;
            }
            this.launchWindow(bl, vector);
        }

        private void launchWindow(boolean bl, Vector vector) {
            block22: {
                block25: {
                    block24: {
                        block23: {
                            block21: {
                                if (this.taskType != 0) break block21;
                                JDialog jDialog = CgGpFrame.this.getDialogFromPool("group");
                                if (jDialog != null && jDialog.isDisplayable()) {
                                    jDialog.show();
                                } else {
                                    if (jDialog != null && !jDialog.isDisplayable()) {
                                        CgGpFrame.this.removeDialogFromPool("group");
                                    }
                                    try {
                                        CgOGManagerDialog cgOGManagerDialog = new CgOGManagerDialog((Frame)CgGpFrame.this.own, CgGpFrame.this.groupHandle, CgGpFrame.this.filterHandle);
                                        CgGpFrame.this.addDialogToPool(cgOGManagerDialog, "group");
                                        cgOGManagerDialog.pack();
                                        cgOGManagerDialog.show();
                                    }
                                    catch (SMAPIException sMAPIException) {
                                        UcDialog.showError((Component)CgGpFrame.this.own, (Object)CgUtil.getI18nMsg((String)"ogMgr.serviceErr"));
                                    }
                                }
                                break block22;
                            }
                            if (this.taskType != 1) break block23;
                            if (CgGpFrame.this.filterRunning) {
                                return;
                            }
                            Runnable runnable = new Runnable(this){
                                private final /* synthetic */ NewMenuItemListener this$1;
                                {
                                    this.this$1 = newMenuItemListener;
                                }

                                public void run() {
                                    NewMenuItemListener.access$0((NewMenuItemListener)this.this$1).filterRunning = true;
                                    CgGpFrame cgGpFrame = NewMenuItemListener.access$0(this.this$1);
                                    NewMenuItemListener.access$0(this.this$1);
                                    JDialog jDialog = cgGpFrame.getDialogFromPool("filter");
                                    if (jDialog != null && jDialog.isDisplayable()) {
                                        jDialog.show();
                                    } else {
                                        try {
                                            if (jDialog != null && !jDialog.isDisplayable()) {
                                                CgGpFrame cgGpFrame2 = NewMenuItemListener.access$0(this.this$1);
                                                NewMenuItemListener.access$0(this.this$1);
                                                cgGpFrame2.removeDialogFromPool("filter");
                                            }
                                            CgFilterManagerDlg cgFilterManagerDlg = new CgFilterManagerDlg((Frame)NewMenuItemListener.access$0((NewMenuItemListener)this.this$1).own, NewMenuItemListener.access$0((NewMenuItemListener)this.this$1).filterHandle);
                                            CgGpFrame cgGpFrame3 = NewMenuItemListener.access$0(this.this$1);
                                            NewMenuItemListener.access$0(this.this$1);
                                            cgGpFrame3.addDialogToPool((JDialog)cgFilterManagerDlg, "filter");
                                            cgFilterManagerDlg.show();
                                        }
                                        catch (SMAPIException sMAPIException) {
                                            UcDialog.showError((Component)NewMenuItemListener.access$0((NewMenuItemListener)this.this$1).own, (Object)sMAPIException.getMessage());
                                        }
                                    }
                                    NewMenuItemListener.access$0((NewMenuItemListener)this.this$1).filterRunning = false;
                                }
                            };
                            new Thread(runnable).start();
                            break block22;
                        }
                        if (this.taskType != 2) break block24;
                        JDialog jDialog = CgGpFrame.this.getDialogFromPool("task");
                        if (jDialog != null && jDialog.isDisplayable()) {
                            jDialog.show();
                        } else {
                            if (jDialog != null && !jDialog.isDisplayable()) {
                                CgGpFrame.this.removeDialogFromPool("task");
                            }
                            try {
                                CgTaskManager cgTaskManager = new CgTaskManager(CgGpFrame.this.own, false, CgGpFrame.this.handle, CgGpFrame.this.taskHandle);
                                CgGpFrame.this.addDialogToPool(cgTaskManager, "task");
                                cgTaskManager.show();
                            }
                            catch (SMAPIException sMAPIException) {
                                UcDialog.showError((Component)CgGpFrame.this.own, (Object)CgUtil.getI18nMsg((String)"Error.service"));
                            }
                        }
                        break block22;
                    }
                    if (this.taskType != 3) break block25;
                    JDialog jDialog = CgGpFrame.this.getDialogFromPool("mcp");
                    if (jDialog != null && jDialog.isDisplayable()) {
                        jDialog.show();
                    } else {
                        try {
                            if (jDialog != null && !jDialog.isDisplayable()) {
                                CgGpFrame.this.removeDialogFromPool("mcp");
                            }
                            CpMCPManager cpMCPManager = new CpMCPManager();
                            CgGpFrame.this.addDialogToPool((JDialog)cpMCPManager, "mcp");
                            cpMCPManager.show();
                        }
                        catch (SMAPIException sMAPIException) {
                            UcDialog.showError((Component)CgGpFrame.this.own, (Object)sMAPIException.getMessage());
                        }
                    }
                    break block22;
                }
                if (this.taskType != 5) break block22;
                JDialog jDialog = CgGpFrame.this.getDialogFromPool("viewLog");
                if (jDialog != null && jDialog.isDisplayable()) {
                    jDialog.show();
                } else {
                    if (jDialog != null && !jDialog.isDisplayable()) {
                        CgGpFrame.this.removeDialogFromPool("viewLog");
                    }
                    try {
                        CgRequestLogViewDialog cgRequestLogViewDialog = new CgRequestLogViewDialog(CgGpFrame.this.own, CgGpFrame.this.requestHandle);
                        CgGpFrame.this.addDialogToPool(cgRequestLogViewDialog, "viewLog");
                        cgRequestLogViewDialog.pack();
                        cgRequestLogViewDialog.show();
                    }
                    catch (SMAPIException sMAPIException) {
                        UcDialog.showError((Component)CgGpFrame.this.own, (Object)sMAPIException.getMessage());
                    }
                }
            }
        }
    }
}

