# Copyright 02/06/02 Sun Microsystems, Inc. All Rights Reserved.
# pragma ident "@(#)t300-d.prc	1.5 02/02/06 Sun Microsystems"
#
#       File:   t300-d.prc
#       Version: 1.0
#
#       Storage T3 procedures
#

#
# registry to hdreg module
#
proc regHdreg { } {
	set rtn  [ catch { locate hdreg.hdreg-table } obj ]
	if { $rtn == "1" } {
		ddl print info "hdreg module hasn't been loaded\n"
		return;
	}
	
	toe_send $obj regModule t300 "StorEdge-T3" V system
}

#
# unregistry the module from hdreg
#
proc unregHdreg { } {
	set rtn  [ catch { locate hdreg.hdreg-table } obj ]
	if { $rtn == "1" } {
		ddl print info "hdreg module hasn't been loaded\n"
		return;
	}

	toe_send $obj unregModule t300
}

#
# set operation
#
proc setEntry { object property index value } {
	set idx [ urltostr [ lookup -d "" nameByIndex $index ] ]
	set rtn [ catch { t300_set $object $idx $property $value } obj ]
	if { $rtn == 0 } {	
		toe_send [ locate t300.system.basic-table ] refreshValueAndTrap
	}
	if { $rtn == 1 } {
		ddl print debug "t3 set failed\n"
	}	
	return $value
}


#
# clear operation
#
proc clearEntry { object index value } {
	set idx [ urltostr [ lookup -d "" nameByIndex $index ] ]
	set rtn [ catch { t300_clear $object $idx } obj ]
	if { $rtn == 0 } {
		toe_send [ locate t300.system.basic-table ] refreshValueAndTrap
	}
	if { $rtn == 1 } {
		ddl print debug "t3 clear failed\n"
	}
	return $value
}

#
# add clear-flag 
#
proc addClearFlag {} {
	set result ""
	set num [ tableDepth ]
	set i 0

	while { $i < $num } {
		lappend result 0
		incr i
	}

	return $result
}
