#! /usr/bin/sh
#
# ident "@(#)es-server.sh 1.43     03/01/14 SMI"
#
# Copyright 2002-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#
# File: es-server.sh
# Version: 1.43 03/01/14 10:40:17
# Author: J.M. Heisz
#
# Copyright (c) 1997 Halcyon Inc.
#
#  This is a temporary script for launching the spa development server.
#  All environment variables, etc. need to be finalized at a later point.
#

if test -z "$ESROOT"; then
    /usr/bin/gettext "ESROOT environment variable must be set"
    exit 1
fi

if test -z "$ESDIR"; then
    /usr/bin/gettext "ESDIR environment variable must be set"
    exit 1
fi

if test -z "$SYMON_JAVAHOME"; then
   /usr/bin/gettext "SYMON_JAVAHOME variable must be set"
   exit 1
else
   JAVA=$SYMON_JAVAHOME/bin/java
fi

INTERFACE_PATH=$ESDIR/cfg
INTERFACE_PATH=$INTERFACE_PATH:$ESROOT/base/cfg
INTERFACE_PATH=$INTERFACE_PATH:$ESROOT/modules/cfg

#------------------------------------------------------------------------------------#
# if Independent path is set use it, else use the default ESROOT ie [/opt/SUNWsymon] #
#------------------------------------------------------------------------------------#
if [ ! -z "$IESROOT" ] ; then
  INTERFACE_PATH=$INTERFACE_PATH:$IESROOT/classes/base/server/cfg
  INTERFACE_PATH=$INTERFACE_PATH:$IESROOT/classes/base/console/cfg
else
  INTERFACE_PATH=$INTERFACE_PATH:$ESROOT/classes/base/server/cfg
  INTERFACE_PATH=$INTERFACE_PATH:$ESROOT/classes/base/console/cfg
fi
export INTERFACE_PATH

#------------------------------------------------------------------------------------#
# if Independent path is set use it, else use the default ESROOT ie [/opt/SUNWsymon] #
#------------------------------------------------------------------------------------#
if [ ! -z "$IESROOT" ] ; then
  BASEPATH=$IESROOT
else
  BASEPATH=$ESROOT
fi

CLASSPATH=$ESDIR/classes
CLASSPATH=$CLASSPATH:$BASEPATH/classes:$BASEPATH/apps/classes
CLASSPATH=$CLASSPATH:$BASEPATH/classes/essrv.jar
CLASSPATH=$CLASSPATH:$BASEPATH/classes/escom.jar
CLASSPATH=$CLASSPATH:$BASEPATH/classes/esclt.jar

# add application jars and zips to the classpath, if any
if [ ! -z "$IESROOT" ] ; then
  APP_JARS=`/usr/bin/ls -1 $IESROOT/apps/classes/*.jar 2>/dev/null`
  APP_ZIPS=`/usr/bin/ls -1 $IESROOT/apps/classes/*.zip 2>/dev/null`
else
  APP_JARS=`/usr/bin/ls -1 $ESROOT/apps/classes/*.jar 2>/dev/null`
  APP_ZIPS=`/usr/bin/ls -1 $ESROOT/apps/classes/*.zip 2>/dev/null`
fi

APP_CLASSES=$APP_JARS' '$APP_ZIPS
APP_CLASSPATH=''

for i in $APP_CLASSES
do
   APP_CLASSPATH=$APP_CLASSPATH:$i
done

CLASSPATH=$CLASSPATH$APP_CLASSPATH
#
# Sun MC 3.5 AddOn specific CLASSPATH
#
addon_dirs=`/usr/bin/ls -1 $ESROOT/addons 2>/dev/null`
if [ ! -z "$addon_dirs" ]; then
        for i in $addon_dirs
        do
           if [ -d $ESROOT/addons/$i/lib/locale/classes ]; then
                CLASSPATH=$CLASSPATH:$ESROOT/addons/$i/lib/locale/classes
           fi
        done
fi
export CLASSPATH

ulimit -n 1024

cd $ESDIR

test ! -d "$ESDIR/cfg"  && mkdir -p $ESDIR/cfg
test ! -d "$ESDIR/log"  && mkdir -p $ESDIR/log

MAX_HEAP_SIZE="-Xmx64m"
ARG_LIST=""

for each_param in $*
do
    echo "$each_param" | /usr/bin/grep "\-Xmx" > /dev/null 2>&1
    if [ $? -eq 0 ] ; then
       MAX_HEAP_SIZE="$each_param"
    else
       ARG_LIST="$ARG_LIST $each_param"
    fi
done

trap '' HUP
exec $JAVA -DINTERFACE_PATH=$INTERFACE_PATH -DESDIR=$ESDIR $MAX_HEAP_SIZE -Xss2m -Xoss4m -DNUM_FDS=`ulimit -n` com.sun.symon.base.server.main.ServerMain $ARG_LIST
