rem 
rem $Header: dbmspexp.sql 26-mar-99.11:00:36 nvishnub Exp $ 
rem 
Rem  Copyright (c) 1992, 1996, 1998, 1999 by Oracle Corporation 
Rem    NAME
Rem      dbmspexp.sql - Package spec. for procedural extensions to export
Rem		NOTE - Package body is in: .../exp/prvtpexp.sql
Rem    DESCRIPTION
Rem      This file defines a pl/sql package containing 
Rem      functions that are called by export to dynamically link in 
Rem      pl/sql logic in the export process.
Rem      The package body is to be released only in PL/SQL binary form.
Rem    PUBLIC FUNCTION(S)
Rem	pre_table  - Get actions to be executed before tgt table is imported.
Rem	post_table - Get actions to be executed after tgt table is imported.
Rem	get_domain_index_metadata - Intermediary procedure between export and
Rem	the ODCIIndexGetMetadata method on a domain index's implementation type
Rem    RETURNS
Rem 
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem    MODIFIED   (MM/DD/YY)
Rem     cyyip      07/07/99 -  replace '&' with 'and'
Rem     nvishnub   03/26/99 -  E/I support for fast rebuild of domain indexes.
Rem     ncramesh   08/07/98 -  change for sqlplus
Rem     gclaborn   07/02/98 -  Add version string to getmetadata prototype
Rem     nagarwal   06/08/98 -  add extidx_imp_lib
Rem     nagarwal   06/04/98 -  add routines for operators
Rem     gclaborn   05/04/98 -  Adjust for changes to ODCI interface
Rem     gclaborn   04/13/98 -  Change sense of multiblock param
Rem     gclaborn   04/07/98 -  Add Domain Index routines
Rem     ixhu       04/11/96 -  AQ support: table object only
Rem     dsdaniel   04/07/94 -  merge changes from branch 1.1.710.1
Rem     adowning   03/29/94 -  merge changes from branch 1.1.710.2
Rem     adowning   02/02/94 -  split file into public / private binary files
Rem     dsdaniel   01/31/94 -  Branch_for_patch
Rem     dsdaniel   01/31/94 -  Branch_for_patch
Rem     dsdaniel   12/29/93 -  Creation

CREATE OR REPLACE PACKAGE DBMS_EXPORT_EXTENSION AS 
------------------------------------------------------------
-- Overview
--
-- This package implements PL/SQL extensions to Export.
-- ...
---------------------------------------------------------------------
-- SECURITY
-- This package is owned by SYS,  and is  granted to PUBLIC.
-- The procedures dynamically called by the package are called using
-- The parse_as_user option
------------------------------------------------------------------------------
-- EXCEPTIONS
-- 
   unExecutedActions EXCEPTION;
-- A function was not called with the same parameters until it returned NULL.
-- This indicates an internal error in EXPORT.
-- CONSTANTS
-- 
--   Function codes for the expact$ table.
-- 
  func_pre_table   CONSTANT NUMBER := 1;     /* execute before loading table */
  func_post_tables CONSTANT NUMBER := 2; /* execute after loading all tables */
  func_pre_row     CONSTANT NUMBER := 3;       /* execute before loading row */
  func_post_row    CONSTANT NUMBER := 4;        /* execute after loading row */
  func_row         CONSTANT NUMBER := 5;   /* execute in lieu of loading row */
------------------------------------------------------------------------------
-- PROCEDURES AND FUNCTIONS
  FUNCTION pre_table(obj_schema IN VARCHAR2,
                     obj_name   IN VARCHAR2)
    RETURN VARCHAR2;
-- execute pre_table functions from the expact$ table, for a specific object 
-- Input Parameters:
--   obj_schema 
--     The schema of the object being exported.
--   obj_name
--     The name for the object being exported.
-- Result:
--   A string containg a procedure invocation to be put in the export stream.
--   If non-null, this procedure should be called again (immediately) for the
--   same object.  If NULL, there are no additional pre_table calls to 
--   be exported to the stream for this object and function.
-- Exceptions:
--   unExecutedActions
--   Any error encountered during executing of the action

  FUNCTION post_tables(obj_schema IN VARCHAR2,
                       obj_name   IN VARCHAR2)
    RETURN VARCHAR2;
-- execute post_tables functions from the expact$ table, for a specific object 
-- Input Parameters:
--   obj_schema 
--     The schema of the object being exported.
--   obj_name
--     The name for the object being exported.
-- Result:
--   A string containing a procedure invocation to be put in the export stream.
--   If non-null, this procedure should be called again (immediately) for the
--   same object.  
--  If NULL, there are no additional post_tables calls to be exported to the
--   stream for this object.
-- Exceptions:
--   unExecutedActions
--   Any error encountered during executing of the action
----------------------------------------------------------------------------
-- ROW FUNCTIONS WILL BE ADDED IN THE FUTURE
----------------------------------------------------------------------------

  FUNCTION get_domain_index_metadata (
	index_name	IN  VARCHAR2,
	index_schema	IN  VARCHAR2,
	type_name	IN  VARCHAR2,
	type_schema	IN  VARCHAR2,
	version		IN  VARCHAR2,
	newblock	OUT PLS_INTEGER )
	RETURN VARCHAR2;

-- Acts as intermediary between export and the ODCIIndexGetMetadata method on
-- a domain index's implementation type. This allows the index to return
-- PL/SQL-based "metadata" such as policy info. Strings are returned
-- representing pieces of PL/SQL blocks to execute at import time. Multiple
-- PL/SQL blocks can be built
-- PARAMETERS:
--   index_name, index_schema	- Identifies current index
--   type_name, type_schema     - Identifies index's implementation type
--   version  - Export's version; e.g, '08.01.03.00.00'
--   newblock - Allows callee to write multiple blocks of PL/SQL code.
--      non-zero: Return string starts a new block,
--      zero: Return string continues current block.
-- RETURNS:
-- A piece of a PL/SQL block to be executed at import time. The BEGIN/END;
-- surrounding each block should not be returned as export will add these.
-- This routine will be repeatedly called until an empty string is returned.

  FUNCTION get_object_source (
           objid     IN  NUMBER,
           objtype   IN  NUMBER)
           RETURN VARCHAR2;

-- This function is used to get the source string for CREATE OPERATOR and 
-- CREATE INDEXTYPE. The function is passed the object number and the 
-- object type and the string returned is the SQL statement needed to 
-- create the operator or the index type. 
-- PARAMTERS: 
--   objid   - object number of the operator or indextype 
--   objtype - object type (32 for indextype, 33 for operators)
-- RETURNS: 
-- The SQL string that can be used to create the operator or the indextype 
-- specified by the object id 


-- get_domain_index_tables
--------------------------

  FUNCTION get_domain_index_tables (
        index_name      IN  VARCHAR2,
        index_schema    IN  VARCHAR2,
        type_name       IN  VARCHAR2,
        type_schema     IN  VARCHAR2,
        read_only       IN  PLS_INTEGER,
        version         IN  VARCHAR2,
        get_tables      IN  PLS_INTEGER)
	RETURN VARCHAR2;

-- Acts as intermediary between export and the ODCIIndexUtilGetTableNames method
-- on a domain index's implementation type. This allows the index to return
-- list of secondary tablenames (seperated by comma) which are to be exported
-- and imported to speed up rebuild of domain indexes during import.
-- PARAMETERS:
--   index_name, index_schema   - Identifies current index
--   type_name, type_schema     - Identifies index's implementation type
--   version    - Export's version; e.g, '08.01.03.00.00'
--   read_only  - Is this a read-only transaction ?  True for Export if
--                CONSISTENT=y.  Note: some types may not be able to exploit
--                fast rebuild in a read-only environment.
--                1 => read_only. 
--   get_tables - Export will first call this function with get_tables=1. 
--   In this case, the function will instantiate both an instance of the 
--   implementation type as defined by  type_name and type_schema, and an 
--   object of type ODCIIndexInfo using parameters index_name and index_schema.
--   It will then call ODCIIndexUtilGetTableNames method on the implementation 
--   type using the ODCIIndexInfo object just constructed. The routine will
--   also maintain in a PL/SQL variable of session scope the context returned 
--   from ODCIIndexUtilGetTableNames to be handed back upon its second call.
--
--   After export writes all the tables returned on the first call to its 
--   dump file, it will call get_domain_index_tables again with parameter 
--   get_tables=0. In this case, this function will then call the 
--   ODCIIndexCleanup method on the ODCIIndexInfo object constructed in the
--   first call handing in the internally stored context. When this returns, 
--   it will clean up its state and return a NULL string to export.

-- RETURNS:
-- A list of secondary tablenames (seperated by comma).

END DBMS_EXPORT_EXTENSION;
/

GRANT execute ON sys.dbms_export_extension to public; 

create or replace library extidx_imp_lib trusted as static;
/
