Rem
Rem $Header: dbmsobtk.sql 02-mar-99.10:14:08 sgkrishn Exp $
Rem
Rem dbmsentk.sql
Rem
Rem  Copyright (c) Oracle Corporation 1997, 1998, 1999. All Rights Reserved.
Rem
Rem    NAME
Rem      dbmsentk.sql - DBMS Obfuscation Toolkit
Rem
Rem    DESCRIPTION
Rem      Contains the PL/SQL interface to the obfuscation toolkit
Rem
Rem    NOTES
Rem      None.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sgkrishn    03/01/99 - added DES related routines
Rem    sgkrishn    02/25/99 - Creation
Rem
REM  ***************************************
REM  THIS PACKAGE MUST BE CREATED UNDER SYS
REM  ***************************************

-- Create the trusted PL/SQL callout library.
CREATE OR REPLACE LIBRARY DBMS_OBFUSCATION_LIB TRUSTED AS STATIC;
/

CREATE OR REPLACE PACKAGE dbms_obfuscation_toolkit AS

    ---------------------- FUNCTIONS AND PROCEDURES ---------------------------

    ---------------------------- DATA ENCRYPTION ------------------------------
    -- The following routines encrypt and decrypt data.
    -- There are two versions of each procedure: one for raw data and the
    -- other for strings.
    ---------------------------------------------------------------------------

    PROCEDURE DESEncrypt(input            IN  RAW,
                         key              IN  RAW,
                         encrypted_data   OUT RAW);

    PROCEDURE DESEncrypt(input_string     IN  VARCHAR2,
                         key_string       IN  VARCHAR2,
                         encrypted_string OUT VARCHAR2);

    PROCEDURE DESDecrypt(input            IN  RAW,
                         key              IN  RAW,
                         decrypted_data   OUT RAW);

    PROCEDURE DESDecrypt(input_string     IN     VARCHAR2,
                         key_string       IN  VARCHAR2,
                         decrypted_string OUT VARCHAR2);

END dbms_obfuscation_toolkit;
/

DROP PUBLIC SYNONYM dbms_obfuscation_toolkit;
/
CREATE PUBLIC SYNONYM dbms_obfuscation_toolkit FOR sys.dbms_obfuscation_toolkit;
/


