/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.migration.datasource;

import com.sun.symon.tools.migration.TmNoSuchObjectException;
import com.sun.symon.tools.migration.datasource.MdDataSourceProperties;
import com.sun.symon.tools.migration.datasource.MdRecord;
import com.sun.symon.tools.migration.datasource.MdTable;
import com.sun.symon.tools.migration.util.MuDebug;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Hashtable;

public abstract class MdDataSource
implements Cloneable,
Serializable {
    private static final Hashtable dataSources = new Hashtable();
    public static final int OPEN_READ = 1;
    public static final int OPEN_WRITE = 2;
    public static final int OPEN_APPEND = 3;
    private String name;
    private MdTable table;
    private int recordsAffected;
    private boolean opened;
    private MdRecord currentMdRecord;
    private MdDataSourceProperties dataSourceProperties;
    private int mode;
    static /* synthetic */ Class class$com$sun$symon$tools$migration$datasource$MdTable;
    static /* synthetic */ Class class$com$sun$symon$tools$migration$datasource$MdDataSourceProperties;

    protected MdDataSource(MdTable mdTable, MdDataSourceProperties mdDataSourceProperties) {
        if (mdTable == null) {
            throw new IllegalArgumentException("table cannot be null");
        }
        this.table = mdTable;
        this.dataSourceProperties = mdDataSourceProperties == null ? new MdDataSourceProperties(mdTable.getMdDataSourceProperties()) : new MdDataSourceProperties(mdDataSourceProperties);
    }

    public static void bind(String string, Class clazz) {
        dataSources.put(string, clazz);
    }

    public static void bind(String string, String string2) throws ClassNotFoundException {
        dataSources.put(string, Class.forName(string2));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object clone() {
        MuDebug.println("Cloning " + this.name + "...");
        try {
            MdDataSource mdDataSource = (MdDataSource)super.clone();
            mdDataSource.dataSourceProperties = (MdDataSourceProperties)this.dataSourceProperties.clone();
            mdDataSource.parseProperties();
            mdDataSource.recordsAffected = 0;
            mdDataSource.opened = false;
            mdDataSource.currentMdRecord = null;
            return mdDataSource;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError(String.valueOf(String.valueOf(this.getClass())) + " could not be cloned: " + exception.getMessage());
        }
    }

    public final synchronized void close() throws Exception {
        MuDebug.println("Closing " + this.name + "...");
        if (this.opened) {
            this.opened = false;
            this.currentMdRecord = null;
            this.closeImpl();
        }
    }

    protected abstract void closeImpl() throws Exception;

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            Object var2_1 = null;
            super.finalize();
        }
    }

    public MdRecord findFirst(String string, String string2) throws Exception {
        this.reset(1);
        return this.findNext(string, string2);
    }

    public MdRecord findNext(String string, String string2) throws Exception {
        MuDebug.println("Searching for: " + string + "==" + string2);
        MdRecord mdRecord = null;
        while ((mdRecord = this.read()) != null) {
            if (!string2.equals(mdRecord.getMdValue(string).toString())) continue;
            return mdRecord;
        }
        return null;
    }

    public MdRecord getCurrentMdRecord() {
        return this.currentMdRecord;
    }

    public static MdDataSource getInstance(MdTable mdTable) throws TmNoSuchObjectException {
        return MdDataSource.getInstance(mdTable, mdTable.getMdDataSourceProperties());
    }

    public static MdDataSource getInstance(MdTable mdTable, MdDataSourceProperties mdDataSourceProperties) throws TmNoSuchObjectException {
        String string = mdDataSourceProperties.getType();
        try {
            Class clazz = (Class)dataSources.get(string);
            if (clazz == null) {
                throw new TmNoSuchObjectException(string, "MdDataSource doesn't exist");
            }
            Constructor constructor = clazz.getConstructor(class$com$sun$symon$tools$migration$datasource$MdTable != null ? class$com$sun$symon$tools$migration$datasource$MdTable : (class$com$sun$symon$tools$migration$datasource$MdTable = MdDataSource.class$("com.sun.symon.tools.migration.datasource.MdTable")), class$com$sun$symon$tools$migration$datasource$MdDataSourceProperties != null ? class$com$sun$symon$tools$migration$datasource$MdDataSourceProperties : (class$com$sun$symon$tools$migration$datasource$MdDataSourceProperties = MdDataSource.class$("com.sun.symon.tools.migration.datasource.MdDataSourceProperties")));
            MdDataSource mdDataSource = (MdDataSource)constructor.newInstance(mdTable, mdDataSourceProperties);
            return mdDataSource;
        }
        catch (TmNoSuchObjectException tmNoSuchObjectException) {
            throw tmNoSuchObjectException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            MdDataSource.unbind(string);
            throw new TmNoSuchObjectException(string, "MdDataSource doesn't exist: " + exception.getClass().getName() + "(" + exception.getMessage() + ")");
        }
    }

    public MdDataSourceProperties getMdDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public int getMdRecordsAffected() {
        return this.recordsAffected;
    }

    public MdTable getMdTable() {
        return this.table;
    }

    public int getMode() {
        return this.mode;
    }

    public String getModeString() {
        return MdDataSource.getModeString(this.mode);
    }

    public static String getModeString(int n) {
        switch (n) {
            case 1: {
                return "OPEN_READ";
            }
            case 2: {
                return "OPEN_WRITE";
            }
            case 3: {
                return "OPEN_APPEND";
            }
        }
        return "UNKNOWN MODE: " + n;
    }

    public String getName() {
        return this.name;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public final synchronized void open(int n) throws Exception {
        MuDebug.println("Opening " + this.name + " for " + MdDataSource.getModeString(n) + "...");
        if (!this.opened) {
            this.mode = n;
            this.parseProperties();
            switch (n) {
                case 1: {
                    this.openReadImpl();
                    break;
                }
                case 2: {
                    this.openWriteImpl();
                    break;
                }
                case 3: {
                    this.openAppendImpl();
                    break;
                }
                default: {
                    throw new IOException("Unknown open mode: " + n);
                }
            }
            this.opened = true;
            this.recordsAffected = 0;
        }
    }

    protected abstract void openAppendImpl() throws Exception;

    protected abstract void openReadImpl() throws Exception;

    protected abstract void openWriteImpl() throws Exception;

    public final synchronized void parseProperties() throws Exception {
        this.parsePropertiesImpl(this.dataSourceProperties);
    }

    protected abstract void parsePropertiesImpl(MdDataSourceProperties var1) throws Exception;

    public final synchronized MdRecord read() throws Exception {
        if (!this.opened) {
            throw new IOException(String.valueOf(String.valueOf(this.getClass())) + " [" + this.name + "] not open");
        }
        if (this.mode != 1) {
            throw new IOException(String.valueOf(String.valueOf(this.getClass())) + " [" + this.name + "] not open for reading: mode=" + this.getModeString());
        }
        this.currentMdRecord = this.readImpl();
        if (this.currentMdRecord != null) {
            this.currentMdRecord.setMdTable(this.table);
            ++this.recordsAffected;
        }
        MuDebug.println("currentMdRecord = [" + this.currentMdRecord + "]");
        return this.currentMdRecord;
    }

    protected abstract MdRecord readImpl() throws Exception;

    public synchronized void reset(int n) throws Exception {
        if (this.opened) {
            if (n != this.mode || this.recordsAffected > 0) {
                this.close();
                this.open(n);
            }
        } else {
            this.open(n);
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return "[name=" + this.name + ", table=" + this.table + ", opened=" + this.opened + ", recordsAffected=" + this.recordsAffected + "]";
    }

    public static void unbind(String string) {
        dataSources.remove(string);
    }

    public final void write(MdRecord mdRecord) throws Exception {
        if (!this.opened) {
            throw new IOException(String.valueOf(String.valueOf(this.getClass())) + " [" + this.name + "] not open");
        }
        if (this.mode != 2 && this.mode != 3) {
            throw new IOException(String.valueOf(String.valueOf(this.getClass())) + " [" + this.name + "] not open for writing: mode=" + this.getModeString());
        }
        if (mdRecord == null) {
            throw new IOException("cannot write null records");
        }
        MuDebug.println("record.getMdTable()=" + mdRecord.getMdTable());
        MuDebug.println("getMdTable()=" + this.getMdTable());
        if (mdRecord.getMdTable() != this.getMdTable()) {
            throw new IOException("expected " + this.getMdTable().getQualifiedName() + " record, found " + mdRecord.getMdTable().getQualifiedName());
        }
        this.writeImpl(mdRecord);
        ++this.recordsAffected;
    }

    protected abstract void writeImpl(MdRecord var1) throws Exception;
}

