/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.common;

import com.sun.symon.base.mgmtservice.common.MSProperties;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcDDLLocalSetup;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class MSLogPrintWriter
extends PrintWriter {
    private static MSProperties properties_;
    private static HashSet initialActiveChannels_;
    private int channel_;
    private boolean active_;
    private StringBuffer buf_ = new StringBuffer();
    private static MSLogPrintWriter debug_;
    private static MSLogPrintWriter error_;
    private static MSLogPrintWriter info_;
    private static MSLogPrintWriter warning_;
    private static Hashtable customChannels_;

    static {
        initialActiveChannels_ = new HashSet();
        debug_ = new MSLogPrintWriter(UcDDL.DDL_DEBUG);
        error_ = new MSLogPrintWriter(UcDDL.DDL_ERROR);
        info_ = new MSLogPrintWriter(UcDDL.DDL_INFO);
        warning_ = new MSLogPrintWriter(UcDDL.DDL_WARNING);
        customChannels_ = new Hashtable();
    }

    private MSLogPrintWriter(int n) {
        super(System.out);
        this.channel_ = n;
        this.active_ = UcDDL.channelIsActive((int)this.channel_);
    }

    private MSLogPrintWriter(String string) throws IOException {
        super(System.out);
        this.active_ = initialActiveChannels_.contains(string);
        if (properties_ == null) {
            this.channel_ = UcDDL.createChannel((String)string, (boolean)this.active_);
            return;
        }
        String string2 = properties_.getProperty(string);
        if (string2 != null && !string2.equals("")) {
            PrintWriter printWriter = UcDDLLocalSetup.createInterfaceStream((String)string2);
            this.channel_ = UcDDL.createChannel((String)string, (boolean)this.active_);
            UcDDL.channelSetStream((int)this.channel_, (PrintWriter)printWriter);
        } else {
            this.channel_ = UcDDL.createChannel((String)string, (boolean)this.active_);
        }
        customChannels_.put(string, this);
    }

    public boolean checkError() {
        this.flush();
        return false;
    }

    public void close() {
        this.flush();
    }

    public static MSLogPrintWriter createChannel(String string) throws IOException {
        if (customChannels_.containsKey(string)) {
            throw new FileNotFoundException(String.valueOf(string) + " channel already exists");
        }
        return new MSLogPrintWriter(string);
    }

    public void flush() {
        if (this.active_) {
            UcDDL.logMessage((int)this.channel_, (String)this.buf_.toString(), null);
        }
        this.buf_ = new StringBuffer();
    }

    public static MSLogPrintWriter getChannel(String string) throws IOException {
        MSLogPrintWriter mSLogPrintWriter = (MSLogPrintWriter)customChannels_.get(string);
        if (mSLogPrintWriter == null) {
            throw new IOException(String.valueOf(string) + " not found");
        }
        return mSLogPrintWriter;
    }

    public static MSLogPrintWriter getDebugWriter() {
        return debug_;
    }

    public static MSLogPrintWriter getErrorWriter() {
        return error_;
    }

    public static MSLogPrintWriter getInfoWriter() {
        return info_;
    }

    public static MSLogPrintWriter getWarningWriter() {
        return warning_;
    }

    public static void init(String string) {
        properties_ = new MSProperties();
        String string2 = "error warning info debug sql";
        try {
            properties_.load(string);
            String string3 = properties_.getProperty("ACTIVE", string2);
            UcDDL.setChannelActivateList((String)string3);
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            while (stringTokenizer.hasMoreTokens()) {
                initialActiveChannels_.add(stringTokenizer.nextToken());
            }
            String string4 = properties_.getProperty("DEFAULT");
            UcDDL.setDefaultOutputStream((String)string4);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            UcDDL.setChannelActivateList((String)string2);
        }
    }

    public boolean isActive() {
        this.active_ = UcDDL.channelIsActive((int)this.channel_);
        return this.active_;
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(int n) {
        this.write(String.valueOf(n));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    public void print(char[] cArray) {
        this.write(cArray);
    }

    public void println() {
        if (!this.active_) {
            return;
        }
        this.flush();
    }

    public void println(char c) {
        Object object = this.lock;
        synchronized (object) {
            this.print(c);
            this.println();
        }
    }

    public void println(double d) {
        Object object = this.lock;
        synchronized (object) {
            this.print(d);
            this.println();
        }
    }

    public void println(float f) {
        Object object = this.lock;
        synchronized (object) {
            this.print(f);
            this.println();
        }
    }

    public void println(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.print(n);
            this.println();
        }
    }

    public void println(long l) {
        Object object = this.lock;
        synchronized (object) {
            this.print(l);
            this.println();
        }
    }

    public void println(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.print(object);
            this.println();
        }
    }

    public void println(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.print(string);
            this.println();
        }
    }

    public void println(String string, Throwable throwable) {
        if (this.active_) {
            this.write(string);
            UcDDL.logMessage((int)this.channel_, (String)this.buf_.toString(), (Throwable)throwable);
        }
        this.buf_ = new StringBuffer();
    }

    public void println(Throwable throwable) {
        this.println("", throwable);
    }

    public void println(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.print(bl);
            this.println();
        }
    }

    public void println(char[] cArray) {
        Object object = this.lock;
        synchronized (object) {
            this.print(cArray);
            this.println();
        }
    }

    public void setActive(boolean bl) {
        UcDDL.channelActivate((int)this.channel_, (boolean)bl);
        this.active_ = bl;
    }

    public void write(int n) {
        if (!this.active_) {
            return;
        }
        this.buf_.append(n);
    }

    public void write(String string) {
        this.write(string, 0, string.length());
    }

    public void write(String string, int n, int n2) {
        if (!this.active_) {
            return;
        }
        this.buf_.append(new String(string.toCharArray(), n, n2));
    }

    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    public void write(char[] cArray, int n, int n2) {
        if (!this.active_) {
            return;
        }
        this.buf_.append(cArray, n, n2);
    }
}

