/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import oracle.aurora.server.tools.loadjava.ToolsException;

public class ClassFileReader {
    private DataInputStream m_in;
    private String[] m_cpStrings = null;
    private int[] m_cpClassNames = null;
    private String m_className = null;
    private Vector m_declaredClassNames = new Vector();
    private String m_declaringClassName = null;
    private int m_modifiers = 0;
    private static final int CLASS_ATTRIBUTE = 1;
    private static final int FIELD_ATTRIBUTE = 2;
    private static final int METHOD_ATTRIBUTE = 3;

    public ClassFileReader(String fileName, InputStream is) throws IOException, ToolsException {
        this.m_in = new DataInputStream(is);
        try {
            this.readClass();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ToolsException("file format error", e);
        }
    }

    public void attribute_info(int attributeType) throws IOException {
        int ndx = this.u2();
        int length = this.u4();
        if (this.m_cpStrings[ndx].equals("InnerClasses") && attributeType == 1) {
            int count = this.u2();
            int i = 0;
            while (i < count) {
                int innerClassNdx = this.u2();
                int outerClassNdx = this.u2();
                int innerNameNdx = this.u2();
                int mods = this.u2();
                if (innerClassNdx != 0 && this.className(innerClassNdx).equals(this.m_className)) {
                    this.m_declaringClassName = this.className(outerClassNdx);
                    this.m_modifiers |= mods;
                } else if (outerClassNdx != 0 && this.className(outerClassNdx).equals(this.m_className)) {
                    this.m_declaredClassNames.addElement(this.className(innerClassNdx));
                }
                ++i;
            }
        } else {
            this.skipBytes(length);
        }
    }

    public String className(int ndx) {
        return this.m_cpStrings[this.m_cpClassNames[ndx]];
    }

    public int cp_info(int ndx) throws IOException {
        int tag = this.u1();
        switch (tag) {
            case 7: {
                this.m_cpClassNames[ndx] = this.u2();
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.skipBytes(4);
                break;
            }
            case 8: {
                this.skipBytes(2);
                break;
            }
            case 5: 
            case 6: {
                this.skipBytes(8);
                ++ndx;
                break;
            }
            case 1: {
                this.m_cpStrings[ndx] = this.m_in.readUTF();
                break;
            }
            default: {
                throw new IllegalArgumentException("tag " + tag + " at ndx " + ndx);
            }
        }
        return ndx + 1;
    }

    public void field_info() throws IOException {
        this.skipBytes(6);
        int count = this.u2();
        int i = 0;
        while (i < count) {
            this.attribute_info(2);
            ++i;
        }
    }

    public String fullyQualifiedClassName() {
        return new String(this.m_className).replace('/', '.');
    }

    public void method_info() throws IOException {
        this.skipBytes(6);
        int count = this.u2();
        int i = 0;
        while (i < count) {
            this.attribute_info(3);
            ++i;
        }
    }

    public void readClass() throws IOException {
        this.skipBytes(8);
        int count = this.u2();
        this.m_cpStrings = new String[count];
        this.m_cpClassNames = new int[count];
        int i = 1;
        while (i < count) {
            i = this.cp_info(i);
        }
        this.skipBytes(2);
        int ndx = this.u2();
        this.m_className = this.className(ndx);
        this.skipBytes(2);
        count = this.u2();
        this.skipBytes(count * 2);
        count = this.u2();
        int i2 = 0;
        while (i2 < count) {
            this.field_info();
            ++i2;
        }
        count = this.u2();
        int i3 = 0;
        while (i3 < count) {
            this.method_info();
            ++i3;
        }
        count = this.u2();
        int i4 = 0;
        while (i4 < count) {
            this.attribute_info(1);
            ++i4;
        }
    }

    public void skipBytes(int n) throws IOException {
        while (n-- > 0) {
            this.m_in.readByte();
        }
    }

    public int u1() throws IOException {
        return this.m_in.readUnsignedByte();
    }

    public int u2() throws IOException {
        return this.m_in.readUnsignedShort();
    }

    public int u4() throws IOException {
        return this.m_in.readInt();
    }
}

