/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server;

import com.sun.server.util.ExProperties;
import java.io.IOException;
import java.net.Socket;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import oracle.aurora.AuroraServices.MinorCodes;
import oracle.aurora.debug.OracleAgent;
import oracle.aurora.memoryManager.Walker;
import oracle.aurora.memstat.MemStat;
import oracle.aurora.mts.session.rdbms.SessionImpl;
import oracle.aurora.net.Presentation;
import oracle.aurora.perf.OracleBTL;
import oracle.aurora.server.ORB;
import oracle.aurora.server.VCIiopConnection;
import oracle.aurora.server.VCListener;
import oracle.aurora.vm.OracleRuntime;
import oracle.jdbc.driver.OracleDriver;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class GiopServer
extends Presentation {
    private boolean __debug = false;
    Hashtable connections = new Hashtable();
    private int lastCallServiced = 0;
    private int startBTLonCall = 0;
    private int dumpMemStatOnCall = 0;
    static final String AURORA_ORB_KEY = "org.omg.CORBA.ORBClass";
    static final String AURORA_ORB_SINGLETON_KEY = "org.omg.CORBA.ORBSingletonClass";
    static final String AURORA_ORB_VALUE = "oracle.aurora.server.ORB";
    static final String AURORA_ORB_SINGLETON_VALUE = "oracle.aurora.server.ORB";

    static {
        GiopServer.initDefaultProperties();
    }

    public GiopServer() {
        ORB.presentation = this;
        GiopServer.readSystemProperties();
        ExProperties env = new ExProperties(System.getProperties());
        if (env.getProperty("giop.debugger.start", false)) {
            String host = env.getProperty("giop.debugger.proxy.host", "localhost");
            int port = env.getProperty("giop.debugger.proxy.port", 1638);
            long timeout = env.getProperty("giop.debugger.proxy.timeout", 30L);
            try {
                OracleAgent.start((String)host, (int)port, (long)timeout);
            }
            catch (Exception e) {
                System.out.println("Error Starting debugger");
                e.printStackTrace();
            }
        }
        if (Boolean.getBoolean("AuroraORBdebug")) {
            this.__debug = true;
        }
        if (Boolean.getBoolean("TurnOffNewspace")) {
            OracleRuntime.enableNewspace((boolean)false);
        }
        this.startBTLonCall = Integer.getInteger("StartBTLOnCall", 0);
        this.dumpMemStatOnCall = Integer.getInteger("DumpMemStatOnCall", 0);
        long gcThreshold = Long.getLong("SessionGCThreshold", 0L);
        if (gcThreshold > 0L) {
            OracleRuntime.setSessionGCThreshold((long)gcThreshold);
        }
    }

    private void _service(Socket connection) {
        block5: {
            ORB._singleton_orb.register();
            VCIiopConnection conn = (VCIiopConnection)((Object)this.connections.get(connection));
            try {
                conn.processRequest();
            }
            catch (INTERNAL exe) {
                throw exe;
            }
            catch (Exception e) {
                try {
                    connection.close();
                }
                catch (IOException ioe) {
                    System.out.println("Exception " + ioe + "caught while closing the" + "socket " + connection);
                }
                if (e instanceof COMM_FAILURE) break block5;
                System.out.println("Non fatal exception caught while processing request: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    void closeAllConnections() {
        Enumeration conns = this.connections.elements();
        while (conns.hasMoreElements()) {
            ((VCIiopConnection)((Object)conns.nextElement())).close();
        }
        this.connections = new Hashtable();
    }

    Socket doConnect(String hostName, int portNumber) {
        try {
            return this.createVirtualCircuit(hostName, portNumber);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new COMM_FAILURE(MinorCodes.getMessage(8), 8, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    Socket doConnect(String localHost, int localPort, String hostName, int portNumber) {
        try {
            return this.createVirtualCircuit(hostName, portNumber);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new COMM_FAILURE(MinorCodes.getMessage(8), 8, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    private void enterCall() {
        block6: {
            int calls = Presentation.calls();
            if (calls == this.lastCallServiced) {
                return;
            }
            this.lastCallServiced = calls;
            if (Boolean.getBoolean("ReportSessionSize")) {
                System.out.println("Session Size: " + OracleRuntime.getSessionSize());
            }
            if (Boolean.getBoolean("WalkSessionRoots")) {
                Walker.walkSessionRoots((boolean)true);
            }
            if (calls == this.startBTLonCall) {
                int type = Integer.getInteger("TraceType", 0);
                OracleBTL.initBTL((String)System.getProperty("TraceFile", ""), (int)type, (long)0L, (boolean)false);
                OracleBTL.startBTL();
            }
            if (calls != this.dumpMemStatOnCall) break block6;
            try {
                MemStat.writeDump((String)"/tmp/memstat", (String)"memstat");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void initDefaultProperties() {
        Properties props = System.getProperties();
        ((Hashtable)props).put("ORBservices", "oracle.aurora.sess_iiop.orb_dep,oracle.aurora.jts.server,oracle.aurora.client");
        ((Hashtable)props).put("ORBdisableLocator", "true");
        ((Hashtable)props).put(AURORA_ORB_KEY, "oracle.aurora.server.ORB");
        ((Hashtable)props).put(AURORA_ORB_SINGLETON_KEY, "oracle.aurora.server.ORB");
    }

    public int maxHandlerThreads() {
        return 2;
    }

    protected void newConnection(Socket s) {
        this.enterCall();
        if (this.__debug) {
            SessionImpl.DEBUG = true;
            System.out.println("In newConnection; socket = " + s);
        }
        VCIiopConnection connection = VCListener.connect(s);
        ORB.startServer();
        this.connections.put(s, connection);
        this._service(s);
    }

    private static void readSystemProperties() {
        Connection con = null;
        try {
            con = new OracleDriver().defaultConnection();
            Statement stmt = con.createStatement();
            stmt.execute("SELECT * FROM AURORA$IIOP$SYSTEM$PROPERTIES");
            ResultSet r = stmt.getResultSet();
            Properties properties = System.getProperties();
            while (r.next()) {
                String key = r.getString(1);
                String value = r.getString(2);
                ((Hashtable)properties).put(key, value);
                ((Hashtable)ORB.props).put(key, value);
            }
            stmt.close();
            r.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void service(Socket connection) {
        if (this.__debug) {
            System.out.println("In service; socket = " + connection);
        }
        this.enterCall();
        this._service(connection);
    }

    protected void socketClosed(Socket connection) {
        if (this.__debug) {
            System.out.println("In socketClosed; socket = " + connection);
        }
        this.connections.remove(connection);
    }

    public boolean useSessIIOP() {
        return false;
    }
}

