#########################################################################
#
# method metaLoad
#
# Method that loads a metadata module
#
# Usage: metaLoad module
#
# Input: module - example: kernel-reader
#
# Output: "loadok", "loadduplicate", "loadfail", or error
#
#######################################################################

proc metaLoadAll { source } {
	#
	# Use info subtree to determine list of known modules
	#
	set listobject [ locate $source ]
	set knownmodules [ toe_send $listobject getValues ]

	#
	# Load the modules
	#
	foreach module $knownmodules {
		if { $module != "" } {
			if { [ catch {
				set result [ metaLoad $module ]
			} error ] } {
				ddl print error "Error loading $module: $error\n"
			}
		}
	}

	return [ llength $knownmodules ]
}

proc metaLoad { module } {
	#
	# Method defaults
	#
	set moduleowner meta

	#
	# Get string representation of module paramaters
	#
	set infoobject [ locate .iso*agent.base.info.modules ]

	if { [ toe_csend allparams $infoobject editXFileGetFilter $module ] } {
		error "invalid module: $module"
	}

	#
	# Filter out only what we want
	#
	set parameters ""
	foreach param [ split $allparams "\n" ] {
		if { [ regsub {^param:} $param "" newparam ] } {
			append parameters $newparam "\n"
		}
	}

	#
	# Get module name from the module parameters
	#
        import string _tmp $parameters
        set modulename [ lookup _tmp module ]
        undefine _tmp

        #
        # Augment params with instance specifics
        #
        append parameters "instance = $modulename" "\n"
	append parameters "instanceName = Metadata Repository" "\n"
	append parameters "daqmode = metadata" "\n"

	#
	# Create surrogate PDU to house "module owner"
	#
	set pdu [ bob create pdu ]
	bob set $pdu securityName $moduleowner

	ddl print info "Loading module $module in metadata mode\n"

	#
	# Load the Module
	#
	set loadobject [ locate .iso*mibman.modules ]
	set result [ toe_send $loadobject quickLoad $parameters $pdu ]

	#
	# Clean up
	#
	bob destroy $pdu

	ddl print info "Load status for $module: $result\n"

	return $result
}


#
# Create new requires proc to disable package loading
#
toe_send null {
    proc new_requires { type name args } {
        if { $type == "package" } {
	    #
	    # do nothing
	    #
	} elseif { $type == "class" } {
	    #
	    # do nothing
	    #

	    toe_begin [ locate .classes ]

	    #
	    # if the class does not exist in the system
	    # then create it
	    #	    
	    if { [ catch { lookup object $name } result ] } {
	        set newobj "$name = { }"
	        import string value $newobj
	    }

	    toe_end

        } else {
	    #
	    # Use original call
	    #
	    set command [ concat [ list "old_requires" $type $name ] $args ]
	    return [ eval $command ]
        }
    }
}

#
# Create new source proc to catch errors during TOE file loading
#
toe_send null {
    proc new_source { args } {
	set result ""
	set file [ lindex $args 0 ]
	set flag [ lindex $args 1 ]
        if { $flag == "" } {
	    if { [ catch { old_source $file } result ] } {
		set result ""
	    }
        } else {
	    if { [ catch { old_source $file $flag } result ] } {
		set result ""
	    }
        }
        return $result
    }
}

method overridePackageLoader {} {
	#
	# Override requires to not load packages...
	#
	toe_send null rename requires old_requires
	toe_send null rename new_requires requires

	#
	# Override source to catch errors when loading TOE files...
	#
	toe_send null rename source old_source
	toe_send null rename new_source source
}

method resetPackageLoader {} {
	#
	# Override requires to load packages again...
	#
	toe_send null rename requires new_requires
	toe_send null rename old_requires requires

	#
	# Override source to load TOE files normally...
	#
	toe_send null rename source new_source
	toe_send null rename old_source source
}

