# Copyright 07/09/01 Sun Microsystems, Inc. All Rights Reserved.
# pragma ident "@(#)a5x00-d.prc	1.7 01/07/09 Sun Microsystems"
#
#       File:   a5x00-d.prc
#       Version: 1.0
#
#       Storage A5x00 procedures
#

#
# registry to hdreg module
#
proc regHdreg { } {
        set rtn  [ catch { locate hdreg.hdreg-table } obj ]
        if { $rtn == "1" } {
                ddl print info "hdreg module hasn't been loaded\n"
                return;
        }

        toe_send $obj regModule a5x00 "StorEdge-A5x00" V sena
}

#
# unregistry the module from hdreg
#
proc unregHdreg { } {
        set rtn  [ catch { locate hdreg.hdreg-table } obj ]
        if { $rtn == "1" } {
                ddl print info "hdreg module hasn't been loaded\n"
                return;
        }

        toe_send $obj unregModule a5x00
}

#
# rename enclosure's name
#
proc setSenaName { index value } {
	ddl print info "Having been setSenaName procedure."

	set old_encl_name [ toe_send [ locate box_name ] lookup -d "" olddata $index ]

	set rtn [ catch { updateEnclosureName $old_encl_name $value } obj ]

	if { $rtn == 0 } {
                toe_send [ locate a5x00 ] refreshValueAndTrap
		ddl print info "Refresh Sena Name and other relative value."
	}

	return $value
}

#
# set enclosure's poweron, poweroff
#
proc setSenaEntry { index value } {
        ddl print debug "Having been setSenaEntry procedure."
	set rtn 1
        set enl_name [ toe_send [ locate box_name ] getValue $index ]


	if { $value == "poweroff" } {
		set flg "1"
        	set rtn [ catch { updatePowerStatus $enl_name $flg } obj ]
	} elseif { $value == "poweron" } {
		set flg "0"
        	set rtn [ catch { updatePowerStatus $enl_name $flg } obj ]
	}
 
        if { $rtn  == 0 } {
                toe_send [ locate a5x00 ] refreshValueAndTrap
	}

	return $value
}


#
# set disk backplane 's bypass, enable
#
proc setDiskBackplaneEntry { index value } {
        ddl print debug "Having been setDiskplaneEntry procedure."
	set rtn 1
        set enl_name [ toe_send [ locate box_name ] getValue $index ]

	set node_name [ toe_send [ locate sunSmNodeName ] getValue $index ]

	if { $node_name == "disk_backplane(0)" } { 
		set fr_flg "0"
	} elseif { $node_name == "disk_backplane(1)" } {
		set fr_flg "1"
	}

	if { $value == "bypass:A" } {
		set flg "1"
		set ab_flg "0"
	} elseif { $value == "bypass:B" } {
		set flg "1"
		set ab_flg "1"
	} elseif { $value == "enable:A" } {
		set flg "0"
		set ab_flg "0"
	} elseif { $value == "enable:B" } {
		set flg "0"
		set ab_flg "1"
	}

       	set rtn [ catch { updateBypassStatus $enl_name $flg $fr_flg $ab_flg } obj ]
 
        if { $rtn == 0 } {
                toe_send [ locate a5x00 ] refreshValueAndTrap
                ddl print info "Refresh power_status and other relative value."
	}

	return $value
}

#
# set enclosure's ssd(disk) poweron, poweroff
#
proc setPowerEntry { index value } {
        ddl print debug "Having been setPowerEntry."

        set path [ toe_send [ locate connect_disk ] getValue $index ]

        if { $value == "off" } {
                set flg "1"
        } else {
                set flg "0"
        }

        set rtn [ catch { updatePowerStatus $path $flg } obj ]

        if { $rtn == 0 } {
               toe_send [ locate a5x00 ] refreshValueAndTrap
               ddl print debug "Refresh power_status and other relative value."
       }
        return $value
}

#
# set ssd(disk)'s bypass, enable
#
proc setBypassEntry { index value } {
        ddl print debug "Having been setBypassEntry procedures."
	set fr_flg "0"
        set path [ toe_send [ locate connect_disk ] getValue $index ]

	#
	# Fix bug 4436895, flg indicate bypass/enable
	# ab_flg indecate PORTA/PORTB
	#
	if { $value == "bypass:A" } {
		set flg "1"
		set ab_flg "0"
	} elseif { $value == "bypass:B" } {
		set flg "1"
		set ab_flg "1"
	} elseif { $value == "enable:A" } {
		set flg "0"
		set ab_flg "0"
	} elseif { $value == "enable:B" } {
		set flg "0"
		set ab_flg "1"
	}

	set rtn [ catch { updateBypassStatus $path $flg $fr_flg $ab_flg } obj ]
        if { $rtn == 0 } {
               toe_send [ locate a5x00 ] refreshValueAndTrap
               ddl print debug "Refresh loop status and other relative value."
        }

        return $value
}

