#!/bin/sh
# Copyright 10/31/01 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)sm_setup_agent.sh	1.46 01/10/31 Sun Microsystems"

#
# Note:  This script is used internally by Sun Enterprise SyMON,
# and is not intended to be called directly by users.
# It should not be modified.
#
#

setup_platform_instances ()
{
    sec_seed=$1
    INSTCFGFILE=${VARDIR}/platform-instances.dat
    if [ ! -f "$INSTCFGFILE" ] ; then
        return 0
    fi

    list_of_instances=""
    list_of_instances=`$XGET $INSTCFGFILE ControlBlock.instances`
    if [ -z "$list_of_instances" ] ; then
        return 0
    fi
    list_of_instances=`echo $list_of_instances | /usr/bin/sed -e "s/,/ /g"`

    ServerName=`$XGET ${VARDIR}/domain-config.x agent.agentServer`

    if [ -n "$ServerName" ] ; then
        echo ""
    else
        while [ 1 -eq 1 ]
        do
            get_input_from_user "Please enter the Sun Management Center Server Hostname: "
            if [ ! -z "$answer" ] ; then
                ServerName="$answer"
                break
            fi
        done
    fi

    for each_instance in $list_of_instances
    do
        $XPUT ${VARDIR}/domain-config.x ${each_instance}.${each_instance}Server $ServerName
        #
        #Generate security keys for this instance
        #
        if [ "$GENERATE_SECURITY_KEY" = "1" ]; then
           move_datfile "${VARDIR}/${each_instance}-usmusertbl-d.dat"
           $BASEDIR/base/sbin/base-usm-seed.sh -s "$sec_seed" -c $each_instance
        fi
    done

}


write_domain_values() {
#
#  $1 = name to use for server
#
    local_host=`/usr/bin/uname -n`
    $XPUT ${VARDIR}/domain-config.x trap.trapServer "$server_host" \
				    event.eventServer "$server_host" \
				    agent.agentServer "$local_host" \
				    platform.platformServer "$local_host"
}

set_server_name() {
#
    while [ 1 -eq 1 ]
    do
	get_input_from_user "Please enter the Sun Management Center Server Hostname: "
	if [ ! -z "$answer" ] ; then
	    server_host="$answer"
	    break
	fi
    done

    write_domain_values "$server_host"
}

configure_server() {

    agent_port=""
    traphost=""
    server_host=""
    platform_port=""

    if [ -f "${VARDIR}/domain-config.x" ] ; then
	agent_port=`$XGET ${VARDIR}/domain-config.x agent.snmpPort`
	traphost=`$XGET ${VARDIR}/domain-config.x trap.trapServer`
	platform_port=`$XGET ${VARDIR}/domain-config.x platform.snmpPort`
    fi

    if [ -n "$traphost" ] ; then
	echolog '$2 appears to be configured as your Sun Management Center server.' $traphost
	ask_user "Is this correct?"
	if [ $answer -eq 0 ] ; then
	    set_server_name
	else
	    server_host="$traphost"
	fi
    else
	set_server_name
    fi

    [ "$server_host" = "_none_" ] && return 0

    if [ -z "$agent_port" ] ; then
	local_host=`/usr/bin/uname -n`
	$XPUT ${VARDIR}/domain-config.x \
	    agent.agentServer  "$local_host"   agent.snmpPort  161 \
	    trap.trapServer    "$server_host"  trap.snmpPort   162 \
	    event.eventServer  "$server_host"  event.snmpPort  163

	if [ $? -ne 0 ] ; then
	    echolog ""
            echolog 'Error - Unable to set $2 values.' "$VARDIR/domain-config.x"
	    echolog ""
	    exit 1
	fi
    else
	echologverbose 'agent.snmpPort already configured in $2' "$VARDIR/domain-config.x"
    fi

    if [ -z "$platform_port" ] ; then
	$XPUT ${VARDIR}/domain-config.x \
	    platform.platformServer "$local_host" platform.snmpPort 166
    fi
}

fix_ent_vers() {
#
#  Fixes the enterprise and version fields
#
#    echo "\nBefore:\n$LINE"

    LINE=`echo $LINE | /usr/bin/sed s/halcyon/sun/g`
    LINE=`echo $LINE | /usr/bin/sed s/'version *= *\"1\.0\"'/'version = \"2.0\"'/`

}

fix_base_modules() {

    [ -f $VARDIR/base-modules-d.dat.old ] && /usr/bin/rm $VARDIR/base-modules-d.dat.old
    /usr/bin/mv $VARDIR/base-modules-d.dat $VARDIR/base-modules-d.dat.old
    SED=/usr/bin/sed

    while read LINE
    do
	module=`echo $LINE | /usr/bin/awk '{print $1}'`
	case $module in
	    datalog-registry)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/primealert\.modules\.localApplication\.datalog\.registry/prod.sunsymon.agent.modules.datalogRegistry/g`
		LINE=`echo $LINE | $SED s/'location = \"\"'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.datalogRegistry\"'/`
		;;
	    dirmon*)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/primealert\.modules\.operatingSystem\.dirmon/prod.sunsymon.agent.modules.dirmon/g`
		LINE=`echo $LINE | $SED s/'location = \"\"'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.dirmon\"'/`
	        ;;
	    filemon*)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/primealert\.modules\.operatingSystem\.filemon/prod.sunsymon.agent.modules.filemon/g`
		LINE=`echo $LINE | $SED s/'location = \"\"'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.filemon\"'/`
	        ;;
	    fscan*)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/primealert\.modules\.localApplication\.fscan/prod.sunsymon.agent.modules.fscan/g`
		LINE=`echo $LINE | $SED s/'location = \"\"'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.fscan\"'/`
	        ;;
	    hp-jetdirect*)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/primealert\.modules\.remoteSystem\.hp\.jetdirect/prod.sunsymon.agent.modules.hpJetdirect/g`
		LINE=`echo $LINE | $SED s/'location = \"\"'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.hpJetdirect\"'/`
	        ;;
	    nfsmon*)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/primealert\.modules\.operatingSystem\.nfsmon/prod.sunsymon.agent.modules.nfsmon/g`
		LINE=`echo $LINE | $SED s/'location = \"\"'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.nfsmon\"'/`
		;;
	    nfsstat)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/primealert\.modules\.operatingSystem\.nfsstat/prod.sunsymon.agent.modules.nfsstat/g`
		LINE=`echo $LINE | $SED s/'location = \"\"'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.nfsstat\"'/`
	        ;;
	    print-spool*)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/primealert\.modules\.localApplication\.print\.spool/prod.sunsymon.agent.modules.printSpool/g`
		LINE=`echo $LINE | $SED s/'location = \"\"'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.printSpool\"'/`
	        ;;
	    process-table*)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/primealert\.modules\.localApplication\.process\.table/prod.sunsymon.agent.modules.processTable/g`
		LINE=`echo $LINE | $SED s/'location = \"\"'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.processTable\"'/`
		;;
	    kernel-reader)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/operatingSystem\.kernel\.reader/kernelReader/g`
		;;
	    process-details)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/operatingSystem\.process\.details/processDetails/g`
		;;
	    health-monitor)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/localApplication\.health\.monitor/healthMonitor/g`
		;;
	    dr)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/localApplication\.dr/dr/g`
		;;
	    *)
		;;
	esac
	LINE=`echo $LINE | /usr/bin/sed s/'"\; '/'\\\"\; '/g`
	LINE=`echo $LINE | /usr/bin/sed s/'= "'/'= \\\"'/g`
	#  Remove the first \
	LINE=`echo $LINE | /usr/bin/sed s:'\\\'::`
	echo "$LINE" >> $VARDIR/base-modules-d.dat

    done < "$VARDIR/base-modules-d.dat.old"
   
}


######################################################
#
#  Main entry point
#

prog_base=`/usr/bin/basename $0`
common_cmd=`echo $0 | /usr/bin/sed s/$prog_base/es-common.sh/`
. $common_cmd
gen_cmd=`echo $0 | /usr/bin/sed s/$prog_base/es-keys.sh/`
. $gen_cmd

VERBOSE=OFF
do_default=0
while getopts dvs: OPT
do
    case $OPT in
	d)
	    do_default=1
	    ;;
	v)
	    VERBOSE=ON
	    ;;
	s)
	    security_seed="$OPTARG"
            #echologverbose 'Using security seed $2 for Sun Management Center agent' "$security_seed"
	    ;;
	*)
	    exit 1
	    ;;
    esac
done
set_basedir
PROGNAME="$0"; export PROGNAME
check_root
check_logfile setup
check_osver
set_xput
set_inst_flags


echologverbose ""
echologverbose "This part of the setup process does the Sun Management Center Agent Component setup."

#
#  Make sure LS directory exists
#
LSDIR=$VAROPTDIR/LS
if [ ! -d "$LSDIR" ] ; then
    /usr/bin/mkdir -p "$LSDIR"
    /usr/bin/chown nobody:nobody "$LSDIR"
    /usr/bin/chmod 755 "$LSDIR"
fi

#
#  Add in mail script
#

#if [ ! -f $VAROPTDIR/bin/email.sh ] ; then
# Do Not check for the presence of file. Copy it from /opt/SUNWsymon/base/sbin.
# This is needed Since we want to replace the 2.0.1 version of this file.4234218
    /usr/bin/mkdir -p $VAROPTDIR/bin
    /usr/bin/cp $BASEDIR/base/sbin/email.sh $VAROPTDIR/bin
#fi

#
#  Copy snmpd.conf if needed
#
if [ -f "$VARDIR/snmpd.conf" ] ; then
    echologverbose 'snmpd.conf already exists in $2.  Leaving it in place' $VARDIR
else
    echologverbose 'Copying snmpd.conf file into $2' $VARDIR
    /usr/bin/cp "$BASEDIR"/base/cfg/snmpd.conf "$VARDIR"
fi

#
#  Setup the domain-config.x file
#
if [ -f "${VARDIR}/domain-config.x" ] ; then
    if [ $no_server -eq 1 ] ; then
	configure_server
    else
	echologverbose ""
	echologverbose "Server component also installed locally."
	echologverbose "Using this machine as the Sun Management Center server."
	server_host=`/usr/bin/uname -n`
	write_domain_values $server_host
    fi
else
    configure_server
fi
#
#  Check the relevant port numbers
#
check_port agent.snmpPort agent

if [ -f "$VARDIR/base-modules-d.dat" ] ; then
    #
    #  Update for new oids
    #
    fix_base_modules

fi

if [ -f "$VARDIR/user-oids-d.dat" ] ; then
    /usr/bin/rm "$VARDIR/user-oids-d.dat"
fi

if [ -f "$VARDIR/platform-oids-d.dat" ] ; then
    /usr/bin/rm "$VARDIR/platform-oids-d.dat"
fi

# generate seeds only if user is not doing an upgrade

if [ "$UPGRADE_DONE" != "YES"  -a "$GENERATE_SECURITY_KEY" = "1" ]
then
    generate_keys agent $do_default "$security_seed"
fi

setup_platform_instances "$security_seed"

echologverbose "Completing Sun Management Center Agent Component setup."

exit 0
