/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.sess_iiop;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Name;
import javax.naming.NamingException;
import oracle.aurora.AuroraServices.Executable;
import oracle.aurora.jndi.sess_iiop.SessionCtx;
import oracle.aurora.server.tools.sess_iiop.CommandLineParser;
import oracle.aurora.server.tools.sess_iiop.Tool;
import oracle.aurora.server.tools.sess_iiop.ToolImpl;
import oracle.aurora.server.tools.sess_iiop.ToolsException;
import org.omg.CORBA.StringHolder;

public class Shell
extends ToolImpl {
    private Hashtable tools = new Hashtable(13, 0.75f);
    private Name[] path;
    private boolean batch = false;
    private String fileName = null;
    private final String DEFAULT_COMMANDLINE_PROPERTIES_FILE = "/etc/oracle/aurora/sess_sh.properties";
    private static final String PROMPT = "PROMPT";
    private static final String HOME = "HOME";
    private static final String LOCAL_HOME = "LOCAL_HOME";
    private static final String PATH = "PATH";
    private static final String PATH_SEPARATOR = ":";
    private static final String IMPORTED_TOOLS = "deployejb:oracle.aurora.ejb.deployment.GenerateEjb|createejb:oracle.aurora.ejb.deployment.CreateEjb";
    private static final String INSTALLED_TOOLS = "TOOLS";
    static /* synthetic */ Class class$oracle$aurora$server$tools$sess_iiop$Eval;
    static /* synthetic */ Class class$oracle$aurora$server$tools$sess_iiop$Java;
    static /* synthetic */ Class class$oracle$aurora$server$tools$sess_iiop$Ln;
    static /* synthetic */ Class class$oracle$aurora$server$tools$sess_iiop$Ls;
    static /* synthetic */ Class class$oracle$aurora$server$tools$sess_iiop$Mkdir;
    static /* synthetic */ Class class$oracle$aurora$server$tools$sess_iiop$Mv;
    static /* synthetic */ Class class$oracle$aurora$server$tools$sess_iiop$Publish;
    static /* synthetic */ Class class$oracle$aurora$server$tools$sess_iiop$Republish;
    static /* synthetic */ Class class$oracle$aurora$server$tools$sess_iiop$Rm;
    static /* synthetic */ Class class$oracle$aurora$server$tools$sess_iiop$Local_ls;
    static /* synthetic */ Class class$oracle$aurora$server$tools$sess_iiop$Loadjar;
    static /* synthetic */ Class class$oracle$aurora$server$tools$sess_iiop$Chmod;
    static /* synthetic */ Class class$oracle$aurora$server$tools$sess_iiop$Chown;

    public Shell() throws ToolsException {
        this.initCommands();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public String commandHelp() throws ToolsException {
        return this.msg("SHELL_COMMAND_HELP", null);
    }

    public String description() throws ToolsException {
        return this.msg("SHELL_DESCRIPTION", null);
    }

    private void description(String[] args) throws ToolsException {
        String description = null;
        description = args.length == 1 ? this.description() : this.get_tool(args[1]).description();
        throw new ToolsException(description);
    }

    private void env(String[] argv) {
        Enumeration keys = ((Hashtable)ToolImpl.environment).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.stdOut.println(String.valueOf(key) + "=" + ToolImpl.environment.get(key));
        }
    }

    private void execute(Executable exe, String[] argv) {
        StringHolder out = new StringHolder();
        exe.main(out, argv);
        this.stdOut.println(out.value);
    }

    private void getPath() {
        String pathString = ToolImpl.environment.getProperty(PATH);
        if (pathString == null) {
            pathString = ".";
        }
        StringTokenizer parser = new StringTokenizer(pathString, PATH_SEPARATOR);
        Vector<String> allPaths = new Vector<String>();
        while (parser.hasMoreTokens()) {
            allPaths.addElement(parser.nextToken());
        }
        this.path = new Name[allPaths.size()];
        int i = -1;
        Enumeration paths = allPaths.elements();
        while (paths.hasMoreElements()) {
            try {
                this.path[++i] = ToolImpl.wd.parse((String)paths.nextElement());
            }
            catch (ToolsException toolsException) {}
        }
    }

    private Tool get_tool(String command) throws ToolsException {
        try {
            Class toolClass = (Class)this.tools.get(command);
            if (toolClass == null) {
                return null;
            }
            return (Tool)toolClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new ToolsException("Unable to create instance of tool: " + command);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ToolsException("Access violation in creation of tool: " + command);
        }
    }

    public String help() throws ToolsException {
        return this.msg("SHELL_HELP", null);
    }

    private void initCommands() throws ToolsException {
        this.tools.put("eval", class$oracle$aurora$server$tools$sess_iiop$Eval != null ? class$oracle$aurora$server$tools$sess_iiop$Eval : (class$oracle$aurora$server$tools$sess_iiop$Eval = Shell.class$("oracle.aurora.server.tools.sess_iiop.Eval")));
        this.tools.put("java", class$oracle$aurora$server$tools$sess_iiop$Java != null ? class$oracle$aurora$server$tools$sess_iiop$Java : (class$oracle$aurora$server$tools$sess_iiop$Java = Shell.class$("oracle.aurora.server.tools.sess_iiop.Java")));
        this.tools.put("ln", class$oracle$aurora$server$tools$sess_iiop$Ln != null ? class$oracle$aurora$server$tools$sess_iiop$Ln : (class$oracle$aurora$server$tools$sess_iiop$Ln = Shell.class$("oracle.aurora.server.tools.sess_iiop.Ln")));
        this.tools.put("ls", class$oracle$aurora$server$tools$sess_iiop$Ls != null ? class$oracle$aurora$server$tools$sess_iiop$Ls : (class$oracle$aurora$server$tools$sess_iiop$Ls = Shell.class$("oracle.aurora.server.tools.sess_iiop.Ls")));
        this.tools.put("mkdir", class$oracle$aurora$server$tools$sess_iiop$Mkdir != null ? class$oracle$aurora$server$tools$sess_iiop$Mkdir : (class$oracle$aurora$server$tools$sess_iiop$Mkdir = Shell.class$("oracle.aurora.server.tools.sess_iiop.Mkdir")));
        this.tools.put("mv", class$oracle$aurora$server$tools$sess_iiop$Mv != null ? class$oracle$aurora$server$tools$sess_iiop$Mv : (class$oracle$aurora$server$tools$sess_iiop$Mv = Shell.class$("oracle.aurora.server.tools.sess_iiop.Mv")));
        this.tools.put("publish", class$oracle$aurora$server$tools$sess_iiop$Publish != null ? class$oracle$aurora$server$tools$sess_iiop$Publish : (class$oracle$aurora$server$tools$sess_iiop$Publish = Shell.class$("oracle.aurora.server.tools.sess_iiop.Publish")));
        this.tools.put("republish", class$oracle$aurora$server$tools$sess_iiop$Republish != null ? class$oracle$aurora$server$tools$sess_iiop$Republish : (class$oracle$aurora$server$tools$sess_iiop$Republish = Shell.class$("oracle.aurora.server.tools.sess_iiop.Republish")));
        this.tools.put("rm", class$oracle$aurora$server$tools$sess_iiop$Rm != null ? class$oracle$aurora$server$tools$sess_iiop$Rm : (class$oracle$aurora$server$tools$sess_iiop$Rm = Shell.class$("oracle.aurora.server.tools.sess_iiop.Rm")));
        this.tools.put("lls", class$oracle$aurora$server$tools$sess_iiop$Local_ls != null ? class$oracle$aurora$server$tools$sess_iiop$Local_ls : (class$oracle$aurora$server$tools$sess_iiop$Local_ls = Shell.class$("oracle.aurora.server.tools.sess_iiop.Local_ls")));
        this.tools.put("loadjar", class$oracle$aurora$server$tools$sess_iiop$Loadjar != null ? class$oracle$aurora$server$tools$sess_iiop$Loadjar : (class$oracle$aurora$server$tools$sess_iiop$Loadjar = Shell.class$("oracle.aurora.server.tools.sess_iiop.Loadjar")));
        this.tools.put("chmod", class$oracle$aurora$server$tools$sess_iiop$Chmod != null ? class$oracle$aurora$server$tools$sess_iiop$Chmod : (class$oracle$aurora$server$tools$sess_iiop$Chmod = Shell.class$("oracle.aurora.server.tools.sess_iiop.Chmod")));
        this.tools.put("chown", class$oracle$aurora$server$tools$sess_iiop$Chown != null ? class$oracle$aurora$server$tools$sess_iiop$Chown : (class$oracle$aurora$server$tools$sess_iiop$Chown = Shell.class$("oracle.aurora.server.tools.sess_iiop.Chown")));
        this.initTools(IMPORTED_TOOLS);
    }

    private void initTool(String tool) throws ToolsException {
        StringTokenizer toolPair = new StringTokenizer(tool, PATH_SEPARATOR);
        String name = toolPair.nextToken();
        String className = toolPair.nextToken();
        try {
            this.tools.put(name, Class.forName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fail1("CLASS_NOT_FOUND", className);
        }
    }

    private void initTools(String toolString) throws ToolsException {
        StringTokenizer toolPairs = new StringTokenizer(toolString, "|");
        while (toolPairs.hasMoreTokens()) {
            this.initTool(toolPairs.nextToken());
        }
    }

    protected void invoke() throws ToolsException {
        BufferedReader inputStream = null;
        if (this.batch && this.fileName != null) {
            try {
                inputStream = new BufferedReader(new FileReader(this.fileName));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.exit(-1);
            }
        } else {
            inputStream = new BufferedReader(new InputStreamReader(this.stdIn), 1);
        }
        CommandLineParser input = new CommandLineParser(inputStream, this.stdOut);
        this.stdOut.println(this.msg("WELCOME_MESSAGE"));
        try {
            while (true) {
                if (!this.batch) {
                    this.stdOut.print(this.prompt());
                }
                try {
                    if (!this.invoke_command(input.tokens())) continue;
                }
                catch (EOFException eOFException) {
                    this.stdErr.println();
                }
                catch (IOException iOException) {
                }
                catch (ToolsException e) {
                    this.stdErr.println(e.getMessage());
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.stdErr.println();
            e.printStackTrace(this.stdErr);
            throw new ToolsException(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean invoke_command(String[] args) throws ToolsException {
        if (args.length == 0) {
            return false;
        }
        if (args.length == 1 && args[0].equals(" ")) {
            return false;
        }
        if (ToolImpl.echo) {
            int i = 0;
            while (i < args.length) {
                this.stdOut.print(String.valueOf(args[i]) + " ");
                ++i;
            }
            this.stdOut.println();
        }
        String command = args[0];
        String[] cmdArgs = new String[args.length - 1];
        System.arraycopy(args, 1, cmdArgs, 0, args.length - 1);
        if (command.equals("exit")) {
            return true;
        }
        if (command.equals("help")) {
            this.stdOut.println(this.commandHelp());
            return false;
        }
        if (command.equals("setenv")) {
            this.setenv(cmdArgs);
            return false;
        }
        if (command.equals("env")) {
            this.env(cmdArgs);
            return false;
        }
        if (command.equals("source")) {
            return false;
        }
        if (command.equals("version")) {
            this.stdOut.println(this.version());
            return false;
        }
        if (command.equals("cd")) {
            if (cmdArgs.length == 0) {
                ToolImpl.wd.cd("/");
                return false;
            } else {
                if (cmdArgs.length != 1) throw new ToolsException(this.msg("CD_USAGE", null));
                if (cmdArgs[0].charAt(0) != '-') {
                    ToolImpl.wd.cd(cmdArgs[0]);
                    return false;
                } else {
                    if (cmdArgs[0].equals("-d") || cmdArgs[0].equals("-describe")) {
                        throw new ToolsException(this.msg("CD_DESCRIPTION", null));
                    }
                    if (cmdArgs[0].equals("-h") || cmdArgs[0].equals("-help")) {
                        throw new ToolsException(this.msg("CD_HELP", null));
                    }
                    if (!cmdArgs[0].equals("-v") && !cmdArgs[0].equals("-version")) throw new ToolsException(this.msg("CD_USAGE", null));
                    throw new ToolsException(this.msg("CD_VERSION", null));
                }
            }
        }
        if (command.equals("pwd")) {
            if (ToolImpl.wd.wd_name.size() == 1) {
                this.stdOut.println(ToolImpl.wd.wd_name());
                return false;
            } else {
                this.stdOut.println(String.valueOf(String.valueOf(ToolImpl.wd.wd_name())) + "/");
            }
            return false;
        }
        if (command.equals("lcd")) {
            if (cmdArgs.length == 0) {
                ToolImpl.local_wd.cd("");
                return false;
            } else {
                if (cmdArgs.length != 1) throw new ToolsException(this.msg("LCD_USAGE", null));
                if (cmdArgs[0].charAt(0) != '-') {
                    ToolImpl.local_wd.cd(cmdArgs[0]);
                    return false;
                } else {
                    if (cmdArgs[0].equals("-d") || cmdArgs[0].equals("-describe")) {
                        throw new ToolsException(this.msg("LCD_DESCRIPTION", null));
                    }
                    if (cmdArgs[0].equals("-h") || cmdArgs[0].equals("-help")) {
                        throw new ToolsException(this.msg("LCD_HELP", null));
                    }
                    if (!cmdArgs[0].equals("-v") && !cmdArgs[0].equals("-version")) throw new ToolsException(this.msg("LCD_USAGE", null));
                    throw new ToolsException(this.msg("LCD_VERSION", null));
                }
            }
        }
        if (command.equals("lpwd")) {
            if (!ToolImpl.local_wd.isWindows() && ToolImpl.local_wd.wd_name.size() == 1) {
                this.stdOut.println(ToolImpl.local_wd.wd_name());
                return false;
            } else {
                this.stdOut.println(String.valueOf(String.valueOf(ToolImpl.local_wd.wd_name())) + "/");
            }
            return false;
        }
        Tool tool = this.get_tool(command);
        if (tool != null) {
            tool.invoke(cmdArgs, this.stdIn, this.stdOut, this.stdErr);
            return false;
        }
        this.invoke_executable(command, cmdArgs);
        return false;
    }

    private void invoke_executable(String exe, String[] cmdArgs) throws ToolsException {
        this.getPath();
        int i = 0;
        while (i < this.path.length) {
            try {
                SessionCtx dir = (SessionCtx)ToolImpl.wd.lookupDirectory(this.path[i]);
                this.execute((Executable)dir.activate(exe), cmdArgs);
                return;
            }
            catch (ToolsException toolsException) {
            }
            catch (NamingException namingException) {
            }
            catch (ClassCastException classCastException) {}
            ++i;
        }
        this.fail1("NOT_FOUND", exe);
    }

    public static void main(String[] args) {
        try {
            new Shell().invoke(args, System.in, System.out, System.err);
        }
        catch (ToolsException e) {
            System.err.println();
            System.err.println(e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    protected void parseArgs(String[] argv) throws ToolsException {
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-batch")) {
                this.batch = true;
                if (++i < argv.length && !argv[i].startsWith("-")) {
                    this.fileName = argv[i];
                }
            }
            ++i;
        }
    }

    private String prompt() {
        String prompt = ToolImpl.environment.getProperty(PROMPT);
        if (prompt == null) {
            return "$ ";
        }
        return prompt;
    }

    private void setenv(String[] args) throws ToolsException {
        if (args.length != 2) {
            this.fail0("SETENV_USAGE");
        }
        ((Hashtable)ToolImpl.environment).put(args[0], args[1]);
        this.path = null;
    }

    private void source(String[] args) throws ToolsException {
        if (args.length == 1) {
            this.source(this.get_property("/etc/oracle/aurora/sess_sh.properties"));
            return;
        }
        this.source(args[1]);
    }

    public String usage() throws ToolsException {
        return this.msg("SHELL_USAGE", null);
    }

    public String version() throws ToolsException {
        return this.msg("SHELL_VERSION", null);
    }

    private void version(String[] args) throws ToolsException {
        String version = null;
        version = args.length == 1 ? this.version() : this.get_tool(args[1]).version();
        throw new ToolsException(version);
    }
}

