/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.jndi.sess_iiop;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ResourceBundle;
import javax.naming.CommunicationException;
import javax.naming.InvalidNameException;
import javax.naming.Name;

class ServiceId {
    private static ResourceBundle resMessages = ResourceBundle.getBundle("oracle.aurora.jndi.sess_iiop.Messages");
    String id;
    String host;
    short port;
    static final short DEFAULT_PORT = 900;

    ServiceId(String name) throws InvalidNameException, CommunicationException {
        this.id = this.parsePort(this.parseHost(name));
    }

    ServiceId(String id_, String host_, short port_) {
        this.id = id_;
        this.host = host_;
        this.port = port_;
    }

    ServiceId(Name name) throws InvalidNameException, CommunicationException {
        this.id = this.parsePort(this.parseHost(name.get(0)));
    }

    public boolean equals(Object obj) {
        try {
            ServiceId that = (ServiceId)obj;
            return this.port == this.port && this.host.equals(that.host) && this.id.equals(that.id);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.host.hashCode() ^ this.port;
    }

    private String parseHost(String name) throws CommunicationException {
        int nextPart = name.indexOf(58);
        if (nextPart < 0) {
            this.host = this.id;
            return "";
        }
        try {
            this.host = InetAddress.getByName(name.substring(0, nextPart)).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new CommunicationException(String.valueOf(resMessages.getString("UNKNOWN_HOST")) + name.substring(0, nextPart));
        }
        return name.substring(nextPart + 1);
    }

    private String parsePort(String name) throws CommunicationException, InvalidNameException {
        int nextPart = name.indexOf(58);
        if (nextPart < 0) {
            try {
                this.port = (short)Integer.parseInt(name);
            }
            catch (NumberFormatException numberFormatException) {
                this.port = (short)900;
                return name;
            }
            return "";
        }
        try {
            this.port = (short)Integer.parseInt(name.substring(0, nextPart));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidNameException(String.valueOf(resMessages.getString("INVALID_PORT")) + name.substring(0, nextPart));
        }
        return name.substring(nextPart + 1);
    }

    public String toString() {
        if (this.id == null) {
            return String.valueOf(this.host) + ':' + this.port;
        }
        return String.valueOf(this.host) + ':' + this.port + ':' + this.id;
    }
}

