/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.xml.parser;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import oracle.aurora.ejb.parser.ParseError;
import oracle.aurora.ejb.parser.ParsedBean;
import oracle.aurora.ejb.parser.ParsedType;
import oracle.aurora.ejb.xml.parser.MethodElement;
import oracle.aurora.ejb.xml.parser.MethodEntry;

public class MethodTable {
    ClassLoader loader;
    Hashtable table;

    MethodTable(ClassLoader loader) {
        this.loader = loader;
        this.table = new Hashtable();
    }

    void addMethods(Method[] methods) {
        if (methods == null) {
            return;
        }
        int i = 0;
        while (i < methods.length) {
            String name = methods[i].getName();
            MethodEntry oldEntry = (MethodEntry)this.table.get(name);
            MethodEntry newEntry = new MethodEntry(methods[i], oldEntry);
            this.table.put(name, newEntry);
            ++i;
        }
    }

    boolean argumentTypesMatch(Vector args, Class[] parameterTypes) throws ClassNotFoundException {
        int size = args.size();
        if (size != parameterTypes.length) {
            return false;
        }
        int i = 0;
        while (i < size) {
            if (!this.typeMatches((String)args.elementAt(i), parameterTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    Method findMethod(MethodElement elem) throws Exception {
        Vector args;
        MethodEntry entry = (MethodEntry)this.table.get(elem.getMethodName());
        if (entry == null) {
            ParseError.NO_METHOD_NAMED(elem.getMethodName());
        }
        if ((args = elem.getMethodParam()) != null) {
            do {
                if (!this.argumentTypesMatch(args, entry.method.getParameterTypes())) continue;
                return entry.method;
            } while ((entry = entry.next) != null);
        } else {
            return entry.method;
        }
        ParseError.NO_METHOD_WITH_SIGNATURE(elem.toString());
        return null;
    }

    private ParsedType parseType(String arg) {
        String typeName = null;
        int dimension = 0;
        int i = arg.indexOf(91);
        if (i == -1) {
            return new ParsedType(arg, 0);
        }
        ++dimension;
        typeName = arg.substring(0, i);
        while (i > 0) {
            if ((i = arg.indexOf(91, i + 1)) <= 0) continue;
            ++dimension;
        }
        return new ParsedType(typeName, dimension);
    }

    boolean typeMatches(String c1, Class c2) throws ClassNotFoundException {
        Class<?> clazz2 = c2;
        ParsedType pt = this.parseType(c1);
        int i = 0;
        while (i < pt.dimension()) {
            if (!clazz2.isArray()) {
                return false;
            }
            clazz2 = clazz2.getComponentType();
            ++i;
        }
        Class this_clazz = ParsedBean.findClass(this.loader, pt.name());
        return this_clazz == clazz2;
    }
}

