/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.deployment;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import oracle.aurora.ejb.deployment.EjbJarFileEditor;

class EjbJarFileClassLoader
extends ClassLoader {
    EjbJarFileEditor editor;
    Hashtable cache = new Hashtable();

    protected EjbJarFileClassLoader(EjbJarFileEditor e) {
        this.editor = e;
    }

    public URL getResource(String name) {
        return ClassLoader.getSystemResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return ClassLoader.getSystemResourceAsStream(name);
    }

    byte[] getStreamBytes(InputStream is) throws IOException {
        int read_this_time;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(is.available());
        byte[] buffer = new byte[4000];
        while ((read_this_time = is.read(buffer)) != -1) {
            baos.write(buffer, 0, read_this_time);
        }
        return baos.toByteArray();
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        byte[] bits = null;
        Class c = (Class)this.cache.get(name);
        if (c != null) {
            return c;
        }
        try {
            return this.findSystemClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                InputStream byteStream = this.editor.classBits(name);
                bits = this.getStreamBytes(byteStream);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(name);
            }
            Class<?> theClass = this.defineClass(bits, 0, bits.length);
            this.cache.put(name, theClass);
            if (resolve) {
                this.resolveClass(theClass);
            }
            return theClass;
        }
    }
}

