/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.publishing;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.aurora.AuroraServices.MinorCodes;
import oracle.aurora.AuroraServices.PublishedObject;
import oracle.aurora.AuroraServices._PublishingContextImplBase;
import oracle.aurora.AuroraServices.ctxAttribs;
import oracle.aurora.AuroraServices.ctxAttribsHolder;
import oracle.aurora.rdbms.DbmsJava;
import oracle.aurora.rdbms.DbmsRealm;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.server.ORB;
import oracle.aurora.server.publishing.Binding;
import oracle.aurora.server.publishing.BindingIteratorImpl;
import oracle.aurora.server.publishing.NamespaceRDBMS;
import oracle.aurora.server.publishing.Node;
import oracle.aurora.server.publishing.PublishedObjectImpl;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.PERSIST_STORE;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;

public final class PublishingContextImpl
extends _PublishingContextImplBase
implements Node {
    protected long node;
    protected static PublishingContextImpl singleton;
    protected static NamespaceRDBMS db;
    protected static Hashtable activated;
    private static final int ROOT_CONTEXT = 1;
    private static final int ERROR_ALREADY_EXIST = 1;
    private static final int ERROR_NOT_EXIST = 0;

    static {
        db = new NamespaceRDBMS();
        activated = new Hashtable();
    }

    private PublishingContextImpl() {
    }

    private PublishingContextImpl(long n) {
        this.node = n;
        com.visigenic.vbroker.orb.ORB _orb = (com.visigenic.vbroker.orb.ORB)ORB.init();
        _orb.BOA_init().obj_is_ready((Object)this);
    }

    private Object activate(long node) throws SQLException {
        if (db.isContext(node)) {
            return this.activateContext(node);
        }
        return this.activateObject(node);
    }

    private PublishingContextImpl activateContext(long node) {
        Hashtable hashtable = activated;
        synchronized (hashtable) {
            PublishingContextImpl ctx = (PublishingContextImpl)activated.get(new Long(node));
            if (ctx == null) {
                ctx = new PublishingContextImpl(node);
                activated.put(new Long(node), ctx);
            }
            PublishingContextImpl publishingContextImpl = ctx;
            java.lang.Object var5_5 = null;
            return publishingContextImpl;
        }
    }

    private Object activateObject(long node) {
        Hashtable hashtable = activated;
        synchronized (hashtable) {
            PublishedObjectImpl obj = (PublishedObjectImpl)activated.get(new Long(node));
            if (obj == null) {
                obj = new PublishedObjectImpl(node);
                activated.put(new Long(node), obj);
            }
            PublishedObjectImpl publishedObjectImpl = obj;
            java.lang.Object var5_5 = null;
            return publishedObjectImpl;
        }
    }

    private void bind(NameComponent name, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        try {
            if (!this.check_write_rights()) {
                db.commitROTxn();
                throw new NO_PERMISSION();
            }
            long child = ((Node)obj).node();
            db.bind(new Binding(this.node, child, name.id, name.kind, 0));
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1) {
                throw new AlreadyBound();
            }
            e.printStackTrace();
            db.abortTxn();
            throw new CannotProceed(this, new NameComponent[]{name});
        }
    }

    public void bind(NameComponent[] name, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        Schema invalidUser = Schema.lookup((String)"AURORA$ORB$UNAUTHENTICATED");
        if (Schema.currentSchema().equals((java.lang.Object)invalidUser)) {
            throw new NO_PERMISSION(MinorCodes.getMessage(18), 18, CompletionStatus.COMPLETED_NO);
        }
        if (name.length == 0) {
            throw new InvalidName();
        }
        db.beginTxn();
        this.r_bind(name, obj);
        db.commitTxn();
    }

    private void bind_context(NameComponent name, NamingContext context) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        long child = ((Node)((java.lang.Object)context)).node();
        try {
            if (!this.check_write_rights()) {
                db.commitROTxn();
                throw new NO_PERMISSION();
            }
            db.bind(new Binding(this.node, child, name.id, name.kind, 1));
        }
        catch (SQLException e) {
            e.printStackTrace();
            db.abortTxn();
            if (e.getErrorCode() == 1) {
                throw new AlreadyBound();
            }
            throw new CannotProceed(this, new NameComponent[]{name});
        }
    }

    public void bind_context(NameComponent[] name, NamingContext context) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (name.length == 0) {
            throw new InvalidName();
        }
        db.beginTxn();
        this.r_bind_context(name, context);
        db.commitTxn();
    }

    private NamingContext bind_new_context(NameComponent n) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        try {
            if (!this.check_write_rights()) {
                db.commitROTxn();
                throw new NO_PERMISSION();
            }
            PublishingContextImpl newCtx = this.createCtx();
            db.bind(new Binding(this.node, newCtx.node, n.id, n.kind, 1));
            return newCtx;
        }
        catch (SQLException e) {
            e.printStackTrace();
            db.abortTxn();
            if (e.getErrorCode() == 1) {
                throw new AlreadyBound();
            }
            NameComponent[] name = new NameComponent[]{n};
            throw new CannotProceed(this, name);
        }
    }

    public NamingContext bind_new_context(NameComponent[] name) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        if (name.length == 0) {
            throw new InvalidName();
        }
        db.beginTxn();
        NamingContext newCtx = this.r_bind_new_context(name);
        db.commitTxn();
        return newCtx;
    }

    boolean check_execute_rights() throws SQLException {
        return this.check_rights(NamespaceRDBMS.EXECUTE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean check_owner() throws SQLException {
        boolean bl;
        ResultSet rs;
        PreparedStatement pstmt;
        block7: {
            boolean bl2;
            block6: {
                Schema schema = Schema.currentSchema();
                if (schema == DbmsRealm.theSystemSchema) {
                    return true;
                }
                pstmt = null;
                rs = null;
                try {
                    pstmt = NamespaceRDBMS.con.prepareStatement("select owner from " + NamespaceRDBMS.inode + " where node = ?");
                    pstmt.setLong(1, this.node);
                    rs = db.execute(pstmt);
                    if (rs.next()) {
                        int uorid = rs.getInt(1);
                        if (uorid == DbmsRealm.thePublicSchema.ownerNumber() || schema.equals(uorid)) {
                            boolean bl3 = true;
                            java.lang.Object var6_8 = null;
                            db.close(pstmt);
                            db.close(rs);
                            return bl3;
                        }
                        if (DbmsJava.isRoleEnabled((int)uorid)) {
                            bl2 = true;
                            break block6;
                        }
                    }
                    bl = false;
                    break block7;
                }
                catch (Throwable throwable) {
                    java.lang.Object var6_11 = null;
                    db.close(pstmt);
                    db.close(rs);
                    throw throwable;
                }
            }
            java.lang.Object var6_9 = null;
            db.close(pstmt);
            db.close(rs);
            return bl2;
        }
        java.lang.Object var6_10 = null;
        db.close(pstmt);
        db.close(rs);
        return bl;
    }

    boolean check_read_rights() throws SQLException {
        return this.check_rights(NamespaceRDBMS.READ);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean check_rights(int right) throws SQLException {
        boolean bl;
        ResultSet rs;
        PreparedStatement pstmt;
        block5: {
            boolean bl2;
            pstmt = null;
            rs = null;
            if (this.check_owner()) {
                return true;
            }
            Schema schema = Schema.currentSchema();
            try {
                int uorid;
                pstmt = NamespaceRDBMS.con.prepareStatement("select schema from " + NamespaceRDBMS.permissions + " where node = :1 and type = :2");
                pstmt.setLong(1, this.node);
                pstmt.setInt(2, right);
                rs = db.execute(pstmt);
                do {
                    if (!rs.next()) {
                        bl = false;
                        break block5;
                    }
                    uorid = rs.getInt(1);
                    if (uorid != DbmsRealm.thePublicSchema.ownerNumber() && !schema.equals(uorid)) continue;
                    boolean bl3 = true;
                    java.lang.Object var7_9 = null;
                    db.close(pstmt);
                    db.close(rs);
                    return bl3;
                } while (!DbmsJava.isRoleEnabled((int)uorid));
                bl2 = true;
            }
            catch (Throwable throwable) {
                java.lang.Object var7_12 = null;
                db.close(pstmt);
                db.close(rs);
                throw throwable;
            }
            java.lang.Object var7_10 = null;
            db.close(pstmt);
            db.close(rs);
            return bl2;
        }
        java.lang.Object var7_11 = null;
        db.close(pstmt);
        db.close(rs);
        return bl;
    }

    boolean check_write_rights() throws SQLException {
        return this.check_rights(NamespaceRDBMS.WRITE);
    }

    private PublishingContextImpl createCtx() throws SQLException {
        long id = db.new_context(Schema.currentSchema().ownerNumber());
        PublishingContextImpl newCtx = new PublishingContextImpl(id);
        Hashtable hashtable = activated;
        synchronized (hashtable) {
            activated.put(new Long(id), newCtx);
        }
        return newCtx;
    }

    private PublishedObjectImpl createObject(String className, String helper) throws SQLException {
        long id = db.create_object(className, Schema.currentSchema().ownerNumber(), helper, Schema.currentSchema().ownerNumber());
        PublishedObjectImpl newObj = new PublishedObjectImpl(id);
        Hashtable hashtable = activated;
        synchronized (hashtable) {
            activated.put(new Long(id), newObj);
        }
        return newObj;
    }

    private PublishedObjectImpl createObject(String className, String schema, String helper) throws SQLException {
        long id = db.create_object(className, NamespaceRDBMS.lookup_schema(schema), helper, Schema.currentSchema().ownerNumber());
        PublishedObjectImpl newObj = new PublishedObjectImpl(id);
        Hashtable hashtable = activated;
        synchronized (hashtable) {
            activated.put(new Long(id), newObj);
        }
        return newObj;
    }

    private PublishedObject create_object(NameComponent name, String className, String helper) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        try {
            if (!this.check_write_rights()) {
                db.commitROTxn();
                throw new NO_PERMISSION();
            }
            if (db.exists(this.node, name)) {
                throw new AlreadyBound();
            }
            PublishedObjectImpl obj = this.createObject(className, helper);
            this.bind(name, (Object)obj);
            return obj;
        }
        catch (SQLException e) {
            e.printStackTrace();
            db.abortTxn();
            if (e.getErrorCode() == 1) {
                throw new AlreadyBound();
            }
            NameComponent[] n = new NameComponent[]{name};
            throw new CannotProceed(this, n);
        }
    }

    public PublishedObject create_object(NameComponent[] name, String className, String helper) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (name.length == 0) {
            throw new InvalidName();
        }
        db.beginTxn();
        PublishedObject obj = this.r_create_object(name, className, helper);
        db.commitTxn();
        return obj;
    }

    private PublishedObject create_object_in(NameComponent name, String className, String schema, String helper) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        try {
            if (!this.check_write_rights()) {
                db.commitROTxn();
                throw new NO_PERMISSION();
            }
            if (db.exists(this.node, name)) {
                throw new AlreadyBound();
            }
            PublishedObjectImpl obj = this.createObject(className, schema, helper);
            this.bind(name, (Object)obj);
            return obj;
        }
        catch (SQLException e) {
            e.printStackTrace();
            db.abortTxn();
            if (e.getErrorCode() == 1) {
                throw new AlreadyBound();
            }
            NameComponent[] n = new NameComponent[]{name};
            throw new CannotProceed(this, n);
        }
    }

    public PublishedObject create_object_in(NameComponent[] name, String className, String schema, String helper) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        Schema invalidUser = Schema.lookup((String)"AURORA$ORB$UNAUTHENTICATED");
        if (Schema.currentSchema().equals((java.lang.Object)invalidUser)) {
            throw new NO_PERMISSION(MinorCodes.getMessage(18), 18, CompletionStatus.COMPLETED_NO);
        }
        if (name.length == 0) {
            throw new InvalidName();
        }
        db.beginTxn();
        PublishedObject obj = this.r_create_object_in(name, className, schema, helper);
        db.commitTxn();
        return obj;
    }

    public void destroy() throws NotEmpty {
        try {
            db.beginTxn();
            if (!this.check_owner()) {
                throw new NO_PERMISSION();
            }
            db.delete(this.node);
            Hashtable hashtable = activated;
            synchronized (hashtable) {
                activated.remove(new Long(this.node));
            }
            db.commitTxn();
            com.visigenic.vbroker.orb.ORB _orb = (com.visigenic.vbroker.orb.ORB)ORB.init();
            _orb.BOA_init().deactivate_obj((Object)this);
        }
        catch (SQLException e) {
            e.printStackTrace();
            db.abortTxn();
            throw new PERSIST_STORE("SQLException: " + e.getMessage());
        }
    }

    public void get_attributes(ctxAttribsHolder attribs) {
        try {
            db.beginTxn();
            if (!this.check_read_rights()) {
                db.commitROTxn();
                String es = "";
                String[] sc = new String[]{};
                attribs.value = new ctxAttribs(es, es, sc, sc, sc);
                return;
            }
            attribs.value = db.get_context_attributes(this.node);
            db.commitROTxn();
        }
        catch (SQLException e) {
            db.abortTxn();
            e.printStackTrace();
            throw new PERSIST_STORE("SQL Exception: " + e.getMessage());
        }
    }

    private NameComponent last(NameComponent[] name) {
        return name[name.length - 1];
    }

    private NameComponent[] lead(NameComponent[] name) {
        NameComponent[] result = new NameComponent[name.length - 1];
        System.arraycopy(name, 0, result, 0, result.length);
        return result;
    }

    public void list(int how_many, BindingListHolder bl, BindingIteratorHolder bi) {
        try {
            try {
                db.beginTxn();
                if (!this.check_read_rights()) {
                    db.commitROTxn();
                    bl.value = new org.omg.CosNaming.Binding[0];
                    java.lang.Object var5_4 = null;
                    db.commitROTxn();
                    return;
                }
                Enumeration listing = db.list_context(this.node);
                bl.value = new org.omg.CosNaming.Binding[how_many];
                int i = 0;
                while (i < how_many) {
                    if (!listing.hasMoreElements()) break;
                    Binding binding = (Binding)listing.nextElement();
                    NameComponent[] name = new NameComponent[]{new NameComponent(binding.id, binding.kind)};
                    bl.value[i] = new org.omg.CosNaming.Binding(name, BindingType.from_int(binding.binding_type));
                    ++i;
                }
                if (listing.hasMoreElements()) {
                    bi.value = new BindingIteratorImpl(listing);
                }
                if (i < how_many) {
                    org.omg.CosNaming.Binding[] bindings = new org.omg.CosNaming.Binding[i];
                    System.arraycopy(bl.value, 0, bindings, 0, i);
                    bl.value = bindings;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new PERSIST_STORE(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            java.lang.Object var5_6 = null;
            db.commitROTxn();
            throw throwable;
        }
        java.lang.Object var5_5 = null;
        db.commitROTxn();
    }

    public NamingContext new_context() {
        try {
            db.beginTxn();
            PublishingContextImpl newCtx = this.createCtx();
            db.commitTxn();
            return newCtx;
        }
        catch (SQLException e) {
            e.printStackTrace();
            db.abortTxn();
            throw new PERSIST_STORE(e.getMessage());
        }
    }

    public long node() {
        return this.node;
    }

    private boolean nullString(String s) {
        if (s == null) {
            return true;
        }
        return s.equals("");
    }

    private void r_bind(NameComponent[] name, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (name.length == 1) {
            this.bind(name[0], obj);
            return;
        }
        Object ctx = this.r_resolve(this.lead(name));
        NameComponent nameEnd = this.last(name);
        if (!(ctx instanceof PublishingContextImpl)) {
            db.abortTxn();
            NameComponent[] rest = new NameComponent[]{nameEnd};
            throw new NotFound(NotFoundReason.not_context, rest);
        }
        ((PublishingContextImpl)ctx).bind(nameEnd, obj);
    }

    private void r_bind_context(NameComponent[] name, NamingContext context) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (name.length == 1) {
            this.bind_context(name[0], context);
            return;
        }
        Object ctx = this.r_resolve(this.lead(name));
        NameComponent nameEnd = this.last(name);
        if (!(ctx instanceof PublishingContextImpl)) {
            db.abortTxn();
            NameComponent[] rest = new NameComponent[]{nameEnd};
            throw new NotFound(NotFoundReason.not_context, rest);
        }
        ((PublishingContextImpl)ctx).bind_context(nameEnd, context);
    }

    private NamingContext r_bind_new_context(NameComponent[] name) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        if (name.length == 1) {
            return this.bind_new_context(name[0]);
        }
        Object ctx = this.r_resolve(this.lead(name));
        NameComponent nameEnd = this.last(name);
        if (!(ctx instanceof PublishingContextImpl)) {
            db.abortTxn();
            NameComponent[] rest = new NameComponent[]{nameEnd};
            throw new NotFound(NotFoundReason.not_context, rest);
        }
        return ((PublishingContextImpl)ctx).bind_new_context(nameEnd);
    }

    private PublishedObject r_create_object(NameComponent[] name, String className, String helper) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        if (name.length == 1) {
            return this.create_object(name[0], className, helper);
        }
        Object ctx = this.r_resolve(this.lead(name));
        NameComponent nameEnd = this.last(name);
        if (!(ctx instanceof PublishingContextImpl)) {
            db.abortTxn();
            NameComponent[] rest = new NameComponent[]{nameEnd};
            throw new NotFound(NotFoundReason.not_context, rest);
        }
        return ((PublishingContextImpl)ctx).create_object(nameEnd, className, helper);
    }

    private PublishedObject r_create_object_in(NameComponent[] name, String className, String schema, String helper) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        if (name.length == 1) {
            return this.create_object_in(name[0], className, schema, helper);
        }
        Object ctx = this.r_resolve(this.lead(name));
        NameComponent nameEnd = this.last(name);
        if (!(ctx instanceof PublishingContextImpl)) {
            db.abortTxn();
            NameComponent[] rest = new NameComponent[]{nameEnd};
            throw new NotFound(NotFoundReason.not_context, rest);
        }
        return ((PublishingContextImpl)ctx).create_object_in(nameEnd, className, schema, helper);
    }

    private void r_rebind(NameComponent[] name, Object obj) throws NotFound, CannotProceed, InvalidName {
        if (name.length == 1) {
            this.rebind(name[0], obj);
            return;
        }
        Object ctx = this.r_resolve(this.lead(name));
        NameComponent nameEnd = this.last(name);
        if (!(ctx instanceof PublishingContextImpl)) {
            NameComponent[] rest = new NameComponent[]{nameEnd};
            throw new NotFound(NotFoundReason.not_context, rest);
        }
        ((PublishingContextImpl)ctx).rebind(nameEnd, obj);
    }

    private void r_rebind_context(NameComponent[] name, NamingContext context) throws NotFound, CannotProceed, InvalidName {
        if (name.length == 1) {
            this.rebind_context(name[0], context);
            return;
        }
        Object ctx = this.r_resolve(this.lead(name));
        NameComponent nameEnd = this.last(name);
        if (!(ctx instanceof PublishingContextImpl)) {
            NameComponent[] rest = new NameComponent[]{nameEnd};
            throw new NotFound(NotFoundReason.not_context, rest);
        }
        ((PublishingContextImpl)ctx).rebind_context(nameEnd, context);
    }

    private Object r_resolve(NameComponent[] name) throws NotFound, CannotProceed, InvalidName {
        Object obj = null;
        Binding binding = null;
        try {
            if (!this.check_execute_rights()) {
                db.commitROTxn();
                throw new NO_PERMISSION();
            }
            binding = db.get_binding(this.node, name[0]);
            if (binding == null) {
                throw new NotFound(NotFoundReason.missing_node, this.tail(name));
            }
            obj = this.activate(binding.child);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new CannotProceed(this, this.tail(name));
        }
        if (name.length == 1) {
            return obj;
        }
        if (!(obj instanceof PublishingContextImpl)) {
            throw new NotFound(NotFoundReason.not_context, this.tail(name));
        }
        if (binding.binding_type == 0) {
            throw new CannotProceed(this, this.tail(name));
        }
        return ((PublishingContextImpl)obj).r_resolve(this.tail(name));
    }

    private void r_unbind(NameComponent[] name) throws NotFound, CannotProceed, InvalidName {
        if (name.length == 1) {
            this.unbind(name[0]);
            return;
        }
        Object ctx = this.r_resolve(this.lead(name));
        NameComponent nameEnd = this.last(name);
        if (!(ctx instanceof PublishingContextImpl)) {
            NameComponent[] rest = new NameComponent[]{nameEnd};
            throw new NotFound(NotFoundReason.not_context, rest);
        }
        ((PublishingContextImpl)ctx).unbind(nameEnd);
    }

    private void rebind(NameComponent name, Object obj) throws NotFound, CannotProceed, InvalidName {
        try {
            if (!this.check_write_rights()) {
                db.commitROTxn();
                throw new NO_PERMISSION();
            }
            long child = ((Node)obj).node();
            Binding binding = new Binding(this.node, child, name.id, name.kind, 1);
            db.rebind(binding);
        }
        catch (SQLException e) {
            e.printStackTrace();
            db.abortTxn();
            if (e.getErrorCode() == 0) {
                throw new NotFound(NotFoundReason.missing_node, null);
            }
            NameComponent[] names = new NameComponent[]{name};
            throw new CannotProceed(this, names);
        }
    }

    public void rebind(NameComponent[] name, Object obj) throws NotFound, CannotProceed, InvalidName {
        if (name.length == 0) {
            throw new InvalidName();
        }
        db.beginTxn();
        this.r_rebind(name, obj);
        db.commitTxn();
    }

    private void rebind_context(NameComponent n, NamingContext nc) throws NotFound, CannotProceed, InvalidName {
        try {
            if (!this.check_write_rights()) {
                db.commitROTxn();
                throw new NO_PERMISSION();
            }
            long child = ((PublishingContextImpl)nc).node;
            Binding binding = new Binding(this.node, child, n.id, n.kind, 1);
            db.rebind(binding);
        }
        catch (SQLException e) {
            e.printStackTrace();
            db.abortTxn();
            if (e.getErrorCode() == 0) {
                throw new NotFound(NotFoundReason.missing_node, null);
            }
            NameComponent[] name = new NameComponent[]{n};
            throw new CannotProceed(this, name);
        }
    }

    public void rebind_context(NameComponent[] name, NamingContext context) throws NotFound, CannotProceed, InvalidName {
        if (name.length == 0) {
            throw new InvalidName();
        }
        db.beginTxn();
        this.r_rebind_context(name, context);
        db.commitTxn();
    }

    public Object resolve(NameComponent[] name) throws NotFound, CannotProceed, InvalidName {
        if (name.length == 0) {
            throw new InvalidName();
        }
        db.beginTxn();
        Object obj = this.r_resolve(name);
        db.commitROTxn();
        return obj;
    }

    public static PublishingContextImpl sessionContext() {
        if (singleton == null) {
            singleton = new PublishingContextImpl(1L);
            ((Hashtable)System.getProperties()).put("oracle.aurora.server.ORB.INITIAL_CONTEXT", singleton);
        }
        return singleton;
    }

    public static PublishingContextImpl sessionContext(Connection conn) {
        db = new NamespaceRDBMS(conn);
        singleton = new PublishingContextImpl(1L);
        com.visigenic.vbroker.orb.ORB _orb = (com.visigenic.vbroker.orb.ORB)ORB.init();
        _orb.BOA_init().obj_is_ready((Object)singleton);
        return singleton;
    }

    public int sessionId() {
        try {
            return DbmsJava.sessionID((int)1);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return 1;
        }
    }

    public void set_attributes(String owner, String[] read, String[] write, String[] execute) {
        try {
            db.beginTxn();
            if (!this.check_owner()) {
                db.abortTxn();
                throw new NO_PERMISSION();
            }
            if (!this.nullString(owner)) {
                if (Schema.currentSchema() != DbmsRealm.theSystemSchema) {
                    throw new NO_PERMISSION();
                }
                db.set_owner(this.node, NamespaceRDBMS.lookup_schema(owner));
            }
            if (read.length > 0) {
                db.set_read_rights(this.node, read);
            }
            if (write.length > 0) {
                db.set_write_rights(this.node, write);
            }
            if (execute.length > 0) {
                db.set_execute_rights(this.node, execute);
            }
            db.commitTxn();
        }
        catch (SQLException e) {
            e.printStackTrace();
            db.abortTxn();
            throw new PERSIST_STORE("SQL Exception: " + e.getMessage());
        }
    }

    public static PublishingContextImpl singletonContext() {
        return singleton;
    }

    private NameComponent[] tail(NameComponent[] name) {
        NameComponent[] result = new NameComponent[name.length - 1];
        System.arraycopy(name, 1, result, 0, result.length);
        return result;
    }

    public String toString() {
        return "Context : " + this.node;
    }

    private void unbind(NameComponent name) throws NotFound, CannotProceed, InvalidName {
        try {
            if (!this.check_write_rights()) {
                db.commitROTxn();
                throw new NO_PERMISSION();
            }
            db.unbind(this.node, name);
        }
        catch (SQLException e) {
            e.printStackTrace();
            db.abortTxn();
            if (e.getErrorCode() == 0) {
                throw new NotFound(NotFoundReason.missing_node, null);
            }
            NameComponent[] names = new NameComponent[]{name};
            throw new CannotProceed(this, names);
        }
    }

    public void unbind(NameComponent[] name) throws NotFound, CannotProceed, InvalidName {
        if (name.length == 0) {
            throw new InvalidName();
        }
        db.beginTxn();
        this.r_unbind(name);
        db.commitTxn();
    }
}

