/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.mcp;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.mcp.SMMCP;
import com.sun.symon.base.client.mcp.SMMCPSyncException;
import com.sun.symon.base.client.mcp.SMParcelData;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.service.SMStaleDataException;
import com.sun.symon.base.console.grouping.CgUtil;
import com.sun.symon.base.console.mcp.CpMCPManager;
import com.sun.symon.base.utility.UcDialog;
import java.util.Date;

public class CpMCPController {
    private SMMCP mcp_;

    public CpMCPController(SMMCP sMMCP) {
        this.mcp_ = sMMCP;
    }

    private String localize(String string) {
        return CpMCPManager.localize(string);
    }

    public static void main(String[] stringArray) {
        CpMCPManager cpMCPManager = new CpMCPManager(true);
    }

    public boolean save(SMParcelData sMParcelData, boolean bl) {
        block15: {
            try {
                if (CpMCPManager.isTesting()) {
                    this.throwEx();
                } else {
                    this.mcp_.save(sMParcelData, bl);
                }
            }
            catch (SMMCPSyncException sMMCPSyncException) {
                System.out.println((Object)sMMCPSyncException);
                this.showError("parcelSyncError");
                return false;
            }
            catch (SMDuplicateException sMDuplicateException) {
                String string = sMParcelData.getName();
                int n = UcDialog.showYesNo((String)CgUtil.getI18nMsg("confirmOverwrite(" + string + ")"));
                if (n == 0) {
                    try {
                        SMDBObject sMDBObject = this.mcp_.loadObj(string);
                        this.mcp_.deleteObj(sMDBObject);
                        this.mcp_.saveObj((SMDBObject)sMParcelData);
                        return true;
                    }
                    catch (SMAPIException sMAPIException) {
                        CgUtil.handleAPIException(sMAPIException, null);
                        return false;
                    }
                }
                return false;
            }
            catch (SMStaleDataException sMStaleDataException) {
                this.showError("staleDataError");
                return false;
            }
            catch (SMNoSuchObjectException sMNoSuchObjectException) {
                this.showError("noSuchObjectError");
                return false;
            }
            catch (SMDatabaseException sMDatabaseException) {
                sMDatabaseException.printStackTrace();
                this.showError("databaseError");
                return false;
            }
            catch (SMSecurityException sMSecurityException) {
                this.showError("securityError");
                return false;
            }
            catch (SMAPIException sMAPIException) {
                sMAPIException.printStackTrace();
                this.showError("saveError");
                return false;
            }
            if (!CpMCPManager.isTesting()) break block15;
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {}
        }
        return true;
    }

    void showError(String string) {
        CpMCPManager.showError(string);
    }

    public Date sync(SMDBObjectID sMDBObjectID) {
        try {
            if (!CpMCPManager.isTesting()) {
                return this.mcp_.sync(sMDBObjectID);
            }
            this.throwEx();
        }
        catch (SMMCPSyncException sMMCPSyncException) {
            System.out.println((Object)sMMCPSyncException);
            this.showError("parcelSyncError");
            return null;
        }
        catch (SMNoSuchObjectException sMNoSuchObjectException) {
            this.showError("noSuchObjectError");
            return null;
        }
        catch (SMDatabaseException sMDatabaseException) {
            sMDatabaseException.printStackTrace();
            this.showError("databaseError");
            return null;
        }
        catch (SMSecurityException sMSecurityException) {
            this.showError("securityError");
            return null;
        }
        catch (SMAPIException sMAPIException) {
            sMAPIException.printStackTrace();
            this.showError("parcelSyncError");
            return null;
        }
        if (CpMCPManager.isTesting()) {
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {}
            return new Date();
        }
        return null;
    }

    private void throwEx() throws SMAPIException {
    }
}

