/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.snmp.v1;

import com.sun.symon.base.server.snmp.SsDecodeException;
import com.sun.symon.base.server.snmp.SsEncodeException;
import com.sun.symon.base.server.snmp.SsMessage;
import com.sun.symon.base.server.snmp.jni.SsPacket;

public class SsTrap
extends SsMessage {
    private String enterprise;
    private String address = "0.0.0.0";
    private int generic;
    private int specific;
    private String timestamp = "0";

    public SsTrap() {
    }

    public SsTrap(SsPacket ssPacket) throws SsDecodeException {
        this.setState(ssPacket.state);
        this.setHost(ssPacket.host);
        this.setPort(ssPacket.port);
        this.setSecurityLevel(ssPacket.level);
        this.setSecurityModel(ssPacket.model);
        this.setText(ssPacket.printStatus());
        this.setContextName(ssPacket.context);
        this.setSecurityName(ssPacket.security);
        this.enterprise = ssPacket.enterprise;
        this.address = this.long2address(ssPacket.address);
        this.generic = ssPacket.generic;
        this.specific = ssPacket.specific;
        this.timestamp = String.valueOf(ssPacket.timestamp);
        this.setVariableNames(ssPacket.name);
        this.setVariableValues(ssPacket.kind, ssPacket.value);
    }

    public long address2long(String string) {
        long l = 0L;
        int n = 0;
        String string2 = string;
        int n2 = 0;
        while (n2 < 4) {
            n = string2.indexOf(46);
            long l2 = n2 != 3 ? Long.parseLong(string2.substring(0, n)) : Long.parseLong(string2);
            l = l * 256L + l2;
            string2 = string2.substring(n + 1);
            ++n2;
        }
        return l;
    }

    public String getAgentAddress() {
        return this.address;
    }

    public String getEnterprise() {
        return this.enterprise;
    }

    public int getGenericTrap() {
        return this.generic;
    }

    public int getSpecificTrap() {
        return this.specific;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public int getType() {
        return 4;
    }

    public int getVersion() {
        return 1;
    }

    public String long2address(long l) {
        long l2 = l % 256L;
        long l3 = l / 256L;
        long l4 = l3 % 256L;
        long l5 = (l3 /= 256L) % 256L;
        return (l3 /= 256L) + "." + l5 + "." + l4 + "." + l2;
    }

    public void setAgentAddress(String string) {
        this.address = string;
    }

    public void setEnterprise(String string) {
        this.enterprise = string;
    }

    public void setGenericTrap(int n) {
        this.generic = n;
    }

    public void setSpecificTrap(int n) {
        this.specific = n;
    }

    public void setTimestamp(String string) {
        this.timestamp = string;
    }

    public byte[] toBytestream() throws SsEncodeException {
        SsPacket ssPacket = new SsPacket();
        ssPacket.version = this.getVersion();
        ssPacket.state = this.getState();
        ssPacket.model = this.getSecurityModel();
        ssPacket.level = this.getSecurityLevel();
        ssPacket.host = this.getHost();
        ssPacket.port = this.getPort();
        ssPacket.context = this.getContextName();
        ssPacket.security = this.getSecurityName();
        ssPacket.type = this.getType();
        ssPacket.enterprise = this.enterprise;
        ssPacket.address = this.address2long(this.address);
        ssPacket.generic = this.getGenericTrap();
        ssPacket.specific = this.specific;
        Integer n = new Integer(this.timestamp);
        ssPacket.timestamp = n;
        ssPacket.name = this.getVariableNames();
        ssPacket.kind = this.getVariableTypes();
        ssPacket.value = this.getVariableValues();
        byte[] byArray = ssPacket.outgoing();
        ssPacket = null;
        return byArray;
    }
}

