#!/bin/sh
#
# @(#)mcp_publish.sh	1.11 01/02/14
# Copyright (c) 02/14/01 Sun Microsystems, Inc. All Rights Reserved.
#

LOCAL_BASE=`expr "$INTERFACE_PATH" : '\([^:]*\)'`
LOCAL_BASE=`dirname $LOCAL_BASE`

TMP_LOG_DIR="/tmp/sunmclog/"
mkdir -m 777 -p $TMP_LOG_DIR

PRODUCT_BASE=$ESROOT
TMP_LOCAL_BASE="$TMP_LOG_DIR"`basename $0`.$$
LOGFILE="$TMP_LOG_DIR"`basename $0`.$$.log
PUT=es-mcp-put

#
# initialize the log file
#
echo $0 called at `date` with args: $* >$LOGFILE

echo "ESROOT=$ESROOT" >> $LOGFILE
echo "INTERFACE_PATH=$INTERFACE_PATH" >> $LOGFILE
echo "LOCAL_BASE=$LOCAL_BASE" >> $LOGFILE

#
# create new base dir
#
mkdir -p "$TMP_LOCAL_BASE/cfg"

# Module parameters
FILE_MODULE_PARAMS="cfg/base-modules-d.dat"
echo "FILE_MODULE_PARAMS=$FILE_MODULE_PARAMS" >> $LOGFILE
touch "$TMP_LOCAL_BASE/${FILE_MODULE_PARAMS}.MCP"

#
# check expanded argument list
#
if [ $# -ne 1 ]
then
    echo "Usage: $0 id,url,parcel,module[+instance],module[+instance]..." >&2
    exit 1
fi

#
# expand first argument into its components
#
OLDIFS=$IFS
IFS=,
set $1
IFS=$OLDIFS

#
# check expanded argument list
#
if [ $# -lt 4 ]
then
    echo "Usage: $0 id,url,parcel,module[+instance],module[+instance]..." >&2
    exit 1
fi

ID=$1
URL=$2
PARCEL=$3
shift 3
MODULES=$*

#
# DAT publishing filter
#
filterDatFile () {
    #
    # remove all alarm acknowledgements
    #
#    grep -v "^value:" $1 |  grep -v value:ackName
    grep -v value:ackName $1
}

#
# get or create relevant files
#
FILES=""
echo "" >>$LOGFILE
for MODULE
do
    echo "module: $MODULE" >>$LOGFILE

    #
    # find "dat" files associated with module
    #
    FILE="cfg/$MODULE.dat"
    echo "  modfile: $FILE LOCAL_BASE $LOCAL_BASE" >>$LOGFILE
    if [ ! -f "$LOCAL_BASE/$FILE"  ] ; then # Skip if dat file doesn't exist
	continue
    fi

    # Save module parameters
    module_params=`/usr/bin/grep "^$MODULE" "$LOCAL_BASE/$FILE_MODULE_PARAMS"`
    if [ "$module_params" != "" ] ; then
	echo "${module_params}" >>"$TMP_LOCAL_BASE/${FILE_MODULE_PARAMS}.MCP"
    fi

    #
    # determine destination file name and directory
    #
    NEWFILE=$FILE.MCP
    NEWNAME=`basename $NEWFILE`

    mkdir -p `dirname $TMP_LOCAL_BASE/$NEWFILE`

    echo "  file: $FILE -> $NEWFILE" >>$LOGFILE

    #
    # create header for MCP content
    #
    echo "        adding filtered contents of $FILE" >>$LOGFILE
    echo "" >$TMP_LOCAL_BASE/$NEWFILE
    echo "#" >>$TMP_LOCAL_BASE/$NEWFILE
    echo "# The following content was added by the MCP system" >>$TMP_LOCAL_BASE/$NEWFILE
    echo "#" >>$TMP_LOCAL_BASE/$NEWFILE
    echo "" >>$TMP_LOCAL_BASE/$NEWFILE

    #
    # tack on filtered dat file
    #
    filterDatFile $LOCAL_BASE/$FILE >> $TMP_LOCAL_BASE/$NEWFILE

    FILES="$FILES $NEWFILE"
    echo "" >>$LOGFILE
done

# Also upload module parameters
FILES="$FILES $FILE_MODULE_PARAMS.MCP"

echo target files: $FILES >>$LOGFILE
echo "" >>$LOGFILE

#
# perform the put
#
if [ -n "$FILES" ]
then
#    MODULES=`echo "$MODULES" | /usr/bin/sed -e "s/+/%2B/g"` # Convert + for HTTP
    
    #
    # log command
    #
    echo running: $PUT $ID $URL $TMP_LOCAL_BASE \"$PARCEL $MODULES\" $FILES >>$LOGFILE

    #
    # execute command
    #
    eval $PUT $ID $URL $TMP_LOCAL_BASE \"$PARCEL $MODULES\" $FILES >>$LOGFILE 2>&1

    STATUS=$?

    #
    # check status
    #
    if [ $STATUS -ne 0 ]
    then
        #
        # failure - log error and exit, leaving log file for perusal
        #
        echo "" >>$LOGFILE
        echo "error: $PUT failed - see $LOGFILE for details" >>$LOGFILE
        echo "result: failure" >>$LOGFILE
        echo "failure"
        exit 2
    fi
else
    echo "" >>$LOGFILE
    echo "error: no files found for publish operation" >>$LOGFILE
    echo "failure"
    exit 3
fi

#
# success - clean up log file and exit
#
rm -f $LOGFILE
rm -rf $TMP_LOCAL_BASE
echo "success"
exit 0
