#!/bin/sh
# Copyright 02/23/01 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)sunmc-postinstall.sh	1.4 01/02/23 Sun Microsystems"


#
#This function works on patches specified in variable $PATCH_NAME
#If any of the patches not available then it will return 1 else
#it will return 0. It puts patches not available in variable 
#reqrd_patch_not_avail.
#

checkInObsoletedPatch() {
    #RELOC_PARAM=""
    #[ "$RELOCATED_ROOT" != "" ] && RELOC_PARAM="-R $RELOCATED_ROOT"
    obsolete_patch=""
    obsolete_patch=`${LOCAL_PATCH_COMMAND} -p $RELOC_PARAM | /usr/bin/cut -d : -f 3`
    for each_obsolete_patch in $obsolete_patch
    do
         if [ $each_obsolete_patch = "Requires" ] ; then
              continue
         fi
         #echo $each_obsolete_patch
         obsolete_patch_number=`echo $each_obsolete_patch | /usr/bin/cut -d- -f1`
         obsolete_patch_version=`echo $each_obsolete_patch | /usr/bin/cut -d- -f2`
         obsolete_patch_version=`echo $obsolete_patch_version | /usr/bin/cut -c1,2 `

         if [ $obsolete_patch_number -eq $1 ] ; then
                 if [ $obsolete_patch_version -ge $2 ] ; then
                      return 0
                 fi
         fi

    done
    return 1
}

checkInAvailPatch() {


        required_patch_number=$1
        required_patch_version=$2


        patch_number_found=`echo $patches_available | /usr/bin/grep -c $required_patch_number`
        if [ $patch_number_found -eq 0 ] ; then
                return 1
        fi
        for avail_patch  in $patches_available ;
        do
                avail_patch_number=`echo $avail_patch | /usr/bin/cut -d- -f1`
                avail_patch_version=`echo $avail_patch | /usr/bin/cut -d- -f2`

                if [ $required_patch_number -eq $avail_patch_number ] ; then
                        if [ $required_patch_version -le $avail_patch_version ]; then
                                return 0
                        fi
                fi
        done
        return 1
}

check_postinstall_patch_dependency () {
    #RELOC_PARAM=""
    required_patchlist="$1"

    patches_available=""
    reqrd_patch_not_avail=""
    reqrd_patch_not_avail_flag=0

    required_patch_number=""
    required_patch_version=""

    #[ "$RELOCATED_ROOT" != "" ] && RELOC_PARAM="-R $RELOCATED_ROOT"
    patches_available=`${LOCAL_PATCH_COMMAND} -p $RELOC_PARAM | /usr/bin/nawk ' { print $2 }'`

    for each_required_in_patchlist in $required_patchlist
    do
        # check if the patch is present

        required_patch_number=`echo $each_required_in_patchlist | /usr/bin/cut -d- -f1`
        required_patch_version=`echo $each_required_in_patchlist | /usr/bin/cut -d- -f2`

        checkInAvailPatch  $required_patch_number  $required_patch_version
        if [ $? -eq 1 ] ; then
            checkInObsoletedPatch $required_patch_number $required_patch_version
            if [ $? -eq 1 ] ; then
                reqrd_patch_not_avail="$reqrd_patch_not_avail $each_required_in_patchlist"
                reqrd_patch_not_avail_flag=1
            fi
        fi
    done

    if [ $reqrd_patch_not_avail_flag -eq 1 ] ; then
            return 1
    fi
    return 0
}
is_patch_needed ()
{
    #
    #Here we may want to see if we have some package installed 
    #for which the patch is not installed. System will say patch
    #is installed even if it was installed for only 2 packages
    # out of more then 2.
    #

    patch_name=$1
    check_postinstall_patch_dependency "$patch_name"
    if [ $? -eq 1 ] ; then
        return 1
    fi

    packages_patched=`${LOCAL_PATCH_COMMAND} -p $RELOC_PARAM | /usr/bin/grep $patch_name | /usr/bin/cut -d : -f 6`
    #
    # This is required because on some machines, packages are separated by commas.
    #
    packages_patched=`echo $packages_patched | /usr/bin/sed -e 's/,//g'`

    packages_in_patch=`/usr/bin/ls -1 "$PATCH_DIRECTORY/$patch_name" | /usr/bin/grep SUNW`

    for each_package in $packages_in_patch
    do
        #
        #See if the package is installed on the system, if yes then
        #if it is present in the patched packages. If no then install
        #the patch.
        #
        /usr/bin/pkginfo -qi  $RELOC_PARAM $each_package
        if [ $? -eq 0 ] ; then
            #
            #package is installed on the system, so now check for the 
            #version of installed package and package in the patch. If
            #they are not same then dont install patch.
            #

            installed_package_version=""
            patch_package_version=""
            installed_package_version=`/usr/bin/pkgparam $RELOC_PARAM $each_package VERSION`
            patch_package_version=`/usr/bin/pkgparam -f ${PATCH_DIRECTORY}/${patch_name}/${each_package}/pkginfo VERSION`
            if [ "$installed_package_version" = "$patch_package_version" ] ; then
		echo "$packages_patched" | /usr/bin/grep $each_package >/dev/null 2>&1
		if [ $? -ne 0 ] ; then
		    #
		    #package is not patched yet, so lets patch it.
		    #
		    return 1
		fi
            fi
        fi
    done

    return 0
}

add_postinstall_patches () 
{
    #RELOC_PARAM=""
    #[ "$RELOCATED_ROOT" != "" ] && RELOC_PARAM="-R $RELOCATED_ROOT"
    failed_patch=""
    for each_patch in $1
    do
	${LOCAL_PATCH_COMMAND} $RELOC_PARAM $PATCH_DIRECTORY/$each_patch
	if [ $? -ne 0 ] ; then
            failed_patch="$failed_patch $each_patch"
	fi
    done
    if [ -z "$failed_patch" ] ; then
        return 0
    fi
    echolog 'Patches could not get installed = $2' "$failed_patch"
    return 1
}

sunmc_postinstall () 
{
    #
    # Install patch for RR or GA depending upon what user has installed
    # on his machine.
    #

    RELOC_PARAM=""
    [ "$RELOCATED_ROOT" != "" ] && RELOC_PARAM="-R $RELOCATED_ROOT"
    version_string=`/usr/bin/pkgparam $RELOC_PARAM SUNWescom SUNW_PRODVERS`
    PATCH_NAME=""
    if [ "$version_string" = "3.0_Build41" ] ; then
        case $OSVERS in 
            2.5.1)
                PATCH_NAME="110862-01"
                ;;
            2.6)
                PATCH_NAME="110936-02"
                ;;
            7)
                PATCH_NAME="110937-02"
                ;;
            8)
                PATCH_NAME="110938-02"
                ;;
            *)
                PATCH_NAME=""
                ;; 
        esac
    fi

    if [ "$version_string" = "3.0_Build39" ] ; then
        case $OSVERS in 
            2.5.1)
                PATCH_NAME="110861-01"
                ;;
            2.6)
                PATCH_NAME="110971-02"
                ;;
            7)
                PATCH_NAME="110972-02"
                ;;
            8)
                PATCH_NAME="110973-02"
                ;;
            *)
                PATCH_NAME=""
                ;; 
        esac
    fi

    PATCH_DIRECTORY="$1/Patches/Solaris_${OSVERS}"

    if [ -z "${PATCH_NAME}" ] ; then
        return 0
    fi

    if [ ! -d "${PATCH_DIRECTORY}/${PATCH_NAME}" ] ; then
        return 0
    fi

    LOCAL_PATCH_COMMAND="/usr/sbin/patchadd"
    if [ "$OSVERS" = "2.5.1" ] ; then
        LOCAL_PATCH_COMMAND="${PATCH_DIRECTORY}/${PATCH_NAME}/installpatch"
    fi
    patches_tobe_installed=""
    for each_patch in $PATCH_NAME
    do
	is_patch_needed $each_patch
	if [ $? -eq 1 ] ; then
            patches_tobe_installed="$patches_tobe_installed $each_patch"
	fi
    done
    if [ ! -z "$patches_tobe_installed" ] ; then
	add_postinstall_patches "$patches_tobe_installed"
	return $?
    fi

    return 0
}

