#
#   File:    base-config.x
#   Author:  Andrew Hillier
#   Version: 1.77 01/01/05 10:38:43
#
#   Copyright (c) 1993-1997 Halcyon Inc.
#
#   General System Configuration File
#

    #
    # Security Configuration
    #
    security = { [ load base-acls-d.dat ]
	#
        # Obselete: Outgoing Query Access Community Specifications
	#
	readCommunity		= public
	writeCommunity		= private
	shadowReadCommunity	= public
	shadowWriteCommunity	= private

#	User authentication information.
#	--------------------------------
	maxAuthKeyLen		= 16
	usmUserTable		= .iso.org.dod.internet.snmpV2.snmpModules.snmpUsmMIB.usmMIBObjects.usmUser.usmUserTable.usmUserEntry

	superuser		= esmaster
	generaluser		= espublic
	userfile		= esusers
	authOID			= 1.3.6.1.6.3.6.1.3.1
	privOID			= 0.0
    }

    defaultacls = {
        #
        # Incoming SNMP Request Access Control List Specifications
        #
        userAccess(%adminUsers,read)           = auth
        userAccess(%operatorUsers,read)        = auth
        userAccess(%generalUsers,read)         = auth
 
        userAccess(%adminUsers,write)          = auth
        userAccess(%operatorUsers,write)       = auth
        userAccess(%generalUsers,write)        = none

        groupAccess(%adminGroups,read)         = auth
        groupAccess(%operatorGroups,read)      = auth
        groupAccess(%generalGroups,read)       = auth

        groupAccess(%adminGroups,write)        = auth
        groupAccess(%operatorGroups,write)     = auth
        groupAccess(%generalGroups,write)      = none

        userAccess(%adminCommunities,read)     = noauth
        userAccess(%operatorCommunities,read)  = noauth
        userAccess(%generalCommunities,read)   = noauth

        userAccess(%adminCommunities,write)    = noauth
        userAccess(%operatorCommunities,write) = noauth
        userAccess(%generalCommunities,write)  = none
    }

    #
    # Agent Configuration
    #
    agent = { [ inherit security ]
	#
	# Communications Parameters
	#
	snmpPort		= 161
        description             = Agent

	#
	# The following line is for the new data logging format
	# for the 3.0 release onwards. Overriding the following
	# value with 1 in domain-config.x will log data in the
	# 2.x release format.
	#

	dataLogVersion          = 2
	

	#
	# Logging and Diagnostic Channel Configuration
	#
	# NOTE: status.log should not be greater than about 50K in size.
	#       This is because the Event Management Agent needs to be able
	#       to retrieve the entire file in one SNMP "get", if necessary.
	#	There's a maximum of 64K on such a request.
	#
	activeChannels		= error warning info status history syslog
	defaultOutput		= "clog://localhost/../log/agent.log;lines=1000;width=200;flags=rw+;mode=644"

	statusOutput		= "clog://localhost/../log/agentStatus.log;lines=250;width=200;flags=rw+;mode=644"

	historyOutput		= "clog://localhost/../log/history.log;lines=1000;width=200;flags=rw+;mode=644"
	syslogOutput		= "syslog://localhost/LOG_ALERT;app=agent;facility=LOG_DAEMON;logopt=LOG_PID"

	#
	# Agent Initialization Parameters
	#
	moduleFile		= module:base-modules-d.dat
	randomSeed		= 2509
	niceValue		= 10
	numFileLimit		= max

#       User Module parameters.
#       -----------------------
	usmUserFiles            = "value:agent-usmuser-d.dat data:agent-usmusertbl-d.dat"
	usmAclFile              = "aclgrps:agent-usmaclgrps-d.dat"

	agentStatsFile          = "value:agent-stats.dat alarmlimit:agent-stats.dat"
	mib2SystemFile          = "def:mib2-system-d.def dat:mib2-system.dat value:mib2-system.dat"

        #
        # The Default Enterprise
        #
        #enterprise      = halcyon
        enterprise      = sun

        # 
        # Disable Dynamic Oids
        #
        strictModuleOids = true
    }

    #
    # Metadata Configuration
    #
    metadata = { [ inherit security ]
	#
	# Communications Parameters
	#
	snmpPort		= 168
        description             = Metadata

	#
	# Logging and Diagnostic Channel Configuration
	#
	# NOTE: status.log should not be greater than about 50K in size.
	#       This is because the Event Management Agent needs to be able
	#       to retrieve the entire file in one SNMP "get", if necessary.
	#	There's a maximum of 64K on such a request.
	#
	activeChannels		= error warning info status history syslog
	defaultOutput		= "clog://localhost/../log/metadata.log;lines=1000;width=200;flags=rw+;mode=644"

	statusOutput		= "clog://localhost/../log/metadataStatus.log;lines=250;width=200;flags=rw+;mode=644"

	historyOutput		= "clog://localhost/../log/history.log;lines=1000;width=200;flags=rw+;mode=644"
	syslogOutput		= "syslog://localhost/LOG_ALERT;app=metadata;facility=LOG_DAEMON;logopt=LOG_PID"

	#
	# Agent Initialization Parameters
	#
	moduleFile		= module:metadata-modules-d.dat module:/dev/null
	randomSeed		= 2509
	niceValue		= 10
	numFileLimit		= max

#       User Module parameters.
#       -----------------------
	usmUserFiles            = "value:metadata-usmuser-d.dat data:metadata-usmusertbl-d.dat"
	usmAclFile              = "aclgrps:metadata-usmaclgrps-d.dat"

	agentStatsFile          = "value:metadata-stats.dat alarmlimit:metadata-stats.dat"
	mib2SystemFile          = "def:mib2-system-d.def dat:mib2-system.dat value:mib2-system.dat"

        #
        # The Default Enterprise
        #
        #enterprise      = halcyon
        enterprise      = sun

        # 
        # Disable Dynamic Oids
        #
        strictModuleOids = true

	#
	# Enable metadata module instance names (used by finder calls)
	#
	#urlMode = metadata
    }





    #
    # Platform Agent Configuration
    #
    platform = { [ inherit security ]
	#
	# Communications Parameters
	#
	snmpPort		= 166
        description             = "Platform Agent"

	#
	# Logging and Diagnostic Channel Configuration
	#
	# NOTE: Event logging is currently not enabled for the Config
	#       Server. Can be enabled to uncommenting the lines to do
	#       with the status channel, below. 
	#
	activeChannels		= error warning info status history syslog
	defaultOutput		= "clog://localhost/../log/platform.log;lines=1000;width=200;flags=rw+;mode=644"

	statusOutput		= "clog://localhost/../log/platformStatus.log;lines=250;width=200;flags=rw+;mode=644"
	syslogOutput		= "syslog://localhost/LOG_ALERT;app=platform;facility=LOG_DAEMON;logopt=LOG_PID"

	#
	# Config Server Initialization Parameters
	#
	moduleFile		= module:platform-modules-d.dat
	randomSeed		= 2509
	niceValue		= 10
	numFileLimit		= max

#       User Module parameters.
#       -----------------------
	usmUserFiles            = "value:platform-usmuser-d.dat data:platform-usmusertbl-d.dat"
	usmAclFile              = "aclgrps:platform-usmaclgrps-d.dat"

	agentStatsFile          = "value:platform-agent-stats.dat alarmlimit:platform-agent-stats.dat"
	mib2SystemFile          = "def:mib2-system-d.def dat:platform-mib2-system.dat value:mib2-system.dat"

	enterprise = sun
    }
    #
    # Config Server Configuration
    #
    cfgserver = { [ inherit security ]
	#
	# Communications Parameters
	#
	cfgserverServer		= escfgserverhost
	snmpPort		= 165
        description             = "Config Server"

	#
	# Logging and Diagnostic Channel Configuration
	#
	# NOTE: Event logging is currently not enabled for the Config
	#       Server. Can be enabled to uncommenting the lines to do
	#       with the status channel, below. 
	#
	#activeChannels		= error warning info status history syslog
	activeChannels		= error warning info history syslog
	defaultOutput		= "clog://localhost/../log/cfgserver.log;lines=1000;width=200;flags=rw+;mode=644"

	#statusOutput		= "clog://localhost/../log/cfgserverStatus.log;lines=250;width=200;flags=rw+;mode=644"
	syslogOutput		= "syslog://localhost/LOG_ALERT;app=cfgserver;facility=LOG_DAEMON;logopt=LOG_PID"

	#
	# Config Server Initialization Parameters
	#
	moduleFile		= module:cfgserver-modules-d.dat
	randomSeed		= 2509
	niceValue		= 10
	numFileLimit		= max

#       User Module parameters.
#       -----------------------
	usmUserFiles            = "value:cfgserver-usmuser-d.dat data:cfgserver-usmusertbl-d.dat"
	usmAclFile              = "aclgrps:cfgserver-usmaclgrps-d.dat"

	agentStatsFile          = "value:cfgserver-agent-stats.dat alarmlimit:cfgserver-agent-stats.dat"
	mib2SystemFile          = "def:mib2-system-d.def dat:cfgserver-mib2-system.dat value:cfgserver-mib2-system.dat"

	maxPasswordLen		= 128

        # 
        # Disable Dynamic Oids
        #
        strictModuleOids = true
    }
    #
    # Concentrator Configuration
    #
    concentrator = { [ inherit security ]
	#
	# Communications Parameters
	#
	snmpPort		= 17161
	consoleServer		= oaconhost
	consolePort		= 17003

	#
	# Logging and Diagnostic Channel Configuration
	#
	activeChannels		= error warning info syslog
	defaultOutput		= "clog://localhost/../log/concentrator.log;lines=1000;width=200;flags=rw+;mode=644"
	syslogOutput		= "syslog://localhost/LOG_ALERT;app=oa-concentrator;facility=LOG_DAEMON;logopt=LOG_PID"
 
	#
	# Initialization Parameters
	#
	moduleFile		= module:concentrator-modules-d.dat
	randomSeed		= 2509
	niceValue		= 10
	numFileLimit		= max

#       User Module parameters.
#       -----------------------
	usmUserFiles            = "value:concentrator-usmuser-d.dat data:concentrator-usmusertbl-d.dat"
	usmAclFile              = "aclgrps:concentrator-usmaclgrps-d.dat"
    }

    #
    # Trap Daemon Configuration
    #
    trap = { [ inherit security ]
	#
	# Communications Parameters
	#
	trapServer		= estraphost
	snmpPort		= 162
        description             = "Trap Handler"

	#
	# Logging And Diagnostic Channel Configuration
	#
	activeChannels		= error warning info trap syslog
	defaultOutput		= "clog://localhost/../log/trap.log;lines=1000;width=200;flags=rw+;mode=644"
	trapOutput		= "clog://localhost/../log/alarms.log;lines=1000;width=200;flags=rw+;mode=644"
	syslogOutput		= "syslog://localhost/LOG_ALERT;app=trap;facility=LOG_DAEMON;logopt=LOG_PID"
 
	#
	# Initialization Parameters
	#
	moduleFile		= module:trap-modules-d.dat
	randomSeed		= 2509
	niceValue		= 10
	numFileLimit		= max

#       User Module parameters.
#       -----------------------
	usmUserFiles            = "value:trap-usmuser-d.dat data:trap-usmusertbl-d.dat"
	usmAclFile              = "aclgrps:trap-usmaclgrps-d.dat"
	agentStatsFile          = "value:trap-agent-stats.dat alarmlimit:trap-agent-stats.dat"
	mib2SystemFile          = "def:mib2-system-d.def dat:trap-mib2-system.dat value:trap-mib2-system.dat"

        # 
        # Disable Dynamic Oids
        #
        strictModuleOids = true
    }

    #
    # Sub-agent Configuration
    #
    subagent = { [ inherit security ]
	#
	# Logging and Diagnostic Channel Configuration
	#
	activeChannels		= error warning info log status
	defaultOutput		= "clog://localhost/../log/subagent.log;lines=1000;width=200;flags=rw+;mode=644"
	logOutput		= "clog://localhost/../log/mon.log;lines=1000;width=200;flags=rw+;mode=644"
	statusOutput		= "clog://localhost/../log/agentStatus.log;lines=250;width=200;flags=rw+;mode=644"
        description             = "Subagent"
 
	#
	# Initialization Parameters
	#
	moduleFile		= module:subagent-modules-d.dat

#       User Module parameters.
#       -----------------------
	usmUserFiles            = "value:agent-usmuser-d.dat data:agent-usmusertbl-d.dat"
	usmAclFile              = "aclgrps:agent-usmaclgrps-d.dat"
	agentStatsFile          = "value:subagent-agent-stats.dat alarmlimit:subagent-agent-stats.dat"
    }

    #
    # Console configuration
    #
    console = {
        #
        # Default profile name
        #
        profile		= profile-c.x

        #
        # Information for editors looking at this data
        #
        editor:publicSlices	= value

	#
	# Logging And Diagnostic Channel Configuration
	#
	activeChannels		= error warning info
	defaultOutput		= "clog://localhost/../log/console.log;lines=1000;width=200;flags=rw+;mode=644"
    }

    #
    # Probe configuration
    #
    probe = {
        #
        # Logging And Diagnostic Channel Configuration
        #
        activeChannels = error warning info
        defaultOutput = "clog://localhost/../log/probe.log;lines=1000;width=200;flags=rw+;mode=644"
        tcpPort = oa_probe
	maxPort = 10500
	minPort = 10000
    }

    #
    # Gateway configuration
    #
    gateway = {
        defaultOutput = "clog://localhost/../log/gateway.log;lines=1000;width=200;flags=rw+;mode=644"
        httpPort = 80
	httpLinger = 0
        
	consoles = 20
        homeURI = /oa-gateway?module=base-summary
    }

    #
    # Event Management Agent Configuration
    #
    event = { [ inherit security ]
	#
	# Communications Parameters
	#
	eventServer		= eseventhost
	snmpPort		= 163
        description             = "Event Manager"

	#
	# Logging and Diagnostic Channel Configuration
	#
	# NOTE: status.log should not be greater than about 50K in size.
	#       This is because the Event Management Agent needs to be able
	#       to retrieve the entire file in one SNMP "get", if necessary.
	#	There's a maximum of 64K on such a request.
        #
        # NOTE: If you want events to show up in /var/adm/messages, turn
        #       the syslog channel back on ... this is no longer done, so
	#       turning on syslog should be okay again.
	#
	activeChannels		= error warning info status history syslog eventhistory

	#activeChannels		= error warning info status history
	defaultOutput		= "clog://localhost/../log/event.log;lines=1000;width=200;flags=rw+;mode=644"
	syslogOutput		= "syslog://localhost/LOG_ALERT;app=event;facility=LOG_DAEMON;logopt=LOG_PID"
	eventhistoryOutput      = "clog://localhost/../log/eventHistory.log;lines=1000;width=200;flags=rw+;mode=644"

	statusOutput		= "clog://localhost/../log/eventStatus.log;lines=250;width=200;flags=rw+;mode=644"

	#
	# Event Management Agent Initialization Parameters
	#
	moduleFile		= module:event-modules-d.dat
	randomSeed		= 2509
	niceValue		= 10
	numFileLimit		= max

#       User Module parameters.
#       -----------------------
	usmUserFiles            = "value:event-usmuser-d.dat data:event-usmusertbl-d.dat"
	usmAclFile              = "aclgrps:event-usmaclgrps-d.dat"
	agentStatsFile          = "value:event-agent-stats.dat alarmlimit:event-agent-stats.dat"
	mib2SystemFile          = "def:mib2-system-d.def dat:event-mib2-system.dat value:event-mib2-system.dat"

        # 
        # Disable Dynamic Oids
        #
        strictModuleOids = true
    }

    #
    # CST Service Management Agent Configuration
    #
    cstservice = { [ inherit security ]
	#
	# Communications Parameters
	#
	cstserviceServer		= escstservicehost
	snmpPort		= 167
        description             = "CST Service"

	#
	# Logging and Diagnostic Channel Configuration
	#
	# NOTE: status.log should not be greater than about 50K in size.
	#       This is because the CST Service Agent needs to be able
	#       to retrieve the entire file in one SNMP "get", if necessary.
	#	There's a maximum of 64K on such a request.
        #
        # NOTE: If you want events to show up in /var/adm/messages, turn
        #       the syslog channel back on ... this is no longer done, so
	#       turning on syslog should be okay again.
	#
	activeChannels		= error warning info cstservicehistory

	#activeChannels		= error warning info status history
	defaultOutput		= "clog://localhost/../log/cstservice.log;lines=1000;width=200;flags=rw+;mode=644"
	syslogOutput		= "syslog://localhost/LOG_ALERT;app=cstservice;facility=LOG_DAEMON;logopt=LOG_PID"
	cstservicehistoryOutput      = "clog://localhost/../log/cstserviceHistory.log;lines=1000;width=200;flags=rw+;mode=644"

	statusOutput		= "clog://localhost/../log/cstserviceStatus.log;lines=250;width=200;flags=rw+;mode=644"

	#
	# CST Service Agent Initialization Parameters
	#
	moduleFile		= module:cstservice-modules-d.dat
	randomSeed		= 2509
	niceValue		= 10
	numFileLimit		= max

#       User Module parameters.
#       -----------------------
	usmUserFiles            = "value:cstservice-usmuser-d.dat data:cstservice-usmusertbl-d.dat"
	usmAclFile              = "aclgrps:cstservice-usmaclgrps-d.dat"
	agentStatsFile          = "value:cstservice-agent-stats.dat alarmlimit:cstservice-agent-stats.dat"
	mib2SystemFile          = "def:mib2-system-d.def dat:cstservice-mib2-system.dat value:cstservice-mib2-system.dat"

        # 
        # Disable Dynamic Oids
        #
        strictModuleOids = true
    }

    #
    # Topology Agent Configuration
    #
    topology = { [ inherit security ]
	#
	# Communications Parameters
	#
	topologyServer		= estopologyhost
	snmpPort		= 164
        description             = "Topology"
        maxEntitiesPerGroup     = 256
        
        #
        # default domain name
        #
        defaultDomainName       = "Default Domain"

	#
	# Logging and Diagnostic Channel Configuration
	#
	# NOTE: status.log should not be greater than about 50K in size.
	#       This is because the Event Management Agent needs to be able
	#       to retrieve the entire file in one SNMP "get", if necessary.
	#	There's a maximum of 64K on such a request.
	#
	activeChannels		= error warning info status history syslog
	defaultOutput		= "clog://localhost/../log/topology.log;lines=1000;width=200;flags=rw+;mode=644"
	syslogOutput		= "syslog://localhost/LOG_ALERT;app=topology;facility=LOG_DAEMON;logopt=LOG_PID"

	statusOutput		= "clog://localhost/../log/topologyStatus.log;lines=250;width=200;flags=rw+;mode=644"

	#
	# Topology Agent Initialization Parameters
	#
	moduleFile		= module:topology-modules-d.dat
	randomSeed		= 1207
	niceValue		= 10
	numFileLimit		= max

#       User Module parameters.
#       -----------------------
	usmUserFiles            = "value:topology-usmuser-d.dat data:topology-usmusertbl-d.dat"
	usmAclFile              = "aclgrps:topology-usmaclgrps-d.dat"
	agentStatsFile          = "value:topology-agent-stats.dat alarmlimit:topology-agent-stats.dat"
	mib2SystemFile          = "def:mib2-system-d.def dat:topology-mib2-system.dat value:topology-mib2-system.dat"

        # 
        # Disable Dynamic Oids
        #
        strictModuleOids = true
    }

    #
    # Server Configuration
    #
    server = {
	activeChannels		= error warning info
	defaultOutput		= "clog://localhost/../log/server.log;lines=1000;width=200;flags=rw+;mode=644"

    }
